/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.IGeneratorFileIo;
import org.eclipse.etrice.generator.generic.GenericActorClassGenerator;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.java.Main;
import org.eclipse.etrice.generator.java.gen.GlobalSettings;
import org.eclipse.etrice.generator.java.gen.JavaExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class OptionalActorInterfaceGen
extends GenericActorClassGenerator {
    @Inject
    private IGeneratorFileIo fileIO;
    @Inject
    @Extension
    private JavaExtensions _javaExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;

    public void doGenerate(Root root) {
        EList _optionalActorClasses = root.getOptionalActorClasses();
        for (ActorClass ac : _optionalActorClasses) {
            String _javaInterfaceFileName;
            String _generationTargetPath = this._roomExtensions.getGenerationTargetPath((EObject)ac);
            String _path = this._roomExtensions.getPath((RoomClass)ac);
            String path = String.valueOf(_generationTargetPath) + _path;
            String _generationInfoPath = this._roomExtensions.getGenerationInfoPath((EObject)ac);
            String _path_1 = this._roomExtensions.getPath((RoomClass)ac);
            String infopath = String.valueOf(_generationInfoPath) + _path_1;
            String file = this._javaExtensions.getJavaInterfaceFileName(ac, false);
            CharSequence _generate = this.generate(root, ac, false);
            this.fileIO.generateFile("generating ActorClass Interface implementation", path, infopath, file, _generate);
            file = _javaInterfaceFileName = this._javaExtensions.getJavaInterfaceFileName(ac, true);
            CharSequence _generate_1 = this.generate(root, ac, true);
            this.fileIO.generateFile("generating ActorClass Interface implementation", path, infopath, file, _generate_1);
        }
    }

    public CharSequence generate(Root root, ActorClass ac, boolean replicated) {
        StringConcatenation _xblockexpression = null;
        String _xifexpression = null;
        _xifexpression = replicated ? "ReplicatedOptionalActorInterfaceBase" : "ScalarOptionalActorInterfaceBase";
        String baseClass = _xifexpression;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _package = this._roomExtensions.getPackage((RoomClass)ac);
        _builder.append((Object)_package, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        GlobalSettings _settings = Main.getSettings();
        boolean _generateMSCInstrumentation = _settings.generateMSCInstrumentation();
        if (_generateMSCInstrumentation) {
            _builder.append((Object)"import org.eclipse.etrice.runtime.java.debugging.DebuggingService;");
            _builder.newLine();
        }
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.IEventReceiver;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.InterfaceItemBroker;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.etrice.runtime.java.modelbase.");
        _builder.append((Object)baseClass, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"class ");
        String _javaInterfaceName = this._javaExtensions.getJavaInterfaceName(ac, replicated);
        _builder.append((Object)_javaInterfaceName, "");
        _builder.append((Object)" extends ");
        _builder.append((Object)baseClass, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"//--------------------- brokers for ports on the interface");
        _builder.newLine();
        List _allInterfacePorts = RoomHelpers.getAllInterfacePorts((ActorContainerClass)ac);
        for (Port ep : _allInterfacePorts) {
            _builder.append((Object)"\t");
            _builder.append((Object)"protected InterfaceItemBroker ");
            String _name = ep.getName();
            _builder.append((Object)_name, "\t");
            _builder.append((Object)" = null;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"//--------------------- interface item IDs");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _genInterfaceItemConstantsForOptionalActor = this.genInterfaceItemConstantsForOptionalActor(ac);
        _builder.append((Object)_genInterfaceItemConstantsForOptionalActor, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"//--------------------- construction");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        String _javaInterfaceName_1 = this._javaExtensions.getJavaInterfaceName(ac, replicated);
        _builder.append((Object)_javaInterfaceName_1, "\t");
        _builder.append((Object)" (IEventReceiver parent, String name) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"super(parent, name, \"");
        String _name_1 = ac.getName();
        _builder.append((Object)_name_1, "\t\t");
        _builder.append((Object)"\");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        List _allInterfacePorts_1 = RoomHelpers.getAllInterfacePorts((ActorContainerClass)ac);
        for (Port ep_1 : _allInterfacePorts_1) {
            boolean _isReplicated = ep_1.isReplicated();
            if (_isReplicated) {
                _builder.append((Object)"\t\t");
                String _name_2 = ep_1.getName();
                _builder.append((Object)_name_2, "\t\t");
                _builder.append((Object)" = new ReplicatedInterfaceItemBroker(this, \"");
                String _name_3 = ep_1.getName();
                _builder.append((Object)_name_3, "\t\t");
                _builder.append((Object)"\", IFITEM_");
                String _name_4 = ep_1.getName();
                _builder.append((Object)_name_4, "\t\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"\t\t");
            String _name_5 = ep_1.getName();
            _builder.append((Object)_name_5, "\t\t");
            _builder.append((Object)" = new InterfaceItemBroker(this, \"");
            String _name_6 = ep_1.getName();
            _builder.append((Object)_name_6, "\t\t");
            _builder.append((Object)"\", IFITEM_");
            String _name_7 = ep_1.getName();
            _builder.append((Object)_name_7, "\t\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        GlobalSettings _settings_1 = Main.getSettings();
        boolean _generateMSCInstrumentation_1 = _settings_1.generateMSCInstrumentation();
        if (_generateMSCInstrumentation_1) {
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Override");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"protected void logCreation(String actorClass, String name) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"DebuggingService.getInstance().addMessageActorCreate(this, actorClass, name);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"@Override");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"protected void logDeletion(String name) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"DebuggingService.getInstance().addMessageActorDestroy(this, name);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }
}

