/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.dialogs;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorCommunicationType;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.RefinedState;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.SimpleState;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.core.validation.ValidationUtil;
import org.eclipse.etrice.ui.behavior.Activator;
import org.eclipse.etrice.ui.behavior.dialogs.AbstractMemberAwarePropertyDialog;
import org.eclipse.etrice.ui.behavior.dialogs.DetailCodeToString;
import org.eclipse.etrice.ui.behavior.dialogs.StringToDetailCode;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;

public class StatePropertyDialog
extends AbstractMemberAwarePropertyDialog {
    private State state;
    private boolean inherited;

    public StatePropertyDialog(Shell shell, ActorClass ac, State s, boolean edit) {
        super(shell, edit ? "Edit State" : "View State", ac);
        this.state = s;
        this.inherited = RoomHelpers.getActorClass((StateGraphItem)s) != ac;
    }

    protected Image getImage() {
        return Activator.getImage("icons/Behavior.gif");
    }

    protected void createContent(IManagedForm mform, Composite body, DataBindingContext bindingContext) {
        GridData gd;
        GridData gd2;
        Text entry;
        String code;
        if (this.state instanceof SimpleState && !this.inherited) {
            NameValidator nv = new NameValidator();
            Text name = this.createText(body, "&Name:", (EObject)this.state, RoomPackage.eINSTANCE.getSimpleState_Name(), nv);
            this.configureMemberAware((Control)name);
            this.createDecorator((Control)name, "invalid name");
            name.setFocus();
            name.selectAll();
        } else {
            this.createFixedText(body, "Name:", this.state.getName(), false);
        }
        DetailCodeToString m2s = new DetailCodeToString();
        StringToDetailCode s2m = new StringToDetailCode();
        if (this.inherited) {
            code = RoomHelpers.getDetailCode((DetailCode)this.state.getEntryCode());
            if (this.state instanceof RefinedState) {
                code = String.valueOf(code) + RoomHelpers.getBaseEntryCode((RefinedState)((RefinedState)this.state));
            }
            entry = this.createFixedText(body, "Entry Code:", code, true);
            gd2 = new GridData(1808);
            gd2.heightHint = 100;
            entry.setLayoutData((Object)gd2);
        } else {
            if (this.state instanceof RefinedState) {
                code = RoomHelpers.getBaseEntryCode((RefinedState)((RefinedState)this.state));
                entry = this.createFixedText(body, "Base Entry Code:", code, true);
                gd2 = new GridData(1808);
                gd2.heightHint = 100;
                entry.setLayoutData((Object)gd2);
            }
            Text entry2 = this.createText(body, "&Entry Code:", (EObject)this.state, (EStructuralFeature)RoomPackage.eINSTANCE.getState_EntryCode(), null, (IConverter)s2m, (IConverter)m2s, true);
            this.configureMemberAware((Control)entry2, true, true);
            gd = new GridData(1808);
            gd.heightHint = 100;
            entry2.setLayoutData((Object)gd);
        }
        if (this.inherited) {
            code = RoomHelpers.getDetailCode((DetailCode)this.state.getExitCode());
            if (this.state instanceof RefinedState) {
                code = String.valueOf(RoomHelpers.getBaseExitCode((RefinedState)((RefinedState)this.state))) + code;
            }
            entry = this.createFixedText(body, "Exit Code:", code, true);
            gd2 = new GridData(1808);
            gd2.heightHint = 100;
            entry.setLayoutData((Object)gd2);
        } else {
            Text exit = this.createText(body, "E&xit Code:", (EObject)this.state, (EStructuralFeature)RoomPackage.eINSTANCE.getState_ExitCode(), null, (IConverter)s2m, (IConverter)m2s, true);
            this.configureMemberAware((Control)exit, true, true);
            gd = new GridData(1808);
            gd.heightHint = 100;
            exit.setLayoutData((Object)gd);
            if (this.state instanceof RefinedState) {
                code = RoomHelpers.getBaseExitCode((RefinedState)((RefinedState)this.state));
                entry = this.createFixedText(body, "Base Exit Code:", code, true);
                gd2 = new GridData(1808);
                gd2.heightHint = 100;
                entry.setLayoutData((Object)gd2);
            }
        }
        ActorClass ac = RoomHelpers.getActorClass((StateGraphItem)this.state);
        if (ac.getCommType() != ActorCommunicationType.EVENT_DRIVEN) {
            Text dotxt = this.createText(body, "&Do Code:", (EObject)this.state, (EStructuralFeature)RoomPackage.eINSTANCE.getState_DoCode(), null, (IConverter)s2m, (IConverter)m2s, true);
            this.configureMemberAware((Control)dotxt, true, true);
            gd2 = new GridData(1808);
            gd2.heightHint = 100;
            dotxt.setLayoutData((Object)gd2);
        }
        this.createMembersAndMessagesButtons(body);
    }

    class NameValidator
    implements IValidator {
        NameValidator() {
        }

        public IStatus validate(Object value) {
            if (value instanceof String) {
                String name = (String)value;
                ValidationUtil.Result result = ValidationUtil.isUniqueName((StateGraphItem)StatePropertyDialog.this.state, (String)name);
                if (!result.isOk()) {
                    return ValidationStatus.error((String)result.getMsg());
                }
            }
            return Status.OK_STATUS;
        }
    }
}

