/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.naming.RoomNameProvider;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.CPBranchTransition;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.Guard;
import org.eclipse.etrice.core.room.GuardedTransition;
import org.eclipse.etrice.core.room.InitialTransition;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageFromIf;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefinedTransition;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.Trigger;
import org.eclipse.etrice.core.room.TriggeredTransition;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.core.validation.ValidationUtil;
import org.eclipse.etrice.ui.behavior.Activator;
import org.eclipse.etrice.ui.behavior.dialogs.AbstractMemberAwarePropertyDialog;
import org.eclipse.etrice.ui.behavior.dialogs.DetailCodeToString;
import org.eclipse.etrice.ui.behavior.dialogs.StringToDetailCode;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TransitionPropertyDialog
extends AbstractMemberAwarePropertyDialog {
    private Transition trans;
    private Combo messageCombo;
    private Combo interfaceCombo;
    private TableViewer mifViewer;
    private List<InterfaceItem> interfaceItems = new ArrayList<InterfaceItem>();
    private TableViewer triggerViewer;
    private List<Message> currentMsgs;
    private DetailCodeToString m2s;
    private StringToDetailCode s2m;
    private StringToDetailCode s2m_not_null;
    private DetailCodeToString m2s_null_empty;
    private Text guardText;
    private Button removeMifButton;
    private boolean triggerError = false;
    private boolean inherited;
    private RefinedTransition refined;

    public TransitionPropertyDialog(Shell shell, ActorClass ac, Transition trans) {
        super(shell, "Edit Transition", ac);
        this.trans = trans;
        this.m2s = new DetailCodeToString();
        this.m2s_null_empty = new DetailCodeToString(true);
        this.s2m = new StringToDetailCode();
        this.s2m_not_null = new StringToDetailCode(false);
        this.interfaceItems = new ArrayList<InterfaceItem>();
        for (InterfaceItem item : RoomHelpers.getAllInterfaceItems((ActorClass)ac)) {
            ProtocolClass pc = RoomHelpers.getProtocol((InterfaceItem)item);
            if (pc == null || pc.getCommType() != CommunicationType.EVENT_DRIVEN) continue;
            this.interfaceItems.add(item);
        }
        this.inherited = RoomHelpers.getActorClass((StateGraphItem)trans) != ac;
        this.refined = null;
        if (this.inherited && this.getActorClass().getStateMachine() != null) {
            for (RefinedTransition rt : this.getActorClass().getStateMachine().getRefinedTransitions()) {
                if (rt.getTarget() != trans) continue;
                this.refined = rt;
                break;
            }
        }
        if (this.inherited && this.refined == null) {
            this.setTitle("View Transition");
        }
    }

    protected Image getImage() {
        return Activator.getImage("icons/Behavior.gif");
    }

    protected void createContent(IManagedForm mform, Composite body, DataBindingContext bindingContext) {
        GridData gd;
        Text action;
        Text cond;
        GuardValidator gv;
        String code;
        GridData gd2;
        if (!(this.trans instanceof InitialTransition)) {
            NameValidator nv = new NameValidator();
            if (this.inherited) {
                this.createFixedText(body, "&Name:", this.trans.getName(), false);
            } else {
                Text name = this.createText(body, "&Name:", (EObject)this.trans, RoomPackage.eINSTANCE.getTransition_Name(), nv);
                this.configureMemberAware((Control)name);
                this.createDecorator((Control)name, "invalid name");
                name.selectAll();
                name.setFocus();
            }
        }
        if (this.trans instanceof TriggeredTransition) {
            FormToolkit toolkit = mform.getToolkit();
            Label l = toolkit.createLabel(body, "Triggers:", 0);
            gd2 = new GridData(768);
            gd2.horizontalSpan = 2;
            l.setLayoutData((Object)gd2);
            if (this.triggersAvailable()) {
                this.createTriggerCompartment(body, toolkit);
                this.addListeners();
                this.triggerViewer.setSelection((ISelection)new StructuredSelection(((TriggeredTransition)this.trans).getTriggers().get(0)), true);
            } else {
                Label error = toolkit.createLabel(body, "No triggers available (interface item with incoming message missing).", 0);
                gd2 = new GridData(768);
                gd2.horizontalSpan = 2;
                error.setLayoutData((Object)gd2);
                this.triggerError = true;
            }
        }
        if (this.trans instanceof GuardedTransition) {
            if (this.inherited) {
                code = RoomHelpers.getDetailCode((DetailCode)((GuardedTransition)this.trans).getGuard());
                this.createFixedText(body, "&Guard:", code, true);
            } else {
                gv = new GuardValidator("guard must not be empty");
                cond = this.createText(body, "&Guard:", (EObject)this.trans, (EStructuralFeature)RoomPackage.eINSTANCE.getGuardedTransition_Guard(), gv, (IConverter)this.s2m_not_null, (IConverter)this.m2s_null_empty, true);
                this.configureMemberAware((Control)cond, true, true, true);
                gd2 = new GridData(1808);
                gd2.heightHint = 100;
                cond.setLayoutData((Object)gd2);
                this.createDecorator((Control)cond, "empty guard");
            }
        }
        if (this.trans instanceof CPBranchTransition) {
            if (this.inherited) {
                code = RoomHelpers.getDetailCode((DetailCode)((CPBranchTransition)this.trans).getCondition());
                this.createFixedText(body, "&Condition", code, true);
            } else {
                gv = new GuardValidator("condition must not be empty");
                cond = this.createText(body, "&Condition:", (EObject)this.trans, (EStructuralFeature)RoomPackage.eINSTANCE.getCPBranchTransition_Condition(), gv, (IConverter)this.s2m_not_null, (IConverter)this.m2s_null_empty, true);
                this.configureMemberAware((Control)cond, true, true, true);
                gd2 = new GridData(1808);
                gd2.heightHint = 100;
                cond.setLayoutData((Object)gd2);
                this.createDecorator((Control)cond, "empty condition");
            }
        }
        if ((code = RoomHelpers.getInheritedActionCode((Transition)this.trans, (ActorClass)this.getActorClass())) != null) {
            this.createFixedText(body, "Base Action Code:", code, true);
        }
        if (this.inherited) {
            if (this.refined != null) {
                action = this.createText(body, "&Action Code:", (EObject)this.refined, (EStructuralFeature)RoomPackage.eINSTANCE.getRefinedTransition_Action(), null, (IConverter)this.s2m, (IConverter)this.m2s, true);
                this.configureMemberAware((Control)action, true, true);
                gd = new GridData(1808);
                gd.heightHint = 100;
                action.setLayoutData((Object)gd);
            }
        } else {
            action = this.createText(body, "&Action Code:", (EObject)this.trans, (EStructuralFeature)RoomPackage.eINSTANCE.getTransition_Action(), null, (IConverter)this.s2m, (IConverter)this.m2s, true);
            this.configureMemberAware((Control)action, true, true);
            gd = new GridData(1808);
            gd.heightHint = 100;
            action.setLayoutData((Object)gd);
        }
        this.createMembersAndMessagesButtons(body);
    }

    private void disableAll(Composite parent) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.setEnabled(false);
            if (child instanceof Composite) {
                this.disableAll((Composite)child);
            }
            ++n2;
        }
    }

    private boolean triggersAvailable() {
        if (this.interfaceItems.isEmpty()) {
            return false;
        }
        for (InterfaceItem item : this.interfaceItems) {
            if (RoomHelpers.getMessageListDeep((InterfaceItem)item, (boolean)false).isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected void updateValidationFeedback(boolean ok) {
        if (ok && this.triggerError) {
            ok = false;
            this.setValidationText("no triggers available");
        }
        if (ok && this.inherited && this.refined == null) {
            this.setValidationFeedbackOff();
            return;
        }
        super.updateValidationFeedback(ok);
    }

    private void createTriggerCompartment(Composite body, FormToolkit toolkit) {
        Composite triggerCompartment = toolkit.createComposite(body);
        triggerCompartment.setLayout((Layout)new GridLayout(3, false));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        triggerCompartment.setLayoutData((Object)gd);
        this.createTriggerTable(triggerCompartment, toolkit);
        this.createMifTable(triggerCompartment, toolkit);
        this.createMifCompartment(triggerCompartment, toolkit);
        if (this.inherited) {
            this.disableAll(triggerCompartment);
        }
    }

    private void createTriggerTable(Composite triggerCompartment, FormToolkit toolkit) {
        Composite tableCompartment = toolkit.createComposite(triggerCompartment);
        tableCompartment.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        tableCompartment.setLayoutData((Object)gd);
        Table triggerTable = toolkit.createTable(tableCompartment, 2052);
        gd = new GridData(768);
        gd.heightHint = 50;
        gd.widthHint = 100;
        gd.horizontalSpan = 2;
        triggerTable.setLayoutData((Object)gd);
        this.triggerViewer = new TableViewer(triggerTable);
        this.triggerViewer.setContentProvider((IContentProvider)new TriggerContentProvider());
        this.triggerViewer.setLabelProvider((IBaseLabelProvider)new TriggerLabelProvider());
        this.triggerViewer.setInput((Object)this.trans);
        this.configureMemberAware((Control)triggerTable);
        if (((TriggeredTransition)this.trans).getTriggers().isEmpty()) {
            this.addNewTrigger();
        }
        Button add = toolkit.createButton(tableCompartment, "Add", 0);
        gd = new GridData(768);
        add.setLayoutData((Object)gd);
        this.configureMemberAware((Control)add);
        final Button remove = toolkit.createButton(tableCompartment, "Remove", 0);
        gd = new GridData(768);
        remove.setLayoutData((Object)gd);
        if (((TriggeredTransition)this.trans).getTriggers().size() == 1) {
            remove.setEnabled(false);
        }
        this.configureMemberAware((Control)remove);
        add.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransitionPropertyDialog.this.addNewTrigger();
                remove.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        remove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransitionPropertyDialog.this.removeCurrentTrigger();
                if (((TriggeredTransition)TransitionPropertyDialog.this.trans).getTriggers().size() == 1) {
                    remove.setEnabled(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createMifTable(Composite triggerCompartment, FormToolkit toolkit) {
        Composite tableCompartment = toolkit.createComposite(triggerCompartment);
        tableCompartment.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        tableCompartment.setLayoutData((Object)gd);
        Table mifTable = toolkit.createTable(tableCompartment, 2052);
        gd = new GridData(768);
        gd.heightHint = 50;
        gd.widthHint = 100;
        gd.horizontalSpan = 2;
        mifTable.setLayoutData((Object)gd);
        this.mifViewer = new TableViewer(mifTable);
        this.mifViewer.setContentProvider((IContentProvider)new MessageFromInterfaceContentProvider());
        this.mifViewer.setLabelProvider((IBaseLabelProvider)new MessageFromInterfaceLabelProvider());
        this.configureMemberAware((Control)mifTable);
        Button add = toolkit.createButton(tableCompartment, "Add", 0);
        gd = new GridData(768);
        add.setLayoutData((Object)gd);
        this.configureMemberAware((Control)add);
        this.removeMifButton = toolkit.createButton(tableCompartment, "Remove", 0);
        gd = new GridData(768);
        this.removeMifButton.setLayoutData((Object)gd);
        this.configureMemberAware((Control)this.removeMifButton);
        add.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransitionPropertyDialog.this.addNewMif();
                TransitionPropertyDialog.this.removeMifButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.removeMifButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransitionPropertyDialog.this.removeCurrentMif();
                TransitionPropertyDialog.this.updateMifButton();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void updateMifButton() {
        this.removeMifButton.setEnabled(this.mifViewer.getTable().getItemCount() > 1);
    }

    private void createMifCompartment(Composite triggerCompartment, FormToolkit toolkit) {
        Composite mifCompartment = toolkit.createComposite(triggerCompartment);
        mifCompartment.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        gd.verticalAlignment = 1;
        mifCompartment.setLayoutData((Object)gd);
        this.createInterfaceCombo(mifCompartment, toolkit);
        this.createMessageCombo(mifCompartment, toolkit);
        Label l = toolkit.createLabel(mifCompartment, "Guard:", 0);
        l.setLayoutData((Object)new GridData());
        this.guardText = toolkit.createText(mifCompartment, "", 2050);
        this.configureMemberAware((Control)this.guardText, true, true, true);
        gd = new GridData(768);
        gd.heightHint = 50;
        this.guardText.setLayoutData((Object)gd);
    }

    private void createInterfaceCombo(Composite triggerCompartment, FormToolkit toolkit) {
        Label l = toolkit.createLabel(triggerCompartment, "Interface Item:", 0);
        l.setLayoutData((Object)new GridData());
        this.interfaceCombo = new Combo(triggerCompartment, 8);
        GridData gd = new GridData(768);
        this.interfaceCombo.setLayoutData((Object)gd);
        this.interfaceCombo.setVisibleItemCount(10);
        toolkit.adapt((Control)this.interfaceCombo, true, true);
        this.configureMemberAware((Control)this.interfaceCombo);
        for (InterfaceItem item : this.interfaceItems) {
            this.interfaceCombo.add(item.getName());
        }
    }

    private void createMessageCombo(Composite triggerCompartment, FormToolkit toolkit) {
        Label l = toolkit.createLabel(triggerCompartment, "Message:", 0);
        l.setLayoutData((Object)new GridData());
        this.messageCombo = new Combo(triggerCompartment, 8);
        this.messageCombo.setLayoutData((Object)new GridData(768));
        this.messageCombo.setVisibleItemCount(10);
        toolkit.adapt((Control)this.messageCombo, true, true);
        this.configureMemberAware((Control)this.messageCombo);
    }

    private void addListeners() {
        this.triggerViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TransitionPropertyDialog.this.updateMifAndGuard();
            }
        });
        this.mifViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TransitionPropertyDialog.this.updateCombos();
            }
        });
        this.interfaceCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransitionPropertyDialog.this.updateInterfaceItem();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.messageCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TransitionPropertyDialog.this.updateMessage();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.guardText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                TransitionPropertyDialog.this.refreshGuard();
            }

            public void focusGained(FocusEvent e) {
            }
        });
    }

    private void updateMessage() {
        String msgName = this.messageCombo.getItem(this.messageCombo.getSelectionIndex());
        for (Message message : this.currentMsgs) {
            if (!msgName.equals(message.getName())) continue;
            MessageFromIf mif = (MessageFromIf)((IStructuredSelection)this.mifViewer.getSelection()).getFirstElement();
            mif.setMessage(message);
            break;
        }
        this.triggerViewer.refresh();
        this.mifViewer.refresh();
    }

    private void updateInterfaceItem() {
        String ifName = this.interfaceCombo.getItem(this.interfaceCombo.getSelectionIndex());
        for (InterfaceItem item : this.interfaceItems) {
            if (!item.getName().equals(ifName)) continue;
            MessageFromIf mif = (MessageFromIf)((IStructuredSelection)this.mifViewer.getSelection()).getFirstElement();
            mif.setFrom(item);
            this.updateCombos();
            break;
        }
        this.triggerViewer.refresh();
        this.mifViewer.refresh();
    }

    private void updateCombos() {
        Object sel;
        this.messageCombo.removeAll();
        if (this.mifViewer.getSelection() instanceof IStructuredSelection && (sel = ((IStructuredSelection)this.mifViewer.getSelection()).getFirstElement()) instanceof MessageFromIf) {
            MessageFromIf mif = (MessageFromIf)sel;
            String[] items = this.interfaceCombo.getItems();
            int i = 0;
            while (i < items.length) {
                if (items[i].equals(mif.getFrom().getName())) {
                    this.interfaceCombo.select(i);
                    this.currentMsgs = RoomHelpers.getMessageListDeep((InterfaceItem)mif.getFrom(), (boolean)false);
                    int pos = 0;
                    int idx = -1;
                    for (Message message : this.currentMsgs) {
                        this.messageCombo.add(message.getName());
                        if (message == mif.getMessage()) {
                            idx = pos;
                        }
                        ++pos;
                    }
                    if (idx == -1) {
                        idx = 0;
                        mif.setMessage(this.currentMsgs.get(idx));
                        this.triggerViewer.refresh();
                        this.mifViewer.refresh();
                    }
                    this.messageCombo.select(idx);
                    break;
                }
                ++i;
            }
        }
    }

    private void addNewTrigger() {
        Trigger tri = RoomFactory.eINSTANCE.createTrigger();
        EList triggers = ((TriggeredTransition)this.trans).getTriggers();
        triggers.add((Object)tri);
        if (!this.interfaceItems.isEmpty()) {
            MessageFromIf mif = this.createDefaultMif();
            tri.getMsgFromIfPairs().add((Object)mif);
        }
        this.triggerViewer.refresh();
        this.triggerViewer.setSelection((ISelection)new StructuredSelection(triggers.get(triggers.size() - 1)), true);
    }

    private MessageFromIf createDefaultMif() {
        MessageFromIf mif = RoomFactory.eINSTANCE.createMessageFromIf();
        for (InterfaceItem item : this.interfaceItems) {
            List msgs = RoomHelpers.getMessageListDeep((InterfaceItem)item, (boolean)false);
            if (msgs.isEmpty()) continue;
            mif.setFrom(item);
            mif.setMessage((Message)msgs.get(0));
            return mif;
        }
        return null;
    }

    private void removeCurrentTrigger() {
        Object element = ((IStructuredSelection)this.triggerViewer.getSelection()).getFirstElement();
        ((TriggeredTransition)this.trans).getTriggers().remove(element);
        this.triggerViewer.refresh();
        this.triggerViewer.setSelection((ISelection)new StructuredSelection(((TriggeredTransition)this.trans).getTriggers().get(0)), true);
    }

    private void addNewMif() {
        Trigger trigger = ((MessageFromInterfaceContentProvider)this.mifViewer.getContentProvider()).getCurrentTrigger();
        if (trigger != null) {
            MessageFromIf mif = this.createDefaultMif();
            trigger.getMsgFromIfPairs().add((Object)mif);
            this.mifViewer.refresh();
            this.triggerViewer.refresh();
            this.mifViewer.setSelection((ISelection)new StructuredSelection((Object)mif), true);
        }
    }

    private void removeCurrentMif() {
        Object element = ((IStructuredSelection)this.mifViewer.getSelection()).getFirstElement();
        Trigger trigger = ((MessageFromInterfaceContentProvider)this.mifViewer.getContentProvider()).getCurrentTrigger();
        if (trigger != null) {
            trigger.getMsgFromIfPairs().remove(element);
            this.mifViewer.refresh();
            this.triggerViewer.refresh();
            this.mifViewer.setSelection((ISelection)new StructuredSelection(trigger.getMsgFromIfPairs().get(0)), true);
        }
    }

    private void updateMifAndGuard() {
        Object selected = ((IStructuredSelection)this.triggerViewer.getSelection()).getFirstElement();
        this.mifViewer.setInput(selected);
        this.updateMifButton();
        if (selected instanceof Trigger) {
            this.mifViewer.setSelection((ISelection)new StructuredSelection(((Trigger)selected).getMsgFromIfPairs().get(0)), true);
            Guard guard2 = ((Trigger)selected).getGuard();
            String text = null;
            if (guard2 != null) {
                text = (String)this.m2s.convert(guard2.getGuard());
            }
            if (text == null) {
                text = "";
            }
            this.guardText.setText(text);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        if (this.inherited || !this.triggersAvailable()) {
            this.getButton(0).setEnabled(false);
        }
    }

    private void refreshGuard() {
        Object element = ((IStructuredSelection)this.triggerViewer.getSelection()).getFirstElement();
        if (element instanceof Trigger) {
            DetailCode dc = (DetailCode)this.s2m.convert(this.guardText.getText());
            Guard guard = null;
            if (dc != null) {
                guard = RoomFactory.eINSTANCE.createGuard();
                guard.setGuard(dc);
            }
            ((Trigger)element).setGuard(guard);
        }
    }

    private class GuardValidator
    implements IValidator {
        private String text;

        public GuardValidator(String text) {
            this.text = text;
        }

        public IStatus validate(Object value) {
            String name;
            if (value instanceof String ? (name = (String)value).isEmpty() : value instanceof DetailCode && RoomHelpers.getDetailCode((DetailCode)((DetailCode)value)).trim().isEmpty()) {
                return ValidationStatus.error((String)this.text);
            }
            return Status.OK_STATUS;
        }
    }

    private class MessageFromInterfaceContentProvider
    implements IStructuredContentProvider {
        private Trigger currentTrigger = null;

        private MessageFromInterfaceContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof Trigger) {
                this.currentTrigger = (Trigger)newInput;
            }
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Trigger) {
                return ((Trigger)inputElement).getMsgFromIfPairs().toArray();
            }
            return new Object[0];
        }

        public Trigger getCurrentTrigger() {
            return this.currentTrigger;
        }
    }

    private class MessageFromInterfaceLabelProvider
    extends LabelProvider
    implements IBaseLabelProvider {
        private MessageFromInterfaceLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof MessageFromIf) {
                MessageFromIf mif = (MessageFromIf)element;
                return RoomNameProvider.getMsgFromIfLabel((MessageFromIf)mif);
            }
            return super.getText(element);
        }
    }

    private class NameValidator
    implements IValidator {
        private NameValidator() {
        }

        public IStatus validate(Object value) {
            if (value instanceof String) {
                String name = (String)value;
                ValidationUtil.Result result = ValidationUtil.isUniqueName((StateGraphItem)TransitionPropertyDialog.this.trans, (String)name);
                if (!result.isOk()) {
                    return ValidationStatus.error((String)result.getMsg());
                }
            }
            return Status.OK_STATUS;
        }
    }

    private class TriggerContentProvider
    implements IStructuredContentProvider {
        private TriggerContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (TransitionPropertyDialog.this.trans instanceof TriggeredTransition) {
                return ((TriggeredTransition)TransitionPropertyDialog.this.trans).getTriggers().toArray();
            }
            return new Object[0];
        }
    }

    private class TriggerLabelProvider
    extends LabelProvider
    implements IBaseLabelProvider {
        private TriggerLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Trigger) {
                Trigger trig = (Trigger)element;
                return RoomNameProvider.getTriggerLabel((Trigger)trig);
            }
            return super.getText(element);
        }
    }
}

