/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.editor;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.RefinedState;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.ui.behavior.Activator;
import org.eclipse.etrice.ui.behavior.support.ContextSwitcher;
import org.eclipse.etrice.ui.behavior.support.SupportUtil;
import org.eclipse.etrice.ui.common.editor.RoomDiagramEditor;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.swt.graphics.Image;

public class BehaviorEditor
extends RoomDiagramEditor {
    public static final String BEHAVIOR_EDITOR_ID = "org.eclipse.etrice.ui.behavior.editor.BehaviorEditor";

    public Image getDefaultImage() {
        return Activator.getImage("icons/Behavior.gif");
    }

    public void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        RecordingCommand cmd = new RecordingCommand(this.getEditingDomain()){

            protected void doExecute() {
                ContextSwitcher.switchTop(BehaviorEditor.this.getDiagramTypeProvider().getDiagram());
            }
        };
        this.getEditingDomain().getCommandStack().execute((Command)cmd);
        this.getEditingDomain().getCommandStack().flush();
    }

    public boolean showStateGraph(StateGraph sg) {
        URI boUri = EcoreUtil.getURI((EObject)sg);
        final StateGraph mySG = (StateGraph)this.getEditingDomain().getResourceSet().getEObject(boUri, true);
        if (mySG == null) {
            return false;
        }
        RecordingCommand cmd = new RecordingCommand(this.getEditingDomain()){

            protected void doExecute() {
                ContextSwitcher.switchTo(BehaviorEditor.this.getDiagramTypeProvider().getDiagram(), mySG);
            }
        };
        this.getEditingDomain().getCommandStack().execute((Command)cmd);
        this.getEditingDomain().getCommandStack().flush();
        return true;
    }

    public ActorClass getActorClass() {
        Diagram diagram = this.getDiagramTypeProvider().getDiagram();
        EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)diagram);
        if (bo instanceof ActorClass) {
            return (ActorClass)bo;
        }
        return null;
    }

    public void doSave(IProgressMonitor monitor) {
        this.getEditingDomain().getCommandStack().execute((Command)new RecordingCommand(this.getEditingDomain()){

            protected void doExecute() {
                BehaviorEditor.this.removeEmptySubgraphs();
                BehaviorEditor.this.rebaseRefinedStates();
                BehaviorEditor.this.removeUnusedRefinedStates();
            }
        });
        super.doSave(monitor);
    }

    protected void removeUnusedRefinedStates() {
        Diagram diagram = this.getDiagramTypeProvider().getDiagram();
        ActorClass ac = SupportUtil.getActorClass(diagram);
        if (ac.getStateMachine() != null) {
            ArrayList<RefinedState> toBeRemoved = new ArrayList<RefinedState>();
            for (State s : ac.getStateMachine().getStates()) {
                if (!(s instanceof RefinedState) || !this.isUnused((RefinedState)s)) continue;
                toBeRemoved.add((RefinedState)s);
            }
            ac.getStateMachine().getStates().removeAll(toBeRemoved);
        }
    }

    private boolean isUnused(RefinedState s) {
        if (RoomHelpers.hasDirectSubStructure((State)s)) {
            return false;
        }
        if (RoomHelpers.hasDetailCode((DetailCode)s.getEntryCode())) {
            return false;
        }
        return !RoomHelpers.hasDetailCode((DetailCode)s.getExitCode());
    }

    protected void removeEmptySubgraphs() {
        State s;
        Diagram diagram = this.getDiagramTypeProvider().getDiagram();
        StateGraph current = ContextSwitcher.getCurrentStateGraph(diagram);
        if (current != null && current.eContainer() instanceof State && !RoomHelpers.hasDirectSubStructure((State)(s = (State)current.eContainer()))) {
            ContextSwitcher.goUp(diagram, current);
        }
        ArrayList<Shape> toBeRemoved = new ArrayList<Shape>();
        for (Shape ctxShape : diagram.getChildren()) {
            State s2;
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement((PictogramElement)ctxShape);
            if (bo.eIsProxy()) {
                toBeRemoved.add(ctxShape);
                continue;
            }
            assert (bo instanceof StateGraph) : "expected state graph";
            StateGraph sg = (StateGraph)bo;
            if (!(sg.eContainer() instanceof State) || RoomHelpers.hasDirectSubStructure((State)(s2 = (State)sg.eContainer()))) continue;
            EcoreUtil.delete((EObject)sg);
            toBeRemoved.add(ctxShape);
        }
        for (Shape shape : toBeRemoved) {
            EcoreUtil.delete((EObject)shape, (boolean)true);
        }
    }

    protected void rebaseRefinedStates() {
        ActorClass ac = this.getActorClass();
        if (ac.getStateMachine() == null) {
            return;
        }
        Map rs2parent = RoomHelpers.getRefinedStatesToRelocate((ActorClass)ac);
        for (RefinedState rs : rs2parent.keySet()) {
            RefinedState parent = (RefinedState)rs2parent.get(rs);
            if (parent.getSubgraph() == null) {
                parent.setSubgraph(RoomFactory.eINSTANCE.createStateGraph());
            }
            parent.getSubgraph().getStates().add((Object)rs);
        }
    }

    protected void superClassChanged() {
        IDiagramTypeProvider diagramTypeProvider = this.getDiagramTypeProvider();
        Diagram diagram = diagramTypeProvider.getDiagram();
        IFeatureProvider featureProvider = diagramTypeProvider.getFeatureProvider();
        UpdateContext updateCtx = new UpdateContext((PictogramElement)diagram);
        featureProvider.updateIfPossible((IUpdateContext)updateCtx);
        diagramTypeProvider.getDiagramBehavior().refresh();
    }

    protected StructureClass getStructureClass() {
        return this.getActorClass();
    }
}

