/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.commands.handlers;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.ui.RoomUiModule;
import org.eclipse.etrice.core.ui.editor.RoomEditor;
import org.eclipse.etrice.ui.behavior.editor.BehaviorEditor;
import org.eclipse.etrice.ui.structure.editor.StructureEditor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.IFragmentProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public abstract class AbstractEditHandler
extends AbstractHandler {
    @Inject
    protected IResourceValidator resourceValidator;
    @Inject
    IFragmentProvider fragmentProvider;
    private EObjectAtOffsetHelper helper = new EObjectAtOffsetHelper();

    public AbstractEditHandler() {
        Injector injector = RoomUiModule.getInjector();
        injector.injectMembers((Object)this);
    }

    protected abstract boolean prepare(XtextEditor var1, String var2);

    protected abstract void openEditor(EObject var1);

    protected abstract boolean isEnabled(String var1);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        IEditorPart editor = window.getActivePage().getActiveEditor();
        if (editor instanceof RoomEditor) {
            RoomEditor xed = (RoomEditor)editor;
            ISelection selection = xed.getSelectionProvider().getSelection();
            if (selection instanceof IStructuredSelection) {
                String fragment;
                IXtextDocument document;
                XtextEditor xtextEditor;
                IStructuredSelection ss = (IStructuredSelection)selection;
                Object sel = ss.getFirstElement();
                if (sel instanceof EObjectNode && this.checkPrerequisites(xtextEditor = EditorUtils.getActiveXtextEditor((ExecutionEvent)event), document = xtextEditor.getDocument(), fragment = ((EObjectNode)sel).getEObjectURI().fragment())) {
                    this.openEditor(document, fragment);
                }
            } else if (selection instanceof ITextSelection) {
                String fragment;
                final ITextSelection ss = (ITextSelection)selection;
                IXtextDocument document = xed.getDocument();
                if (this.checkPrerequisites((XtextEditor)xed, document, fragment = (String)document.readOnly((IUnitOfWork)new IUnitOfWork<String, XtextResource>(){

                    public String exec(XtextResource resource) throws Exception {
                        EObject obj = AbstractEditHandler.this.helper.resolveElementAt(resource, ss.getOffset());
                        while (obj != null) {
                            if (obj instanceof StructureClass) {
                                return AbstractEditHandler.this.fragmentProvider.getFragment(obj, null);
                            }
                            obj = obj.eContainer();
                        }
                        return null;
                    }
                }))) {
                    this.openEditor(document, fragment);
                }
            }
        } else if (editor instanceof StructureEditor) {
            StructureClass sc = ((StructureEditor)editor).getStructureClass();
            if (sc instanceof ActorClass) {
                this.openEditor((EObject)sc);
            }
        } else if (editor instanceof BehaviorEditor) {
            ActorClass ac = ((BehaviorEditor)editor).getActorClass();
            this.openEditor((EObject)ac);
        }
        return null;
    }

    public boolean isEnabled() {
        IStructuredSelection ss;
        Object sel;
        ISelection selection;
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = win.getActivePage();
        IWorkbenchPart part = page.getActivePart();
        if (part instanceof ContentOutline && (selection = ((ContentOutline)part).getSelection()) instanceof IStructuredSelection && (sel = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof EObjectNode) {
            EObjectNode node = (EObjectNode)sel;
            String fragment = node.getEObjectURI().fragment();
            return this.isEnabled(fragment);
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor instanceof XtextEditor) {
            ISelection selection2 = ((XtextEditor)editor).getSelectionProvider().getSelection();
            if (selection2 instanceof ITextSelection) {
                final ITextSelection ss2 = (ITextSelection)selection2;
                XtextEditor xed = (XtextEditor)editor;
                IXtextDocument document = xed.getDocument();
                String fragment = (String)document.readOnly((IUnitOfWork)new IUnitOfWork<String, XtextResource>(){

                    public String exec(XtextResource resource) throws Exception {
                        EObject obj = AbstractEditHandler.this.helper.resolveElementAt(resource, ss2.getOffset());
                        while (obj != null) {
                            if (obj instanceof StructureClass) {
                                return AbstractEditHandler.this.fragmentProvider.getFragment(obj, null);
                            }
                            obj = obj.eContainer();
                        }
                        return "";
                    }
                });
                return this.isEnabled(fragment);
            }
        } else {
            if (editor instanceof StructureEditor) {
                StructureClass sc = ((StructureEditor)editor).getStructureClass();
                return this.isEnabled(this.fragmentProvider.getFragment((EObject)sc, null));
            }
            if (editor instanceof BehaviorEditor) {
                ActorClass ac = ((BehaviorEditor)editor).getActorClass();
                return this.isEnabled(this.fragmentProvider.getFragment((EObject)ac, null));
            }
        }
        return false;
    }

    protected void openEditor(IXtextDocument document, final String fragment) {
        document.readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

            public void process(XtextResource resource) throws Exception {
                if (resource != null) {
                    EObject object = resource.getEObject(fragment);
                    AbstractEditHandler.this.openEditor(object);
                }
            }
        });
    }

    protected boolean checkPrerequisites(XtextEditor xtextEditor, IXtextDocument document, String fragment) {
        if (fragment == null) {
            return false;
        }
        if (this.hasIssues(document, (IProgressMonitor)new NullProgressMonitor())) {
            MessageDialog.openError((Shell)xtextEditor.getSite().getShell(), (String)"Validation Errors", (String)"The editor has validation errors.\nCannot open diagram!");
            return false;
        }
        if (xtextEditor.isDirty() && !MessageDialog.openQuestion((Shell)xtextEditor.getSite().getShell(), (String)"Save model file", (String)"The editor will be saved before opening the diagram editor.\nProceed?")) {
            return false;
        }
        if (!this.prepare(xtextEditor, fragment)) {
            return false;
        }
        if (xtextEditor.isDirty()) {
            xtextEditor.doSave((IProgressMonitor)new NullProgressMonitor());
        }
        return true;
    }

    public boolean hasIssues(IXtextDocument xtextDocument, final IProgressMonitor monitor) {
        boolean issues = (Boolean)xtextDocument.readOnly((IUnitOfWork)new IUnitOfWork<Boolean, XtextResource>(){

            public Boolean exec(XtextResource resource) throws Exception {
                if (resource == null) {
                    return false;
                }
                List issueList = AbstractEditHandler.this.resourceValidator.validate((Resource)resource, CheckMode.NORMAL_AND_FAST, new CancelIndicator(){

                    public boolean isCanceled() {
                        return monitor.isCanceled();
                    }
                });
                for (Issue issue : issueList) {
                    if (issue.getSeverity() != Severity.ERROR) continue;
                    return true;
                }
                return false;
            }
        });
        return issues;
    }
}

