/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.support;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.naming.RoomNameProvider;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.ReferenceType;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemRef;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.ui.common.support.ChangeAwareCreateFeature;
import org.eclipse.etrice.ui.common.support.ChangeAwareCustomFeature;
import org.eclipse.etrice.ui.common.support.CommonSupportUtil;
import org.eclipse.etrice.ui.common.support.DeleteWithoutConfirmFeature;
import org.eclipse.etrice.ui.structure.DiagramAccess;
import org.eclipse.etrice.ui.structure.DiagramTypeProvider;
import org.eclipse.etrice.ui.structure.dialogs.ActorContainerRefPropertyDialog;
import org.eclipse.etrice.ui.structure.support.DiagramUtil;
import org.eclipse.etrice.ui.structure.support.SupportUtil;
import org.eclipse.etrice.ui.structure.support.context.InitialAddShapeContext;
import org.eclipse.etrice.ui.structure.support.context.PositionUpdateContext;
import org.eclipse.etrice.ui.structure.support.feature.ShapeUpdateFeature;
import org.eclipse.etrice.ui.structure.support.provider.DefaultPositionProvider;
import org.eclipse.etrice.ui.structure.support.provider.IPositionProvider;
import org.eclipse.etrice.ui.structure.support.provider.SuperDiagramPositionProvider;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.features.impl.AbstractLayoutFeature;
import org.eclipse.graphiti.features.impl.DefaultMoveShapeFeature;
import org.eclipse.graphiti.features.impl.DefaultRemoveFeature;
import org.eclipse.graphiti.features.impl.DefaultResizeShapeFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.StyleContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.AbstractStyle;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.algorithms.styles.Style;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ChopboxAnchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.services.IPeService;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.graphiti.util.PredefinedColoredAreas;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;

public class ActorContainerRefSupport {
    private static final String VERSION_KEY = "actorref_version";
    private static final int LINE_WIDTH = 1;
    public static final int DEFAULT_SIZE_X = 180;
    public static final int DEFAULT_SIZE_Y = 80;
    public static final int MIN_SIZE_X = 100;
    public static final int MIN_SIZE_Y = 60;
    public static final int MARGIN = 30;
    private static final int SIZE_FRAME_SIZE = 25;
    private static final int REPLICATED_RECT_OFFSET = 3;
    public static final IColorConstant LINE_COLOR = new ColorConstant(0, 0, 0);
    public static final IColorConstant INHERITED_COLOR = new ColorConstant(100, 100, 100);
    public static final IColorConstant BACKGROUND = new ColorConstant(200, 200, 200);
    public static final String GRAPHIC_ITEM_KEY = "actorref_graphic_element";
    public static final String HATCHED_LINE = "hatched_line";
    public static final String LAYERCONN_ANCHOR = "layerconn_anchor";
    public static final String MAIN_BORDER = "mainborder";
    public static final String NAME_SHAPE = "name_shape";
    public static final String REPL_BORDER = "replborder";
    public static final String SIZE_FRAME = "sizeframe";
    public static final String SIZE_SHAPE = "size_shape";
    public static final String SUBSTRUCTURE = "substructure";
    private FeatureProvider pfp;
    private BehaviorProvider tbp;

    public static Style getStyle(Diagram diagram) {
        IGaService gaService = Graphiti.getGaService();
        Style style = null;
        if (style == null) {
            style = gaService.createPlainStyle((StyleContainer)diagram, "line");
            style.setFilled(Boolean.valueOf(true));
            style.setForeground(gaService.manageColor(diagram, LINE_COLOR));
            gaService.setRenderingStyle((AbstractStyle)style, PredefinedColoredAreas.getBlueWhiteGlossAdaptions());
        }
        return style;
    }

    public ActorContainerRefSupport(IDiagramTypeProvider dtp, IFeatureProvider fp) {
        this.pfp = new FeatureProvider(dtp, fp);
        this.tbp = new BehaviorProvider(dtp);
    }

    public IFeatureProvider getFeatureProvider() {
        return this.pfp;
    }

    public IToolBehaviorProvider getToolBehaviorProvider() {
        return this.tbp;
    }

    private class BehaviorProvider
    extends DefaultToolBehaviorProvider {
        public BehaviorProvider(IDiagramTypeProvider dtp) {
            super(dtp);
        }

        public GraphicsAlgorithm[] getClickArea(PictogramElement pe) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            if (!rectangle.getLineVisible().booleanValue()) {
                rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(1);
            }
            return new GraphicsAlgorithm[]{rectangle};
        }

        public GraphicsAlgorithm getSelectionBorder(PictogramElement pe) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            if (!rectangle.getLineVisible().booleanValue()) {
                rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(1);
            }
            return rectangle;
        }

        public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
            return new FeatureProvider.OpenRefStructureDiagram(this.getDiagramTypeProvider().getFeatureProvider());
        }

        public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
            ICreateConnectionFeature[] features;
            IContextButtonPadData data = super.getContextButtonPad(context);
            PictogramElement pe = context.getPictogramElement();
            CreateConnectionContext ccc = new CreateConnectionContext();
            ccc.setSourcePictogramElement(pe);
            Anchor anchor = null;
            if (pe instanceof AnchorContainer) {
                anchor = (Anchor)((ContainerShape)pe).getAnchors().get(0);
            }
            ccc.setSourceAnchor(anchor);
            ContextButtonEntry button = new ContextButtonEntry(null, (IContext)context);
            button.setText("Create Layer Connection");
            button.setIconId("org.eclipse.etrice.ui.structure.layer_connection");
            ICreateConnectionFeature[] iCreateConnectionFeatureArray = features = this.getFeatureProvider().getCreateConnectionFeatures();
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                ICreateConnectionFeature feature = iCreateConnectionFeatureArray[n2];
                if (feature.isAvailable((IContext)ccc) && feature.canStartConnection((ICreateConnectionContext)ccc)) {
                    button.addDragAndDropFeature((IFeature)feature);
                }
                ++n2;
            }
            if (button.getDragAndDropFeatures().size() > 0) {
                data.getDomainSpecificContextButtons().add(button);
            }
            return data;
        }
    }

    private static class FeatureProvider
    extends DefaultFeatureProvider {
        private IFeatureProvider fp;

        public FeatureProvider(IDiagramTypeProvider dtp, IFeatureProvider fp) {
            super(dtp);
            this.fp = fp;
        }

        public ICreateFeature[] getCreateFeatures() {
            return new ICreateFeature[]{new CreateFeature(this.fp, true), new CreateFeature(this.fp, false)};
        }

        public IAddFeature getAddFeature(IAddContext context) {
            return new AddFeature(this.fp);
        }

        public ILayoutFeature getLayoutFeature(ILayoutContext context) {
            return new LayoutFeature(this.fp);
        }

        public IUpdateFeature getUpdateFeature(IUpdateContext context) {
            return new UpdateFeature(this.fp);
        }

        public IMoveShapeFeature getMoveShapeFeature(IMoveShapeContext context) {
            return new MoveShapeFeature(this.fp);
        }

        public IResizeShapeFeature getResizeShapeFeature(IResizeShapeContext context) {
            return new ResizeFeature(this.fp);
        }

        public IRemoveFeature getRemoveFeature(IRemoveContext context) {
            return new RemoveFeature(this.fp);
        }

        public IDeleteFeature getDeleteFeature(IDeleteContext context) {
            return new DeleteFeature(this.fp);
        }

        public ICustomFeature[] getCustomFeatures(ICustomContext context) {
            return new ICustomFeature[]{new PropertyFeature(this.fp), new OpenRefStructureDiagram(this.fp), new OpenRefBehaviorDiagram(this.fp)};
        }

        protected static boolean isInherited(ActorContainerRef ar, EObject parent) {
            return ar.eContainer() != parent;
        }

        private static boolean hasSubStructure(ActorContainerRef acr) {
            return acr instanceof ActorRef ? !((ActorRef)acr).getType().getActorRefs().isEmpty() : acr instanceof SubSystemRef && !((SubSystemRef)acr).getType().getActorRefs().isEmpty();
        }

        private static void updateRefFigure(ActorContainerRef acr, ContainerShape containerShape, boolean inherited, Diagram diagram) {
            boolean isReplicated;
            boolean bl = acr instanceof ActorRef ? ((ActorRef)acr).getMultiplicity() != 1 : (isReplicated = false);
            boolean isOptional = acr instanceof ActorRef ? ((ActorRef)acr).getRefType() == ReferenceType.OPTIONAL : false;
            boolean hasSubStructure = FeatureProvider.hasSubStructure(acr);
            IColorConstant lineColorConstant = inherited ? INHERITED_COLOR : LINE_COLOR;
            Color lineColor = Graphiti.getGaService().manageColor(diagram, lineColorConstant);
            Color bgColor = Graphiti.getGaService().manageColor(diagram, BACKGROUND);
            ActorRefGraphicsAccess graphics = new ActorRefGraphicsAccess(containerShape, diagram);
            Rectangle rect = graphics.getReplBorder();
            rect.setForeground(lineColor);
            rect.setBackground(bgColor);
            rect.setLineVisible(Boolean.valueOf(isReplicated));
            rect.setFilled(Boolean.valueOf(isReplicated));
            rect = graphics.getMainBorder();
            rect.setForeground(lineColor);
            rect.setBackground(bgColor);
            for (GraphicsAlgorithm line : graphics.getHatchedLines()) {
                line.setLineVisible(Boolean.valueOf(isOptional));
                line.setForeground(lineColor);
            }
            for (GraphicsAlgorithm hint : graphics.getSubstructure()) {
                hint.setLineVisible(Boolean.valueOf(hasSubStructure));
                hint.setForeground(lineColor);
            }
            rect = graphics.getSizeFrame();
            rect.setForeground(lineColor);
            rect.setBackground(bgColor);
            rect.setLineVisible(Boolean.valueOf(isReplicated));
            rect.setFilled(Boolean.valueOf(isReplicated));
            Text label = graphics.getNameLabel();
            label.setValue(RoomNameProvider.getRefLabelName((ActorContainerRef)acr));
            label.setForeground(lineColor);
            label.setBackground(bgColor);
            label = graphics.getSizeLabel();
            if (acr instanceof ActorRef) {
                ActorRef ar = (ActorRef)acr;
                String text = isOptional ? "*" : String.valueOf(ar.getMultiplicity());
                label.setValue(text);
            }
            label.setForeground(lineColor);
            label.setBackground(bgColor);
            label.getPictogramElement().setVisible(isReplicated);
        }

        private static class ActorRefGraphicsAccess {
            private IPeService peService;
            private ContainerShape containerShape;
            private GraphicsAlgorithm invRectangle;
            private Diagram diagram;

            public ActorRefGraphicsAccess(ContainerShape containerShape, Diagram diagram) {
                this.containerShape = containerShape;
                this.invRectangle = containerShape.getGraphicsAlgorithm();
                this.diagram = diagram;
                this.peService = Graphiti.getPeService();
                String version = this.peService.getPropertyValue((PropertyContainer)containerShape, ActorContainerRefSupport.VERSION_KEY);
                if (!"2".equals(version)) {
                    this.convertToVersion2();
                }
            }

            private void convertToVersion2() {
                ArrayList<Object> deleteList = new ArrayList<Object>();
                for (Shape child : this.containerShape.getChildren()) {
                    if (!(child.getGraphicsAlgorithm() instanceof Text)) continue;
                    deleteList.add(child);
                }
                for (GraphicsAlgorithm ga : this.invRectangle.getGraphicsAlgorithmChildren()) {
                    deleteList.add(ga);
                }
                this.createRefFigureInternal();
                for (Anchor anchor : this.containerShape.getAnchors()) {
                    anchor.setReferencedGraphicsAlgorithm((GraphicsAlgorithm)this.getMainBorder());
                }
                for (EObject toDelete : Lists.newArrayList(deleteList)) {
                    EcoreUtil.delete((EObject)toDelete, (boolean)true);
                }
                this.peService.setPropertyValue((PropertyContainer)this.containerShape, ActorContainerRefSupport.VERSION_KEY, "2");
            }

            public Rectangle getMainBorder() {
                return (Rectangle)this.findFirst((List<? extends PropertyContainer>)this.invRectangle.getGraphicsAlgorithmChildren(), ActorContainerRefSupport.MAIN_BORDER);
            }

            public Rectangle getReplBorder() {
                return (Rectangle)this.findFirst((List<? extends PropertyContainer>)this.invRectangle.getGraphicsAlgorithmChildren(), ActorContainerRefSupport.REPL_BORDER);
            }

            public Rectangle getSizeFrame() {
                return (Rectangle)this.findFirst((List<? extends PropertyContainer>)this.invRectangle.getGraphicsAlgorithmChildren(), ActorContainerRefSupport.SIZE_FRAME);
            }

            public List<GraphicsAlgorithm> getSubstructure() {
                Rectangle mainBorder = this.getMainBorder();
                return this.findAll((List<? extends PropertyContainer>)mainBorder.getGraphicsAlgorithmChildren(), ActorContainerRefSupport.SUBSTRUCTURE);
            }

            public List<GraphicsAlgorithm> getHatchedLines() {
                Rectangle mainBorder = this.getMainBorder();
                return this.findAll((List<? extends PropertyContainer>)mainBorder.getGraphicsAlgorithmChildren(), ActorContainerRefSupport.HATCHED_LINE);
            }

            public Text getNameLabel() {
                Shape shape = (Shape)this.findFirst((List<? extends PropertyContainer>)this.containerShape.getChildren(), ActorContainerRefSupport.NAME_SHAPE);
                return (Text)shape.getGraphicsAlgorithm();
            }

            public Text getSizeLabel() {
                Shape shape = (Shape)this.findFirst((List<? extends PropertyContainer>)this.containerShape.getChildren(), ActorContainerRefSupport.SIZE_SHAPE);
                return (Text)shape.getGraphicsAlgorithm();
            }

            private List<? extends PropertyContainer> findAll(List<? extends PropertyContainer> items, String propValue) {
                ArrayList<PropertyContainer> result = new ArrayList<PropertyContainer>();
                for (PropertyContainer propertyContainer : items) {
                    if (!propValue.equals(this.peService.getPropertyValue(propertyContainer, ActorContainerRefSupport.GRAPHIC_ITEM_KEY))) continue;
                    result.add(propertyContainer);
                }
                return result;
            }

            private PropertyContainer findFirst(List<? extends PropertyContainer> items, String propValue) {
                for (PropertyContainer propertyContainer : items) {
                    if (!propValue.equals(this.peService.getPropertyValue(propertyContainer, ActorContainerRefSupport.GRAPHIC_ITEM_KEY))) continue;
                    return propertyContainer;
                }
                return null;
            }

            private void createRefFigureInternal() {
                int width = this.invRectangle.getWidth() - 60;
                int height = this.invRectangle.getHeight() - 60;
                IGaService gaService = Graphiti.getGaService();
                IPeService peService = Graphiti.getPeService();
                IPeCreateService peCreateService = Graphiti.getPeCreateService();
                Rectangle rect = gaService.createRectangle((GraphicsAlgorithmContainer)this.invRectangle);
                peService.setPropertyValue((PropertyContainer)rect, ActorContainerRefSupport.GRAPHIC_ITEM_KEY, ActorContainerRefSupport.REPL_BORDER);
                rect.setLineWidth(Integer.valueOf(1));
                gaService.setLocationAndSize((GraphicsAlgorithm)rect, 33, 27, width, height);
                Rectangle borderRect = gaService.createRectangle((GraphicsAlgorithmContainer)this.invRectangle);
                peService.setPropertyValue((PropertyContainer)borderRect, ActorContainerRefSupport.GRAPHIC_ITEM_KEY, ActorContainerRefSupport.MAIN_BORDER);
                borderRect.setLineWidth(Integer.valueOf(1));
                gaService.setLocationAndSize((GraphicsAlgorithm)borderRect, 30, 30, width, height);
                this.addSubStructureHint();
                this.createHatched();
                Rectangle sizeFrame = gaService.createRectangle((GraphicsAlgorithmContainer)this.invRectangle);
                peService.setPropertyValue((PropertyContainer)sizeFrame, ActorContainerRefSupport.GRAPHIC_ITEM_KEY, ActorContainerRefSupport.SIZE_FRAME);
                sizeFrame.setLineWidth(Integer.valueOf(1));
                gaService.setLocationAndSize((GraphicsAlgorithm)sizeFrame, 30 + width - 25, 30, 25, 25);
                Shape labelShape = peCreateService.createShape(this.containerShape, false);
                peService.setPropertyValue((PropertyContainer)labelShape, ActorContainerRefSupport.GRAPHIC_ITEM_KEY, ActorContainerRefSupport.NAME_SHAPE);
                Text label = gaService.createDefaultText(this.diagram, (GraphicsAlgorithmContainer)labelShape);
                label.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
                label.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
                gaService.setLocationAndSize((GraphicsAlgorithm)label, 30, 30, width, height);
                labelShape = peCreateService.createShape(this.containerShape, false);
                peService.setPropertyValue((PropertyContainer)labelShape, ActorContainerRefSupport.GRAPHIC_ITEM_KEY, ActorContainerRefSupport.SIZE_SHAPE);
                label = gaService.createDefaultText(this.diagram, (GraphicsAlgorithmContainer)labelShape);
                label.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
                label.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
                gaService.setLocationAndSize((GraphicsAlgorithm)label, 30 + width - 25, 30, 25, 25);
            }

            private void createRefFigureAnchor() {
                ChopboxAnchor anchor = Graphiti.getPeCreateService().createChopboxAnchor((AnchorContainer)this.containerShape);
                this.peService.setPropertyValue((PropertyContainer)anchor, ActorContainerRefSupport.GRAPHIC_ITEM_KEY, ActorContainerRefSupport.LAYERCONN_ANCHOR);
                anchor.setReferencedGraphicsAlgorithm((GraphicsAlgorithm)this.getMainBorder());
            }

            public void createRefFigure() {
                this.createRefFigureInternal();
                this.createRefFigureAnchor();
            }

            public void createHatched() {
                int x0 = 0;
                int y0 = 0;
                int x1 = 0;
                int y1 = 0;
                int step = 15;
                boolean down0 = true;
                boolean right1 = true;
                Rectangle mainBorder = this.getMainBorder();
                int width = mainBorder.getWidth();
                int height = mainBorder.getHeight();
                IGaService gaService = Graphiti.getGaService();
                while (true) {
                    if (down0) {
                        if ((y0 += step) > height) {
                            down0 = false;
                            x0 = y0 - height;
                            y0 = height;
                        }
                    } else if ((x0 += step) > width) break;
                    if (right1) {
                        if ((x1 += step) > width) {
                            right1 = false;
                            y1 = x1 - width;
                            x1 = width;
                        }
                    } else {
                        y1 += step;
                        if (y0 > height) break;
                    }
                    Polyline line = gaService.createPlainPolyline((GraphicsAlgorithmContainer)mainBorder, new int[]{x0, y0, x1, y1});
                    Graphiti.getPeService().setPropertyValue((PropertyContainer)line, ActorContainerRefSupport.GRAPHIC_ITEM_KEY, ActorContainerRefSupport.HATCHED_LINE);
                    line.setTransparency(Double.valueOf(0.4));
                }
            }

            private void addSubStructureHint() {
                Rectangle mainBorder = this.getMainBorder();
                int x = mainBorder.getWidth() - 35;
                int y = mainBorder.getHeight() - 30;
                IGaService gaService = Graphiti.getGaService();
                Rectangle hint1 = gaService.createRectangle((GraphicsAlgorithmContainer)mainBorder);
                Graphiti.getPeService().setPropertyValue((PropertyContainer)hint1, ActorContainerRefSupport.GRAPHIC_ITEM_KEY, ActorContainerRefSupport.SUBSTRUCTURE);
                hint1.setFilled(Boolean.valueOf(false));
                hint1.setLineWidth(Integer.valueOf(1));
                gaService.setLocationAndSize((GraphicsAlgorithm)hint1, x + 5, y, 20, 10);
                Rectangle hint2 = gaService.createRectangle((GraphicsAlgorithmContainer)mainBorder);
                Graphiti.getPeService().setPropertyValue((PropertyContainer)hint2, ActorContainerRefSupport.GRAPHIC_ITEM_KEY, ActorContainerRefSupport.SUBSTRUCTURE);
                hint2.setFilled(Boolean.valueOf(false));
                hint2.setLineWidth(Integer.valueOf(1));
                gaService.setLocationAndSize((GraphicsAlgorithm)hint2, x, y + 15, 20, 10);
            }
        }

        private class AddFeature
        extends AbstractAddFeature {
            public AddFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canAdd(IAddContext context) {
                EObject obj;
                return context.getNewObject() instanceof ActorContainerRef && context.getTargetContainer().getLink().getBusinessObjects().size() == 1 && (obj = (EObject)context.getTargetContainer().getLink().getBusinessObjects().get(0)) instanceof StructureClass;
            }

            public PictogramElement add(IAddContext context) {
                ActorContainerRef ar = (ActorContainerRef)context.getNewObject();
                ContainerShape acShape = context.getTargetContainer();
                ContainerShape containerShape = Graphiti.getPeCreateService().createContainerShape(acShape, true);
                Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, "obj-type", "ref");
                Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, ActorContainerRefSupport.VERSION_KEY, "2");
                int width = context.getWidth() <= 0 ? 180 : context.getWidth();
                int height = context.getHeight() <= 0 ? 80 : context.getHeight();
                Rectangle invisibleRectangle = Graphiti.getGaService().createInvisibleRectangle((PictogramElement)containerShape);
                Graphiti.getGaService().setLocationAndSize((GraphicsAlgorithm)invisibleRectangle, context.getX() - (width / 2 + 30), context.getY() - (height / 2 + 30), width + 60, height + 60);
                new ActorRefGraphicsAccess(containerShape, this.getDiagram()).createRefFigure();
                this.link((PictogramElement)containerShape, ar);
                if (!(context instanceof InitialAddShapeContext)) {
                    this.updatePictogramElement((PictogramElement)containerShape);
                }
                this.layoutPictogramElement((PictogramElement)containerShape);
                return containerShape;
            }
        }

        private class CreateFeature
        extends ChangeAwareCreateFeature {
            private boolean actorRef;

            public CreateFeature(IFeatureProvider fp, boolean actorRef) {
                super(fp, actorRef ? "ActorRef" : "SubSystemRef", "create " + (actorRef ? "ActorRef" : "SubSystemRef"));
                this.actorRef = actorRef;
            }

            public String getCreateImageId() {
                return "org.eclipse.etrice.ui.structure.ref";
            }

            public boolean canCreate(ICreateContext context) {
                if (context.getTargetContainer().getLink() != null && context.getTargetContainer().getLink().getBusinessObjects().size() == 1) {
                    EObject obj = (EObject)context.getTargetContainer().getLink().getBusinessObjects().get(0);
                    if (obj instanceof ActorContainerClass) {
                        return this.actorRef;
                    }
                    if (obj instanceof LogicalSystem) {
                        return !this.actorRef;
                    }
                }
                return false;
            }

            protected Object[] doCreate(ICreateContext context) {
                StructureClass sc = (StructureClass)context.getTargetContainer().getLink().getBusinessObjects().get(0);
                ActorRef newRef = null;
                if (sc instanceof ActorContainerClass) {
                    ActorContainerClass acc = (ActorContainerClass)sc;
                    ActorRef ar = RoomFactory.eINSTANCE.createActorRef();
                    acc.getActorRefs().add((Object)ar);
                    newRef = ar;
                } else if (sc instanceof LogicalSystem) {
                    LogicalSystem sys = (LogicalSystem)sc;
                    SubSystemRef ssr = RoomFactory.eINSTANCE.createSubSystemRef();
                    sys.getSubSystems().add((Object)ssr);
                    newRef = ssr;
                }
                newRef.setName(RoomNameProvider.getUniqueActorContainerRefName((StructureClass)sc));
                IScopeProvider scopeProvider = ((DiagramTypeProvider)this.getFeatureProvider().getDiagramTypeProvider()).getScopeProvider();
                EReference reference = newRef instanceof ActorRef ? RoomPackage.eINSTANCE.getActorRef_Type() : RoomPackage.eINSTANCE.getSubSystemRef_Type();
                IScope scope = scopeProvider.getScope(newRef.eContainer().eContainer(), reference);
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ActorContainerRefPropertyDialog dlg = new ActorContainerRefPropertyDialog(shell, (ActorContainerRef)newRef, scope, sc, true);
                if (dlg.open() == 0) {
                    this.addGraphicalRepresentation((IAreaContext)context, newRef);
                    return new Object[]{newRef};
                }
                return EMPTY;
            }
        }

        private class DeleteFeature
        extends DeleteWithoutConfirmFeature {
            public DeleteFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canDelete(IDeleteContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof ActorContainerRef) {
                    ActorContainerRef ar = (ActorContainerRef)bo;
                    ContainerShape acShape = (ContainerShape)context.getPictogramElement().eContainer();
                    EObject parent = (EObject)acShape.getLink().getBusinessObjects().get(0);
                    return !FeatureProvider.isInherited(ar, parent);
                }
                return false;
            }

            public void preDelete(IDeleteContext context) {
                super.preDelete(context);
                if (!(context.getPictogramElement() instanceof ContainerShape)) {
                    return;
                }
                ContainerShape container = (ContainerShape)context.getPictogramElement();
                CommonSupportUtil.deleteConnectionsRecursive((ContainerShape)container, (IFeatureProvider)this.getFeatureProvider());
            }
        }

        private class LayoutFeature
        extends AbstractLayoutFeature {
            public LayoutFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canLayout(ILayoutContext context) {
                PictogramElement pe = context.getPictogramElement();
                if (!(pe instanceof ContainerShape)) {
                    return false;
                }
                EList businessObjects = pe.getLink().getBusinessObjects();
                return businessObjects.size() == 1 && businessObjects.get(0) instanceof ActorContainerRef;
            }

            public boolean layout(ILayoutContext context) {
                ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
                GraphicsAlgorithm invRectangle = containerShape.getGraphicsAlgorithm();
                ActorRefGraphicsAccess graphics = new ActorRefGraphicsAccess(containerShape, this.getDiagram());
                int w = invRectangle.getWidth();
                int h = invRectangle.getHeight();
                int nw = w - 60;
                int nh = h - 60;
                Rectangle replBorder = graphics.getReplBorder();
                replBorder.setWidth(nw);
                replBorder.setHeight(nh);
                Rectangle mainBorder = graphics.getMainBorder();
                mainBorder.setWidth(nw);
                mainBorder.setHeight(nh);
                int x = mainBorder.getWidth() - 35;
                int y = mainBorder.getHeight() - 30;
                Graphiti.getLayoutService().setLocationAndSize(graphics.getSubstructure().get(0), x + 5, y, 20, 10);
                Graphiti.getLayoutService().setLocationAndSize(graphics.getSubstructure().get(1), x, y + 15, 20, 10);
                for (GraphicsAlgorithm line : Lists.newArrayList(graphics.getHatchedLines())) {
                    EcoreUtil.delete((EObject)line, (boolean)true);
                }
                graphics.createHatched();
                Rectangle replFrame = graphics.getSizeFrame();
                replFrame.setX(30 + nw - 25);
                Text label = graphics.getNameLabel();
                label.setWidth(nw);
                label.setHeight(nh);
                Text replLabel = graphics.getSizeLabel();
                replLabel.setX(30 + nw - 25);
                ActorContainerRef acr = (ActorContainerRef)this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                EObject parent = (EObject)this.getBusinessObjectForPictogramElement((PictogramElement)containerShape.getContainer());
                boolean inherited = FeatureProvider.isInherited(acr, parent);
                FeatureProvider.updateRefFigure(acr, containerShape, inherited, this.getDiagram());
                return true;
            }
        }

        private class MoveShapeFeature
        extends DefaultMoveShapeFeature {
            public MoveShapeFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canMoveShape(IMoveShapeContext context) {
                Object bo;
                boolean canMove = super.canMoveShape(context);
                if (canMove && (bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement())) instanceof ActorContainerRef) {
                    ActorContainerRef ar = (ActorContainerRef)bo;
                    ContainerShape acShape = context.getTargetContainer();
                    EObject parent = (EObject)acShape.getLink().getBusinessObjects().get(0);
                    return !FeatureProvider.isInherited(ar, parent);
                }
                return canMove;
            }
        }

        private static class OpenRefBehaviorDiagram
        extends AbstractCustomFeature {
            public OpenRefBehaviorDiagram(IFeatureProvider fp) {
                super(fp);
            }

            public String getName() {
                return "Open Ref Behavior";
            }

            public boolean canExecute(ICustomContext context) {
                Object bo;
                PictogramElement[] pes = context.getPictogramElements();
                return pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof ActorRef;
            }

            public void execute(ICustomContext context) {
                Object bo;
                PictogramElement[] pes = context.getPictogramElements();
                if (pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof ActorContainerRef) {
                    final ActorContainerRef ref = (ActorContainerRef)bo;
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            org.eclipse.etrice.ui.behavior.DiagramAccess diagramAccess = new org.eclipse.etrice.ui.behavior.DiagramAccess();
                            if (ref instanceof ActorRef) {
                                diagramAccess.openDiagramEditor((StructureClass)((ActorRef)ref).getType());
                            }
                        }
                    });
                }
            }

            public boolean hasDoneChanges() {
                ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.etrice.ui.common");
                boolean autoSave = store.getBoolean("SaveDiagOnFocusLost");
                return autoSave;
            }
        }

        private static class OpenRefStructureDiagram
        extends AbstractCustomFeature {
            public OpenRefStructureDiagram(IFeatureProvider fp) {
                super(fp);
            }

            public String getName() {
                return "Open Ref Structure";
            }

            public boolean canExecute(ICustomContext context) {
                Object bo;
                PictogramElement[] pes = context.getPictogramElements();
                return pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof ActorContainerRef;
            }

            public void execute(ICustomContext context) {
                Object bo;
                PictogramElement[] pes = context.getPictogramElements();
                if (pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof ActorContainerRef) {
                    final ActorContainerRef ref = (ActorContainerRef)bo;
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            DiagramAccess diagramAccess = new DiagramAccess();
                            if (ref instanceof ActorRef) {
                                diagramAccess.openDiagramEditor((StructureClass)((ActorRef)ref).getType());
                            } else if (ref instanceof SubSystemRef) {
                                diagramAccess.openDiagramEditor((StructureClass)((SubSystemRef)ref).getType());
                            }
                        }
                    });
                }
            }

            public boolean hasDoneChanges() {
                return false;
            }
        }

        private static class PropertyFeature
        extends ChangeAwareCustomFeature {
            public PropertyFeature(IFeatureProvider fp) {
                super(fp);
            }

            public String getName() {
                return "Edit Reference...";
            }

            public String getDescription() {
                return "Edit Reference Properties";
            }

            public boolean canExecute(ICustomContext context) {
                Object bo;
                PictogramElement[] pes = context.getPictogramElements();
                if (pes != null && pes.length == 1 && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof ActorContainerRef) {
                    EObject parent = (EObject)this.getBusinessObjectForPictogramElement((PictogramElement)pes[0].eContainer());
                    return !FeatureProvider.isInherited((ActorContainerRef)bo, parent);
                }
                return false;
            }

            protected boolean doExecute(ICustomContext context) {
                ContainerShape containerShape = (ContainerShape)context.getPictogramElements()[0];
                ActorContainerRef acr = (ActorContainerRef)this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                StructureClass sc = (StructureClass)acr.eContainer();
                IScopeProvider scopeProvider = ((DiagramTypeProvider)this.getFeatureProvider().getDiagramTypeProvider()).getScopeProvider();
                EReference reference = acr instanceof ActorRef ? RoomPackage.eINSTANCE.getActorRef_Type() : RoomPackage.eINSTANCE.getSubSystemRef_Type();
                IScope scope = scopeProvider.getScope(acr.eContainer().eContainer(), reference);
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ActorContainerRefPropertyDialog dlg = new ActorContainerRefPropertyDialog(shell, acr, scope, sc, false);
                if (dlg.open() == 0) {
                    EObject parent = (EObject)this.getBusinessObjectForPictogramElement((PictogramElement)containerShape.getContainer());
                    FeatureProvider.updateRefFigure(acr, containerShape, FeatureProvider.isInherited(acr, parent), this.getDiagram());
                    return true;
                }
                return false;
            }
        }

        private class RemoveFeature
        extends DefaultRemoveFeature {
            public RemoveFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canRemove(IRemoveContext context) {
                return false;
            }
        }

        private class ResizeFeature
        extends DefaultResizeShapeFeature {
            public ResizeFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canResizeShape(IResizeShapeContext context) {
                if (!super.canResizeShape(context)) {
                    return false;
                }
                int width = context.getWidth() - 30;
                int height = context.getHeight() - 30;
                return width <= 0 || height <= 0 || width >= 130 && height >= 90;
            }

            public void resizeShape(IResizeShapeContext context) {
                ContainerShape containerShape = (ContainerShape)context.getShape();
                GraphicsAlgorithm containerGa = containerShape.getGraphicsAlgorithm();
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                if (bo instanceof ActorRef && ((ActorRef)bo).getMultiplicity() != 1) {
                    this.resizeChildrenInterfaceItems(context, (GraphicsAlgorithm)containerGa.getGraphicsAlgorithmChildren().get(1));
                } else {
                    this.resizeChildrenInterfaceItems(context, (GraphicsAlgorithm)containerGa.getGraphicsAlgorithmChildren().get(0));
                }
                super.resizeShape(context);
            }

            private void resizeChildrenInterfaceItems(IResizeShapeContext context, GraphicsAlgorithm innerRect) {
                IPositionProvider.PosAndSize innerRectPos = DiagramUtil.getPosAndSize(innerRect);
                double sx = (double)(context.getWidth() - 2 * innerRectPos.getX()) / (double)innerRectPos.getW();
                double sy = (double)(context.getHeight() - 2 * innerRectPos.getY()) / (double)innerRectPos.getH();
                for (Shape childShape : ((ContainerShape)context.getPictogramElement()).getChildren()) {
                    Object childBo = this.getBusinessObjectForPictogramElement((PictogramElement)childShape);
                    if (!(childBo instanceof InterfaceItem)) continue;
                    GraphicsAlgorithm childGa = childShape.getGraphicsAlgorithm();
                    IPositionProvider.PosAndSize childPos = DiagramUtil.getPosAndSize(childGa);
                    int midX = childPos.getX() + childPos.getW() / 2 - innerRectPos.getX();
                    int midY = childPos.getY() + childPos.getH() / 2 - innerRectPos.getY();
                    midX = (int)(sx * (double)midX);
                    midY = (int)(sy * (double)midY);
                    midX = midX - childPos.getW() / 2 + innerRectPos.getX();
                    midY = midY - childPos.getH() / 2 + innerRectPos.getY();
                    Graphiti.getGaService().setLocation(childGa, midX, midY);
                    this.updatePictogramElement((PictogramElement)childShape);
                }
            }
        }

        private class UpdateFeature
        extends ShapeUpdateFeature {
            public UpdateFeature(IFeatureProvider fp) {
                super(fp);
            }

            @Override
            protected boolean canUpdate(EObject bo, PictogramElement pe) {
                return bo instanceof ActorContainerRef;
            }

            @Override
            protected IReason updateNeeded(EObject bo, IUpdateContext context) {
                String label;
                boolean isReplicated;
                ActorContainerRef acr = (ActorContainerRef)bo;
                ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
                ActorRefGraphicsAccess graphics = new ActorRefGraphicsAccess(containerShape, this.getDiagram());
                String reason = "";
                boolean bl = acr instanceof ActorRef ? ((ActorRef)acr).getMultiplicity() != 1 : (isReplicated = false);
                boolean isOptional = acr instanceof ActorRef ? ((ActorRef)acr).getRefType() == ReferenceType.OPTIONAL : false;
                boolean hasSubStruct = FeatureProvider.hasSubStructure(acr);
                boolean replFrameVisible = graphics.getReplBorder().getLineVisible();
                if (isReplicated && !replFrameVisible) {
                    reason = String.valueOf(reason) + "ActorRef got replicated";
                } else if (!isReplicated && replFrameVisible) {
                    reason = String.valueOf(reason) + "ActorRef is not replicated anymore";
                }
                Object containerBo = this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                if (containerBo instanceof ActorClass) {
                    ActorClass ac = (ActorClass)containerBo;
                    boolean found = false;
                    do {
                        if (ac == acr.eContainer()) {
                            found = true;
                        }
                        ac = ac.getBase();
                    } while (!found && ac != null);
                    if (!found) {
                        reason = String.valueOf(reason) + "Ref not inherited anymore\n";
                    }
                }
                boolean subStructureVisible = graphics.getSubstructure().get(0).getLineVisible();
                if (hasSubStruct && !subStructureVisible) {
                    reason = String.valueOf(reason) + "state has sub structure now\n";
                }
                if (!hasSubStruct && subStructureVisible) {
                    reason = String.valueOf(reason) + "state has no sub structure anymore\n";
                }
                if (bo instanceof ActorContainerRef && !(label = RoomNameProvider.getRefLabelName((ActorContainerRef)((ActorContainerRef)bo))).equals(graphics.getNameLabel().getValue())) {
                    reason = String.valueOf(reason) + "Class name is out of date\n";
                }
                if (isOptional || isReplicated) {
                    String string = label = isOptional ? "*" : String.valueOf(((ActorRef)bo).getMultiplicity());
                    if (!label.equals(graphics.getSizeLabel().getValue())) {
                        reason = String.valueOf(reason) + "multiplicity changed";
                    }
                }
                ActorClass acc = acr instanceof ActorRef ? ((ActorRef)acr).getType() : ((SubSystemRef)acr).getType();
                List interfaceItems = RoomHelpers.getInterfaceItems((StructureClass)acc, (boolean)true);
                List<InterfaceItem> presentItems = SupportUtil.getInterfaceItems(containerShape, FeatureProvider.this.fp);
                int missing = 0;
                for (InterfaceItem interfaceItem : interfaceItems) {
                    if (presentItems.contains(interfaceItem)) continue;
                    ++missing;
                }
                if (missing > 0) {
                    reason = String.valueOf(reason) + missing + " interface item(s) missing\n";
                }
                if (!reason.isEmpty()) {
                    return Reason.createTrueReason((String)reason.substring(0, reason.length() - 1));
                }
                return Reason.createFalseReason();
            }

            @Override
            protected boolean update(EObject bo, IUpdateContext context) {
                ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
                GraphicsAlgorithm invisibleRect = containerShape.getGraphicsAlgorithm();
                ActorContainerRef acr = (ActorContainerRef)bo;
                if (context instanceof PositionUpdateContext) {
                    this.setPosition((EObject)acr, (Shape)containerShape, (PositionUpdateContext)context);
                }
                EObject parent = (EObject)this.getBusinessObjectForPictogramElement((PictogramElement)containerShape.getContainer());
                FeatureProvider.updateRefFigure(acr, containerShape, FeatureProvider.isInherited(acr, parent), this.getDiagram());
                Rectangle mainBorder = new ActorRefGraphicsAccess(containerShape, this.getDiagram()).getMainBorder();
                IPositionProvider positionProvider = null;
                if (context instanceof PositionUpdateContext) {
                    positionProvider = ((PositionUpdateContext)context).getPositionProvider();
                    positionProvider = positionProvider.setNewParent((EObject)acr, DiagramUtil.getPosAndSize(invisibleRect), DiagramUtil.getPosAndSize((GraphicsAlgorithm)mainBorder));
                }
                Map<EObject, Shape> present = this.getChildrenShapesForBoClass(containerShape, RoomPackage.Literals.INTERFACE_ITEM);
                ActorClass acc = acr instanceof ActorRef ? ((ActorRef)acr).getType() : ((SubSystemRef)acr).getType();
                ArrayList expected = new ArrayList(RoomHelpers.getInterfaceItems((StructureClass)acc, (boolean)true));
                expected.removeAll(present.keySet());
                Map<EObject, Shape> newShapes = this.addShapesInitial(expected, containerShape);
                if (positionProvider != null) {
                    this.updatePictogramElements(newShapes.values(), positionProvider);
                }
                HashMap<EObject, Shape> withoutPosition = new HashMap<EObject, Shape>();
                if (positionProvider != null) {
                    for (EObject obj : newShapes.keySet()) {
                        if (positionProvider.contains(obj)) continue;
                        withoutPosition.put(obj, newShapes.get(obj));
                    }
                } else if (!newShapes.isEmpty()) {
                    withoutPosition.putAll(newShapes);
                }
                if (!withoutPosition.isEmpty()) {
                    IPositionProvider defaultPP = new DefaultPositionProvider(acr);
                    defaultPP = defaultPP.setNewParent((EObject)acr, DiagramUtil.getPosAndSize(invisibleRect), DiagramUtil.getPosAndSize((GraphicsAlgorithm)mainBorder));
                    this.updatePictogramElements(newShapes.values(), defaultPP);
                }
                if (positionProvider instanceof SuperDiagramPositionProvider) {
                    this.updatePictogramElements(present.values(), positionProvider);
                } else {
                    this.updatePictogramElements(present.values());
                }
                return true;
            }
        }
    }
}

