/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.support;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.ui.structure.DiagramAccess;
import org.eclipse.etrice.ui.structure.support.DiagramUtil;
import org.eclipse.etrice.ui.structure.support.context.DeleteContext;
import org.eclipse.etrice.ui.structure.support.context.PositionUpdateContext;
import org.eclipse.etrice.ui.structure.support.provider.IPositionProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class DiagramUpdateFeature
extends AbstractUpdateFeature {
    public DiagramUpdateFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canUpdate(IUpdateContext context) {
        Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
        return bo instanceof EObject && !((EObject)bo).eIsProxy();
    }

    public IReason updateNeeded(IUpdateContext context) {
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pe);
        if (bo instanceof EObject) {
            EObject eBo = (EObject)bo;
            if (eBo.eIsProxy()) {
                return Reason.createTrueReason((String)"Deleted from model");
            }
            StructureClass sc = (StructureClass)bo;
            if (sc instanceof ActorClass && ((ActorClass)sc).getBase() != null) {
                return new Reason(true);
            }
            if (this.updateConnectionsNeeded(this.getDiagram())) {
                return new Reason(true);
            }
            if (this.updateNeeded((ContainerShape)this.getDiagram())) {
                return new Reason(true);
            }
            if (!new DiagramAccess().getDiagramName(sc).equals(this.getDiagram().getName())) {
                return new Reason(true);
            }
        }
        return new Reason(false);
    }

    private boolean updateConnectionsNeeded(Diagram diagram) {
        boolean needed = false;
        for (Connection conn : new ArrayList(diagram.getConnections())) {
            UpdateContext context = new UpdateContext((PictogramElement)conn);
            IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)context);
            if (updateFeature == null || !updateFeature.canUpdate((IUpdateContext)context) || !updateFeature.updateNeeded((IUpdateContext)context).toBoolean()) continue;
            needed = true;
        }
        return needed;
    }

    private boolean updateNeeded(ContainerShape container) {
        boolean needed = false;
        for (Shape child : new ArrayList(container.getChildren())) {
            if (!(child instanceof ContainerShape) || !this.updateNeeded((ContainerShape)child)) continue;
            needed = true;
        }
        if (!(container instanceof Diagram)) {
            UpdateContext context = new UpdateContext((PictogramElement)container);
            IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)context);
            if (updateFeature != null && updateFeature.canUpdate((IUpdateContext)context) && updateFeature.updateNeeded((IUpdateContext)context).toBoolean()) {
                needed = true;
            }
        }
        return needed;
    }

    public boolean update(IUpdateContext context) {
        String diagramName;
        PictogramElement pe = context.getPictogramElement();
        Object bo = this.getBusinessObjectForPictogramElement(pe);
        StructureClass sc = (StructureClass)bo;
        ContainerShape scShape = DiagramUtil.findScShape(this.getDiagram());
        IPositionProvider positionProvider = null;
        if (context instanceof PositionUpdateContext) {
            positionProvider = ((PositionUpdateContext)context).getPositionProvider();
        }
        if (scShape == null) {
            scShape = this.createStructureClass(sc, positionProvider);
        }
        boolean doneChanges = this.updateConnections(this.getDiagram());
        if (this.updateIfNeeded((ContainerShape)this.getDiagram())) {
            doneChanges = true;
        }
        if (scShape != null) {
            UpdateContext ctx = positionProvider != null ? new PositionUpdateContext((PictogramElement)scShape, positionProvider) : new UpdateContext((PictogramElement)scShape);
            doneChanges |= this.getFeatureProvider().updateIfPossible((IUpdateContext)ctx).toBoolean();
        }
        if (!(diagramName = new DiagramAccess().getDiagramName(sc)).equals(this.getDiagram().getName())) {
            this.getDiagram().setName(new DiagramAccess().getDiagramName(sc));
            doneChanges = true;
        }
        return doneChanges;
    }

    private boolean updateConnections(Diagram diagram) {
        boolean doneChanges = false;
        ArrayList connections = new ArrayList(diagram.getConnections());
        for (Connection conn : connections) {
            DeleteContext context = new DeleteContext((PictogramElement)conn);
            IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)context);
            if (updateFeature == null || !updateFeature.canUpdate((IUpdateContext)context) || !updateFeature.updateNeeded((IUpdateContext)context).toBoolean() || !updateFeature.update((IUpdateContext)context)) continue;
            doneChanges = true;
        }
        return doneChanges;
    }

    private boolean updateIfNeeded(ContainerShape container) {
        boolean doneChanges = false;
        ArrayList children = new ArrayList(container.getChildren());
        for (Shape child : children) {
            if (!(child instanceof ContainerShape) || !this.updateIfNeeded((ContainerShape)child)) continue;
            doneChanges = true;
        }
        if (!(container instanceof Diagram)) {
            DeleteContext context = new DeleteContext((PictogramElement)container);
            IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)context);
            if (updateFeature != null && updateFeature.canUpdate((IUpdateContext)context) && updateFeature.updateNeeded((IUpdateContext)context).toBoolean() && updateFeature.update((IUpdateContext)context)) {
                doneChanges = true;
            }
        }
        return doneChanges;
    }

    private ContainerShape createStructureClass(StructureClass sc, IPositionProvider positionProvider) {
        AddContext addContext = new AddContext();
        addContext.setNewObject((Object)sc);
        addContext.setTargetContainer((ContainerShape)this.getDiagram());
        addContext.setX(40);
        addContext.setY(40);
        ContainerShape scShape = (ContainerShape)this.getFeatureProvider().addIfPossible((IAddContext)addContext);
        if (positionProvider != null) {
            IPositionProvider.PosAndSize pos = positionProvider.getDiagramPosition();
            GraphicsAlgorithm ga = scShape.getGraphicsAlgorithm();
            if (pos != null) {
                ga.setX(pos.getX());
                ga.setY(pos.getY());
                if (pos.getW() > 0) {
                    ga.setWidth(pos.getW());
                }
                if (pos.getH() > 0) {
                    ga.setHeight(pos.getH());
                }
            }
        }
        return scShape;
    }
}

