/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.support;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.ui.structure.support.provider.IPositionProvider;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.ILinkService;
import org.eclipse.graphiti.services.IPeService;

public class DiagramUtil {
    public static boolean isSupported(Object obj) {
        return obj instanceof StructureClass || obj instanceof ActorContainerRef || obj instanceof InterfaceItem || obj instanceof Binding || obj instanceof LayerConnection;
    }

    public static boolean isConnection(EObject bo) {
        return bo instanceof Binding || bo instanceof LayerConnection;
    }

    public static String getResourcePath(EObject bo) {
        assert (DiagramUtil.isSupported(bo)) : "unexpected type";
        return String.valueOf(bo.eResource().getURI().toString()) + bo.eResource().getURIFragment(bo);
    }

    public static ContainerShape findScShape(Diagram diagram) {
        ILinkService linkService = Graphiti.getLinkService();
        for (Shape child : diagram.getChildren()) {
            EObject bo = linkService.getBusinessObjectForLinkedPictogramElement((PictogramElement)child);
            if (!(bo instanceof StructureClass)) continue;
            return (ContainerShape)child;
        }
        return null;
    }

    public static IPositionProvider.PosAndSize getPosAndSize(GraphicsAlgorithm ga) {
        return new IPositionProvider.PosAndSize(ga.getX(), ga.getY(), ga.getWidth(), ga.getHeight());
    }

    public static PropertyContainer findProp(List<? extends PropertyContainer> items, String key, String value) {
        IPeService peService = Graphiti.getPeService();
        for (PropertyContainer propertyContainer : items) {
            if (!value.equals(peService.getPropertyValue(propertyContainer, key))) continue;
            return propertyContainer;
        }
        return null;
    }
}

