/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.support.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.ui.structure.DiagramAccess;
import org.eclipse.etrice.ui.structure.support.DiagramUtil;
import org.eclipse.etrice.ui.structure.support.provider.IPositionProvider;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.ILinkService;

public class SuperDiagramPositionProvider
implements IPositionProvider {
    private IPositionProvider.PosAndSize superDiagramPosition;
    private HashMap<String, Position> obj2pos;
    private HashMap<String, Position> obj2text;
    private HashMap<String, ArrayList<Position>> obj2bendpoints;
    private Parent parent;

    private SuperDiagramPositionProvider() {
    }

    public SuperDiagramPositionProvider(StructureClass sc) {
        ActorClass base;
        this.obj2pos = new HashMap();
        this.obj2text = new HashMap();
        this.obj2bendpoints = new HashMap();
        this.parent = new Parent();
        this.parent.bo = sc;
        this.parent.key = this.getKey((EObject)sc);
        if (sc instanceof ActorClass && (base = ((ActorClass)sc).getBase()) != null) {
            this.mapPositions(base);
        }
    }

    @Override
    public SuperDiagramPositionProvider setNewParent(EObject parent, IPositionProvider.PosAndSize invisibleRect, IPositionProvider.PosAndSize innerRect) {
        SuperDiagramPositionProvider pp = new SuperDiagramPositionProvider();
        pp.obj2pos = this.obj2pos;
        pp.obj2text = this.obj2text;
        pp.obj2bendpoints = this.obj2bendpoints;
        pp.superDiagramPosition = this.superDiagramPosition;
        Parent newParent = new Parent();
        newParent.bo = parent;
        newParent.key = this.getKey(parent);
        newParent.inv = invisibleRect;
        newParent.inner = innerRect;
        pp.parent = newParent;
        return pp;
    }

    @Override
    public boolean contains(EObject obj) {
        String key = this.getKey(obj);
        return this.obj2pos.containsKey(key) || this.obj2text.containsKey(key) || this.obj2bendpoints.containsKey(key);
    }

    @Override
    public IPositionProvider.PosAndSize getDiagramPosition() {
        return this.superDiagramPosition;
    }

    @Override
    public IPositionProvider.PosAndSize getPosition(EObject bo) {
        Position pos = this.obj2pos.get(this.getKey(bo));
        if (pos == null) {
            return null;
        }
        boolean fixedSize = false;
        int width = 0;
        int height = 0;
        if (bo instanceof InterfaceItem) {
            if (this.parent.bo instanceof ActorContainerRef) {
                height = 60;
                width = 60;
            } else {
                height = 80;
                width = 80;
            }
            fixedSize = true;
        } else if (bo instanceof ActorContainerRef) {
            int margin = 30;
            width = (int)(pos.sx * (double)this.parent.inner.getW()) + 2 * margin;
            height = (int)(pos.sy * (double)this.parent.inner.getH()) + 2 * margin;
        }
        return new IPositionProvider.PosAndSize((int)(pos.x * (double)this.parent.inner.getW()) - width / 2 + this.parent.inner.getX(), (int)(pos.y * (double)this.parent.inner.getH()) - height / 2 + this.parent.inner.getY(), fixedSize ? -1 : width, fixedSize ? -1 : height);
    }

    @Override
    public IPositionProvider.Pos getConnectionText(EObject obj) {
        Position pos = this.obj2text.get(this.getKey(obj));
        if (pos == null) {
            return null;
        }
        return new IPositionProvider.Pos((int)(pos.x * (double)this.parent.inner.getW()) + this.parent.inner.getX() + this.parent.inv.getX(), (int)(pos.y * (double)this.parent.inner.getH()) + this.parent.inner.getY() + this.parent.inv.getY());
    }

    @Override
    public List<IPositionProvider.Pos> getConnectionBendpoints(EObject obj) {
        ArrayList<IPositionProvider.Pos> result = new ArrayList<IPositionProvider.Pos>();
        ArrayList<Position> list = this.obj2bendpoints.get(this.getKey(obj));
        if (list == null) {
            return result;
        }
        for (Position p : list) {
            IPositionProvider.Pos pos = new IPositionProvider.Pos((int)(p.x * (double)this.parent.inner.getW()) + this.parent.inner.getX() + this.parent.inv.getX(), (int)(p.y * (double)this.parent.inner.getH()) + this.parent.inner.getY() + this.parent.inv.getY());
            result.add(pos);
        }
        return result;
    }

    private void mapPositions(ActorClass ac) {
        Position pos;
        EObject obj;
        Diagram diagram = new DiagramAccess().getDiagram((StructureClass)ac);
        if (diagram == null) {
            return;
        }
        ContainerShape acShape = DiagramUtil.findScShape(diagram);
        if (acShape == null) {
            return;
        }
        ILinkService linkService = Graphiti.getLinkService();
        EObject sc = linkService.getBusinessObjectForLinkedPictogramElement((PictogramElement)acShape);
        if (!sc.eResource().getURI().equals(ac.eResource().getURI())) {
            return;
        }
        IPositionProvider.PosAndSize acInv = DiagramUtil.getPosAndSize(acShape.getGraphicsAlgorithm());
        IPositionProvider.PosAndSize acInner = DiagramUtil.getPosAndSize((GraphicsAlgorithm)acShape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0));
        this.superDiagramPosition = acInv;
        this.parent.inv = acInv;
        this.parent.inner = acInner;
        for (Shape shape : acShape.getChildren()) {
            obj = linkService.getBusinessObjectForLinkedPictogramElement((PictogramElement)shape);
            if (!(obj instanceof ActorContainerRef) && !(obj instanceof InterfaceItem)) continue;
            IPositionProvider.PosAndSize objInv = DiagramUtil.getPosAndSize(shape.getGraphicsAlgorithm());
            IPositionProvider.PosAndSize objInner = DiagramUtil.getPosAndSize((GraphicsAlgorithm)shape.getGraphicsAlgorithm().getGraphicsAlgorithmChildren().get(0));
            pos = new Position();
            pos.x = (double)(objInv.getX() - acInner.getX() + objInv.getW() / 2) / (double)acInner.getW();
            pos.y = (double)(objInv.getY() - acInner.getY() + objInv.getH() / 2) / (double)acInner.getH();
            pos.sx = (double)objInner.getW() / (double)acInner.getW();
            pos.sy = (double)objInner.getH() / (double)acInner.getH();
            this.obj2pos.put(this.getKey(obj), pos);
            if (!(obj instanceof ActorContainerRef)) continue;
            for (Shape child : ((ContainerShape)shape).getChildren()) {
                EObject childBo = linkService.getBusinessObjectForLinkedPictogramElement((PictogramElement)child);
                if (!(childBo instanceof InterfaceItem)) continue;
                IPositionProvider.PosAndSize ifInv = DiagramUtil.getPosAndSize(child.getGraphicsAlgorithm());
                Position p = new Position();
                p.x = (double)(ifInv.getX() - objInner.getX() + ifInv.getW() / 2) / (double)objInner.getW();
                p.y = (double)(ifInv.getY() - objInner.getY() + ifInv.getH() / 2) / (double)objInner.getH();
                this.obj2pos.put(String.valueOf(this.getKey(obj)) + this.getKey(childBo), p);
            }
        }
        for (Connection conn : diagram.getConnections()) {
            ConnectionDecorator cd;
            obj = linkService.getBusinessObjectForLinkedPictogramElement((PictogramElement)conn);
            if (!(obj instanceof Binding) && !(obj instanceof LayerConnection)) continue;
            if (conn.getConnectionDecorators().size() > 1 && (cd = (ConnectionDecorator)conn.getConnectionDecorators().get(1)).getGraphicsAlgorithm() instanceof Text) {
                GraphicsAlgorithm ga = cd.getGraphicsAlgorithm();
                pos = new Position();
                pos.x = (double)(ga.getX() - acInv.getX() - acInner.getX()) / (double)acInner.getW();
                pos.y = (double)(ga.getY() - acInv.getY() - acInner.getY()) / (double)acInner.getH();
                this.obj2text.put(this.getKey(obj), pos);
            }
            if (!(conn instanceof FreeFormConnection)) continue;
            ArrayList<Position> points = new ArrayList<Position>();
            for (Point bp : ((FreeFormConnection)conn).getBendpoints()) {
                Position pos2 = new Position();
                pos2.x = (double)(bp.getX() - acInv.getX() - acInner.getX()) / (double)acInner.getW();
                pos2.y = (double)(bp.getY() - acInv.getY() - acInner.getY()) / (double)acInner.getH();
                points.add(pos2);
            }
            if (points.isEmpty()) continue;
            this.obj2bendpoints.put(this.getKey(obj), points);
        }
    }

    private String getKey(EObject bo) {
        if (bo instanceof StructureClass) {
            return "";
        }
        return String.valueOf(this.parent.key) + DiagramUtil.getResourcePath(bo);
    }

    private class Parent {
        EObject bo;
        String key;
        IPositionProvider.PosAndSize inv;
        IPositionProvider.PosAndSize inner;

        private Parent() {
        }
    }

    private class Position {
        double x;
        double y;
        double sx = -1.0;
        double sy = -1.0;

        private Position() {
        }
    }
}

