/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.room;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RoomAnnotationTargetEnum implements Enumerator
{
    DATA_CLASS(0, "DATA_CLASS", "DataClass"),
    ACTOR_CLASS(1, "ACTOR_CLASS", "ActorClass"),
    ACTOR_BEHAVIOR(2, "ACTOR_BEHAVIOR", "ActorBehavior"),
    PROTOCOL_CLASS(3, "PROTOCOL_CLASS", "ProtocolClass"),
    COMPOUND_PROTOCOL_CLASS(4, "COMPOUND_PROTOCOL_CLASS", "CompoundProtocolClass"),
    SUBSYSTEM_CLASS(5, "SUBSYSTEM_CLASS", "SubSystemClass"),
    LOGICAL_SYSTEM_CLASS(6, "LOGICAL_SYSTEM_CLASS", "LogicalSystem");

    public static final int DATA_CLASS_VALUE = 0;
    public static final int ACTOR_CLASS_VALUE = 1;
    public static final int ACTOR_BEHAVIOR_VALUE = 2;
    public static final int PROTOCOL_CLASS_VALUE = 3;
    public static final int COMPOUND_PROTOCOL_CLASS_VALUE = 4;
    public static final int SUBSYSTEM_CLASS_VALUE = 5;
    public static final int LOGICAL_SYSTEM_CLASS_VALUE = 6;
    private static final RoomAnnotationTargetEnum[] VALUES_ARRAY;
    public static final List<RoomAnnotationTargetEnum> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RoomAnnotationTargetEnum[]{DATA_CLASS, ACTOR_CLASS, ACTOR_BEHAVIOR, PROTOCOL_CLASS, COMPOUND_PROTOCOL_CLASS, SUBSYSTEM_CLASS, LOGICAL_SYSTEM_CLASS};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RoomAnnotationTargetEnum get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RoomAnnotationTargetEnum result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RoomAnnotationTargetEnum getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RoomAnnotationTargetEnum result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RoomAnnotationTargetEnum get(int value) {
        switch (value) {
            case 0: {
                return DATA_CLASS;
            }
            case 1: {
                return ACTOR_CLASS;
            }
            case 2: {
                return ACTOR_BEHAVIOR;
            }
            case 3: {
                return PROTOCOL_CLASS;
            }
            case 4: {
                return COMPOUND_PROTOCOL_CLASS;
            }
            case 5: {
                return SUBSYSTEM_CLASS;
            }
            case 6: {
                return LOGICAL_SYSTEM_CLASS;
            }
        }
        return null;
    }

    private RoomAnnotationTargetEnum(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

