/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.room.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.common.base.KeyValue;
import org.eclipse.etrice.core.common.base.util.BaseHelpers;
import org.eclipse.etrice.core.naming.RoomNameProvider;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorInstanceMapping;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.ChoicePoint;
import org.eclipse.etrice.core.room.ChoicepointTerminal;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.InitialTransition;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageFromIf;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PortOperation;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefPath;
import org.eclipse.etrice.core.room.RefSegment;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RefinedState;
import org.eclipse.etrice.core.room.RefinedTransition;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.SimpleState;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.StateGraphNode;
import org.eclipse.etrice.core.room.StateTerminal;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubStateTrPointTerminal;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.TrPointTerminal;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.TransitionTerminal;
import org.eclipse.etrice.core.room.Trigger;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.validation.ValidationUtil;

public class RoomHelpers
extends BaseHelpers {
    public static List<ActorClass> getClassHierarchy(ActorClass ac) {
        ArrayList<ActorClass> result = new ArrayList<ActorClass>();
        while (ac != null) {
            result.add(0, ac);
            ac = ac.getBase();
        }
        return result;
    }

    public static List<InterfaceItem> getInterfaceItems(StructureClass sc, boolean includeInherited) {
        ArrayList<InterfaceItem> result = new ArrayList<InterfaceItem>();
        if (sc instanceof ActorClass) {
            ActorClass ac = (ActorClass)sc;
            do {
                result.addAll((Collection<InterfaceItem>)ac.getServiceProvisionPoints());
                result.addAll((Collection<InterfaceItem>)ac.getInterfacePorts());
                ac = ac.getBase();
            } while (includeInherited && ac != null);
        } else if (sc instanceof SubSystemClass) {
            result.addAll((Collection<InterfaceItem>)((SubSystemClass)sc).getServiceProvisionPoints());
            result.addAll((Collection<InterfaceItem>)((SubSystemClass)sc).getRelayPorts());
        } else if (!(sc instanceof LogicalSystem)) assert (false) : "unexpected sub type";
        return result;
    }

    public static List<ActorContainerRef> getRefs(StructureClass sc, boolean includeInherited) {
        ArrayList<ActorContainerRef> result = new ArrayList<ActorContainerRef>();
        if (sc instanceof ActorClass) {
            ActorClass ac = (ActorClass)sc;
            do {
                result.addAll((Collection<ActorContainerRef>)ac.getActorRefs());
                ac = ac.getBase();
            } while (includeInherited && ac != null);
        } else if (sc instanceof SubSystemClass) {
            result.addAll((Collection<ActorContainerRef>)((SubSystemClass)sc).getActorRefs());
        } else if (sc instanceof LogicalSystem) {
            result.addAll((Collection<ActorContainerRef>)((LogicalSystem)sc).getSubSystems());
        } else assert (false) : "unexpected sub type";
        return result;
    }

    public static List<Binding> getBindings(StructureClass sc, boolean includeInherited) {
        ArrayList<Binding> result = new ArrayList<Binding>();
        if (sc instanceof ActorClass) {
            ActorClass ac = (ActorClass)sc;
            do {
                result.addAll((Collection<Binding>)ac.getBindings());
                ac = ac.getBase();
            } while (includeInherited && ac != null);
        } else if (sc instanceof SubSystemClass) {
            result.addAll((Collection<Binding>)((SubSystemClass)sc).getBindings());
        } else if (sc instanceof LogicalSystem) {
            result.addAll((Collection<Binding>)((LogicalSystem)sc).getBindings());
        } else assert (false) : "unexpected sub type";
        return result;
    }

    public static List<LayerConnection> getConnections(StructureClass sc, boolean includeInherited) {
        ArrayList<LayerConnection> result = new ArrayList<LayerConnection>();
        if (sc instanceof ActorClass) {
            ActorClass ac = (ActorClass)sc;
            do {
                result.addAll((Collection<LayerConnection>)ac.getConnections());
                ac = ac.getBase();
            } while (includeInherited && ac != null);
        } else if (sc instanceof SubSystemClass) {
            result.addAll((Collection<LayerConnection>)((SubSystemClass)sc).getConnections());
        } else if (sc instanceof LogicalSystem) {
            result.addAll((Collection<LayerConnection>)((LogicalSystem)sc).getConnections());
        } else assert (false) : "unexpected sub type";
        return result;
    }

    public static String getDeepUserCode1(DataClass dc) {
        return RoomHelpers.getDeepUserCode(dc, (EStructuralFeature)RoomPackage.Literals.DATA_CLASS__USER_CODE1);
    }

    public static String getDeepUserCode2(DataClass dc) {
        return RoomHelpers.getDeepUserCode(dc, (EStructuralFeature)RoomPackage.Literals.DATA_CLASS__USER_CODE2);
    }

    public static String getDeepUserCode3(DataClass dc) {
        return RoomHelpers.getDeepUserCode(dc, (EStructuralFeature)RoomPackage.Literals.DATA_CLASS__USER_CODE3);
    }

    public static String getDeepUserCode1(ProtocolClass pc) {
        return RoomHelpers.getDeepUserCode(pc, (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__USER_CODE1);
    }

    public static String getDeepUserCode2(ProtocolClass pc) {
        return RoomHelpers.getDeepUserCode(pc, (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__USER_CODE2);
    }

    public static String getDeepUserCode3(ProtocolClass pc) {
        return RoomHelpers.getDeepUserCode(pc, (EStructuralFeature)RoomPackage.Literals.PROTOCOL_CLASS__USER_CODE3);
    }

    public static String getDeepUserCode1(ActorContainerClass ac) {
        return RoomHelpers.getDeepUserCode(ac, (EStructuralFeature)RoomPackage.Literals.ACTOR_CONTAINER_CLASS__USER_CODE1);
    }

    public static String getDeepUserCode2(ActorContainerClass ac) {
        return RoomHelpers.getDeepUserCode(ac, (EStructuralFeature)RoomPackage.Literals.ACTOR_CONTAINER_CLASS__USER_CODE2);
    }

    public static String getDeepUserCode3(ActorContainerClass ac) {
        return RoomHelpers.getDeepUserCode(ac, (EStructuralFeature)RoomPackage.Literals.ACTOR_CONTAINER_CLASS__USER_CODE3);
    }

    private static String getDeepUserCode(EObject obj, EStructuralFeature code) {
        StringBuilder result = new StringBuilder();
        while (obj != null) {
            DetailCode dc = (DetailCode)obj.eGet(code);
            result.insert(0, RoomHelpers.getDetailCode(dc));
            if (obj instanceof ActorClass) {
                obj = ((ActorClass)obj).getBase();
                continue;
            }
            if (obj instanceof ProtocolClass) {
                obj = ((ProtocolClass)obj).getBase();
                continue;
            }
            if (!(obj instanceof DataClass)) break;
            obj = ((DataClass)obj).getBase();
        }
        return result.toString();
    }

    public static boolean hasSubStructure(State state, ActorClass ac) {
        if (RoomHelpers.hasDirectSubStructure(state)) {
            return true;
        }
        if (state instanceof RefinedState) {
            State target = ((RefinedState)state).getTarget();
            while (target != null) {
                if (RoomHelpers.hasDirectSubStructure(target)) {
                    return true;
                }
                if (!(target instanceof RefinedState)) break;
                target = ((RefinedState)target).getTarget();
            }
        }
        if (ac.getStateMachine() != null) {
            Iterator<State> iterator = RoomHelpers.getAllStatesRecursive(ac.getStateMachine()).iterator();
            block1: while (iterator.hasNext()) {
                State s;
                State predecessor = s = iterator.next();
                while (predecessor instanceof RefinedState) {
                    if ((predecessor = ((RefinedState)predecessor).getTarget()) != state) continue;
                    predecessor = s;
                    while (predecessor instanceof RefinedState) {
                        if (RoomHelpers.hasDirectSubStructure(predecessor)) {
                            return true;
                        }
                        predecessor = ((RefinedState)s).getTarget();
                        if (predecessor == state) continue block1;
                    }
                    continue block1;
                }
            }
        }
        return false;
    }

    public static boolean hasDirectSubStructure(State s) {
        return !RoomHelpers.isEmpty(s.getSubgraph());
    }

    public static boolean hasNonEmptyStateMachine(ActorClass ac) {
        return !RoomHelpers.isEmpty(ac.getStateMachine());
    }

    public static boolean isEmpty(StateGraph sg) {
        if (sg == null) {
            return true;
        }
        if (!sg.getStates().isEmpty()) {
            return false;
        }
        if (!sg.getTransitions().isEmpty()) {
            return false;
        }
        if (!sg.getTrPoints().isEmpty()) {
            return false;
        }
        if (!sg.getChPoints().isEmpty()) {
            return false;
        }
        return sg.getRefinedTransitions().isEmpty();
    }

    public static boolean isTopLevel(StateGraphNode s) {
        return !(s.eContainer().eContainer() instanceof State);
    }

    public static boolean isLeaf(State s) {
        return s.getSubgraph() == null;
    }

    public static List<State> getLeafStateList(State state) {
        return RoomHelpers.getLeafStateList(state.getSubgraph());
    }

    public static List<State> getLeafStateList(StateGraph sg) {
        ArrayList<State> res = new ArrayList<State>();
        if (sg != null) {
            TreeIterator it = sg.eAllContents();
            while (it.hasNext()) {
                EObject obj = (EObject)it.next();
                if (!(obj instanceof State) || !RoomHelpers.isLeaf((State)obj)) continue;
                res.add((State)obj);
            }
        }
        return res;
    }

    public static List<State> getStateList(StateGraph sg) {
        ArrayList<State> res = new ArrayList<State>();
        if (sg != null) {
            TreeIterator it = sg.eAllContents();
            while (it.hasNext()) {
                EObject obj = (EObject)it.next();
                if (!(obj instanceof State)) continue;
                res.add((State)obj);
            }
        }
        return res;
    }

    public static List<State> getBaseStateList(StateGraph sg) {
        ArrayList<State> res = new ArrayList<State>();
        if (sg != null) {
            TreeIterator it = sg.eAllContents();
            while (it.hasNext()) {
                EObject obj = (EObject)it.next();
                if (!(obj instanceof SimpleState)) continue;
                res.add((State)obj);
            }
        }
        return res;
    }

    public static List<State> getAllBaseStates(ActorClass ac) {
        return RoomHelpers.getBaseStateList(ac.getStateMachine());
    }

    public static State getParentState(StateGraphNode s) {
        if (RoomHelpers.isTopLevel(s)) {
            return null;
        }
        return (State)s.eContainer().eContainer();
    }

    public static State getTargettingState(State state, ActorClass ac) {
        State targetting = state;
        Iterator<State> iterator = RoomHelpers.getAllStatesRecursive(ac.getStateMachine()).iterator();
        while (iterator.hasNext()) {
            State s;
            State predecessor = s = iterator.next();
            while (predecessor instanceof RefinedState) {
                if ((predecessor = ((RefinedState)predecessor).getTarget()) != state) continue;
                targetting = s;
            }
        }
        return targetting;
    }

    public static boolean hasDetailCode(DetailCode dc) {
        if (dc == null) {
            return false;
        }
        for (String cmd : dc.getLines()) {
            if (cmd.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasGuard(Trigger trig) {
        return trig.getGuard() != null && RoomHelpers.hasDetailCode(trig.getGuard().getGuard());
    }

    public static boolean hasEntryCode(State s, boolean includeInherited) {
        return RoomHelpers.hasDetailCode(s, includeInherited, RoomPackage.Literals.STATE__ENTRY_CODE);
    }

    public static boolean hasExitCode(State s, boolean includeInherited) {
        return RoomHelpers.hasDetailCode(s, includeInherited, RoomPackage.Literals.STATE__EXIT_CODE);
    }

    public static boolean hasDoCode(State s, boolean includeInherited) {
        return RoomHelpers.hasDetailCode(s, includeInherited, RoomPackage.Literals.STATE__DO_CODE);
    }

    private static boolean hasDetailCode(State s, boolean includeInherited, EReference feature) {
        DetailCode dc = (DetailCode)s.eGet((EStructuralFeature)feature);
        if (RoomHelpers.hasDetailCode(dc)) {
            return true;
        }
        if (includeInherited && s instanceof RefinedState) {
            return !RoomHelpers.getInheritedCode((RefinedState)s, feature, true).getLines().isEmpty();
        }
        return false;
    }

    public static String getDetailCode(DetailCode code) {
        if (code == null || code.getLines().isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (String cmd : code.getLines()) {
            result.append(String.valueOf(cmd) + "\n");
        }
        return result.toString();
    }

    public static DetailCode getInheritedEntryCode(RefinedState rs) {
        return RoomHelpers.getInheritedCode(rs, RoomPackage.Literals.STATE__ENTRY_CODE, true);
    }

    public static DetailCode getInheritedExitCode(RefinedState rs) {
        return RoomHelpers.getInheritedCode(rs, RoomPackage.Literals.STATE__EXIT_CODE, false);
    }

    public static DetailCode getInheritedDoCode(RefinedState rs) {
        return RoomHelpers.getInheritedCode(rs, RoomPackage.Literals.STATE__DO_CODE, true);
    }

    private static DetailCode getInheritedCode(RefinedState rs, EReference code, boolean addFront) {
        DetailCode result = RoomFactory.eINSTANCE.createDetailCode();
        State s = rs.getTarget();
        while (s != null) {
            DetailCode dc = (DetailCode)s.eGet((EStructuralFeature)code);
            if (dc != null) {
                if (addFront) {
                    result.getLines().addAll(0, dc.getLines());
                } else {
                    result.getLines().addAll(dc.getLines());
                }
            }
            if (!(s instanceof RefinedState)) break;
            s = ((RefinedState)s).getTarget();
        }
        return result;
    }

    public static State getRefinedStateFor(StateGraph sg, State state) {
        ActorClass ac;
        for (State s : sg.getStates()) {
            if (!(s instanceof RefinedState) || !s.getName().equals(state.getName())) continue;
            return s;
        }
        if (sg.eContainer() instanceof State) {
            if (sg.eContainer() instanceof RefinedState) {
                return RoomHelpers.getRefinedStateFor(((RefinedState)sg.eContainer()).getTarget().getSubgraph(), state);
            }
        } else if (sg.eContainer() instanceof ActorClass && (ac = (ActorClass)sg.eContainer()).getBase() != null && ac.getBase().getStateMachine() != null) {
            return RoomHelpers.getRefinedStateFor(ac.getBase().getStateMachine(), state);
        }
        return state;
    }

    public static boolean isGuarded(Trigger trig) {
        return trig.getGuard() != null && RoomHelpers.hasDetailCode(trig.getGuard().getGuard());
    }

    public static StateGraphNode getNode(TransitionTerminal tt) {
        if (tt instanceof StateTerminal) {
            return ((StateTerminal)tt).getState();
        }
        if (tt instanceof TrPointTerminal) {
            return ((TrPointTerminal)tt).getTrPoint();
        }
        if (tt instanceof SubStateTrPointTerminal) {
            return ((SubStateTrPointTerminal)tt).getTrPoint();
        }
        if (tt instanceof ChoicepointTerminal) {
            return ((ChoicepointTerminal)tt).getCp();
        }
        return null;
    }

    public static List<State> getAllStates(StateGraph sg) {
        return RoomHelpers.getAllStateGraphItems(sg, RoomPackage.eINSTANCE.getStateGraph_States(), false);
    }

    public static List<State> getAllStatesRecursive(StateGraph sg) {
        return RoomHelpers.getAllStateGraphItems(sg, RoomPackage.eINSTANCE.getStateGraph_States(), true);
    }

    public static List<TrPoint> getAllTrPoints(StateGraph sg) {
        return RoomHelpers.getAllStateGraphItems(sg, RoomPackage.eINSTANCE.getStateGraph_TrPoints(), false);
    }

    public static List<TrPoint> getAllTrPointsRecursive(StateGraph sg) {
        return RoomHelpers.getAllStateGraphItems(sg, RoomPackage.eINSTANCE.getStateGraph_TrPoints(), true);
    }

    public static List<ChoicePoint> getAllChoicePoints(StateGraph sg) {
        return RoomHelpers.getAllStateGraphItems(sg, RoomPackage.eINSTANCE.getStateGraph_ChPoints(), false);
    }

    public static List<Transition> getAllTransitions(StateGraph sg) {
        return RoomHelpers.getAllStateGraphItems(sg, RoomPackage.eINSTANCE.getStateGraph_Transitions(), false);
    }

    public static List<Transition> getAllTransitionsRecursive(StateGraph sg) {
        return RoomHelpers.getAllStateGraphItems(sg, RoomPackage.eINSTANCE.getStateGraph_Transitions(), true);
    }

    private static <T extends StateGraphItem> List<T> getAllStateGraphItems(StateGraph sg, EReference feature, boolean recurse) {
        ArrayList<T> result = new ArrayList<T>();
        while (sg != null) {
            Object items = sg.eGet((EStructuralFeature)feature);
            if (items instanceof List) {
                result.addAll((List)items);
            }
            if (recurse) {
                for (State s : sg.getStates()) {
                    if (s.getSubgraph() == null) continue;
                    List<T> subItems = RoomHelpers.getAllStateGraphItems(s.getSubgraph(), feature, recurse);
                    result.addAll(subItems);
                }
            }
            if (sg.eContainer() instanceof RefinedState) {
                sg = ((RefinedState)sg.eContainer()).getTarget().getSubgraph();
                continue;
            }
            if (!(sg.eContainer() instanceof ActorClass)) break;
            ActorClass base = ((ActorClass)sg.eContainer()).getBase();
            StateGraph stateGraph = sg = base != null ? base.getStateMachine() : null;
        }
        return result;
    }

    public static Set<String> getAllNames(StateGraph sg) {
        return RoomHelpers.getAllNames(sg, null);
    }

    public static Set<String> getAllNames(StateGraph sg, StateGraphItem skip) {
        HashSet<String> result = new HashSet<String>();
        do {
            for (State st : sg.getStates()) {
                if (st == skip) continue;
                result.add(st.getName());
            }
            for (TrPoint tp : sg.getTrPoints()) {
                if (tp == skip) continue;
                result.add(tp.getName());
            }
            for (ChoicePoint cp : sg.getChPoints()) {
                if (cp == skip) continue;
                result.add(cp.getName());
            }
            for (Transition tr : sg.getTransitions()) {
                if (tr == skip) continue;
                result.add(tr.getName());
            }
            if (sg.eContainer() instanceof RefinedState) {
                sg = ((RefinedState)sg.eContainer()).getTarget().getSubgraph();
                continue;
            }
            if (!(sg.eContainer() instanceof ActorClass)) break;
            ActorClass base = ((ActorClass)sg.eContainer()).getBase();
            StateGraph stateGraph = sg = base != null ? base.getStateMachine() : null;
        } while (sg != null);
        return result;
    }

    public static Set<String> getAllStateNames(StateGraph sg) {
        return RoomHelpers.getAllNames(sg, null, RoomPackage.eINSTANCE.getStateGraph_States());
    }

    public static Set<String> getAllStateNames(StateGraph sg, State skip) {
        return RoomHelpers.getAllNames(sg, skip, RoomPackage.eINSTANCE.getStateGraph_States());
    }

    public static Set<String> getAllTrPointNames(StateGraph sg) {
        return RoomHelpers.getAllNames(sg, null, RoomPackage.eINSTANCE.getStateGraph_TrPoints());
    }

    public static Set<String> getAllTrPointNames(StateGraph sg, TrPoint skip) {
        return RoomHelpers.getAllNames(sg, skip, RoomPackage.eINSTANCE.getStateGraph_TrPoints());
    }

    public static Set<String> getAllChoicePointNames(StateGraph sg) {
        return RoomHelpers.getAllNames(sg, null, RoomPackage.eINSTANCE.getStateGraph_ChPoints());
    }

    public static Set<String> getAllChoicePointNames(StateGraph sg, ChoicePoint skip) {
        return RoomHelpers.getAllNames(sg, skip, RoomPackage.eINSTANCE.getStateGraph_ChPoints());
    }

    public static Set<String> getAllTransitionNames(StateGraph sg) {
        return RoomHelpers.getAllNames(sg, null, RoomPackage.eINSTANCE.getStateGraph_Transitions());
    }

    public static Set<String> getAllTransitionNames(StateGraph sg, Transition skip) {
        return RoomHelpers.getAllNames(sg, skip, RoomPackage.eINSTANCE.getStateGraph_Transitions());
    }

    private static <T extends StateGraphItem> Set<String> getAllNames(StateGraph sg, T skip, EReference feature) {
        List<StateGraphItem> items = RoomHelpers.getAllStateGraphItems(sg, feature, false);
        HashSet<String> names = new HashSet<String>();
        for (StateGraphItem item : items) {
            if (item == skip) continue;
            names.add(item.getName());
        }
        return names;
    }

    public static List<Message> getAllIncomingMessages(ProtocolClass pc) {
        return RoomHelpers.getAllMessages(pc, true);
    }

    public static List<Message> getAllOutgoingMessages(ProtocolClass pc) {
        return RoomHelpers.getAllMessages(pc, false);
    }

    public static List<Message> getAllMessages(ProtocolClass pc, boolean incoming) {
        ArrayList<Message> result = new ArrayList<Message>();
        while (pc != null) {
            if (incoming) {
                result.addAll(0, (Collection<Message>)pc.getIncomingMessages());
            } else {
                result.addAll(0, (Collection<Message>)pc.getOutgoingMessages());
            }
            pc = pc.getBase();
        }
        return result;
    }

    public static List<Message> getIncoming(InterfaceItem item) {
        if (RoomHelpers.getProtocol(item) != null) {
            return RoomHelpers.getAllMessages(RoomHelpers.getProtocol(item), !RoomHelpers.isConjugated(item));
        }
        return Collections.emptyList();
    }

    public static List<Message> getOutgoing(InterfaceItem item) {
        if (RoomHelpers.getProtocol(item) != null) {
            return RoomHelpers.getAllMessages(RoomHelpers.getProtocol(item), RoomHelpers.isConjugated(item));
        }
        return Collections.emptyList();
    }

    public static boolean isConjugated(InterfaceItem item) {
        if (item instanceof Port) {
            return ((Port)item).isConjugated();
        }
        if (item instanceof SAP) {
            return true;
        }
        if (item instanceof SPP) {
            return false;
        }
        assert (false) : "unexpected sub type";
        return true;
    }

    public static List<Attribute> getAllAttributes(ActorClass ac) {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        while (ac != null) {
            result.addAll(0, (Collection<Attribute>)ac.getAttributes());
            ac = ac.getBase();
        }
        return result;
    }

    public static List<Attribute> getAllAttributes(DataClass dc) {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        while (dc != null) {
            result.addAll(0, (Collection<Attribute>)dc.getAttributes());
            dc = dc.getBase();
        }
        return result;
    }

    public static List<Operation> getAllOperations(ActorClass ac) {
        ArrayList<Operation> result = new ArrayList<Operation>();
        while (ac != null) {
            result.addAll(0, (Collection<Operation>)ac.getOperations());
            ac = ac.getBase();
        }
        return result;
    }

    public static List<Operation> getAllOperations(DataClass dc) {
        ArrayList<Operation> result = new ArrayList<Operation>();
        while (dc != null) {
            result.addAll(0, (Collection<Operation>)dc.getOperations());
            dc = dc.getBase();
        }
        return result;
    }

    public static List<Port> getEndPorts(ActorClass ac) {
        ArrayList<Port> result = new ArrayList<Port>((Collection<Port>)ac.getInternalPorts());
        int insertAt = 0;
        for (ExternalPort p : ac.getExternalPorts()) {
            result.add(insertAt++, p.getInterfacePort());
        }
        return result;
    }

    public static List<SAP> getAllSAPs(ActorClass ac) {
        ArrayList<SAP> result = new ArrayList<SAP>();
        while (ac != null) {
            result.addAll(0, (Collection<SAP>)ac.getServiceAccessPoints());
            ac = ac.getBase();
        }
        return result;
    }

    public static List<ServiceImplementation> getAllServiceImplementations(ActorClass ac) {
        ArrayList<ServiceImplementation> result = new ArrayList<ServiceImplementation>();
        while (ac != null) {
            result.addAll(0, (Collection<ServiceImplementation>)ac.getServiceImplementations());
            ac = ac.getBase();
        }
        return result;
    }

    public static List<Port> getAllEndPorts(ActorClass ac) {
        ArrayList<Port> result = new ArrayList<Port>();
        while (ac != null) {
            result.addAll(0, (Collection<Port>)ac.getInternalPorts());
            int insertAt = 0;
            for (ExternalPort p : ac.getExternalPorts()) {
                result.add(insertAt++, p.getInterfacePort());
            }
            ac = ac.getBase();
        }
        return result;
    }

    public static List<Port> getInterfacePorts(ActorContainerClass ac) {
        if (ac instanceof ActorClass) {
            return ((ActorClass)ac).getInterfacePorts();
        }
        if (ac instanceof SubSystemClass) {
            return ((SubSystemClass)ac).getRelayPorts();
        }
        assert (false) : "unexpected sub type";
        return null;
    }

    public static List<Port> getAllInterfacePorts(ActorContainerClass ac) {
        if (ac instanceof ActorClass) {
            ArrayList<Port> result = new ArrayList<Port>();
            ActorClass curr = (ActorClass)ac;
            while (curr != null) {
                result.addAll(0, (Collection<Port>)curr.getInterfacePorts());
                curr = curr.getBase();
            }
            return result;
        }
        if (ac instanceof SubSystemClass) {
            return ((SubSystemClass)ac).getRelayPorts();
        }
        assert (false) : "unexpected sub type";
        return null;
    }

    public static List<InterfaceItem> getInterfaceItems(ActorClass ac) {
        ArrayList<InterfaceItem> result = new ArrayList<InterfaceItem>();
        result.addAll((Collection<InterfaceItem>)ac.getInternalPorts());
        result.addAll((Collection<InterfaceItem>)ac.getExternalEndPorts());
        result.addAll((Collection<InterfaceItem>)ac.getServiceAccessPoints());
        result.addAll((Collection<InterfaceItem>)ac.getImplementedSPPs());
        return result;
    }

    public static List<MessageFromIf> getMessagesFromInterfaces(ActorClass ac) {
        ArrayList<MessageFromIf> result = new ArrayList<MessageFromIf>();
        List<InterfaceItem> items = RoomHelpers.getInterfaceItems(ac);
        for (InterfaceItem item : items) {
            ProtocolClass pc;
            if (!(item.getGeneralProtocol() instanceof ProtocolClass) || (pc = (ProtocolClass)item.getGeneralProtocol()).getCommType() != CommunicationType.EVENT_DRIVEN) continue;
            for (Message msg : RoomHelpers.getIncoming(item)) {
                MessageFromIf mif = RoomFactory.eINSTANCE.createMessageFromIf();
                mif.setMessage(msg);
                mif.setFrom(item);
                result.add(mif);
            }
        }
        return result;
    }

    public static List<MessageFromIf> getOwnMessagesFromInterfaces(ActorClass ac) {
        ArrayList<MessageFromIf> result = new ArrayList<MessageFromIf>();
        result.addAll(RoomHelpers.getMessagesFromInterfaces(ac));
        ac = ac.getBase();
        while (ac != null) {
            if (RoomHelpers.hasNonEmptyStateMachine(ac)) break;
            List<InterfaceItem> items = RoomHelpers.getInterfaceItems(ac);
            for (InterfaceItem item : items) {
                ProtocolClass pc;
                if (!(item.getGeneralProtocol() instanceof ProtocolClass) || (pc = (ProtocolClass)item.getGeneralProtocol()).getCommType() != CommunicationType.EVENT_DRIVEN) continue;
                for (Message msg : RoomHelpers.getIncoming(item)) {
                    MessageFromIf mif = RoomFactory.eINSTANCE.createMessageFromIf();
                    mif.setMessage(msg);
                    mif.setFrom(item);
                    result.add(mif);
                }
            }
            ac = ac.getBase();
        }
        return result;
    }

    public static List<MessageFromIf> getAllMessagesFromInterfaces(ActorClass ac) {
        ArrayList<MessageFromIf> result = new ArrayList<MessageFromIf>();
        while (ac != null) {
            List<InterfaceItem> items = RoomHelpers.getInterfaceItems(ac);
            for (InterfaceItem item : items) {
                ProtocolClass pc;
                if (!(item.getGeneralProtocol() instanceof ProtocolClass) || (pc = (ProtocolClass)item.getGeneralProtocol()).getCommType() != CommunicationType.EVENT_DRIVEN) continue;
                for (Message msg : RoomHelpers.getIncoming(item)) {
                    MessageFromIf mif = RoomFactory.eINSTANCE.createMessageFromIf();
                    mif.setMessage(msg);
                    mif.setFrom(item);
                    result.add(mif);
                }
            }
            ac = ac.getBase();
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static List<InterfaceItem> getAllInterfaceItems(ActorClass ac) {
        result = new ArrayList<InterfaceItem>();
        if (!ValidationUtil.isCircularClassHierarchy(ac)) ** GOTO lbl13
        return result;
lbl-1000:
        // 1 sources

        {
            result.addAll((Collection<InterfaceItem>)ac.getInternalPorts());
            result.addAll((Collection<InterfaceItem>)ac.getExternalEndPorts());
            result.addAll((Collection<InterfaceItem>)ac.getServiceAccessPoints());
            result.addAll((Collection<InterfaceItem>)ac.getImplementedSPPs());
            ac = ac.getBase();
lbl13:
            // 2 sources

            ** while (ac != null)
        }
lbl14:
        // 1 sources

        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static List<Port> getAllPorts(ActorClass ac) {
        result = new ArrayList<Port>();
        if (!ValidationUtil.isCircularClassHierarchy(ac)) ** GOTO lbl9
        return result;
lbl-1000:
        // 1 sources

        {
            result.addAll((Collection<Port>)ac.getInternalPorts());
            result.addAll((Collection<Port>)ac.getInterfacePorts());
            ac = ac.getBase();
lbl9:
            // 2 sources

            ** while (ac != null)
        }
lbl10:
        // 1 sources

        return result;
    }

    public static List<ActorContainerRef> getAllActorContainerRefs(StructureClass sc) {
        ArrayList<ActorContainerRef> refs = new ArrayList<ActorContainerRef>();
        if (sc instanceof LogicalSystem) {
            refs.addAll((Collection<ActorContainerRef>)((LogicalSystem)sc).getSubSystems());
        } else if (sc instanceof ActorContainerClass) {
            refs.addAll((Collection<ActorContainerRef>)((ActorContainerClass)sc).getActorRefs());
            if (sc instanceof ActorClass) {
                ActorClass base = (ActorClass)sc;
                while ((base = base.getBase()) != null) {
                    refs.addAll((Collection<ActorContainerRef>)base.getActorRefs());
                }
            }
        }
        return refs;
    }

    /*
     * Unable to fully structure code
     */
    public static List<Binding> getAllBindings(ActorClass ac) {
        result = new ArrayList<Binding>();
        if (!ValidationUtil.isCircularClassHierarchy(ac)) ** GOTO lbl7
        return result;
lbl-1000:
        // 1 sources

        {
            result.addAll((Collection<Binding>)ac.getBindings());
            ac = ac.getBase();
lbl7:
            // 2 sources

            ** while (ac != null)
        }
lbl8:
        // 1 sources

        return result;
    }

    /*
     * Unable to fully structure code
     */
    public static List<LayerConnection> getAllLayerConnections(ActorClass ac) {
        result = new ArrayList<LayerConnection>();
        if (!ValidationUtil.isCircularClassHierarchy(ac)) ** GOTO lbl7
        return result;
lbl-1000:
        // 1 sources

        {
            result.addAll((Collection<LayerConnection>)ac.getConnections());
            ac = ac.getBase();
lbl7:
            // 2 sources

            ** while (ac != null)
        }
lbl8:
        // 1 sources

        return result;
    }

    public static ActorClass getActorClass(StateGraphItem item) {
        StateGraphItem parent = item;
        while (parent != null) {
            if (!((parent = parent.eContainer()) instanceof ActorClass)) continue;
            return (ActorClass)((Object)parent);
        }
        assert (false) : "data structure broken";
        return null;
    }

    public static ActorClass getActorClass(EObject obj) {
        EObject parent = obj;
        while (parent != null) {
            if (!((parent = parent.eContainer()) instanceof ActorClass)) continue;
            return (ActorClass)parent;
        }
        return null;
    }

    public static ProtocolClass getProtocolClass(EObject obj) {
        EObject ctx = obj.eContainer();
        while (!(ctx instanceof ProtocolClass) && ctx.eContainer() != null) {
            ctx = ctx.eContainer();
        }
        if (ctx instanceof ProtocolClass) {
            return (ProtocolClass)ctx;
        }
        return null;
    }

    public static boolean isAnnotationPresent(ActorClass ac, String name) {
        return RoomHelpers.isAnnotationPresent(ac.getAnnotations(), (String)name);
    }

    public static boolean isBehaviorAnnotationPresent(ActorClass ac, String name) {
        return RoomHelpers.isAnnotationPresent(ac.getBehaviorAnnotations(), (String)name);
    }

    public static List<KeyValue> getAttributes(ActorClass ac, String name) {
        return RoomHelpers.getAttributes(ac.getAnnotations(), (String)name);
    }

    public static List<KeyValue> getBehaviorAttributes(ActorClass ac, String name) {
        return RoomHelpers.getAttributes(ac.getBehaviorAnnotations(), (String)name);
    }

    public static boolean isAttributePresent(ActorClass ac, String name, String key) {
        return RoomHelpers.isAttributePresent(ac.getAnnotations(), (String)name, (String)key);
    }

    public static boolean isBehaviorAttributePresent(ActorClass ac, String name, String key) {
        return RoomHelpers.isAttributePresent(ac.getBehaviorAnnotations(), (String)name, (String)key);
    }

    public static String getAttribute(ActorClass ac, String name, String key) {
        return RoomHelpers.getAttribute(ac.getAnnotations(), (String)name, (String)key);
    }

    public static String getBehaviorAttribute(ActorClass ac, String name, String key) {
        return RoomHelpers.getAttribute(ac.getBehaviorAnnotations(), (String)name, (String)key);
    }

    public static boolean hasFlatStateMachine(ActorClass ac) {
        if (RoomHelpers.isEmpty(ac.getStateMachine())) {
            return false;
        }
        if (!ac.getStateMachine().getTrPoints().isEmpty()) {
            return false;
        }
        for (State st : ac.getStateMachine().getStates()) {
            if (!RoomHelpers.hasDirectSubStructure(st)) continue;
            return false;
        }
        return true;
    }

    public static List<Message> getMessageListDeep(InterfaceItem item, boolean outgoing) {
        ProtocolClass protocol = null;
        if (item instanceof Port) {
            if (!(((Port)item).getProtocol() instanceof ProtocolClass)) {
                assert (false) : "unexpected protocol type";
                return null;
            }
            protocol = (ProtocolClass)((Port)item).getProtocol();
            if (((Port)item).isConjugated()) {
                outgoing = !outgoing;
            }
        } else if (item instanceof SAP) {
            outgoing = !outgoing;
            protocol = ((SAP)item).getProtocol();
        } else if (item instanceof SPP) {
            protocol = ((SPP)item).getProtocol();
        } else {
            assert (false) : "unexpected sub type";
            return null;
        }
        return RoomHelpers.getAllMessages(protocol, !outgoing);
    }

    public static PortClass getPortClass(InterfaceItem item) {
        ProtocolClass protocol = null;
        boolean conjugated = false;
        if (item instanceof Port) {
            if (!(((Port)item).getProtocol() instanceof ProtocolClass)) {
                assert (false) : "unexpected protocol type";
                return null;
            }
            protocol = (ProtocolClass)((Port)item).getProtocol();
            conjugated = ((Port)item).isConjugated();
        } else if (item instanceof SAP) {
            protocol = ((SAP)item).getProtocol();
            conjugated = true;
        } else if (item instanceof SPP) {
            protocol = ((SPP)item).getProtocol();
        } else {
            assert (false) : "unexpected sub type";
            return null;
        }
        return conjugated ? protocol.getConjugated() : protocol.getRegular();
    }

    public static boolean isRelay(Port port) {
        ActorContainerClass acc = (ActorContainerClass)port.eContainer();
        if (acc instanceof ActorClass) {
            if (((ActorClass)acc).getInterfacePorts().contains((Object)port)) {
                for (ExternalPort xp : ((ActorClass)acc).getExternalPorts()) {
                    if (xp.getInterfacePort() != port) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean isInternal(Port port) {
        ActorContainerClass acc = (ActorContainerClass)port.eContainer();
        if (acc instanceof ActorClass) {
            return ((ActorClass)acc).getInternalPorts().contains((Object)port);
        }
        return false;
    }

    public static boolean isExternal(Port port) {
        ActorContainerClass acc = (ActorContainerClass)port.eContainer();
        if (acc instanceof ActorClass) {
            for (ExternalPort ep : ((ActorClass)acc).getExternalPorts()) {
                if (ep.getInterfacePort() != port) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isConstructor(Operation op) {
        if (op instanceof PortOperation) {
            return false;
        }
        RoomClass cls = (RoomClass)op.eContainer();
        if (cls.getName().equals(op.getName())) {
            return !((StandardOperation)op).isDestructor();
        }
        return false;
    }

    public static boolean isDestructor(Operation op) {
        if (op instanceof PortOperation) {
            return false;
        }
        RoomClass cls = (RoomClass)op.eContainer();
        if (cls.getName().equals(op.getName())) {
            return ((StandardOperation)op).isDestructor();
        }
        return false;
    }

    public static boolean hasConstructor(ActorClass ac) {
        for (StandardOperation op : ac.getOperations()) {
            if (!op.getName().equals(ac.getName()) || op.isDestructor()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDestructor(ActorClass ac) {
        for (StandardOperation op : ac.getOperations()) {
            if (!op.getName().equals(ac.getName()) || !op.isDestructor()) continue;
            return true;
        }
        return false;
    }

    public static String getTypedArgumentList(Operation op) {
        String signature = "";
        for (VarDecl arg : op.getArguments()) {
            signature = signature.isEmpty() ? String.valueOf(arg.getName()) + ": " + arg.getRefType().getType().getName() : String.valueOf(signature) + ", " + arg.getName() + ": " + arg.getRefType().getType().getName();
        }
        signature = "(" + signature + ")";
        return signature;
    }

    public static String getSignature(Operation op) {
        String rt;
        String signature = "";
        for (VarDecl arg : op.getArguments()) {
            signature = signature.isEmpty() ? String.valueOf(arg.getName()) + ": " + arg.getRefType().getType().getName() : String.valueOf(signature) + ", " + arg.getName() + ": " + arg.getRefType().getType().getName();
        }
        String string = rt = op.getReturnType() != null ? ": " + op.getReturnType().getType().getName() : "";
        if (op instanceof PortOperation && ((PortOperation)op).getSendsMsg() != null) {
            rt = " sends " + ((PortOperation)op).getSendsMsg().getName();
        }
        signature = String.valueOf(op.getName()) + "(" + signature + ")" + rt;
        return signature;
    }

    public static String getArguments(Operation op) {
        String signature = "";
        for (VarDecl arg : op.getArguments()) {
            signature = signature.isEmpty() ? arg.getName() : String.valueOf(signature) + ", " + arg.getName();
        }
        signature = "(" + signature + ")";
        return signature;
    }

    public static SimpleState getBaseState(State s) {
        if (s instanceof SimpleState) {
            return (SimpleState)s;
        }
        if (s instanceof RefinedState) {
            return RoomHelpers.getBaseState(((RefinedState)s).getTarget());
        }
        return null;
    }

    public static List<State> getReferencedStatesRecursively(RefinedState rs) {
        ArrayList<State> result = new ArrayList<State>();
        State target = rs.getTarget();
        result.add(target);
        if (target instanceof RefinedState) {
            List<State> refs = RoomHelpers.getReferencedStatesRecursively((RefinedState)target);
            result.addAll(refs);
        }
        return result;
    }

    public static boolean referencesStateRecursively(RefinedState rs, State referenced) {
        State target = rs.getTarget();
        if (target == referenced) {
            return true;
        }
        if (target instanceof SimpleState) {
            return false;
        }
        if (target instanceof RefinedState) {
            return RoomHelpers.referencesStateRecursively((RefinedState)target, referenced);
        }
        assert (false) : "unexpected sub type";
        return false;
    }

    public static Map<RefinedState, RefinedState> getRefinedStatesToRelocate(ActorClass ac) {
        ArrayList<RefinedState> refinedStates = new ArrayList<RefinedState>();
        ArrayList<String> paths = new ArrayList<String>();
        HashMap<String, RefinedState> path2rs = new HashMap<String, RefinedState>();
        TreeIterator it = ac.getStateMachine().eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (!(obj instanceof RefinedState)) continue;
            refinedStates.add((RefinedState)obj);
            String path = RoomNameProvider.getFullPath((RefinedState)obj);
            paths.add(path);
            path2rs.put(path, (RefinedState)obj);
        }
        Collections.sort(paths, Collections.reverseOrder());
        HashMap<RefinedState, RefinedState> rs2parent = new HashMap<RefinedState, RefinedState>();
        block1: for (RefinedState rs : refinedStates) {
            String fullPath = RoomNameProvider.getFullPath(rs);
            for (String path : paths) {
                if (fullPath.equals(path) || !fullPath.startsWith(path) || fullPath.charAt(path.length()) != "_".charAt(0)) continue;
                RefinedState parent = (RefinedState)path2rs.get(path);
                if (parent.getSubgraph() != null && parent.getSubgraph().getStates().contains((Object)rs)) continue block1;
                rs2parent.put(rs, parent);
                continue block1;
            }
        }
        return rs2parent;
    }

    public static ProtocolClass getProtocol(InterfaceItem item) {
        GeneralProtocolClass pc = RoomHelpers.getGeneralProtocol(item);
        if (pc instanceof ProtocolClass) {
            return (ProtocolClass)pc;
        }
        return null;
    }

    public static boolean isDataDriven(InterfaceItem item) {
        ProtocolClass pc = RoomHelpers.getProtocol(item);
        return pc != null && pc.getCommType() == CommunicationType.DATA_DRIVEN;
    }

    public static GeneralProtocolClass getGeneralProtocol(InterfaceItem item) {
        if (item instanceof Port) {
            return ((Port)item).getProtocol();
        }
        if (item instanceof SAP) {
            return ((SAP)item).getProtocol();
        }
        if (item instanceof SPP) {
            return ((SPP)item).getProtocol();
        }
        assert (item.eIsProxy()) : "unexpected sub type";
        return null;
    }

    public static String getBaseEntryCode(RefinedState state) {
        return RoomHelpers.getBaseCode(state, (EStructuralFeature)RoomPackage.Literals.STATE__ENTRY_CODE);
    }

    public static String getBaseExitCode(RefinedState state) {
        return RoomHelpers.getBaseCode(state, (EStructuralFeature)RoomPackage.Literals.STATE__EXIT_CODE);
    }

    public static String getBaseDoCode(RefinedState state) {
        return RoomHelpers.getBaseCode(state, (EStructuralFeature)RoomPackage.Literals.STATE__DO_CODE);
    }

    private static String getBaseCode(RefinedState state, EStructuralFeature feat) {
        StringBuilder result = new StringBuilder();
        State base = state.getTarget();
        while (base != null) {
            String code = RoomHelpers.getDetailCode((DetailCode)base.eGet(feat));
            result.append(code);
            if (!(base instanceof RefinedState)) break;
            base = ((RefinedState)base).getTarget();
        }
        return result.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static RefableType getLastCommonSuperType(List<RefableType> types) {
        int nref = 0;
        int ndc = 0;
        for (RefableType rt : types) {
            if (rt == null) {
                return null;
            }
            if (rt.getType() instanceof DataClass) {
                ++ndc;
            }
            if (!rt.isRef()) continue;
            ++nref;
        }
        if (nref != 0 && nref != types.size()) {
            return null;
        }
        if (ndc == 0) {
            DataType type = types.get(0).getType();
            for (RefableType rt : types) {
                if (rt.getType() == type) continue;
                return null;
            }
            return (RefableType)EcoreUtil.copy((EObject)types.get(0));
        }
        if (ndc == types.size()) {
            void var6_14;
            ArrayList allSuperTypes = new ArrayList();
            for (RefableType rt : types) {
                void var6_8;
                DataClass dataClass = (DataClass)rt.getType();
                ArrayList superTypes = new ArrayList();
                allSuperTypes.add(superTypes);
                while (var6_8 != null) {
                    superTypes.add(0, var6_8);
                    DataClass dataClass2 = var6_8.getBase();
                }
            }
            int min = ((ArrayList)allSuperTypes.get(0)).size();
            DataClass common = (DataClass)((ArrayList)allSuperTypes.get(0)).get(0);
            for (ArrayList arrayList : allSuperTypes) {
                min = Math.min(min, arrayList.size());
                if (arrayList.get(0) == common) continue;
                return null;
            }
            boolean bl = true;
            block5: while (var6_14 < min) {
                DataClass better = (DataClass)((ArrayList)allSuperTypes.get(0)).get((int)var6_14);
                for (ArrayList arrayList : allSuperTypes) {
                    if (arrayList.get((int)var6_14) != better) break block5;
                }
                common = better;
                ++var6_14;
            }
            RefableType refableType = RoomFactory.eINSTANCE.createRefableType();
            refableType.setRef(nref > 0);
            refableType.setType(common);
            return refableType;
        }
        return null;
    }

    public static String getInheritedActionCode(Transition trans, ActorClass ac) {
        return RoomHelpers.getActionCode(trans, ac, false);
    }

    public static Transition getInitTransition(StateGraph sg) {
        for (Transition tr : sg.getTransitions()) {
            if (!(tr instanceof InitialTransition)) continue;
            return tr;
        }
        return null;
    }

    public static boolean hasInitTransition(StateGraph sg) {
        return RoomHelpers.getInitTransition(sg) != null;
    }

    public static String getAllActionCode(Transition trans, ActorClass ac) {
        return RoomHelpers.getActionCode(trans, ac, true);
    }

    private static String getActionCode(Transition trans, ActorClass ac, boolean includeOwn) {
        StringBuilder result = new StringBuilder();
        ActorClass baseAC = RoomHelpers.getActorClass(trans);
        if (!includeOwn) {
            if (ac == baseAC) {
                return null;
            }
            ac = ac.getBase();
        }
        while (ac != null) {
            if (ac == baseAC) {
                result.insert(0, RoomHelpers.getDetailCode(trans.getAction()));
                return result.toString();
            }
            if (ac.getStateMachine() != null) {
                for (RefinedTransition rt : ac.getStateMachine().getRefinedTransitions()) {
                    if (rt.getTarget() != trans) continue;
                    result.insert(0, RoomHelpers.getDetailCode(rt.getAction()));
                }
            }
            ac = ac.getBase();
        }
        return null;
    }

    public static ActorContainerClass getParentContainer(ActorInstanceMapping aim) {
        ActorContainerClass root = null;
        if (aim.eContainer() instanceof ActorInstanceMapping) {
            ActorInstanceMapping parent = (ActorInstanceMapping)aim.eContainer();
            root = RoomHelpers.getActorContainerClass(parent);
        } else if (aim.eContainer() instanceof SubSystemClass) {
            root = (SubSystemClass)aim.eContainer();
        }
        return root;
    }

    public static ActorContainerClass getActorContainerClass(ActorInstanceMapping aim) {
        ActorContainerClass result = RoomHelpers.getParentContainer(aim);
        for (RefSegment ref : aim.getPath().getRefs()) {
            ActorRef match = null;
            for (ActorContainerRef actor : RoomHelpers.getRefs(result, true)) {
                if (!(actor instanceof ActorRef) || !actor.getName().equals(ref.getRef())) continue;
                match = (ActorRef)actor;
                break;
            }
            if (match == null) {
                return null;
            }
            result = match.getType();
        }
        return result;
    }

    public static String asString(RefPath path) {
        StringBuilder sb = new StringBuilder();
        for (RefSegment ref : path.getRefs()) {
            sb.append("/" + ref);
        }
        return sb.toString();
    }

    public static ActorRef getLastActorRef(ActorContainerClass root, RefPath path) {
        if (path.getRefs().isEmpty()) {
            return null;
        }
        ActorRef lastMatch = null;
        ActorContainerClass result = root;
        for (RefSegment ref : path.getRefs()) {
            ActorRef match = null;
            for (ActorContainerRef actor : RoomHelpers.getRefs(result, true)) {
                if (!(actor instanceof ActorRef) || !actor.getName().equals(ref.getRef())) continue;
                match = (ActorRef)actor;
                break;
            }
            if (match == null) {
                return null;
            }
            result = match.getType();
            lastMatch = match;
        }
        return lastMatch;
    }

    public static String checkPath(ActorContainerClass root, RefPath path) {
        if (path == null) {
            return null;
        }
        ActorContainerClass last = root;
        Iterator it = path.getRefs().iterator();
        while (it.hasNext()) {
            RefSegment ref = (RefSegment)it.next();
            ActorRef match = null;
            for (ActorRef actor : last.getActorRefs()) {
                if (!actor.getName().equals(ref.getRef())) continue;
                match = actor;
                break;
            }
            ArrayList<InterfaceItem> ifs = new ArrayList<InterfaceItem>();
            ifs.addAll((Collection<InterfaceItem>)last.getServiceProvisionPoints());
            if (last instanceof ActorClass) {
                ActorClass actor = (ActorClass)last;
                ifs.addAll((Collection<InterfaceItem>)actor.getInterfacePorts());
                ifs.addAll((Collection<InterfaceItem>)actor.getInternalPorts());
            }
            if (last instanceof SubSystemClass) {
                ifs.addAll((Collection<InterfaceItem>)((SubSystemClass)last).getRelayPorts());
            }
            for (InterfaceItem item : ifs) {
                if (!item.getName().equals(ref) || it.hasNext()) continue;
                return null;
            }
            if (match == null) {
                return ref.getRef();
            }
            if (match.getMultiplicity() == 1) {
                if (ref.getIdx() != -1) {
                    return String.valueOf(ref.toString()) + " (ref not indexed )";
                }
            } else {
                if (ref.getIdx() < 0) {
                    return String.valueOf(ref.toString()) + " (ref needs index)";
                }
                if (ref.getIdx() >= match.getMultiplicity()) {
                    return String.valueOf(ref.toString()) + " (index out of bounds)";
                }
            }
            last = match.getType();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isDerivedFrom(ProtocolClass pc1, ProtocolClass pc2) {
        if (pc1 != pc2) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (pc1 == pc2) {
                return true;
            }
            pc1 = pc1.getBase();
lbl6:
            // 2 sources

            ** while (pc1 != null)
        }
lbl7:
        // 1 sources

        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isKindOf(ActorClass ac1, ActorClass ac2) {
        if (ac2 != null) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (ac2 == ac1) {
                return true;
            }
            ac1 = ac1.getBase();
lbl6:
            // 2 sources

            ** while (ac1 != null)
        }
lbl7:
        // 1 sources

        return false;
    }
}

