/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.etunit.converter.Etunit.util;

import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;
import org.eclipse.etrice.etunit.converter.Etunit.DocumentRoot;
import org.eclipse.etrice.etunit.converter.Etunit.ErrorType;
import org.eclipse.etrice.etunit.converter.Etunit.EtunitPackage;
import org.eclipse.etrice.etunit.converter.Etunit.FailureType;
import org.eclipse.etrice.etunit.converter.Etunit.TestcaseType;
import org.eclipse.etrice.etunit.converter.Etunit.Testsuite;
import org.eclipse.etrice.etunit.converter.Etunit.TestsuiteType;
import org.eclipse.etrice.etunit.converter.Etunit.TestsuitesType;

public class EtunitValidator
extends EObjectValidator {
    public static final EtunitValidator INSTANCE = new EtunitValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.etrice.etunit.converter.Etunit";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected XMLTypeValidator xmlTypeValidator = XMLTypeValidator.INSTANCE;
    public static final EValidator.PatternMatcher[][] ISO8601DATETIMEPATTERN__PATTERN__VALUES = new EValidator.PatternMatcher[][]{{XMLTypeUtil.createPatternMatcher((String)"[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}")}};

    protected EPackage getEPackage() {
        return EtunitPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateDocumentRoot((DocumentRoot)value, diagnostics, context);
            }
            case 1: {
                return this.validateErrorType((ErrorType)value, diagnostics, context);
            }
            case 2: {
                return this.validateFailureType((FailureType)value, diagnostics, context);
            }
            case 3: {
                return this.validateTestcaseType((TestcaseType)value, diagnostics, context);
            }
            case 4: {
                return this.validateTestsuite((Testsuite)value, diagnostics, context);
            }
            case 5: {
                return this.validateTestsuitesType((TestsuitesType)value, diagnostics, context);
            }
            case 6: {
                return this.validateTestsuiteType((TestsuiteType)value, diagnostics, context);
            }
            case 7: {
                return this.validateISO8601DATETIMEPATTERN((XMLGregorianCalendar)value, diagnostics, context);
            }
            case 8: {
                return this.validateNameType((String)value, diagnostics, context);
            }
            case 9: {
                return this.validatePreString((String)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateDocumentRoot(DocumentRoot documentRoot, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(documentRoot, diagnostics, context);
    }

    public boolean validateErrorType(ErrorType errorType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(errorType, diagnostics, context);
    }

    public boolean validateFailureType(FailureType failureType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(failureType, diagnostics, context);
    }

    public boolean validateTestcaseType(TestcaseType testcaseType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(testcaseType, diagnostics, context);
    }

    public boolean validateTestsuite(Testsuite testsuite, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(testsuite, diagnostics, context);
    }

    public boolean validateTestsuitesType(TestsuitesType testsuitesType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(testsuitesType, diagnostics, context);
    }

    public boolean validateTestsuiteType(TestsuiteType testsuiteType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(testsuiteType, diagnostics, context);
    }

    public boolean validateISO8601DATETIMEPATTERN(XMLGregorianCalendar iso8601DATETIMEPATTERN, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateISO8601DATETIMEPATTERN_Pattern(iso8601DATETIMEPATTERN, diagnostics, context);
        return result;
    }

    public boolean validateISO8601DATETIMEPATTERN_Pattern(XMLGregorianCalendar iso8601DATETIMEPATTERN, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validatePattern(EtunitPackage.Literals.ISO8601DATETIMEPATTERN, iso8601DATETIMEPATTERN, ISO8601DATETIMEPATTERN__PATTERN__VALUES, diagnostics, context);
    }

    public boolean validateNameType(String nameType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateNameType_MinLength(nameType, diagnostics, context);
        return result;
    }

    public boolean validateNameType_MinLength(String nameType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = nameType.length();
        boolean bl = result = length >= 1;
        if (!result && diagnostics != null) {
            this.reportMinLengthViolation(EtunitPackage.Literals.NAME_TYPE, nameType, length, 1, diagnostics, context);
        }
        return result;
    }

    public boolean validatePreString(String preString, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

