/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.common.base.LiteralType;
import org.eclipse.etrice.core.common.base.util.BaseHelpers;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.ExecMode;
import org.eclipse.etrice.core.etphys.eTPhys.NodeClass;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.etphys.eTPhys.PhysicalThread;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.IDiagnostician;
import org.eclipse.etrice.core.genmodel.etricegen.InstanceBase;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.PortInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorCommunicationType;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.GlobalGeneratorSettings;
import org.eclipse.etrice.generator.base.IGeneratorFileIo;
import org.eclipse.etrice.generator.base.IntelligentSeparator;
import org.eclipse.etrice.generator.c.Main;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.c.gen.Initialization;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class NodeGen {
    @Inject
    @Extension
    private CExtensions _cExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private TypeHelpers _typeHelpers;
    @Inject
    @Extension
    private ProcedureHelpers helpers;
    @Inject
    private IGeneratorFileIo fileIO;
    @Inject
    private Initialization attrInitGenAddon;
    @Inject
    private ILanguageExtension languageExt;
    @Inject
    private IDiagnostician diagnostician;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        Collection _nodeRefs = ETMapUtil.getNodeRefs();
        for (NodeRef nr : _nodeRefs) {
            List _subSystemInstancePaths = ETMapUtil.getSubSystemInstancePaths((NodeRef)nr);
            for (String instpath : _subSystemInstancePaths) {
                String _dispSourceFileName;
                String _instSourceFileName;
                String _cSourceFileName;
                HashSet<PhysicalThread> _hashSet;
                boolean _notEquals;
                StructureInstance _instance = root.getInstance(instpath);
                SubSystemInstance ssi = (SubSystemInstance)_instance;
                boolean bl = _notEquals = !Objects.equal((Object)ssi, null);
                if (!_notEquals) continue;
                SubSystemClass _subSystemClass = ssi.getSubSystemClass();
                String _generationTargetPath = this._roomExtensions.getGenerationTargetPath((EObject)_subSystemClass);
                SubSystemClass _subSystemClass_1 = ssi.getSubSystemClass();
                String _path = this._roomExtensions.getPath((RoomClass)_subSystemClass_1);
                String filepath = String.valueOf(_generationTargetPath) + _path;
                SubSystemClass _subSystemClass_2 = ssi.getSubSystemClass();
                String _generationInfoPath = this._roomExtensions.getGenerationInfoPath((EObject)_subSystemClass_2);
                SubSystemClass _subSystemClass_3 = ssi.getSubSystemClass();
                String _path_1 = this._roomExtensions.getPath((RoomClass)_subSystemClass_3);
                String infopath = String.valueOf(_generationInfoPath) + _path_1;
                String file = this._cExtensions.getCHeaderFileName(nr, ssi);
                this.checkDataPorts(ssi);
                HashSet<PhysicalThread> usedThreads = _hashSet = new HashSet<PhysicalThread>();
                NodeClass _type = nr.getType();
                EList _threads = _type.getThreads();
                for (final PhysicalThread thread : _threads) {
                    boolean _not;
                    Functions.Function1<ActorInstance, Boolean> _function;
                    EList _allContainedInstances = ssi.getAllContainedInstances();
                    Iterable instancesOnThread = IterableExtensions.filter((Iterable)_allContainedInstances, (Functions.Function1)(_function = new Functions.Function1<ActorInstance, Boolean>(){

                        public Boolean apply(ActorInstance ai) {
                            ETMapUtil.MappedThread _mappedThread = ETMapUtil.getMappedThread((AbstractInstance)ai);
                            PhysicalThread _thread = _mappedThread.getThread();
                            boolean _equals = Objects.equal((Object)_thread, (Object)thread);
                            return _equals;
                        }
                    }));
                    boolean _isEmpty = IterableExtensions.isEmpty((Iterable)instancesOnThread);
                    boolean bl2 = _not = !_isEmpty;
                    if (!_not) continue;
                    usedThreads.add(thread);
                }
                CharSequence _generateHeaderFile = this.generateHeaderFile(root, ssi);
                this.fileIO.generateFile("generating Node declaration", filepath, infopath, file, _generateHeaderFile);
                file = _cSourceFileName = this._cExtensions.getCSourceFileName(nr, ssi);
                CharSequence _generateSourceFile = this.generateSourceFile(root, ssi, usedThreads);
                this.fileIO.generateFile("generating Node implementation", filepath, infopath, file, _generateSourceFile);
                file = _instSourceFileName = this._cExtensions.getInstSourceFileName(nr, ssi);
                CharSequence _generateInstanceFile = this.generateInstanceFile(root, ssi, usedThreads);
                this.fileIO.generateFile("generating Node instance file", filepath, infopath, file, _generateInstanceFile);
                file = _dispSourceFileName = this._cExtensions.getDispSourceFileName(nr, ssi);
                CharSequence _generateDispatcherFile = this.generateDispatcherFile(root, ssi, usedThreads);
                this.fileIO.generateFile("generating Node dispatcher file", filepath, infopath, file, _generateDispatcherFile);
            }
        }
    }

    private CharSequence generateHeaderFile(Root root, SubSystemInstance ssi) {
        StringConcatenation _xblockexpression = null;
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssi);
        SubSystemClass ssc = ssi.getSubSystemClass();
        String _name = nr.getName();
        String _plus = String.valueOf(_name) + "_";
        String _name_1 = ssi.getName();
        String clsname = String.valueOf(_plus) + _name_1;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Header File of Node ");
        String _name_2 = nr.getName();
        _builder.append((Object)_name_2, " ");
        _builder.append((Object)" with SubSystem ");
        String _name_3 = ssi.getName();
        _builder.append((Object)_name_3, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateIncludeGuardBegin = this._cExtensions.generateIncludeGuardBegin(clsname);
        _builder.append((Object)_generateIncludeGuardBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include \"etDatatypes.h\"");
        _builder.newLine();
        _builder.newLine();
        DetailCode _userCode1 = ssc.getUserCode1();
        CharSequence _userCode = this.helpers.userCode(_userCode1);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/* lifecycle functions");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* init -> start -> run (loop) -> stop -> destroy");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_init(void);\t\t/* lifecycle init  \t */");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_start(void);\t/* lifecycle start \t */");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_run(etBool runAsTest);\t\t/* lifecycle run \t */");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_stop(void); \t/* lifecycle stop\t */");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_destroy(void); \t/* lifecycle destroy */");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_shutdown(void);  /* shutdown the dispatcher loop */");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        DetailCode _userCode2 = ssc.getUserCode2();
        CharSequence _userCode_1 = this.helpers.userCode(_userCode2);
        _builder.append((Object)_userCode_1, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateIncludeGuardEnd = this._cExtensions.generateIncludeGuardEnd(clsname);
        _builder.append((Object)_generateIncludeGuardEnd, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence generateSourceFile(Root root, SubSystemInstance ssi, final HashSet<PhysicalThread> usedThreads) {
        StringConcatenation _xblockexpression = null;
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssi);
        SubSystemClass ssc = ssi.getSubSystemClass();
        String _name = nr.getName();
        String _plus = String.valueOf(_name) + "_";
        String _name_1 = ssi.getName();
        String clsname = String.valueOf(_plus) + _name_1;
        NodeClass _type = nr.getType();
        EList _threads = _type.getThreads();
        Functions.Function1<PhysicalThread, Boolean> _function = new Functions.Function1<PhysicalThread, Boolean>(){

            public Boolean apply(PhysicalThread t) {
                boolean _contains = usedThreads.contains(t);
                return _contains;
            }
        };
        Iterable threads = IterableExtensions.filter((Iterable)_threads, (Functions.Function1)_function);
        EList _annotations = ssc.getAnnotations();
        boolean logData = BaseHelpers.isAnnotationPresent((List)_annotations, (String)"DataLogging");
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Source File of Node ");
        String _name_2 = nr.getName();
        _builder.append((Object)_name_2, " ");
        _builder.append((Object)" with SubSystem ");
        String _name_3 = ssi.getName();
        _builder.append((Object)_name_3, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include <stdio.h>");
        _builder.newLine();
        _builder.append((Object)"#include <string.h>");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"");
        String _cHeaderFileName = this._cExtensions.getCHeaderFileName(nr, ssi);
        _builder.append((Object)_cHeaderFileName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include \"debugging/etLogger.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"debugging/etMSCLogger.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"debugging/etDataLogger.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"messaging/etSystemProtocol.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"osal/etTimer.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"osal/etSema.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"runtime/etRuntime.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"etRuntimeConfig.h\"");
        _builder.newLine();
        _builder.newLine();
        DetailCode _userCode3 = ssc.getUserCode3();
        CharSequence _userCode = this.helpers.userCode(_userCode3);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/* data for Node ");
        String _name_4 = nr.getName();
        _builder.append((Object)_name_4, "");
        _builder.append((Object)" with SubSystem ");
        String _name_5 = ssi.getName();
        _builder.append((Object)_name_5, "");
        _builder.append((Object)" */");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"typedef struct ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"char *name;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"volatile int shutdownRequest;");
        _builder.newLine();
        _builder.append((Object)"} ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"static ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)" ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"Inst = {\"");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"\", 0};");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"static void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_initActorInstances(void);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"static void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_constructActorInstances(void);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/* include instances for all classes */");
        _builder.newLine();
        _builder.append((Object)"#include \"");
        String _instSourceFileName = this._cExtensions.getInstSourceFileName(nr, ssi);
        _builder.append((Object)_instSourceFileName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"#include \"");
        String _dispSourceFileName = this._cExtensions.getDispSourceFileName(nr, ssi);
        _builder.append((Object)_dispSourceFileName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"static void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_initMessageServices(void) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"\", \"initMessageServices\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"etTime interval;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"/* initialization of all message services */");
        _builder.newLine();
        for (PhysicalThread thread : threads) {
            boolean _or = false;
            ExecMode _execmode = thread.getExecmode();
            boolean _equals = Objects.equal((Object)_execmode, (Object)ExecMode.POLLED);
            if (_equals) {
                _or = true;
            } else {
                ExecMode _execmode_1 = thread.getExecmode();
                boolean _equals_1 = Objects.equal((Object)_execmode_1, (Object)ExecMode.MIXED);
                boolean bl = _or = _equals || _equals_1;
            }
            if (_or) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"interval.sec = 0;");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"interval.nSec = ");
                int _time = thread.getTime();
                _builder.append((Object)_time, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"etMessageService_init(");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"&msgService_");
            String _name_6 = thread.getName();
            _builder.append((Object)_name_6, "\t\t\t");
            _builder.append((Object)",");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"msgBuffer_");
            String _name_7 = thread.getName();
            _builder.append((Object)_name_7, "\t\t\t");
            _builder.append((Object)",");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            String _name_8 = thread.getName();
            String _upperCase = _name_8.toUpperCase();
            _builder.append((Object)_upperCase, "\t\t\t");
            _builder.append((Object)"_POOL_SIZE,");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            String _name_9 = thread.getName();
            String _upperCase_1 = _name_9.toUpperCase();
            _builder.append((Object)_upperCase_1, "\t\t\t");
            _builder.append((Object)"_BLOCK_SIZE,");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            int _stacksize = thread.getStacksize();
            _builder.append((Object)_stacksize, "\t\t\t");
            _builder.append((Object)",");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            int _prio = thread.getPrio();
            _builder.append((Object)_prio, "\t\t\t");
            _builder.append((Object)",");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"interval,");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"MsgDispatcher_");
            String _name_10 = thread.getName();
            _builder.append((Object)_name_10, "\t\t\t");
            _builder.append((Object)"_receiveMessage,");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"EXECMODE_");
            ExecMode _execmode_2 = thread.getExecmode();
            String _string = _execmode_2.toString();
            String _upperCase_2 = _string.toUpperCase();
            _builder.append((Object)_upperCase_2, "\t\t\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"static void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_startMessageServices(void) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"\", \"startMessageServices\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        for (PhysicalThread thread_1 : threads) {
            _builder.append((Object)"\t");
            _builder.append((Object)"etMessageService_start(&msgService_");
            String _name_11 = thread_1.getName();
            _builder.append((Object)_name_11, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"static void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_stopMessageServices(void) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"\", \"stopMessageServices\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        for (PhysicalThread thread_2 : threads) {
            _builder.append((Object)"\t");
            _builder.append((Object)"etMessageService_stop(&msgService_");
            String _name_12 = thread_2.getName();
            _builder.append((Object)_name_12, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"static void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_destroyMessageServices(void) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"\", \"destroyMessageServices\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        for (PhysicalThread thread_3 : threads) {
            _builder.append((Object)"\t");
            _builder.append((Object)"etMessageService_destroy(&msgService_");
            String _name_13 = thread_3.getName();
            _builder.append((Object)_name_13, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_init(void) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"\", \"init\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"etLogger_logInfoF(\"%s_init\", ");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"Inst.name);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/* construct all actors */");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"_constructActorInstances();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/* initialization of all message services */");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"_initMessageServices();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/* init all actors */");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"_initActorInstances();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        if (logData) {
            for (PhysicalThread thread_4 : threads) {
                _builder.append((Object)"\t");
                _builder.append((Object)"MsgDispatcher_");
                String _name_14 = thread_4.getName();
                _builder.append((Object)_name_14, "\t");
                _builder.append((Object)"_logDataHeaders();");
                _builder.newLineIfNotEmpty();
            }
            for (PhysicalThread thread_5 : threads) {
                _builder.append((Object)"\t");
                _builder.append((Object)"MsgDispatcher_");
                String _name_15 = thread_5.getName();
                _builder.append((Object)_name_15, "\t");
                _builder.append((Object)"_logData();");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_start(void) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"\", \"start\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"etLogger_logInfoF(\"%s_start\", ");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"Inst.name);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"_startMessageServices();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_run(etBool runAsTest) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"\", \"run\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (runAsTest) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"etSema_waitForWakeup(etRuntime_getTerminateSemaphore());");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"else {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"printf(\"type quit to exit\\n\");");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"fflush(stdout);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"while (TRUE) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"char line[64];");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"if (fgets(line, 64, stdin) != NULL) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"if (strncmp(line, \"quit\", 4)==0)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t\t");
        _builder.append((Object)"break;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_stop(void){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"\", \"stop\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"etLogger_logInfoF(\"%s_stop\", ");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"Inst.name);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"_stopMessageServices();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_destroy(void){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"\", \"destroy\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"etLogger_logInfoF(\"%s_destroy\", ");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"Inst.name);");
        _builder.newLineIfNotEmpty();
        EList _allContainedInstances = ssi.getAllContainedInstances();
        List _reverseView = ListExtensions.reverseView((List)_allContainedInstances);
        for (ActorInstance ai : _reverseView) {
            boolean _not;
            Functions.Function1<StandardOperation, Boolean> _function_1;
            ActorClass _actorClass = ai.getActorClass();
            EList _operations = _actorClass.getOperations();
            Iterable _filter = IterableExtensions.filter((Iterable)_operations, (Functions.Function1)(_function_1 = new Functions.Function1<StandardOperation, Boolean>(){

                public Boolean apply(StandardOperation op) {
                    boolean _isDestructor = op.isDestructor();
                    return _isDestructor;
                }
            }));
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)_filter);
            boolean bl = _not = !_isEmpty;
            if (!_not) continue;
            _builder.append((Object)"\t");
            ActorClass _actorClass_1 = ai.getActorClass();
            String _name_16 = _actorClass_1.getName();
            ActorClass _actorClass_2 = ai.getActorClass();
            String _name_17 = _actorClass_2.getName();
            String _destructorName = this.languageExt.destructorName(_name_17);
            String _memberInUse = this.languageExt.memberInUse(_name_16, _destructorName);
            _builder.append((Object)_memberInUse, "\t");
            _builder.append((Object)"(&");
            String _path = ai.getPath();
            String _pathName = this._roomExtensions.getPathName(_path);
            _builder.append((Object)_pathName, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"_destroyMessageServices();");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_shutdown(void){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"\", \"shutdown\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"etLogger_logInfoF(\"%s_shutdown\", ");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"Inst.name);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"Inst.shutdownRequest = 1;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"static void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_constructActorInstances(void){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"\", \"constructActorInstances\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        EList _allContainedInstances_1 = ssi.getAllContainedInstances();
        for (ActorInstance ai_1 : _allContainedInstances_1) {
            boolean _not_1;
            Functions.Function1<StandardOperation, Boolean> _function_2;
            ActorClass _actorClass_3 = ai_1.getActorClass();
            EList _operations_1 = _actorClass_3.getOperations();
            Iterable _filter_1 = IterableExtensions.filter((Iterable)_operations_1, (Functions.Function1)(_function_2 = new Functions.Function1<StandardOperation, Boolean>(){

                public Boolean apply(StandardOperation op) {
                    boolean _isConstructor = RoomHelpers.isConstructor((Operation)op);
                    return _isConstructor;
                }
            }));
            boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)_filter_1);
            boolean bl = _not_1 = !_isEmpty_1;
            if (!_not_1) continue;
            _builder.append((Object)"\t");
            ActorClass _actorClass_4 = ai_1.getActorClass();
            String _name_18 = _actorClass_4.getName();
            ActorClass _actorClass_5 = ai_1.getActorClass();
            String _name_19 = _actorClass_5.getName();
            String _constructorName = this.languageExt.constructorName(_name_19);
            String _memberInUse_1 = this.languageExt.memberInUse(_name_18, _constructorName);
            _builder.append((Object)_memberInUse_1, "\t");
            _builder.append((Object)"(&");
            String _path_1 = ai_1.getPath();
            String _pathName_1 = this._roomExtensions.getPathName(_path_1);
            _builder.append((Object)_pathName_1, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"static void ");
        _builder.append((Object)clsname, "");
        _builder.append((Object)"_initActorInstances(void){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"");
        _builder.append((Object)clsname, "\t");
        _builder.append((Object)"\", \"initActorInstances\")");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        EList _allContainedInstances_2 = ssi.getAllContainedInstances();
        for (ActorInstance ai_2 : _allContainedInstances_2) {
            _builder.append((Object)"\t");
            ActorClass _actorClass_6 = ai_2.getActorClass();
            String _name_20 = _actorClass_6.getName();
            _builder.append((Object)_name_20, "\t");
            _builder.append((Object)"_init(&");
            String _path_2 = ai_2.getPath();
            String _pathName_2 = this._roomExtensions.getPathName(_path_2);
            _builder.append((Object)_pathName_2, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence generateInstanceFile(Root root, SubSystemInstance ssi, final HashSet<PhysicalThread> usedThreads) {
        StringConcatenation _xblockexpression = null;
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssi);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Instance File of Node ");
        String _name = nr.getName();
        _builder.append((Object)_name, " ");
        _builder.append((Object)" with SubSystem ");
        String _name_1 = ssi.getName();
        _builder.append((Object)_name_1, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* - instantiation of all actor instances and port instances");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* - configuration of data and connection of ports");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"messaging/etMessageService.h\"");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/* include all referenced ActorClasses */");
        _builder.newLine();
        SubSystemClass _subSystemClass = ssi.getSubSystemClass();
        EList _referencedActorClasses = root.getReferencedActorClasses((RoomClass)_subSystemClass);
        for (ActorClass actorClass : _referencedActorClasses) {
            _builder.append((Object)"#include ");
            String _includePath = this._cExtensions.getIncludePath((RoomClass)actorClass);
            _builder.append((Object)_includePath, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"/* include all referenced ProtcolClasses */");
        _builder.newLine();
        SubSystemClass _subSystemClass_1 = ssi.getSubSystemClass();
        EList _referencedProtocolClasses = root.getReferencedProtocolClasses((RoomClass)_subSystemClass_1);
        for (ProtocolClass protocolClass : _referencedProtocolClasses) {
            _builder.append((Object)"#include ");
            String _includePath_1 = this._cExtensions.getIncludePath((RoomClass)protocolClass);
            _builder.append((Object)_includePath_1, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"/* instantiation of message services and message buffers */");
        _builder.newLine();
        NodeClass _type = nr.getType();
        EList _threads = _type.getThreads();
        Functions.Function1<PhysicalThread, Boolean> _function = new Functions.Function1<PhysicalThread, Boolean>(){

            public Boolean apply(PhysicalThread t) {
                boolean _contains = usedThreads.contains(t);
                return _contains;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_threads, (Functions.Function1)_function);
        for (PhysicalThread thread : _filter) {
            _builder.append((Object)"/* ");
            String _name_2 = thread.getName();
            _builder.append((Object)_name_2, "");
            _builder.append((Object)" */");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"#define ");
            String _name_3 = thread.getName();
            String _upperCase = _name_3.toUpperCase();
            _builder.append((Object)_upperCase, "");
            _builder.append((Object)"_POOL_SIZE\t\t");
            int _msgpoolsize = thread.getMsgpoolsize();
            _builder.append((Object)_msgpoolsize, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"#define ");
            String _name_4 = thread.getName();
            String _upperCase_1 = _name_4.toUpperCase();
            _builder.append((Object)_upperCase_1, "");
            _builder.append((Object)"_BLOCK_SIZE\t");
            int _msgblocksize = thread.getMsgblocksize();
            _builder.append((Object)_msgblocksize, "");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"static uint8 msgBuffer_");
            String _name_5 = thread.getName();
            _builder.append((Object)_name_5, "");
            _builder.append((Object)"[");
            String _name_6 = thread.getName();
            String _upperCase_2 = _name_6.toUpperCase();
            _builder.append((Object)_upperCase_2, "");
            _builder.append((Object)"_POOL_SIZE * ");
            String _name_7 = thread.getName();
            String _upperCase_3 = _name_7.toUpperCase();
            _builder.append((Object)_upperCase_3, "");
            _builder.append((Object)"_BLOCK_SIZE]; ");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"static etMessageService msgService_");
            String _name_8 = thread.getName();
            _builder.append((Object)_name_8, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"/* declarations of all ActorClass instances (const and variable structs) */");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/* forward declaration of variable actor structs */");
        _builder.newLine();
        EList _allContainedInstances = ssi.getAllContainedInstances();
        for (ActorInstance ai : _allContainedInstances) {
            _builder.append((Object)"static ");
            ActorClass _actorClass = ai.getActorClass();
            String _name_9 = _actorClass.getName();
            _builder.append((Object)_name_9, "");
            _builder.append((Object)" ");
            String _path = ai.getPath();
            String _pathName = this._roomExtensions.getPathName(_path);
            _builder.append((Object)_pathName, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"/* forward declaration of variable port structs */");
        _builder.newLine();
        EList _allContainedInstances_1 = ssi.getAllContainedInstances();
        for (ActorInstance ai_1 : _allContainedInstances_1) {
            EList _orderedIfItemInstances = ai_1.getOrderedIfItemInstances();
            boolean _isEmpty = _orderedIfItemInstances.isEmpty();
            if (_isEmpty) {
                _builder.append((Object)"/* nothing to do */");
                _builder.newLine();
                continue;
            }
            EList _orderedIfItemInstances_1 = ai_1.getOrderedIfItemInstances();
            for (InterfaceItemInstance pi : _orderedIfItemInstances_1) {
                boolean _equals;
                boolean _greaterThan;
                ProtocolClass _protocol = pi.getProtocol();
                boolean _isConjugated = this._roomExtensions.isConjugated(pi);
                PortClass _portClass = this._roomExtensions.getPortClass(_protocol, _isConjugated);
                EList _attributes = null;
                if (_portClass != null) {
                    _attributes = _portClass.getAttributes();
                }
                int _size = 0;
                if (_attributes != null) {
                    _size = _attributes.size();
                }
                boolean bl = _greaterThan = _size > 0;
                if (!_greaterThan) continue;
                _builder.append((Object)"static ");
                ProtocolClass _protocol_1 = pi.getProtocol();
                boolean _isConjugated_1 = this._roomExtensions.isConjugated(pi);
                String _portClassName = this._roomExtensions.getPortClassName(_protocol_1, _isConjugated_1);
                _builder.append((Object)_portClassName, "");
                _builder.append((Object)"_var ");
                String _path_1 = pi.getPath();
                String _pathName_1 = this._roomExtensions.getPathName(_path_1);
                _builder.append((Object)_pathName_1, "");
                _builder.append((Object)"_var");
                boolean _isReplicated = pi.isReplicated();
                if (_isReplicated) {
                    _builder.append((Object)"[");
                    EList _peers = pi.getPeers();
                    int _size_1 = _peers.size();
                    _builder.append((Object)_size_1, "");
                    _builder.append((Object)"]");
                }
                _builder.append((Object)"={");
                _builder.newLineIfNotEmpty();
                int _xifexpression = 0;
                EList _peers_1 = pi.getPeers();
                int _size_2 = _peers_1.size();
                boolean bl2 = _equals = _size_2 == 0;
                if (_equals) {
                    _xifexpression = 1;
                } else {
                    int _size_3;
                    EList _peers_2 = pi.getPeers();
                    _xifexpression = _size_3 = _peers_2.size();
                }
                IntegerRange _upTo = new IntegerRange(1, _xifexpression);
                boolean _hasElements = false;
                for (Integer i : _upTo) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    _builder.append((Object)"\t");
                    InterfaceItem _interfaceItem = pi.getInterfaceItem();
                    PortClass _portClass_1 = RoomHelpers.getPortClass((InterfaceItem)_interfaceItem);
                    EList _attributes_1 = _portClass_1.getAttributes();
                    CharSequence _generateAttributeInit = this.attrInitGenAddon.generateAttributeInit((InstanceBase)pi, (List<Attribute>)_attributes_1);
                    _builder.append((Object)_generateAttributeInit, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t\t\t\t\t\t\t");
                }
                _builder.append((Object)"};");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        EList _allContainedInstances_2 = ssi.getAllContainedInstances();
        for (ActorInstance ai_2 : _allContainedInstances_2) {
            boolean _not;
            _builder.newLine();
            _builder.append((Object)"/* instance ");
            String _path_2 = ai_2.getPath();
            String _pathName_2 = this._roomExtensions.getPathName(_path_2);
            _builder.append((Object)_pathName_2, "");
            _builder.append((Object)" */");
            _builder.newLineIfNotEmpty();
            boolean _and = false;
            GlobalGeneratorSettings _settings = Main.getSettings();
            boolean _generateMSCInstrumentation = _settings.generateMSCInstrumentation();
            boolean bl = _not = !_generateMSCInstrumentation;
            if (!_not) {
                _and = false;
            } else {
                EList _orderedIfItemInstances_2 = ai_2.getOrderedIfItemInstances();
                boolean _isEmpty_1 = _orderedIfItemInstances_2.isEmpty();
                boolean bl3 = _and = _not && _isEmpty_1;
            }
            if (_and) {
                _builder.append((Object)"/* no ports/saps/services - nothing to initialize statically */");
                _builder.newLine();
                continue;
            }
            CharSequence _genActorInstanceInitializer = this.genActorInstanceInitializer(root, ai_2);
            _builder.append((Object)_genActorInstanceInitializer, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence genActorInstanceInitializer(Root root, ActorInstance ai) {
        IntelligentSeparator _intelligentSeparator;
        boolean _not;
        String _plus;
        HashMap<InterfaceItemInstance, Integer> _hashMap;
        ArrayList _arrayList_1;
        ArrayList _arrayList;
        StringConcatenation _xblockexpression = null;
        String _path = ai.getPath();
        String instName = this._roomExtensions.getPathName(_path);
        ArrayList replEventItems = _arrayList = new ArrayList();
        EList _orderedIfItemInstances = ai.getOrderedIfItemInstances();
        Functions.Function1<InterfaceItemInstance, Boolean> _function = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance e) {
                boolean _isReplicated = e.isReplicated();
                return _isReplicated;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_orderedIfItemInstances, (Functions.Function1)_function);
        Iterables.addAll(replEventItems, (Iterable)_filter);
        Functions.Function1<InterfaceItemInstance, Boolean> _function_1 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance e) {
                EList _peers = e.getPeers();
                boolean _isEmpty = _peers.isEmpty();
                boolean _not = !_isEmpty;
                return _not;
            }
        };
        InterfaceItemInstance _findFirst = (InterfaceItemInstance)IterableExtensions.findFirst(replEventItems, (Functions.Function1)_function_1);
        boolean haveReplSubItems = !Objects.equal((Object)_findFirst, null);
        Functions.Function1<InterfaceItemInstance, Boolean> _function_2 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance i) {
                InterfaceItem _interfaceItem = i.getInterfaceItem();
                return _interfaceItem instanceof Port;
            }
        };
        Iterable replEventPorts = IterableExtensions.filter(replEventItems, (Functions.Function1)_function_2);
        Functions.Function1<InterfaceItemInstance, Boolean> _function_3 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance i) {
                InterfaceItem _interfaceItem = i.getInterfaceItem();
                return _interfaceItem instanceof SPP;
            }
        };
        Iterable replEventSPPs = IterableExtensions.filter(replEventItems, (Functions.Function1)_function_3);
        EList _orderedIfItemInstances_1 = ai.getOrderedIfItemInstances();
        Functions.Function1<InterfaceItemInstance, Boolean> _function_4 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance e) {
                boolean _isSimple = e.isSimple();
                return _isSimple;
            }
        };
        Iterable simplePorts = IterableExtensions.filter((Iterable)_orderedIfItemInstances_1, (Functions.Function1)_function_4);
        ArrayList simpleEventItems = _arrayList_1 = new ArrayList();
        Functions.Function1<InterfaceItemInstance, Boolean> _function_5 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance p) {
                ProtocolClass _protocol = p.getProtocol();
                CommunicationType _commType = _protocol.getCommType();
                boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.EVENT_DRIVEN);
                return _equals;
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)simplePorts, (Functions.Function1)_function_5);
        Iterables.addAll(simpleEventItems, (Iterable)_filter_1);
        Functions.Function1<InterfaceItemInstance, Boolean> _function_6 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance i) {
                InterfaceItem _interfaceItem = i.getInterfaceItem();
                return _interfaceItem instanceof Port;
            }
        };
        Iterable simpleEventPorts = IterableExtensions.filter(simpleEventItems, (Functions.Function1)_function_6);
        Functions.Function1<InterfaceItemInstance, Boolean> _function_7 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance i) {
                InterfaceItem _interfaceItem = i.getInterfaceItem();
                return _interfaceItem instanceof SAP;
            }
        };
        Iterable simpleEventSAPs = IterableExtensions.filter(simpleEventItems, (Functions.Function1)_function_7);
        Functions.Function1<InterfaceItemInstance, Boolean> _function_8 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance p) {
                ProtocolClass _protocol = p.getProtocol();
                CommunicationType _commType = _protocol.getCommType();
                boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.DATA_DRIVEN);
                return _equals;
            }
        };
        Iterable dataPorts = IterableExtensions.filter((Iterable)simplePorts, (Functions.Function1)_function_8);
        Functions.Function1<InterfaceItemInstance, Boolean> _function_9 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance p) {
                boolean _and = false;
                if (!(p instanceof PortInstance)) {
                    _and = false;
                } else {
                    Port _port = ((PortInstance)p).getPort();
                    boolean _isConjugated = _port.isConjugated();
                    boolean _not = !_isConjugated;
                    _and = p instanceof PortInstance && _not;
                }
                return _and;
            }
        };
        Iterable recvPorts = IterableExtensions.filter((Iterable)dataPorts, (Functions.Function1)_function_9);
        Functions.Function1<InterfaceItemInstance, Boolean> _function_10 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance p) {
                boolean _and = false;
                if (!(p instanceof PortInstance)) {
                    _and = false;
                } else {
                    Port _port = ((PortInstance)p).getPort();
                    boolean _isConjugated = _port.isConjugated();
                    _and = p instanceof PortInstance && _isConjugated;
                }
                return _and;
            }
        };
        Iterable sendPorts = IterableExtensions.filter((Iterable)dataPorts, (Functions.Function1)_function_10);
        HashMap<InterfaceItemInstance, Integer> offsets = _hashMap = new HashMap<InterfaceItemInstance, Integer>();
        int offset = 0;
        for (InterfaceItemInstance p : replEventItems) {
            int _plus2;
            offsets.put(p, offset);
            EList _peers = p.getPeers();
            int _size = _peers.size();
            offset = _plus2 = offset + _size;
        }
        String _xifexpression = null;
        _xifexpression = haveReplSubItems ? (_plus = String.valueOf(instName) + "_repl_sub_ports") : "NULL";
        String replSubPortsArray = _xifexpression;
        boolean _or = false;
        boolean _or_1 = false;
        boolean _or_2 = false;
        boolean _isEmpty = simpleEventItems.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _or_2 = true;
        } else {
            boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)recvPorts);
            boolean _not_1 = !_isEmpty_1;
            boolean bl2 = _or_2 = _not || _not_1;
        }
        if (_or_2) {
            _or_1 = true;
        } else {
            boolean _isEmpty_2 = replEventItems.isEmpty();
            boolean _not_2 = !_isEmpty_2;
            boolean bl3 = _or_1 = _or_2 || _not_2;
        }
        if (_or_1) {
            _or = true;
        } else {
            GlobalGeneratorSettings _settings = Main.getSettings();
            boolean _generateMSCInstrumentation = _settings.generateMSCInstrumentation();
            _or = _or_1 || _generateMSCInstrumentation;
        }
        boolean haveConstData = _or;
        IntelligentSeparator sep = _intelligentSeparator = new IntelligentSeparator(",");
        String _xifexpression_1 = null;
        GlobalGeneratorSettings _settings_1 = Main.getSettings();
        boolean _generateMSCInstrumentation_1 = _settings_1.generateMSCInstrumentation();
        _xifexpression_1 = _generateMSCInstrumentation_1 ? "/*const*/" : "const";
        String const_ = _xifexpression_1;
        StringConcatenation _builder = new StringConcatenation();
        GlobalGeneratorSettings _settings_2 = Main.getSettings();
        boolean _generateMSCInstrumentation_2 = _settings_2.generateMSCInstrumentation();
        if (_generateMSCInstrumentation_2) {
            CharSequence _genPeerPortArrays = this.genPeerPortArrays(root, ai);
            _builder.append((Object)_genPeerPortArrays, "");
            _builder.newLineIfNotEmpty();
        }
        if (haveReplSubItems) {
            _builder.append((Object)"static const etReplSubPort ");
            _builder.append((Object)replSubPortsArray, "");
            _builder.append((Object)"[");
            _builder.append((Object)offset, "");
            _builder.append((Object)"] = {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* Replicated Sub Ports: {varData, msgService, peerAddress, localId, index} */");
            _builder.newLine();
            Functions.Function1<InterfaceItemInstance, Boolean> _function_11 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

                public Boolean apply(InterfaceItemInstance e) {
                    EList _peers = e.getPeers();
                    boolean _isEmpty = _peers.isEmpty();
                    boolean _not = !_isEmpty;
                    return _not;
                }
            };
            Iterable _filter_2 = IterableExtensions.filter(replEventItems, (Functions.Function1)_function_11);
            boolean _hasElements = false;
            for (InterfaceItemInstance pi : _filter_2) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "\t");
                }
                _builder.append((Object)"\t");
                String _genReplSubPortInitializers = this.genReplSubPortInitializers(root, ai, pi);
                _builder.append((Object)_genReplSubPortInitializers, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"};");
            _builder.newLine();
        }
        if (haveConstData) {
            _builder.append((Object)"static ");
            _builder.append((Object)const_, "");
            _builder.append((Object)" ");
            ActorClass _actorClass = ai.getActorClass();
            String _name = _actorClass.getName();
            _builder.append((Object)_name, "");
            _builder.append((Object)"_const ");
            _builder.append((Object)instName, "");
            _builder.append((Object)"_const = {");
            _builder.newLineIfNotEmpty();
            GlobalGeneratorSettings _settings_3 = Main.getSettings();
            boolean _generateMSCInstrumentation_3 = _settings_3.generateMSCInstrumentation();
            if (_generateMSCInstrumentation_3) {
                _builder.append((Object)"\t");
                _builder.append((Object)sep, "\t");
                _builder.append((Object)"\"");
                String _path_1 = ai.getPath();
                _builder.append((Object)_path_1, "\t");
                _builder.append((Object)"\"");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.newLine();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"/* Ports: {varData, msgService, peerAddress, localId} */");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* simple ports */");
            _builder.newLine();
            for (InterfaceItemInstance pi_1 : simpleEventPorts) {
                _builder.append((Object)"\t");
                _builder.append((Object)sep, "\t");
                String _genPortInitializer = this.genPortInitializer(root, ai, pi_1);
                _builder.append((Object)_genPortInitializer, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* data receive ports */");
            _builder.newLine();
            for (InterfaceItemInstance pi_2 : recvPorts) {
                _builder.append((Object)"\t");
                _builder.append((Object)sep, "\t");
                String _genRecvPortInitializer = this.genRecvPortInitializer(root, ai, pi_2);
                _builder.append((Object)_genRecvPortInitializer, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* saps */");
            _builder.newLine();
            for (InterfaceItemInstance pi_3 : simpleEventSAPs) {
                _builder.append((Object)"\t");
                _builder.append((Object)sep, "\t");
                String _genPortInitializer_1 = this.genPortInitializer(root, ai, pi_3);
                _builder.append((Object)_genPortInitializer_1, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* replicated ports */");
            _builder.newLine();
            for (InterfaceItemInstance pi_4 : replEventPorts) {
                _builder.append((Object)"\t");
                _builder.append((Object)sep, "\t");
                _builder.append((Object)"{");
                EList _peers = pi_4.getPeers();
                int _size = _peers.size();
                _builder.append((Object)_size, "\t");
                _builder.append((Object)", ");
                _builder.append((Object)replSubPortsArray, "\t");
                _builder.append((Object)"+");
                Integer _get = (Integer)offsets.get(pi_4);
                _builder.append((Object)_get, "\t");
                _builder.append((Object)"}");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"/* services */");
            _builder.newLine();
            for (InterfaceItemInstance pi_5 : replEventSPPs) {
                _builder.append((Object)"\t");
                _builder.append((Object)sep, "\t");
                _builder.append((Object)"{");
                EList _peers_1 = pi_5.getPeers();
                int _size_1 = _peers_1.size();
                _builder.append((Object)_size_1, "\t");
                _builder.append((Object)", ");
                _builder.append((Object)replSubPortsArray, "\t");
                _builder.append((Object)"+");
                Integer _get_1 = (Integer)offsets.get(pi_5);
                _builder.append((Object)_get_1, "\t");
                _builder.append((Object)"}");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"};");
            _builder.newLine();
        }
        _builder.append((Object)"static ");
        ActorClass _actorClass_1 = ai.getActorClass();
        String _name_1 = _actorClass_1.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)" ");
        _builder.append((Object)instName, "");
        _builder.append((Object)" = {");
        _builder.newLineIfNotEmpty();
        if (haveConstData) {
            _builder.append((Object)"\t");
            _builder.append((Object)"&");
            _builder.append((Object)instName, "\t");
            _builder.append((Object)"_const,");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"/* data send ports */");
        _builder.newLine();
        for (InterfaceItemInstance pi_6 : sendPorts) {
            _builder.append((Object)"\t");
            CharSequence _genSendPortInitializer = this.genSendPortInitializer(pi_6);
            _builder.append((Object)_genSendPortInitializer, "\t");
            _builder.append((Object)",");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/* attributes */");
        _builder.newLine();
        _builder.append((Object)"\t");
        ActorClass _actorClass_2 = ai.getActorClass();
        List _allAttributes = RoomHelpers.getAllAttributes((ActorClass)_actorClass_2);
        CharSequence _generateAttributeInit = this.attrInitGenAddon.generateAttributeInit((InstanceBase)ai, _allAttributes);
        _builder.append((Object)_generateAttributeInit, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/* state and history are initialized in init function */");
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence genPeerPortArrays(Root root, ActorInstance ai) {
        boolean _not;
        StringConcatenation _xblockexpression = null;
        EList _orderedIfItemInstances = ai.getOrderedIfItemInstances();
        Functions.Function1<InterfaceItemInstance, Boolean> _function = new Functions.Function1<InterfaceItemInstance, Boolean>(){

            public Boolean apply(InterfaceItemInstance e) {
                boolean _and = false;
                boolean _isSimple = e.isSimple();
                _and = !_isSimple ? false : _isSimple && e instanceof PortInstance;
                return _and;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_orderedIfItemInstances, (Functions.Function1)_function);
        Functions.Function1<InterfaceItemInstance, PortInstance> _function_1 = new Functions.Function1<InterfaceItemInstance, PortInstance>(){

            public PortInstance apply(InterfaceItemInstance inst) {
                return (PortInstance)inst;
            }
        };
        Iterable simplePorts = IterableExtensions.map((Iterable)_filter, (Functions.Function1)_function_1);
        Functions.Function1<PortInstance, Boolean> _function_2 = new Functions.Function1<PortInstance, Boolean>(){

            public Boolean apply(PortInstance p) {
                boolean _and = false;
                Port _port = p.getPort();
                boolean _isConjugated = _port.isConjugated();
                if (!_isConjugated) {
                    _and = false;
                } else {
                    ProtocolClass _protocol = p.getProtocol();
                    CommunicationType _commType = _protocol.getCommType();
                    boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.DATA_DRIVEN);
                    _and = _isConjugated && _equals;
                }
                return _and;
            }
        };
        Iterable sendPorts = IterableExtensions.filter((Iterable)simplePorts, (Functions.Function1)_function_2);
        Functions.Function1<PortInstance, Boolean> _function_3 = new Functions.Function1<PortInstance, Boolean>(){

            public Boolean apply(PortInstance p) {
                boolean _not;
                boolean _and = false;
                EList _peers = p.getPeers();
                boolean _isEmpty = _peers.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (!_not) {
                    _and = false;
                } else {
                    Functions.Function1<Message, Boolean> _function;
                    Port _port = p.getPort();
                    List _outgoing = RoomHelpers.getOutgoing((InterfaceItem)_port);
                    Iterable _filter = IterableExtensions.filter((Iterable)_outgoing, (Functions.Function1)(_function = new Functions.Function1<Message, Boolean>(){

                        public Boolean apply(Message m) {
                            VarDecl _data = m.getData();
                            RefableType _refType = _data.getRefType();
                            DataType _type = _refType.getType();
                            boolean _isEnumeration = NodeGen.this._typeHelpers.isEnumeration(_type);
                            return _isEnumeration;
                        }
                    }));
                    boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)_filter);
                    boolean _not_1 = !_isEmpty_1;
                    _and = _not && _not_1;
                }
                return _and;
            }
        };
        Iterable enumPortsWithPeers = IterableExtensions.filter((Iterable)sendPorts, (Functions.Function1)_function_3);
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)enumPortsWithPeers);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append((Object)"#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE");
            _builder.newLine();
            for (PortInstance pi : enumPortsWithPeers) {
                _builder.append((Object)"static const char* ");
                String _path = pi.getPath();
                String _pathName = this._roomExtensions.getPathName(_path);
                _builder.append((Object)_pathName, "");
                _builder.append((Object)"_peers[");
                EList _peers = pi.getPeers();
                int _size = _peers.size();
                int _plus = _size + 1;
                _builder.append((Object)_plus, "");
                _builder.append((Object)"] = {");
                _builder.newLineIfNotEmpty();
                EList _peers_1 = pi.getPeers();
                for (InterfaceItemInstance peer : _peers_1) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\"");
                    EObject _eContainer = peer.eContainer();
                    String _path_1 = ((ActorInstance)_eContainer).getPath();
                    _builder.append((Object)_path_1, "\t");
                    _builder.append((Object)"\",");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"NULL");
                _builder.newLine();
                _builder.append((Object)"};");
                _builder.newLine();
            }
            _builder.append((Object)"#endif");
            _builder.newLine();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private String genPortInitializer(Root root, ActorInstance ai, InterfaceItemInstance pi) {
        String _plus_18;
        String _xblockexpression = null;
        int _xifexpression = 0;
        EList _peers = pi.getPeers();
        boolean _isEmpty = _peers.isEmpty();
        if (_isEmpty) {
            _xifexpression = 0;
        } else {
            int _objId;
            EList _peers_1 = pi.getPeers();
            InterfaceItemInstance _get = (InterfaceItemInstance)_peers_1.get(0);
            _xifexpression = _objId = _get.getObjId();
        }
        int objId = _xifexpression;
        int _xifexpression_1 = 0;
        EList _peers_2 = pi.getPeers();
        boolean _isEmpty_1 = _peers_2.isEmpty();
        if (_isEmpty_1) {
            _xifexpression_1 = 0;
        } else {
            int _indexOf;
            EList _peers_3 = pi.getPeers();
            InterfaceItemInstance _get_1 = (InterfaceItemInstance)_peers_3.get(0);
            EList _peers_4 = _get_1.getPeers();
            _xifexpression_1 = _indexOf = _peers_4.indexOf((Object)pi);
        }
        int idx = _xifexpression_1;
        String _xifexpression_2 = null;
        EList _peers_5 = pi.getPeers();
        boolean _isEmpty_2 = _peers_5.isEmpty();
        if (_isEmpty_2) {
            _xifexpression_2 = "NULL";
        } else {
            String _plus;
            EList _peers_6 = pi.getPeers();
            InterfaceItemInstance _get_2 = (InterfaceItemInstance)_peers_6.get(0);
            EObject _eContainer = _get_2.eContainer();
            ETMapUtil.MappedThread _mappedThread = ETMapUtil.getMappedThread((AbstractInstance)((ActorInstance)_eContainer));
            PhysicalThread _thread = _mappedThread.getThread();
            String _name = _thread.getName();
            _xifexpression_2 = _plus = "&msgService_" + _name;
        }
        String msgSvc = _xifexpression_2;
        String _xifexpression_3 = null;
        GlobalGeneratorSettings _settings = Main.getSettings();
        boolean _generateMSCInstrumentation = _settings.generateMSCInstrumentation();
        if (_generateMSCInstrumentation) {
            String _plus_2;
            EObject _eContainer_1 = pi.eContainer();
            String _path = ((ActorInstance)_eContainer_1).getPath();
            String _plus_1 = ",\"" + _path;
            _xifexpression_3 = _plus_2 = String.valueOf(_plus_1) + "\",";
        } else {
            _xifexpression_3 = "";
        }
        String myInst = _xifexpression_3;
        String _xifexpression_4 = null;
        boolean _and = false;
        GlobalGeneratorSettings _settings_1 = Main.getSettings();
        boolean _generateMSCInstrumentation_1 = _settings_1.generateMSCInstrumentation();
        if (!_generateMSCInstrumentation_1) {
            _and = false;
        } else {
            EList _peers_7 = pi.getPeers();
            boolean _isEmpty_3 = _peers_7.isEmpty();
            boolean _not = !_isEmpty_3;
            boolean bl = _and = _generateMSCInstrumentation_1 && _not;
        }
        if (_and) {
            String _plus_4;
            EList _peers_8 = pi.getPeers();
            InterfaceItemInstance _get_3 = (InterfaceItemInstance)_peers_8.get(0);
            EObject _eContainer_2 = _get_3.eContainer();
            String _path_1 = ((ActorInstance)_eContainer_2).getPath();
            String _plus_3 = "\"" + _path_1;
            _xifexpression_4 = _plus_4 = String.valueOf(_plus_3) + "\"";
        } else {
            _xifexpression_4 = "";
        }
        String peerInst = _xifexpression_4;
        String _interfaceItemInstanceData = this.getInterfaceItemInstanceData(pi);
        String _plus_5 = "{" + _interfaceItemInstanceData;
        String _plus_6 = String.valueOf(_plus_5) + ", ";
        String _plus_7 = String.valueOf(_plus_6) + msgSvc;
        String _plus_8 = String.valueOf(_plus_7) + ", ";
        int _plus_9 = objId + idx;
        String _plus_10 = String.valueOf(_plus_8) + Integer.valueOf(_plus_9);
        String _plus_11 = String.valueOf(_plus_10) + "+BASE_ADDRESS, ";
        ExpandedActorClass _expandedActorClass = root.getExpandedActorClass(ai);
        InterfaceItem _interfaceItem = pi.getInterfaceItem();
        int _interfaceItemLocalId = _expandedActorClass.getInterfaceItemLocalId(_interfaceItem);
        int _plus_12 = _interfaceItemLocalId + 1;
        String _plus_13 = String.valueOf(_plus_11) + Integer.valueOf(_plus_12);
        String _plus_14 = String.valueOf(_plus_13) + myInst;
        String _plus_15 = String.valueOf(_plus_14) + peerInst;
        String _plus_16 = String.valueOf(_plus_15) + "} /* Port ";
        String _name_1 = pi.getName();
        String _plus_17 = String.valueOf(_plus_16) + _name_1;
        _xblockexpression = _plus_18 = String.valueOf(_plus_17) + " */";
        return _xblockexpression;
    }

    private CharSequence genSendPortInitializer(InterfaceItemInstance pi) {
        StringConcatenation _xblockexpression = null;
        Port _port = ((PortInstance)pi).getPort();
        GeneralProtocolClass _protocol = _port.getProtocol();
        ProtocolClass pc = (ProtocolClass)_protocol;
        List _allIncomingMessages = RoomHelpers.getAllIncomingMessages((ProtocolClass)pc);
        Functions.Function1<Message, Boolean> _function = new Functions.Function1<Message, Boolean>(){

            public Boolean apply(Message m) {
                VarDecl _data = m.getData();
                boolean _notEquals = !Objects.equal((Object)_data, null);
                return _notEquals;
            }
        };
        Iterable messages = IterableExtensions.filter((Iterable)_allIncomingMessages, (Functions.Function1)_function);
        Functions.Function1<Message, Boolean> _function_1 = new Functions.Function1<Message, Boolean>(){

            public Boolean apply(Message m) {
                VarDecl _data = m.getData();
                RefableType _refType = _data.getRefType();
                DataType _type = _refType.getType();
                boolean _isEnumeration = NodeGen.this._typeHelpers.isEnumeration(_type);
                return _isEnumeration;
            }
        };
        Iterable enumMsgs = IterableExtensions.filter((Iterable)messages, (Functions.Function1)_function_1);
        boolean _and = false;
        GlobalGeneratorSettings _settings = Main.getSettings();
        boolean _generateMSCInstrumentation = _settings.generateMSCInstrumentation();
        if (!_generateMSCInstrumentation) {
            _and = false;
        } else {
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)enumMsgs);
            boolean _not = !_isEmpty;
            _and = _generateMSCInstrumentation && _not;
        }
        boolean usesMSC = _and;
        EObject _eContainer = pi.eContainer();
        String instName = ((ActorInstance)_eContainer).getPath();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"{");
        _builder.newLine();
        EList _incomingMessages = pc.getIncomingMessages();
        boolean _hasElements = false;
        for (Message m : _incomingMessages) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "\t");
            }
            _builder.append((Object)"\t");
            VarDecl _data = m.getData();
            RefableType _refType = _data.getRefType();
            DataType _type = _refType.getType();
            String _defaultValue = this._cExtensions.defaultValue(_type);
            _builder.append((Object)_defaultValue, "\t");
            _builder.newLineIfNotEmpty();
        }
        if (usesMSC) {
            _builder.append((Object)"\t");
            _builder.append((Object)"#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)", \"");
            _builder.append((Object)instName, "\t\t");
            _builder.append((Object)"\",");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            String _path = pi.getPath();
            String _pathName = this._roomExtensions.getPathName(_path);
            _builder.append((Object)_pathName, "\t\t");
            _builder.append((Object)"_peers");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"#endif");
            _builder.newLine();
        }
        _builder.append((Object)"} /* send port ");
        String _name = pi.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)" */");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private String getInterfaceItemInstanceData(InterfaceItemInstance pi) {
        boolean _isConjugated_1;
        boolean _isConjugated;
        ProtocolClass _protocol = pi.getProtocol();
        PortClass _portClass = this._roomExtensions.getPortClass(_protocol, _isConjugated = this._roomExtensions.isConjugated(pi));
        boolean _equals = Objects.equal((Object)_portClass, null);
        if (_equals) {
            return "NULL";
        }
        ProtocolClass _protocol_1 = pi.getProtocol();
        PortClass _portClass_1 = this._roomExtensions.getPortClass(_protocol_1, _isConjugated_1 = this._roomExtensions.isConjugated(pi));
        EList _attributes = _portClass_1.getAttributes();
        boolean _isEmpty = _attributes.isEmpty();
        if (_isEmpty) {
            return "NULL";
        }
        String _path = pi.getPath();
        String _pathName = this._roomExtensions.getPathName(_path);
        String _plus = "&" + _pathName;
        return String.valueOf(_plus) + "_var";
    }

    private String genRecvPortInitializer(Root root, ActorInstance ai, InterfaceItemInstance pi) {
        String _plus_9;
        String _xblockexpression = null;
        InterfaceItem _interfaceItem = pi.getInterfaceItem();
        List _incoming = RoomHelpers.getIncoming((InterfaceItem)_interfaceItem);
        Functions.Function1<Message, Boolean> _function = new Functions.Function1<Message, Boolean>(){

            public Boolean apply(Message m) {
                VarDecl _data = m.getData();
                boolean _notEquals = !Objects.equal((Object)_data, null);
                return _notEquals;
            }
        };
        Iterable sentMsgs = IterableExtensions.filter((Iterable)_incoming, (Functions.Function1)_function);
        Functions.Function1<Message, Boolean> _function_1 = new Functions.Function1<Message, Boolean>(){

            public Boolean apply(Message m) {
                VarDecl _data = m.getData();
                RefableType _refType = _data.getRefType();
                DataType _type = _refType.getType();
                boolean _isEnumeration = NodeGen.this._typeHelpers.isEnumeration(_type);
                return _isEnumeration;
            }
        };
        Iterable enumMsgs = IterableExtensions.filter((Iterable)sentMsgs, (Functions.Function1)_function_1);
        boolean _and = false;
        GlobalGeneratorSettings _settings = Main.getSettings();
        boolean _generateMSCInstrumentation = _settings.generateMSCInstrumentation();
        if (!_generateMSCInstrumentation) {
            _and = false;
        } else {
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)enumMsgs);
            boolean _not = !_isEmpty;
            _and = _generateMSCInstrumentation && _not;
        }
        boolean usesMSC = _and;
        String _xifexpression = null;
        if (usesMSC) {
            String _plus_3;
            String _path = ai.getPath();
            String _plus = "\n#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE\n, \"" + _path;
            String _plus_1 = String.valueOf(_plus) + "\", ";
            Message _get = ((Message[])Conversions.unwrapArray((Object)enumMsgs, Message.class))[0];
            VarDecl _data = _get.getData();
            RefableType _refType = _data.getRefType();
            DataType _type = _refType.getType();
            String _defaultValue = this._cExtensions.defaultValue(_type);
            String _plus_2 = String.valueOf(_plus_1) + _defaultValue;
            _xifexpression = _plus_3 = String.valueOf(_plus_2) + "\n#endif\n";
        } else {
            _xifexpression = "";
        }
        String enumVal = _xifexpression;
        EList _peers = pi.getPeers();
        boolean _isEmpty_1 = _peers.isEmpty();
        if (_isEmpty_1) {
            String _plus_4 = "{NULL" + enumVal;
            return String.valueOf(_plus_4) + "}";
        }
        EList _peers_1 = pi.getPeers();
        InterfaceItemInstance peer = (InterfaceItemInstance)_peers_1.get(0);
        EList _peers_2 = pi.getPeers();
        InterfaceItemInstance _get_1 = (InterfaceItemInstance)_peers_2.get(0);
        EObject _eContainer = _get_1.eContainer();
        ActorInstance peerInst = (ActorInstance)_eContainer;
        String _path_1 = peerInst.getPath();
        String instName = this._roomExtensions.getPathName(_path_1);
        String _plus_5 = "{&" + instName;
        String _plus_6 = String.valueOf(_plus_5) + ".";
        String _name = peer.getName();
        String _plus_7 = String.valueOf(_plus_6) + _name;
        String _plus_8 = String.valueOf(_plus_7) + enumVal;
        _xblockexpression = _plus_9 = String.valueOf(_plus_8) + "}";
        return _xblockexpression;
    }

    private String genReplSubPortInitializers(Root root, ActorInstance ai, InterfaceItemInstance pi) {
        String result = "";
        String _xifexpression = null;
        GlobalGeneratorSettings _settings = Main.getSettings();
        boolean _generateMSCInstrumentation = _settings.generateMSCInstrumentation();
        if (_generateMSCInstrumentation) {
            String _plus_1;
            EObject _eContainer = pi.eContainer();
            String _path = ((ActorInstance)_eContainer).getPath();
            String _plus = "\n#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE\n,\"" + _path;
            _xifexpression = _plus_1 = String.valueOf(_plus) + "\",\n#endif\n";
        } else {
            _xifexpression = "";
        }
        String myInst = _xifexpression;
        EList _peers = pi.getPeers();
        for (InterfaceItemInstance p : _peers) {
            String _plus_27;
            EList _peers_1 = pi.getPeers();
            int idx = _peers_1.indexOf((Object)p);
            String _xifexpression_1 = null;
            EList _peers_2 = pi.getPeers();
            int _size = _peers_2.size();
            int _minus = _size - 1;
            boolean _lessThan = idx < _minus;
            _xifexpression_1 = _lessThan ? "," : "";
            String comma = _xifexpression_1;
            EObject _eContainer_1 = p.eContainer();
            ETMapUtil.MappedThread _mappedThread = ETMapUtil.getMappedThread((AbstractInstance)((ActorInstance)_eContainer_1));
            PhysicalThread _thread = _mappedThread.getThread();
            String thread = _thread.getName();
            String iiiD = this.getInterfaceItemInstanceData(pi);
            String _xifexpression_2 = null;
            GlobalGeneratorSettings _settings_1 = Main.getSettings();
            boolean _generateMSCInstrumentation_1 = _settings_1.generateMSCInstrumentation();
            if (_generateMSCInstrumentation_1) {
                String _plus_3;
                EObject _eContainer_2 = p.eContainer();
                String _path_1 = ((ActorInstance)_eContainer_2).getPath();
                String _plus_2 = "\"" + _path_1;
                _xifexpression_2 = _plus_3 = String.valueOf(_plus_2) + "\"";
            } else {
                _xifexpression_2 = "";
            }
            String peerInst = _xifexpression_2;
            String _xifexpression_3 = null;
            boolean _equals = iiiD.equals("NULL");
            if (_equals) {
                String _plus_4;
                _xifexpression_3 = _plus_4 = String.valueOf(iiiD) + ",";
            } else {
                String _plus_7;
                String _plus_5 = String.valueOf(iiiD) + "[";
                String _plus_6 = String.valueOf(_plus_5) + Integer.valueOf(idx);
                _xifexpression_3 = _plus_7 = String.valueOf(_plus_6) + "],";
            }
            iiiD = _xifexpression_3;
            String _plus_8 = String.valueOf(result) + "{{";
            String _plus_9 = String.valueOf(_plus_8) + iiiD;
            String _plus_10 = String.valueOf(_plus_9) + "&msgService_";
            String _plus_11 = String.valueOf(_plus_10) + thread;
            String _plus_12 = String.valueOf(_plus_11) + ", ";
            int _objId = p.getObjId();
            String _plus_13 = String.valueOf(_plus_12) + Integer.valueOf(_objId);
            String _plus_14 = String.valueOf(_plus_13) + "+BASE_ADDRESS, ";
            ExpandedActorClass _expandedActorClass = root.getExpandedActorClass(ai);
            InterfaceItem _interfaceItem = pi.getInterfaceItem();
            int _interfaceItemLocalId = _expandedActorClass.getInterfaceItemLocalId(_interfaceItem);
            int _plus_15 = _interfaceItemLocalId + 1;
            String _plus_16 = String.valueOf(_plus_14) + Integer.valueOf(_plus_15);
            String _plus_17 = String.valueOf(_plus_16) + myInst;
            String _plus_18 = String.valueOf(_plus_17) + peerInst;
            String _plus_19 = String.valueOf(_plus_18) + "},";
            String _plus_20 = String.valueOf(_plus_19) + Integer.valueOf(idx);
            String _plus_21 = String.valueOf(_plus_20) + "}";
            String _plus_22 = String.valueOf(_plus_21) + comma;
            String _plus_23 = String.valueOf(_plus_22) + " /* Repl Sub Port ";
            String _name = pi.getName();
            String _plus_24 = String.valueOf(_plus_23) + _name;
            String _plus_25 = String.valueOf(_plus_24) + " idx +";
            String _plus_26 = String.valueOf(_plus_25) + Integer.valueOf(idx);
            result = _plus_27 = String.valueOf(_plus_26) + "*/\n";
        }
        return result;
    }

    private CharSequence generateDispatcherFile(Root root, SubSystemInstance ssi, final HashSet<PhysicalThread> usedThreads) {
        StringConcatenation _xblockexpression = null;
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)ssi);
        ArrayList<PortInstance> loggedPorts = this.loggedPorts(ssi);
        SubSystemClass _subSystemClass = ssi.getSubSystemClass();
        EList _annotations = _subSystemClass.getAnnotations();
        boolean logData = BaseHelpers.isAnnotationPresent((List)_annotations, (String)"DataLogging");
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Dispatcher File of Node ");
        String _name = nr.getName();
        _builder.append((Object)_name, " ");
        _builder.append((Object)" with SubSystem ");
        String _name_1 = ssi.getName();
        _builder.append((Object)_name_1, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* contains a generated message dispatcher (receiveMessage) for each MessageService (Thread)");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"messaging/etMessageReceiver.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"debugging/etLogger.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"debugging/etMSCLogger.h\"");
        _builder.newLine();
        _builder.newLine();
        NodeClass _type = nr.getType();
        EList _threads = _type.getThreads();
        Functions.Function1<PhysicalThread, Boolean> _function = new Functions.Function1<PhysicalThread, Boolean>(){

            public Boolean apply(PhysicalThread t) {
                boolean _contains = usedThreads.contains(t);
                return _contains;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_threads, (Functions.Function1)_function);
        boolean _hasElements = false;
        for (final PhysicalThread thread : _filter) {
            boolean _not;
            boolean _greaterThan;
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)"\n", "");
            }
            EList _allContainedInstances = ssi.getAllContainedInstances();
            Functions.Function1<ActorInstance, Boolean> _function_1 = new Functions.Function1<ActorInstance, Boolean>(){

                public Boolean apply(ActorInstance ai) {
                    ETMapUtil.MappedThread _mappedThread = ETMapUtil.getMappedThread((AbstractInstance)ai);
                    PhysicalThread _thread = _mappedThread.getThread();
                    boolean _equals = Objects.equal((Object)_thread, (Object)thread);
                    return _equals;
                }
            };
            Iterable instancesOnThread = IterableExtensions.filter((Iterable)_allContainedInstances, (Functions.Function1)_function_1);
            _builder.newLineIfNotEmpty();
            Functions.Function1<ActorInstance, Boolean> _function_2 = new Functions.Function1<ActorInstance, Boolean>(){

                public Boolean apply(ActorInstance ai) {
                    boolean _or = false;
                    ActorClass _actorClass = ai.getActorClass();
                    ActorCommunicationType _commType = _actorClass.getCommType();
                    boolean _equals = Objects.equal((Object)_commType, (Object)ActorCommunicationType.EVENT_DRIVEN);
                    if (_equals) {
                        _or = true;
                    } else {
                        ActorClass _actorClass_1 = ai.getActorClass();
                        ActorCommunicationType _commType_1 = _actorClass_1.getCommType();
                        boolean _equals_1 = Objects.equal((Object)_commType_1, (Object)ActorCommunicationType.ASYNCHRONOUS);
                        _or = _equals || _equals_1;
                    }
                    return _or;
                }
            };
            Iterable dispatchedInstances = IterableExtensions.filter((Iterable)instancesOnThread, (Functions.Function1)_function_2);
            _builder.newLineIfNotEmpty();
            Functions.Function1<ActorInstance, Boolean> _function_3 = new Functions.Function1<ActorInstance, Boolean>(){

                public Boolean apply(ActorInstance ai) {
                    boolean _or = false;
                    ActorClass _actorClass = ai.getActorClass();
                    ActorCommunicationType _commType = _actorClass.getCommType();
                    boolean _equals = Objects.equal((Object)_commType, (Object)ActorCommunicationType.DATA_DRIVEN);
                    if (_equals) {
                        _or = true;
                    } else {
                        ActorClass _actorClass_1 = ai.getActorClass();
                        ActorCommunicationType _commType_1 = _actorClass_1.getCommType();
                        boolean _equals_1 = Objects.equal((Object)_commType_1, (Object)ActorCommunicationType.ASYNCHRONOUS);
                        _or = _equals || _equals_1;
                    }
                    return _or;
                }
            };
            Iterable executedInstances = IterableExtensions.filter((Iterable)instancesOnThread, (Functions.Function1)_function_3);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            int _size = IterableExtensions.size((Iterable)executedInstances);
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                _builder.append((Object)"/**");
                _builder.newLine();
                _builder.append((Object)" ");
                _builder.append((Object)"* generated execute function for all cyclic execute calls for the async or datadriven actor instances of thread \"");
                String _name_2 = thread.getName();
                _builder.append((Object)_name_2, " ");
                _builder.append((Object)"\"");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)" ");
                _builder.append((Object)"*/");
                _builder.newLine();
                _builder.append((Object)"static void MsgDispatcher_");
                String _name_3 = thread.getName();
                _builder.append((Object)_name_3, "");
                _builder.append((Object)"_poll(void){");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"MsgDispatcher_");
                String _name_4 = thread.getName();
                _builder.append((Object)_name_4, "\t");
                _builder.append((Object)"\", \"execute\")");
                _builder.newLineIfNotEmpty();
                for (ActorInstance ai : executedInstances) {
                    _builder.append((Object)"\t");
                    ActorClass _actorClass = ai.getActorClass();
                    String _name_5 = _actorClass.getName();
                    _builder.append((Object)_name_5, "\t");
                    _builder.append((Object)"_execute((void*)&");
                    String _path = ai.getPath();
                    String _pathName = this._roomExtensions.getPathName(_path);
                    _builder.append((Object)_pathName, "\t");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                if (logData) {
                    _builder.append((Object)"static void MsgDispatcher_");
                    String _name_6 = thread.getName();
                    _builder.append((Object)_name_6, "");
                    _builder.append((Object)"_logDataHeaders(void){");
                    _builder.newLineIfNotEmpty();
                    for (PortInstance pi : loggedPorts) {
                        _builder.append((Object)"\t");
                        _builder.append((Object)"ET_DATA_LOGGER_LOG_STRING(\"");
                        String _path_1 = pi.getPath();
                        _builder.append((Object)_path_1, "\t");
                        _builder.append((Object)"\")");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"\t");
                    _builder.append((Object)"ET_DATA_LOGGER_NEW_ROW");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    _builder.append((Object)"static void MsgDispatcher_");
                    String _name_7 = thread.getName();
                    _builder.append((Object)_name_7, "");
                    _builder.append((Object)"_logData(void){");
                    _builder.newLineIfNotEmpty();
                    for (PortInstance pi_1 : loggedPorts) {
                        _builder.append((Object)"\t");
                        String _createLoggerCall = this.createLoggerCall(pi_1);
                        _builder.append((Object)_createLoggerCall, "\t");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"\t");
                    _builder.append((Object)"ET_DATA_LOGGER_NEW_ROW");
                    _builder.newLine();
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
            }
            _builder.newLine();
            _builder.append((Object)"/**");
            _builder.newLine();
            _builder.append((Object)" ");
            _builder.append((Object)"* generated dispatch function for all messages for the thread \"");
            String _name_8 = thread.getName();
            _builder.append((Object)_name_8, " ");
            _builder.append((Object)"\"");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)" ");
            _builder.append((Object)"*/");
            _builder.newLine();
            _builder.append((Object)"static etBool MsgDispatcher_");
            String _name_9 = thread.getName();
            _builder.append((Object)_name_9, "");
            _builder.append((Object)"_receiveMessage(const etMessage* msg){");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"ET_MSC_LOGGER_SYNC_ENTRY(\"MsgDispatcher_");
            String _name_10 = thread.getName();
            _builder.append((Object)_name_10, "\t");
            _builder.append((Object)"\", \"receiveMessage\")");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"switch(msg->address){");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"case MESSAGESERVICE_ADDRESS:");
            _builder.newLine();
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)executedInstances);
            boolean bl2 = _not = !_isEmpty;
            if (_not) {
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"if (msg->evtID == etSystemProtocol_IN_poll) {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"MsgDispatcher_");
                String _name_11 = thread.getName();
                _builder.append((Object)_name_11, "\t\t\t\t");
                _builder.append((Object)"_poll();");
                _builder.newLineIfNotEmpty();
                if (logData) {
                    _builder.append((Object)"\t\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"MsgDispatcher_");
                    String _name_12 = thread.getName();
                    _builder.append((Object)_name_12, "\t\t\t\t");
                    _builder.append((Object)"_logData();");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"else");
                _builder.newLine();
            }
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"if (msg->evtID == etSystemProtocol_IN_terminate)");
            _builder.newLine();
            _builder.append((Object)"\t\t\t\t");
            _builder.append((Object)"return FALSE;");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"break;");
            _builder.newLine();
            for (ActorInstance ai_1 : dispatchedInstances) {
                _builder.append((Object)"\t\t");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"/* interface items of ");
                String _path_2 = ai_1.getPath();
                _builder.append((Object)_path_2, "\t\t");
                _builder.append((Object)" */");
                _builder.newLineIfNotEmpty();
                EList _orderedIfItemInstances = ai_1.getOrderedIfItemInstances();
                Functions.Function1<InterfaceItemInstance, Boolean> _function_4 = new Functions.Function1<InterfaceItemInstance, Boolean>(){

                    public Boolean apply(InterfaceItemInstance p) {
                        ProtocolClass _protocol = p.getProtocol();
                        CommunicationType _commType = _protocol.getCommType();
                        boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.EVENT_DRIVEN);
                        return _equals;
                    }
                };
                Iterable _filter_1 = IterableExtensions.filter((Iterable)_orderedIfItemInstances, (Functions.Function1)_function_4);
                for (InterfaceItemInstance pi_2 : _filter_1) {
                    boolean _isReplicated = pi_2.isReplicated();
                    if (_isReplicated) {
                        EList _peers = pi_2.getPeers();
                        for (InterfaceItemInstance peer : _peers) {
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"case ");
                            int _objId = pi_2.getObjId();
                            EList _peers_1 = pi_2.getPeers();
                            int _indexOf = _peers_1.indexOf((Object)peer);
                            int _plus = _objId + _indexOf;
                            _builder.append((Object)_plus, "\t\t");
                            _builder.append((Object)"+BASE_ADDRESS:");
                            _builder.newLineIfNotEmpty();
                            ProtocolClass _protocol = pi_2.getProtocol();
                            boolean _isConjugated = this._roomExtensions.isConjugated(pi_2);
                            boolean _handlesReceive = this._roomExtensions.handlesReceive(_protocol, _isConjugated);
                            if (_handlesReceive) {
                                _builder.append((Object)"\t\t");
                                _builder.append((Object)"\t");
                                _builder.append((Object)"switch (msg->evtID){");
                                _builder.newLine();
                                ProtocolClass _protocol_1 = pi_2.getProtocol();
                                boolean _isConjugated_1 = this._roomExtensions.isConjugated(pi_2);
                                List _receiveHandlers = this._roomExtensions.getReceiveHandlers(_protocol_1, _isConjugated_1);
                                for (MessageHandler h : _receiveHandlers) {
                                    _builder.append((Object)"\t\t");
                                    _builder.append((Object)"\t");
                                    _builder.append((Object)"\t");
                                    _builder.append((Object)"case ");
                                    ProtocolClass _protocol_2 = pi_2.getProtocol();
                                    String _name_13 = _protocol_2.getName();
                                    _builder.append((Object)_name_13, "\t\t\t\t");
                                    _builder.append((Object)"_");
                                    Message _msg = h.getMsg();
                                    String _codeName = this._roomExtensions.getCodeName(_msg);
                                    _builder.append((Object)_codeName, "\t\t\t\t");
                                    _builder.append((Object)":");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append((Object)"\t\t");
                                    _builder.append((Object)"\t");
                                    _builder.append((Object)"\t");
                                    _builder.append((Object)"\t");
                                    ProtocolClass _protocol_3 = pi_2.getProtocol();
                                    boolean _isConjugated_2 = this._roomExtensions.isConjugated(pi_2);
                                    String _portClassName = this._roomExtensions.getPortClassName(_protocol_3, _isConjugated_2);
                                    _builder.append((Object)_portClassName, "\t\t\t\t\t");
                                    _builder.append((Object)"_");
                                    Message _msg_1 = h.getMsg();
                                    String _name_14 = _msg_1.getName();
                                    _builder.append((Object)_name_14, "\t\t\t\t\t");
                                    _builder.append((Object)"_receiveHandler((etPort *)&");
                                    String _path_3 = ai_1.getPath();
                                    String _pathName_1 = this._roomExtensions.getPathName(_path_3);
                                    _builder.append((Object)_pathName_1, "\t\t\t\t\t");
                                    _builder.append((Object)"_const.");
                                    String _name_15 = pi_2.getName();
                                    _builder.append((Object)_name_15, "\t\t\t\t\t");
                                    _builder.append((Object)".ports[");
                                    EList _peers_2 = pi_2.getPeers();
                                    int _indexOf_1 = _peers_2.indexOf((Object)peer);
                                    _builder.append((Object)_indexOf_1, "\t\t\t\t\t");
                                    _builder.append((Object)"],msg,(void*)&");
                                    String _path_4 = ai_1.getPath();
                                    String _pathName_2 = this._roomExtensions.getPathName(_path_4);
                                    _builder.append((Object)_pathName_2, "\t\t\t\t\t");
                                    _builder.append((Object)",");
                                    ActorClass _actorClass_1 = ai_1.getActorClass();
                                    String _name_16 = _actorClass_1.getName();
                                    _builder.append((Object)_name_16, "\t\t\t\t\t");
                                    _builder.append((Object)"_receiveMessage);");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append((Object)"\t\t");
                                    _builder.append((Object)"\t");
                                    _builder.append((Object)"\t");
                                    _builder.append((Object)"break;");
                                    _builder.newLine();
                                }
                                _builder.append((Object)"\t\t");
                                _builder.append((Object)"\t");
                                _builder.append((Object)"\t");
                                _builder.append((Object)"default: ");
                                ActorClass _actorClass_2 = ai_1.getActorClass();
                                String _name_17 = _actorClass_2.getName();
                                _builder.append((Object)_name_17, "\t\t\t\t");
                                _builder.append((Object)"_receiveMessage((void*)&");
                                String _path_5 = ai_1.getPath();
                                String _pathName_3 = this._roomExtensions.getPathName(_path_5);
                                _builder.append((Object)_pathName_3, "\t\t\t\t");
                                _builder.append((Object)",(etPort*)&");
                                String _path_6 = ai_1.getPath();
                                String _pathName_4 = this._roomExtensions.getPathName(_path_6);
                                _builder.append((Object)_pathName_4, "\t\t\t\t");
                                _builder.append((Object)"_const.");
                                String _name_18 = pi_2.getName();
                                _builder.append((Object)_name_18, "\t\t\t\t");
                                _builder.append((Object)".ports[");
                                EList _peers_3 = pi_2.getPeers();
                                int _indexOf_2 = _peers_3.indexOf((Object)peer);
                                _builder.append((Object)_indexOf_2, "\t\t\t\t");
                                _builder.append((Object)"], msg);");
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"\t\t");
                                _builder.append((Object)"\t");
                                _builder.append((Object)"\t\t");
                                _builder.append((Object)"break;");
                                _builder.newLine();
                                _builder.append((Object)"\t\t");
                                _builder.append((Object)"\t");
                                _builder.append((Object)"\t");
                                _builder.append((Object)"}\t\t\t\t\t\t\t\t\t\t");
                                _builder.newLine();
                            } else {
                                GlobalGeneratorSettings _settings = Main.getSettings();
                                boolean _generateMSCInstrumentation = _settings.generateMSCInstrumentation();
                                if (_generateMSCInstrumentation) {
                                    _builder.append((Object)"\t\t");
                                    _builder.append((Object)"\t");
                                    _builder.append((Object)"ET_MSC_LOGGER_ASYNC_IN(");
                                    _builder.newLine();
                                    _builder.append((Object)"\t\t");
                                    _builder.append((Object)"\t");
                                    _builder.append((Object)"\t");
                                    String _path_7 = ai_1.getPath();
                                    String _pathName_5 = this._roomExtensions.getPathName(_path_7);
                                    _builder.append((Object)_pathName_5, "\t\t\t\t");
                                    _builder.append((Object)"_const.");
                                    String _name_19 = pi_2.getName();
                                    _builder.append((Object)_name_19, "\t\t\t\t");
                                    _builder.append((Object)".ports[");
                                    EList _peers_4 = pi_2.getPeers();
                                    int _indexOf_3 = _peers_4.indexOf((Object)peer);
                                    _builder.append((Object)_indexOf_3, "\t\t\t\t");
                                    _builder.append((Object)"].port.peerInstName,");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append((Object)"\t\t");
                                    _builder.append((Object)"\t");
                                    _builder.append((Object)"\t");
                                    ProtocolClass _protocol_4 = pi_2.getProtocol();
                                    String _name_20 = _protocol_4.getName();
                                    _builder.append((Object)_name_20, "\t\t\t\t");
                                    _builder.append((Object)"_getMessageString(msg->evtID),");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append((Object)"\t\t");
                                    _builder.append((Object)"\t");
                                    _builder.append((Object)"\t");
                                    String _path_8 = ai_1.getPath();
                                    String _pathName_6 = this._roomExtensions.getPathName(_path_8);
                                    _builder.append((Object)_pathName_6, "\t\t\t\t");
                                    _builder.append((Object)"_const.");
                                    String _name_21 = pi_2.getName();
                                    _builder.append((Object)_name_21, "\t\t\t\t");
                                    _builder.append((Object)".ports[");
                                    EList _peers_5 = pi_2.getPeers();
                                    int _indexOf_4 = _peers_5.indexOf((Object)peer);
                                    _builder.append((Object)_indexOf_4, "\t\t\t\t");
                                    _builder.append((Object)"].port.myInstName");
                                    _builder.newLineIfNotEmpty();
                                    _builder.append((Object)"\t\t");
                                    _builder.append((Object)"\t");
                                    _builder.append((Object)"\t");
                                    _builder.append((Object)")");
                                    _builder.newLine();
                                }
                                _builder.append((Object)"\t\t");
                                _builder.append((Object)"\t");
                                ActorClass _actorClass_3 = ai_1.getActorClass();
                                String _name_22 = _actorClass_3.getName();
                                _builder.append((Object)_name_22, "\t\t\t");
                                _builder.append((Object)"_receiveMessage((void*)&");
                                String _path_9 = ai_1.getPath();
                                String _pathName_7 = this._roomExtensions.getPathName(_path_9);
                                _builder.append((Object)_pathName_7, "\t\t\t");
                                _builder.append((Object)",&");
                                String _path_10 = ai_1.getPath();
                                String _pathName_8 = this._roomExtensions.getPathName(_path_10);
                                _builder.append((Object)_pathName_8, "\t\t\t");
                                _builder.append((Object)"_const.");
                                String _name_23 = pi_2.getName();
                                _builder.append((Object)_name_23, "\t\t\t");
                                _builder.append((Object)".ports[");
                                EList _peers_6 = pi_2.getPeers();
                                int _indexOf_5 = _peers_6.indexOf((Object)peer);
                                _builder.append((Object)_indexOf_5, "\t\t\t");
                                _builder.append((Object)"].port, msg);");
                                _builder.newLineIfNotEmpty();
                            }
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"break;");
                            _builder.newLine();
                        }
                        continue;
                    }
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"case ");
                    int _objId_1 = pi_2.getObjId();
                    _builder.append((Object)_objId_1, "\t\t");
                    _builder.append((Object)"+BASE_ADDRESS:");
                    _builder.newLineIfNotEmpty();
                    ProtocolClass _protocol_5 = pi_2.getProtocol();
                    boolean _isConjugated_3 = this._roomExtensions.isConjugated(pi_2);
                    boolean _handlesReceive_1 = this._roomExtensions.handlesReceive(_protocol_5, _isConjugated_3);
                    if (_handlesReceive_1) {
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"switch (msg->evtID){");
                        _builder.newLine();
                        ProtocolClass _protocol_6 = pi_2.getProtocol();
                        boolean _isConjugated_4 = this._roomExtensions.isConjugated(pi_2);
                        List _receiveHandlers_1 = this._roomExtensions.getReceiveHandlers(_protocol_6, _isConjugated_4);
                        for (MessageHandler h_1 : _receiveHandlers_1) {
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"case ");
                            ProtocolClass _protocol_7 = pi_2.getProtocol();
                            String _name_24 = _protocol_7.getName();
                            _builder.append((Object)_name_24, "\t\t\t\t");
                            _builder.append((Object)"_");
                            Message _msg_2 = h_1.getMsg();
                            String _codeName_1 = this._roomExtensions.getCodeName(_msg_2);
                            _builder.append((Object)_codeName_1, "\t\t\t\t");
                            _builder.append((Object)":");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"\t");
                            ProtocolClass _protocol_8 = pi_2.getProtocol();
                            boolean _isConjugated_5 = this._roomExtensions.isConjugated(pi_2);
                            String _portClassName_1 = this._roomExtensions.getPortClassName(_protocol_8, _isConjugated_5);
                            _builder.append((Object)_portClassName_1, "\t\t\t\t\t");
                            _builder.append((Object)"_");
                            Message _msg_3 = h_1.getMsg();
                            String _name_25 = _msg_3.getName();
                            _builder.append((Object)_name_25, "\t\t\t\t\t");
                            _builder.append((Object)"_receiveHandler((etPort *)&");
                            String _path_11 = ai_1.getPath();
                            String _pathName_9 = this._roomExtensions.getPathName(_path_11);
                            _builder.append((Object)_pathName_9, "\t\t\t\t\t");
                            _builder.append((Object)"_const.");
                            String _name_26 = pi_2.getName();
                            _builder.append((Object)_name_26, "\t\t\t\t\t");
                            _builder.append((Object)",msg,(void*)&");
                            String _path_12 = ai_1.getPath();
                            String _pathName_10 = this._roomExtensions.getPathName(_path_12);
                            _builder.append((Object)_pathName_10, "\t\t\t\t\t");
                            _builder.append((Object)",");
                            ActorClass _actorClass_4 = ai_1.getActorClass();
                            String _name_27 = _actorClass_4.getName();
                            _builder.append((Object)_name_27, "\t\t\t\t\t");
                            _builder.append((Object)"_receiveMessage);");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"break;");
                            _builder.newLine();
                        }
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"default: ");
                        ActorClass _actorClass_5 = ai_1.getActorClass();
                        String _name_28 = _actorClass_5.getName();
                        _builder.append((Object)_name_28, "\t\t\t\t");
                        _builder.append((Object)"_receiveMessage((void*)&");
                        String _path_13 = ai_1.getPath();
                        String _pathName_11 = this._roomExtensions.getPathName(_path_13);
                        _builder.append((Object)_pathName_11, "\t\t\t\t");
                        _builder.append((Object)",(etPort*)&");
                        String _path_14 = ai_1.getPath();
                        String _pathName_12 = this._roomExtensions.getPathName(_path_14);
                        _builder.append((Object)_pathName_12, "\t\t\t\t");
                        _builder.append((Object)"_const.");
                        String _name_29 = pi_2.getName();
                        _builder.append((Object)_name_29, "\t\t\t\t");
                        _builder.append((Object)", msg);");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"break;");
                        _builder.newLine();
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        _builder.append((Object)"}");
                        _builder.newLine();
                    } else {
                        GlobalGeneratorSettings _settings_1 = Main.getSettings();
                        boolean _generateMSCInstrumentation_1 = _settings_1.generateMSCInstrumentation();
                        if (_generateMSCInstrumentation_1) {
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"ET_MSC_LOGGER_ASYNC_IN(");
                            _builder.newLine();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"((etPort*)&");
                            String _path_15 = ai_1.getPath();
                            String _pathName_13 = this._roomExtensions.getPathName(_path_15);
                            _builder.append((Object)_pathName_13, "\t\t\t\t");
                            _builder.append((Object)"_const.");
                            String _name_30 = pi_2.getName();
                            _builder.append((Object)_name_30, "\t\t\t\t");
                            _builder.append((Object)")->peerInstName,");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"\t");
                            ProtocolClass _protocol_9 = pi_2.getProtocol();
                            String _name_31 = _protocol_9.getName();
                            _builder.append((Object)_name_31, "\t\t\t\t");
                            _builder.append((Object)"_getMessageString(msg->evtID),");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"((etPort*)&");
                            String _path_16 = ai_1.getPath();
                            String _pathName_14 = this._roomExtensions.getPathName(_path_16);
                            _builder.append((Object)_pathName_14, "\t\t\t\t");
                            _builder.append((Object)"_const.");
                            String _name_32 = pi_2.getName();
                            _builder.append((Object)_name_32, "\t\t\t\t");
                            _builder.append((Object)")->myInstName");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)"\t");
                            _builder.append((Object)")");
                            _builder.newLine();
                        }
                        _builder.append((Object)"\t\t");
                        _builder.append((Object)"\t");
                        ActorClass _actorClass_6 = ai_1.getActorClass();
                        String _name_33 = _actorClass_6.getName();
                        _builder.append((Object)_name_33, "\t\t\t");
                        _builder.append((Object)"_receiveMessage((void*)&");
                        String _path_17 = ai_1.getPath();
                        String _pathName_15 = this._roomExtensions.getPathName(_path_17);
                        _builder.append((Object)_pathName_15, "\t\t\t");
                        _builder.append((Object)",(etPort*)&");
                        String _path_18 = ai_1.getPath();
                        String _pathName_16 = this._roomExtensions.getPathName(_path_18);
                        _builder.append((Object)_pathName_16, "\t\t\t");
                        _builder.append((Object)"_const.");
                        String _name_34 = pi_2.getName();
                        _builder.append((Object)_name_34, "\t\t\t");
                        _builder.append((Object)", msg);");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"break;");
                    _builder.newLine();
                }
            }
            _builder.append((Object)"\t\t");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"default:");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"etLogger_logErrorF(\"MessageService_");
            String _name_35 = thread.getName();
            _builder.append((Object)_name_35, "\t\t\t");
            _builder.append((Object)"_receiveMessage: address %d does not exist \", msg->address);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"break;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"ET_MSC_LOGGER_SYNC_EXIT");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"return TRUE;");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private String createLoggerCall(PortInstance pi) {
        String _xblockexpression = null;
        ProtocolClass _protocol = pi.getProtocol();
        EList _incomingMessages = _protocol.getIncomingMessages();
        Functions.Function1<Message, Boolean> _function = new Functions.Function1<Message, Boolean>(){

            public Boolean apply(Message m) {
                boolean _notEquals;
                boolean _and = false;
                VarDecl _data = m.getData();
                boolean bl = _notEquals = !Objects.equal((Object)_data, null);
                if (!_notEquals) {
                    _and = false;
                } else {
                    VarDecl _data_1 = m.getData();
                    RefableType _refType = _data_1.getRefType();
                    DataType _type = _refType.getType();
                    boolean _isEnumerationOrPrimitive = NodeGen.this._typeHelpers.isEnumerationOrPrimitive(_type);
                    _and = _notEquals && _isEnumerationOrPrimitive;
                }
                return _and;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_incomingMessages, (Functions.Function1)_function);
        Message msg = ((Message[])Conversions.unwrapArray((Object)_filter, Message.class))[0];
        EObject _eContainer = pi.eContainer();
        ActorInstance ai = (ActorInstance)_eContainer;
        String _path = ai.getPath();
        String _pathName = this._roomExtensions.getPathName(_path);
        String _plus = String.valueOf(_pathName) + ".";
        String _name = pi.getName();
        String _plus_1 = String.valueOf(_plus) + _name;
        String _plus_2 = String.valueOf(_plus_1) + ".";
        String _name_1 = msg.getName();
        String data = String.valueOf(_plus_2) + _name_1;
        LiteralType _xifexpression = null;
        VarDecl _data = msg.getData();
        RefableType _refType = _data.getRefType();
        DataType _type = _refType.getType();
        if (_type instanceof EnumerationType) {
            _xifexpression = LiteralType.INT;
        } else {
            LiteralType _type_2;
            VarDecl _data_1 = msg.getData();
            RefableType _refType_1 = _data_1.getRefType();
            DataType _type_1 = _refType_1.getType();
            _xifexpression = _type_2 = ((PrimitiveType)_type_1).getType();
        }
        LiteralType type = _xifexpression;
        String _switchResult = null;
        boolean _matched = false;
        if (!_matched && Objects.equal((Object)type, (Object)LiteralType.BOOL)) {
            String _plus_4;
            _matched = true;
            String _plus_3 = "ET_DATA_LOGGER_LOG_BOOL((int)" + data;
            _switchResult = _plus_4 = String.valueOf(_plus_3) + ")";
        }
        if (!_matched && Objects.equal((Object)type, (Object)LiteralType.CHAR)) {
            String _plus_6;
            _matched = true;
            String _plus_5 = "ET_DATA_LOGGER_LOG_INT((int)" + data;
            _switchResult = _plus_6 = String.valueOf(_plus_5) + ")";
        }
        if (!_matched && Objects.equal((Object)type, (Object)LiteralType.INT)) {
            String _plus_8;
            _matched = true;
            String _plus_7 = "ET_DATA_LOGGER_LOG_INT((int)" + data;
            _switchResult = _plus_8 = String.valueOf(_plus_7) + ")";
        }
        if (!_matched && Objects.equal((Object)type, (Object)LiteralType.REAL)) {
            String _plus_10;
            _matched = true;
            String _plus_9 = "ET_DATA_LOGGER_LOG_DOUBLE((double)" + data;
            _switchResult = _plus_10 = String.valueOf(_plus_9) + ")";
        }
        if (!_matched) {
            _switchResult = "internal error: unknown primitive type";
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    private ArrayList<PortInstance> loggedPorts(SubSystemInstance ssi) {
        ArrayList result = CollectionLiterals.newArrayList((Object[])new PortInstance[0]);
        SubSystemClass _subSystemClass = ssi.getSubSystemClass();
        EList _annotations = _subSystemClass.getAnnotations();
        boolean _isAnnotationPresent = BaseHelpers.isAnnotationPresent((List)_annotations, (String)"DataLogging");
        if (_isAnnotationPresent) {
            boolean _hasNext;
            String[] filterList;
            this.logger.logInfo("Data Logging is configured by annotation");
            SubSystemClass _subSystemClass_1 = ssi.getSubSystemClass();
            EList _annotations_1 = _subSystemClass_1.getAnnotations();
            String filters = BaseHelpers.getAttribute((List)_annotations_1, (String)"DataLogging", (String)"pathlist");
            String[] stringArray = filterList = filters.split(",");
            int n = filterList.length;
            int n2 = 0;
            while (n2 < n) {
                String filter = stringArray[n2];
                String _plus = "  filter: " + filter;
                this.logger.logInfo(_plus);
                ++n2;
            }
            ArrayList notLogged = CollectionLiterals.newArrayList((Object[])new String[0]);
            this.logger.logInfo("  logged ports:");
            TreeIterator iter = ssi.eAllContents();
            boolean _while = _hasNext = iter.hasNext();
            while (_while) {
                boolean _hasNext_1;
                EObject obj = (EObject)iter.next();
                if (obj instanceof PortInstance) {
                    ProtocolClass _protocol;
                    CommunicationType _commType;
                    boolean _equals;
                    boolean _not;
                    PortInstance pi = (PortInstance)obj;
                    Port _port = pi.getPort();
                    boolean _isRelay = RoomHelpers.isRelay((Port)_port);
                    boolean bl = _not = !_isRelay;
                    if (_not && (_equals = Objects.equal((Object)(_commType = (_protocol = pi.getProtocol()).getCommType()), (Object)CommunicationType.DATA_DRIVEN))) {
                        Port _port_1 = pi.getPort();
                        boolean _isConjugated = _port_1.isConjugated();
                        if (_isConjugated) {
                            boolean _not_2;
                            String path = pi.getPath();
                            boolean matched = false;
                            boolean primitive = false;
                            String[] stringArray2 = filterList;
                            int n3 = filterList.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                String filter_1 = stringArray2[n4];
                                boolean _matches = path.matches(filter_1);
                                if (_matches) {
                                    boolean _not_1;
                                    Functions.Function1<Message, Boolean> _function;
                                    matched = true;
                                    ProtocolClass _protocol_1 = pi.getProtocol();
                                    EList _incomingMessages = _protocol_1.getIncomingMessages();
                                    Iterable _filter = IterableExtensions.filter((Iterable)_incomingMessages, (Functions.Function1)(_function = new Functions.Function1<Message, Boolean>(){

                                        public Boolean apply(Message m) {
                                            boolean _notEquals;
                                            boolean _and = false;
                                            VarDecl _data = m.getData();
                                            boolean bl = _notEquals = !Objects.equal((Object)_data, null);
                                            if (!_notEquals) {
                                                _and = false;
                                            } else {
                                                VarDecl _data_1 = m.getData();
                                                RefableType _refType = _data_1.getRefType();
                                                DataType _type = _refType.getType();
                                                boolean _isEnumerationOrPrimitive = NodeGen.this._typeHelpers.isEnumerationOrPrimitive(_type);
                                                _and = _notEquals && _isEnumerationOrPrimitive;
                                            }
                                            return _and;
                                        }
                                    }));
                                    boolean _isEmpty = IterableExtensions.isEmpty((Iterable)_filter);
                                    boolean bl2 = _not_1 = !_isEmpty;
                                    if (_not_1) {
                                        result.add(pi);
                                        primitive = true;
                                        String _path = pi.getPath();
                                        String _plus_1 = "    data driven port " + _path;
                                        String _plus_2 = String.valueOf(_plus_1) + " (matched ";
                                        String _plus_3 = String.valueOf(_plus_2) + filter_1;
                                        String _plus_4 = String.valueOf(_plus_3) + ")";
                                        this.logger.logInfo(_plus_4);
                                    }
                                }
                                ++n4;
                            }
                            boolean bl3 = _not_2 = !primitive;
                            if (_not_2) {
                                if (matched) {
                                    String _path_1 = pi.getPath();
                                    String _plus_5 = "    data driven port " + _path_1;
                                    String _plus_6 = String.valueOf(_plus_5) + " (matched but contains no primitive data)";
                                    notLogged.add(_plus_6);
                                } else {
                                    String _path_2 = pi.getPath();
                                    String _plus_7 = "    data driven port " + _path_2;
                                    String _plus_8 = String.valueOf(_plus_7) + " (no match found)";
                                    notLogged.add(_plus_8);
                                }
                            }
                        } else {
                            String _path_3 = pi.getPath();
                            String _plus_9 = "    data driven port " + _path_3;
                            String _plus_10 = String.valueOf(_plus_9) + " (receive port)";
                            notLogged.add(_plus_10);
                        }
                    }
                }
                _while = _hasNext_1 = iter.hasNext();
            }
            this.logger.logInfo("  NOT logged ports:");
            for (String nl : notLogged) {
                this.logger.logInfo(nl);
            }
        }
        return result;
    }

    private void checkDataPorts(SubSystemInstance comp) {
        HashSet<String> _hashSet;
        HashSet<String> found = _hashSet = new HashSet<String>();
        EList _allContainedInstances = comp.getAllContainedInstances();
        for (ActorInstance ai : _allContainedInstances) {
            int thread = ai.getThreadId();
            EList _orderedIfItemInstances = ai.getOrderedIfItemInstances();
            for (InterfaceItemInstance pi : _orderedIfItemInstances) {
                ProtocolClass _protocol = pi.getProtocol();
                CommunicationType _commType = _protocol.getCommType();
                boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.DATA_DRIVEN);
                if (!_equals) continue;
                EList _peers = pi.getPeers();
                for (InterfaceItemInstance peer : _peers) {
                    boolean _not;
                    boolean _lessThan;
                    boolean _notEquals;
                    EObject _eContainer = peer.eContainer();
                    ActorInstance peer_ai = (ActorInstance)_eContainer;
                    int peer_thread = peer_ai.getThreadId();
                    boolean bl = _notEquals = thread != peer_thread;
                    if (!_notEquals) continue;
                    String path = pi.getPath();
                    String ppath = peer.getPath();
                    String _xifexpression = null;
                    int _compareTo = path.compareTo(ppath);
                    boolean bl2 = _lessThan = _compareTo < 0;
                    if (_lessThan) {
                        String _plus_1;
                        String _plus = String.valueOf(path) + " and ";
                        _xifexpression = _plus_1 = String.valueOf(_plus) + ppath;
                    } else {
                        String _plus_3;
                        String _plus_2 = String.valueOf(ppath) + " and ";
                        _xifexpression = _plus_3 = String.valueOf(_plus_2) + path;
                    }
                    String pair = _xifexpression;
                    boolean _contains = found.contains(pair);
                    boolean bl3 = _not = !_contains;
                    if (!_not) continue;
                    found.add(pair);
                    String _plus_4 = String.valueOf(pair) + ": data ports placed on different threads (not supported yet)";
                    InterfaceItem _interfaceItem = pi.getInterfaceItem();
                    InterfaceItem _interfaceItem_1 = pi.getInterfaceItem();
                    EStructuralFeature _eContainingFeature = _interfaceItem_1.eContainingFeature();
                    this.diagnostician.error(_plus_4, (EObject)_interfaceItem, _eContainingFeature);
                }
            }
        }
    }
}

