/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.config.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.etrice.core.config.ActorClassConfig;
import org.eclipse.etrice.core.config.ActorInstanceConfig;
import org.eclipse.etrice.core.config.AttrClassConfig;
import org.eclipse.etrice.core.config.AttrInstanceConfig;
import org.eclipse.etrice.core.config.ConfigModel;
import org.eclipse.etrice.core.config.ProtocolClassConfig;
import org.eclipse.etrice.core.config.RefPath;
import org.eclipse.etrice.core.config.SubSystemConfig;
import org.eclipse.etrice.core.config.util.ConfigUtil;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.ProtocolClass;

public class DataConfigurationHelper {
    public static Map<String, AttrClassConfig> actorClassAttrMap = new HashMap<String, AttrClassConfig>();
    public static Map<String, AttrClassConfig> protocolClassAttrMap = new HashMap<String, AttrClassConfig>();
    public static Map<String, AttrInstanceConfig> actorInstanceAttrMap = new HashMap<String, AttrInstanceConfig>();
    public static Map<String, SubSystemConfig> subSystemConfigMap = new HashMap<String, SubSystemConfig>();
    public static Map<String, List<AttrInstanceConfig>> dynActorInstanceAttrMap = new HashMap<String, List<AttrInstanceConfig>>();
    public static Map<ActorClass, List<AttrInstanceConfig>> dynActorClassAttrMap = new HashMap<ActorClass, List<AttrInstanceConfig>>();

    public static boolean setConfigModels(ResourceSet rs, ILogger logger) {
        actorClassAttrMap.clear();
        protocolClassAttrMap.clear();
        actorInstanceAttrMap.clear();
        subSystemConfigMap.clear();
        dynActorInstanceAttrMap.clear();
        dynActorClassAttrMap.clear();
        boolean error = false;
        ArrayList<ConfigModel> configs = new ArrayList<ConfigModel>();
        for (Resource res : rs.getResources()) {
            EObject object = (EObject)res.getContents().get(0);
            if (!(object instanceof ConfigModel)) continue;
            configs.add((ConfigModel)object);
        }
        if (!configs.isEmpty()) {
            logger.logInfo("-- loading configurations");
        }
        HashSet<ActorClass> actorClasses = new HashSet<ActorClass>();
        HashSet<ProtocolClass> protocolClasses = new HashSet<ProtocolClass>();
        HashSet<String> actorInstances = new HashSet<String>();
        for (ConfigModel config : configs) {
            String path;
            for (ActorClassConfig classConfig : config.getActorClassConfigs()) {
                if (actorClasses.contains(classConfig.getActor())) {
                    logger.logError("Multiple configurations for actor class " + classConfig.getActor().getName() + " found", null);
                    error = true;
                    continue;
                }
                actorClasses.add(classConfig.getActor());
                DataConfigurationHelper.collectConfigs(classConfig, actorClassAttrMap);
            }
            for (ProtocolClassConfig protocolConfig : config.getProtocolClassConfigs()) {
                if (protocolClasses.contains(protocolConfig.getProtocol())) {
                    logger.logError("Multiple configurations for protocol class " + protocolConfig.getProtocol().getName() + " found", null);
                    error = true;
                    continue;
                }
                protocolClasses.add(protocolConfig.getProtocol());
                DataConfigurationHelper.collectConfigs(protocolConfig, protocolClassAttrMap);
            }
            for (ActorInstanceConfig instanceConfig : config.getActorInstanceConfigs()) {
                path = ConfigUtil.getPath((ActorInstanceConfig)instanceConfig);
                if (actorInstances.contains(path)) {
                    logger.logError("Multiple configurations for actor instance " + path + " found", null);
                    continue;
                }
                actorInstances.add(path);
                DataConfigurationHelper.collectConfigs(instanceConfig, path, actorInstanceAttrMap);
            }
            for (SubSystemConfig ssConfig : config.getSubSystemConfigs()) {
                path = ConfigUtil.getPath((SubSystemConfig)ssConfig);
                if (subSystemConfigMap.containsKey(path)) {
                    logger.logError("Multiple configurations for subSystem" + path + " found", null);
                    error = true;
                    continue;
                }
                subSystemConfigMap.put(path, ssConfig);
            }
        }
        return !error;
    }

    private static void collectConfigs(ActorInstanceConfig actorConfig, String path, Map<String, AttrInstanceConfig> map) {
        for (AttrInstanceConfig c : actorConfig.getAttributes()) {
            DataConfigurationHelper.collectConfigs(c, String.valueOf(path) + "/" + c.getAttribute().getName(), map);
            if (!c.isDynConfig()) continue;
            List<AttrInstanceConfig> list = dynActorInstanceAttrMap.get(path);
            if (list == null) {
                list = new ArrayList<AttrInstanceConfig>();
            }
            list.add(c);
            dynActorInstanceAttrMap.put(path, list);
            ActorClass ac = ConfigUtil.getLastActorRef((ActorContainerClass)actorConfig.getSubSystem().getType(), (RefPath)actorConfig.getPath()).getType();
            list = dynActorClassAttrMap.get(ac);
            if (list == null) {
                list = new ArrayList<AttrInstanceConfig>();
            }
            list.add(c);
            dynActorClassAttrMap.put(ac, list);
        }
        for (AttrInstanceConfig c : actorConfig.getPorts()) {
            for (AttrInstanceConfig a : c.getAttributes()) {
                DataConfigurationHelper.collectConfigs(a, String.valueOf(path) + "/" + c.getItem().getName() + "/" + a.getAttribute().getName(), map);
            }
        }
    }

    private static void collectConfigs(ProtocolClassConfig protocolConfig, Map<String, AttrClassConfig> map) {
        String path = "/" + protocolConfig.getProtocol().getName();
        if (protocolConfig.getRegular() != null) {
            for (AttrClassConfig c : protocolConfig.getRegular().getAttributes()) {
                DataConfigurationHelper.collectConfigs(c, String.valueOf(path) + "/regular/" + c.getAttribute().getName(), map);
            }
        }
        if (protocolConfig.getConjugated() != null) {
            for (AttrClassConfig c : protocolConfig.getConjugated().getAttributes()) {
                DataConfigurationHelper.collectConfigs(c, String.valueOf(path) + "/conjugated/" + c.getAttribute().getName(), map);
            }
        }
    }

    private static void collectConfigs(ActorClassConfig actorConfig, Map<String, AttrClassConfig> map) {
        String path = "/" + actorConfig.getActor().getName();
        for (AttrClassConfig c : actorConfig.getAttributes()) {
            DataConfigurationHelper.collectConfigs(c, String.valueOf(path) + "/" + c.getAttribute().getName(), map);
        }
    }

    private static void collectConfigs(AttrClassConfig config, String path, Map<String, AttrClassConfig> map) {
        Attribute a = config.getAttribute();
        if (a.getType().getType() instanceof DataClass) {
            for (AttrClassConfig c : config.getAttributes()) {
                DataConfigurationHelper.collectConfigs(c, String.valueOf(path) + "/" + c.getAttribute().getName(), map);
            }
        }
        map.put(path, config);
    }

    private static void collectConfigs(AttrInstanceConfig config, String path, Map<String, AttrInstanceConfig> map) {
        Attribute a = config.getAttribute();
        if (a.getType().getType() instanceof DataClass) {
            for (AttrInstanceConfig c : config.getAttributes()) {
                DataConfigurationHelper.collectConfigs(c, String.valueOf(path) + "/" + c.getAttribute().getName(), map);
            }
        }
        map.put(path, config);
    }

    public static String toStringPath(Iterable<String> path, String pathDelim) {
        StringBuilder b = new StringBuilder();
        for (String p : path) {
            b.append(String.valueOf(pathDelim) + p);
        }
        return b.toString();
    }
}

