/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp;

import com.google.inject.Inject;
import com.google.inject.Module;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.etrice.core.etmap.eTMap.Import;
import org.eclipse.etrice.core.etmap.eTMap.MappingModel;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.PhysicalModel;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.IDiagnostician;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.generator.base.AbstractGenerator;
import org.eclipse.etrice.generator.base.IDataConfiguration;
import org.eclipse.etrice.generator.base.IResourceURIAcceptor;
import org.eclipse.etrice.generator.cpp.gen.GeneratorSettings;
import org.eclipse.etrice.generator.cpp.gen.Validator;
import org.eclipse.etrice.generator.cpp.setup.GeneratorModule;
import org.eclipse.etrice.generator.doc.gen.MainGen;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.scoping.impl.ImportUriResolver;

public class Main
extends AbstractGenerator {
    public static final String OPTION_ETUNIT = "-etunit";
    @Inject
    private IGenerator mainGenerator;
    @Inject
    protected MainGen mainDocGenerator;
    @Inject
    private Validator validator;
    @Inject
    protected IDataConfiguration dataConfig;
    @Inject
    protected ImportUriResolver uriResolver;

    protected void printUsage() {
        output.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + this.getCommonOptions() + " <list of model file paths>");
        output.println(this.getCommonOptionDescriptions());
    }

    public static void main(String[] args) {
        int ret = Main.createAndRunGenerator((Module)new GeneratorModule(), (String[])args);
        if (Main.isTerminateOnError() && ret != 0) {
            System.exit(ret);
        }
    }

    public static GeneratorSettings getSettings() {
        return (GeneratorSettings)Main.getInstance().getGeneratorSettings();
    }

    protected boolean parseOption(String arg, Iterator<String> it) {
        if (arg.equals(OPTION_ETUNIT)) {
            Main.getSettings().setUseEtUnit(true);
            return true;
        }
        return super.parseOption(arg, it);
    }

    protected int runGenerator() {
        this.setupRoomModel();
        this.dataConfig.doSetup();
        if (!this.loadModels(Main.getSettings().getInputModelURIs())) {
            this.logger.logInfo("loading of models failed");
            this.logger.logError("-- terminating", null);
            return 1;
        }
        if (!this.validateModels()) {
            this.logger.logInfo("validation failed");
            this.logger.logError("-- terminating", null);
            return 1;
        }
        if (!this.dataConfig.setResources(this.getResourceSet(), (ILogger)this.logger)) {
            this.logger.logInfo("configuration errors");
            this.logger.logError("-- terminating", null);
            return 1;
        }
        Root genModel = this.createGeneratorModel(Main.getSettings().isGenerateAsLibrary(), Main.getSettings().getGeneratorModelPath());
        if (this.diagnostician.isFailed() || genModel == null) {
            this.logger.logInfo("errors during build of generator model");
            this.logger.logError("-- terminating", null);
            return 1;
        }
        if (!this.validator.validate(genModel)) {
            this.logger.logInfo("validation failed during build of generator model");
            this.logger.logError("-- terminating", null);
            return 1;
        }
        ETMapUtil.processModels((Root)genModel, (ResourceSet)this.getResourceSet(), (IDiagnostician)this.diagnostician);
        if (Main.getSettings().isDebugMode()) {
            this.logger.logInfo("-- begin dump of mappings");
            this.logger.logInfo(ETMapUtil.dumpMappings());
            this.logger.logInfo("-- end dump of mappings");
        }
        if (this.diagnostician.isFailed() || genModel == null) {
            this.logger.logInfo("errors in mapping");
            this.logger.logError("-- terminating", null);
            return 1;
        }
        this.logger.logInfo("-- starting code generation");
        this.fileAccess.setOutputPath("src-gen/");
        this.mainGenerator.doGenerate(genModel.eResource(), (IFileSystemAccess)this.fileAccess);
        if (Main.getSettings().isGenerateDocumentation()) {
            this.mainDocGenerator.doGenerate(genModel);
        }
        if (this.diagnostician.isFailed()) {
            this.logger.logInfo("errors during code generation");
            this.logger.logError("-- terminating", null);
            return 1;
        }
        this.logger.logInfo("-- finished code generation");
        return 0;
    }

    protected void addReferencedModels(EObject root, IResourceURIAcceptor acceptor) {
        super.addReferencedModels(root, acceptor);
        if (root instanceof PhysicalModel) {
            for (org.eclipse.etrice.core.etphys.eTPhys.Import imp : ((PhysicalModel)root).getImports()) {
                String importURI = this.uriResolver.resolve((EObject)imp);
                acceptor.addResourceURI(importURI);
            }
        } else if (root instanceof MappingModel) {
            for (Import imp : ((MappingModel)root).getImports()) {
                String importURI = this.uriResolver.resolve((EObject)imp);
                acceptor.addResourceURI(importURI);
            }
        } else {
            this.dataConfig.addReferencedModels(acceptor, root);
        }
    }
}

