/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefableType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.VarDecl;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.cpp.Main;
import org.eclipse.etrice.generator.cpp.gen.CppExtensions;
import org.eclipse.etrice.generator.cpp.gen.GeneratorSettings;
import org.eclipse.etrice.generator.cpp.gen.Initialization;
import org.eclipse.etrice.generator.generic.GenericProtocolClassGenerator;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
public class ProtocolClassGen
extends GenericProtocolClassGenerator {
    @Inject
    @Extension
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    @Extension
    private CppExtensions stdExt;
    @Inject
    @Extension
    private RoomExtensions roomExt;
    @Inject
    @Extension
    private ProcedureHelpers helpers;
    @Inject
    @Extension
    private TypeHelpers _typeHelpers;
    @Inject
    @Extension
    private Initialization _initialization;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        EList _usedProtocolClasses = root.getUsedProtocolClasses();
        for (ProtocolClass pc : _usedProtocolClasses) {
            String _generationTargetPath = this.roomExt.getGenerationTargetPath((EObject)pc);
            String _path = this.roomExt.getPath((RoomClass)pc);
            String path = String.valueOf(_generationTargetPath) + _path;
            String _cppHeaderFileName = this.stdExt.getCppHeaderFileName((RoomClass)pc);
            String _plus = "generating ProtocolClass header '" + _cppHeaderFileName;
            String _plus_1 = String.valueOf(_plus) + "' in '";
            String _plus_2 = String.valueOf(_plus_1) + path;
            String _plus_3 = String.valueOf(_plus_2) + "'";
            this.logger.logInfo(_plus_3);
            this.fileAccess.setOutputPath(path);
            String _cppHeaderFileName_1 = this.stdExt.getCppHeaderFileName((RoomClass)pc);
            CharSequence _generateHeaderFile = this.generateHeaderFile(root, pc);
            this.fileAccess.generateFile(_cppHeaderFileName_1, _generateHeaderFile);
            String _cppSourceFileName = this.stdExt.getCppSourceFileName((RoomClass)pc);
            String _plus_4 = "generating ProtocolClass source '" + _cppSourceFileName;
            String _plus_5 = String.valueOf(_plus_4) + "' in '";
            String _plus_6 = String.valueOf(_plus_5) + path;
            String _plus_7 = String.valueOf(_plus_6) + "'";
            this.logger.logInfo(_plus_7);
            this.fileAccess.setOutputPath(path);
            String _cppSourceFileName_1 = this.stdExt.getCppSourceFileName((RoomClass)pc);
            CharSequence _generateSourceFile = this.generateSourceFile(root, pc);
            this.fileAccess.generateFile(_cppSourceFileName_1, _generateSourceFile);
        }
    }

    private CharSequence generateHeaderFile(Root root, ProtocolClass pc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Header File of ProtocolClass ");
        String _name = pc.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        String _name_1 = pc.getName();
        CharSequence _generateIncludeGuardBegin = this.stdExt.generateIncludeGuardBegin(_name_1);
        _builder.append((Object)_generateIncludeGuardBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include \"platforms/generic/etDatatypes.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/messaging/IRTObject.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/modelbase/PortBase.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/modelbase/InterfaceItemBase.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/messaging/Address.h\"");
        _builder.newLine();
        _builder.append((Object)"#include \"common/messaging/Message.h\"");
        _builder.newLine();
        _builder.append((Object)"#include <vector>");
        _builder.newLine();
        _builder.append((Object)"#include <string>");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"namespace etRuntime {");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"class IEventReceiver;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        DetailCode _userCode1 = pc.getUserCode1();
        CharSequence _userCode = this.helpers.userCode(_userCode1);
        _builder.append((Object)_userCode, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList _referencedDataClasses = root.getReferencedDataClasses((RoomClass)pc);
        for (DataClass dataClass : _referencedDataClasses) {
            _builder.append((Object)"#include \"");
            String _path = this.roomExt.getPath((RoomClass)dataClass);
            _builder.append((Object)_path, "");
            String _name_2 = dataClass.getName();
            _builder.append((Object)_name_2, "");
            _builder.append((Object)".h\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"class ");
        String _name_3 = pc.getName();
        _builder.append((Object)_name_3, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"   ");
        _builder.append((Object)"public:");
        _builder.newLine();
        CommunicationType _commType = pc.getCommType();
        boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.EVENT_DRIVEN);
        if (_equals) {
            boolean _equals_2;
            boolean _equals_1;
            _builder.append((Object)"\t   /* message IDs */");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            String _genMessageIDs = this.genMessageIDs(pc);
            _builder.append((Object)_genMessageIDs, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"static bool isValidEvtID(int evtId) {");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"return ((MSG_MIN < evtId) && (evtId < MSG_MAX));");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"};");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"static bool isValidOutgoingEvtID(int evtId) {");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"return ((MSG_MIN < evtId) && (evtId < ");
            EList _incomingMessages = pc.getIncomingMessages();
            int _size = _incomingMessages.size();
            boolean bl = _equals_1 = _size == 0;
            if (_equals_1) {
                _builder.append((Object)"MSG_MAX");
            } else {
                _builder.append((Object)"IN_");
                EList _incomingMessages_1 = pc.getIncomingMessages();
                Message _get = (Message)_incomingMessages_1.get(0);
                String _name_4 = _get.getName();
                _builder.append((Object)_name_4, "\t\t\t");
            }
            _builder.append((Object)"));");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"};");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"static bool isValidIncomingEvtID(int evtId) {");
            _builder.newLine();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"return ((");
            EList _incomingMessages_2 = pc.getIncomingMessages();
            int _size_1 = _incomingMessages_2.size();
            boolean bl2 = _equals_2 = _size_1 == 0;
            if (_equals_2) {
                _builder.append((Object)"MSG_MAX");
            } else {
                _builder.append((Object)"IN_");
                EList _incomingMessages_3 = pc.getIncomingMessages();
                Message _get_1 = (Message)_incomingMessages_3.get(0);
                String _name_5 = _get_1.getName();
                _builder.append((Object)_name_5, "\t\t\t");
            }
            _builder.append((Object)" <= evtId) && (evtId < MSG_MAX));");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"};");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"static std::string getMessageString(int msg_id);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"private:");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"static std::string s_messageStrings[];");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t");
        DetailCode _userCode2 = pc.getUserCode2();
        CharSequence _userCode_1 = this.helpers.userCode(_userCode2);
        _builder.append((Object)_userCode_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.newLine();
        CharSequence _portClassDeclaration = this.portClassDeclaration(pc, false);
        _builder.append((Object)_portClassDeclaration, "");
        _builder.newLineIfNotEmpty();
        CharSequence _portClassDeclaration_1 = this.portClassDeclaration(pc, true);
        _builder.append((Object)_portClassDeclaration_1, "");
        _builder.newLineIfNotEmpty();
        String _name_6 = pc.getName();
        CharSequence _generateIncludeGuardEnd = this.stdExt.generateIncludeGuardEnd(_name_6);
        _builder.append((Object)_generateIncludeGuardEnd, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence portClassDeclaration(ProtocolClass pc, Boolean conj) {
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _xblockexpression = null;
        PortClass pclass = this.roomExt.getPortClass(pc, conj.booleanValue());
        String portClassName = this.roomExt.getPortClassName(pc, conj.booleanValue());
        String replPortClassName = this.roomExt.getPortClassName(pc, conj.booleanValue(), true);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"//------------------------------------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append((Object)"// ");
        if (conj.booleanValue()) {
            _builder.append((Object)"conjugated ");
        }
        _builder.append((Object)"port class");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"//------------------------------------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append((Object)"class ");
        _builder.append((Object)portClassName, "");
        _builder.append((Object)" : public etRuntime::PortBase {");
        _builder.newLineIfNotEmpty();
        boolean bl = _notEquals = !Objects.equal((Object)pclass, null);
        if (_notEquals) {
            _builder.append((Object)"\t");
            DetailCode _userCode = pclass.getUserCode();
            CharSequence _userCode_1 = this.helpers.userCode(_userCode);
            _builder.append((Object)_userCode_1, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"   ");
        _builder.append((Object)"public:");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// constructors");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)portClassName, "\t ");
        _builder.append((Object)"(etRuntime::IEventReceiver& actor, etRuntime::IRTObject* parent, std::string name, int localId, etRuntime::Address addr, etRuntime::Address peerAddress, bool doRegistration = true); ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t ");
        _builder.append((Object)portClassName, "\t ");
        _builder.append((Object)"(etRuntime::IEventReceiver& actor, etRuntime::IRTObject* parent, std::string name, int localId, int idx, etRuntime::Address addr, etRuntime::Address peerAddress, bool doRegistration = true);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"virtual void receive(etRuntime::Message* m);");
        _builder.newLine();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)pclass, null);
        if (_notEquals_1) {
            _builder.append((Object)"\t");
            EList _attributes = pclass.getAttributes();
            CharSequence _attributes_1 = this.helpers.attributes((List)_attributes);
            _builder.append((Object)_attributes_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            EList _operations = pclass.getOperations();
            CharSequence _operationsDeclaration = this.helpers.operationsDeclaration((List)_operations, portClassName);
            _builder.append((Object)_operationsDeclaration, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t  ");
        _builder.append((Object)"// outgoing messages");
        _builder.newLine();
        List _allMessages = RoomHelpers.getAllMessages((ProtocolClass)pc, (boolean)conj);
        for (Message m : _allMessages) {
            _builder.append((Object)"\t");
            CharSequence _sendMessageDeclaration = this.sendMessageDeclaration(m, conj);
            _builder.append((Object)_sendMessageDeclaration, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"//------------------------------------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append((Object)"// ");
        if (conj.booleanValue()) {
            _builder.append((Object)"conjugated ");
        }
        _builder.append((Object)"replicated port class");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"//------------------------------------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append((Object)"class ");
        _builder.append((Object)replPortClassName, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"private:");
        _builder.newLine();
        _builder.append((Object)"\t    ");
        _builder.append((Object)"int m_replication;");
        _builder.newLine();
        _builder.append((Object)"\t    ");
        _builder.append((Object)portClassName, "\t    ");
        _builder.append((Object)"* m_ports;  //dynamic array used instead of vector to avoid copy construction");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public:");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)replPortClassName, "\t\t");
        _builder.append((Object)"(etRuntime::IEventReceiver& actor, etRuntime::IRTObject* parent, std::string name, int localId, std::vector<etRuntime::Address> addr, std::vector<etRuntime::Address> peerAddress);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"virtual ~");
        _builder.append((Object)replPortClassName, "\t\t");
        _builder.append((Object)"() {};");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"int getReplication() {\treturn m_replication; }");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"int getIndexOf(const etRuntime::InterfaceItemBase& ifitem){ return ifitem.getIdx();\t}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)portClassName, "\t\t");
        _builder.append((Object)" get(int i) {return m_ports[i];}");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        CommunicationType _commType = pc.getCommType();
        boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.EVENT_DRIVEN);
        if (_equals) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)" ");
            _builder.append((Object)"// outgoing messages");
            _builder.newLine();
            List _allMessages_1 = RoomHelpers.getAllMessages((ProtocolClass)pc, (boolean)conj);
            for (Message m_1 : _allMessages_1) {
                _builder.append((Object)"\t\t");
                CharSequence _sendMessageDeclaration_1 = this.sendMessageDeclaration(m_1, conj);
                _builder.append((Object)_sendMessageDeclaration_1, "\t\t");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private CharSequence generateSourceFile(Root root, ProtocolClass pc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* Source File of ProtocolClass ");
        String _name = pc.getName();
        _builder.append((Object)_name, "\t ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include \"");
        String _cppHeaderFileName = this.stdExt.getCppHeaderFileName((RoomClass)pc);
        _builder.append((Object)_cppHeaderFileName, "\t");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include \"common/debugging/DebuggingService.h\"");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include <iostream>");
        _builder.newLine();
        GeneratorSettings _settings = Main.getSettings();
        boolean _isUseEtUnit = _settings.isUseEtUnit();
        if (_isUseEtUnit) {
            _builder.append((Object)"\t");
            _builder.append((Object)"extern \"C\" {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"#include \"etUnit.h\"");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"using namespace etRuntime;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        DetailCode _userCode3 = pc.getUserCode3();
        CharSequence _userCode = this.helpers.userCode(_userCode3);
        _builder.append((Object)_userCode, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        CommunicationType _commType = pc.getCommType();
        boolean _equals = Objects.equal((Object)_commType, (Object)CommunicationType.EVENT_DRIVEN);
        if (_equals) {
            _builder.append((Object)"\t");
            DetailCode _userCode2 = pc.getUserCode2();
            CharSequence _userCode_1 = this.helpers.userCode(_userCode2);
            _builder.append((Object)_userCode_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append((Object)"\t");
            CharSequence _portClassImplementation = this.portClassImplementation(pc, false);
            _builder.append((Object)_portClassImplementation, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            CharSequence _portClassImplementation_1 = this.portClassImplementation(pc, true);
            _builder.append((Object)_portClassImplementation_1, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"/*--------------------- debug helpers */");
            _builder.newLine();
            _builder.append((Object)"\t");
            CharSequence _generateDebugHelpersImplementation = this.generateDebugHelpersImplementation(root, pc);
            _builder.append((Object)_generateDebugHelpersImplementation, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        return _builder;
    }

    public CharSequence portClassImplementation(ProtocolClass pc, Boolean conj) {
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _xblockexpression = null;
        PortClass pclass = this.roomExt.getPortClass(pc, conj.booleanValue());
        String portClassName = this.roomExt.getPortClassName(pc, conj.booleanValue());
        String replPortClassName = this.roomExt.getPortClassName(pc, conj.booleanValue(), true);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"//------------------------------------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append((Object)"// ");
        if (conj.booleanValue()) {
            _builder.append((Object)"conjugated ");
        }
        _builder.append((Object)"port class");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"//------------------------------------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)portClassName, "");
        _builder.append((Object)"::");
        _builder.append((Object)portClassName, "");
        _builder.append((Object)"(etRuntime::IEventReceiver& actor, etRuntime::IRTObject* parent, std::string name, int localId, Address addr, Address peerAddress, bool doRegistration)");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)": ");
        String _generateConstructorInitalizerList = this.generateConstructorInitalizerList(pclass, "0");
        _builder.append((Object)_generateConstructorInitalizerList, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"\t");
        boolean bl = _notEquals = !Objects.equal((Object)pclass, null);
        if (_notEquals) {
            EList _attributes = pclass.getAttributes();
            CharSequence _attributeInitialization = this._initialization.attributeInitialization((List<Attribute>)_attributes, false);
            _builder.append((Object)_attributeInitialization, "\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (doRegistration) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"DebuggingService::getInstance().addPortInstance(*this);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)portClassName, "");
        _builder.append((Object)"::");
        _builder.append((Object)portClassName, "");
        _builder.append((Object)"(etRuntime::IEventReceiver& actor, etRuntime::IRTObject* parent, std::string name, int localId, int idx, Address addr, Address peerAddress, bool doRegistration)");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)": ");
        String _generateConstructorInitalizerList_1 = this.generateConstructorInitalizerList(pclass, "idx");
        _builder.append((Object)_generateConstructorInitalizerList_1, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"\t");
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)pclass, null);
        if (_notEquals_1) {
            EList _attributes_1 = pclass.getAttributes();
            CharSequence _attributeInitialization_1 = this._initialization.attributeInitialization((List<Attribute>)_attributes_1, false);
            _builder.append((Object)_attributeInitialization_1, "\t");
        }
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (doRegistration) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"DebuggingService::getInstance().addPortInstance(*this);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"void ");
        _builder.append((Object)portClassName, "");
        _builder.append((Object)"::receive(Message* msg) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (! ");
        String _name = pc.getName();
        _builder.append((Object)_name, "\t");
        _builder.append((Object)"::");
        if (conj.booleanValue()) {
            _builder.append((Object)"isValidOutgoingEvtID");
        } else {
            _builder.append((Object)"isValidIncomingEvtID");
        }
        _builder.append((Object)"(msg->getEvtId())) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"std::cout << \"unknown\" << std::endl;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"else {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"if (msg->hasDebugFlagSet()) {\t\t\t// TODO: model switch for activation of this flag");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"DebuggingService::getInstance().addMessageAsyncIn(getPeerAddress(), getAddress(), ");
        String _name_1 = pc.getName();
        _builder.append((Object)_name_1, "\t\t\t");
        _builder.append((Object)"::getMessageString(msg->getEvtId()));");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        boolean _handlesReceive = this.roomExt.handlesReceive(pc, conj.booleanValue());
        if (_handlesReceive) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"switch (msg->getEvtId()) {");
            _builder.newLine();
            List _receiveHandlers = this.roomExt.getReceiveHandlers(pc, conj.booleanValue());
            for (MessageHandler hdlr : _receiveHandlers) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"case ");
                String _name_2 = pc.getName();
                _builder.append((Object)_name_2, "\t\t\t");
                _builder.append((Object)"::");
                Message _msg = hdlr.getMsg();
                String _codeName = this.roomExt.getCodeName(_msg);
                _builder.append((Object)_codeName, "\t\t\t");
                _builder.append((Object)":");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"{");
                _builder.newLine();
                DetailCode _detailCode = hdlr.getDetailCode();
                EList _lines = _detailCode.getLines();
                for (String command : _lines) {
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)command, "\t\t\t\t\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"break;");
                _builder.newLine();
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"default:");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"getEventReceiver().receiveEvent(this, msg->getEvtId(),\tmsg->getData());");
        _builder.newLine();
        boolean _handlesReceive_1 = this.roomExt.handlesReceive(pc, conj.booleanValue());
        if (_handlesReceive_1) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"break;");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.newLine();
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)pclass, null);
        if (_notEquals_2) {
            EList _operations = pclass.getOperations();
            CharSequence _operationsImplementation = this.helpers.operationsImplementation((List)_operations, portClassName);
            _builder.append((Object)_operationsImplementation, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"// sent messages");
        _builder.newLine();
        List _allMessages = RoomHelpers.getAllMessages((ProtocolClass)pc, (boolean)conj);
        for (Message m : _allMessages) {
            String _name_3 = pc.getName();
            CharSequence _sendMessage = this.sendMessage(m, _name_3, portClassName, conj);
            _builder.append((Object)_sendMessage, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"//------------------------------------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append((Object)"// ");
        if (conj.booleanValue()) {
            _builder.append((Object)"conjugated ");
        }
        _builder.append((Object)"replicated port class");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"//------------------------------------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append((Object)replPortClassName, "");
        _builder.append((Object)"::");
        _builder.append((Object)replPortClassName, "");
        _builder.append((Object)"(etRuntime::IEventReceiver& actor, etRuntime::IRTObject* parent, std::string name, int localId, std::vector<Address> addr, std::vector<Address> peerAddress) ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)": m_replication(addr.size()),");
        _builder.newLine();
        _builder.append((Object)"  \t  ");
        _builder.append((Object)"m_ports()");
        _builder.newLine();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"char numstr[10]; // enough to hold all numbers up to 32-bits");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"m_ports = reinterpret_cast<");
        _builder.append((Object)portClassName, "\t");
        _builder.append((Object)"*> (new char[sizeof(");
        _builder.append((Object)portClassName, "\t");
        _builder.append((Object)") * addr.size()]);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"for (int i = 0; i < m_replication; ++i) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"snprintf(numstr, sizeof(numstr), \"%d\", i);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"//placement new to avoid copy construction, therefore no vector is used");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"new  (&m_ports[i]) ");
        _builder.append((Object)portClassName, "\t\t");
        _builder.append((Object)"(actor, parent, name + numstr, localId, i, addr[i], peerAddress[i]);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"// outgoing messages");
        _builder.newLine();
        List _allMessages_1 = RoomHelpers.getAllMessages((ProtocolClass)pc, (boolean)conj);
        for (Message m_1 : _allMessages_1) {
            CharSequence _messageSignatureDefinition = this.messageSignatureDefinition(m_1, replPortClassName);
            _builder.append((Object)_messageSignatureDefinition, "");
            _builder.append((Object)"{");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"for (int i=0; i<m_replication; ++i) {");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"m_ports[i].");
            CharSequence _messageCall = this.messageCall(m_1);
            _builder.append((Object)_messageCall, "\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public String generateConstructorInitalizerList(PortClass pc, String index) {
        boolean _notEquals;
        ArrayList<Object> _arrayList;
        ArrayList<Object> initializerList = _arrayList = new ArrayList<Object>();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"PortBase(actor, parent, name, localId, ");
        _builder.append((Object)index, "");
        _builder.append((Object)", addr, peerAddress)");
        initializerList.add(_builder);
        boolean bl = _notEquals = !Objects.equal((Object)pc, null);
        if (_notEquals) {
            EList _attributes = pc.getAttributes();
            for (Attribute attrib : _attributes) {
                CharSequence _attributeInitialization = this._initialization.attributeInitialization(attrib, false);
                initializerList.add(_attributeInitialization);
            }
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        String _join = IterableExtensions.join(initializerList, (CharSequence)",\n");
        _builder_1.append((Object)_join, "");
        _builder_1.newLineIfNotEmpty();
        return _builder_1.toString();
    }

    private CharSequence messageCall(Message m) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        String _name = m.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"(");
        VarDecl _data = m.getData();
        boolean bl = _notEquals = !Objects.equal((Object)_data, null);
        if (_notEquals) {
            _builder.append((Object)" ");
            VarDecl _data_1 = m.getData();
            String _name_1 = _data_1.getName();
            _builder.append((Object)_name_1, "");
        }
        _builder.append((Object)")");
        return _builder;
    }

    private CharSequence generateDebugHelpersImplementation(Root root, ProtocolClass pc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"/* message names as strings for debugging (generate MSC) */");
        _builder.newLine();
        _builder.append((Object)"std::string ");
        String _name = pc.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"::s_messageStrings[] ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"= {\"MIN\", ");
        _builder.newLine();
        List _allOutgoingMessages = RoomHelpers.getAllOutgoingMessages((ProtocolClass)pc);
        for (Message m : _allOutgoingMessages) {
            _builder.append((Object)"\t\t   ");
            _builder.append((Object)"\"");
            String _name_1 = m.getName();
            _builder.append((Object)_name_1, "\t\t   ");
            _builder.append((Object)"\",");
            _builder.newLineIfNotEmpty();
        }
        List _allIncomingMessages = RoomHelpers.getAllIncomingMessages((ProtocolClass)pc);
        for (Message m_1 : _allIncomingMessages) {
            _builder.append((Object)"\t\t   ");
            _builder.append((Object)"\"");
            String _name_2 = m_1.getName();
            _builder.append((Object)_name_2, "\t\t   ");
            _builder.append((Object)"\",");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t   ");
        _builder.append((Object)"\"MAX\"};");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"std::string ");
        String _name_3 = pc.getName();
        _builder.append((Object)_name_3, "");
        _builder.append((Object)"::getMessageString(int msg_id) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"if ((MSG_MIN < msg_id ) && ( msg_id < MSG_MAX )) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return s_messageStrings[msg_id];");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"} else {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"// id out of range");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return \"Message ID out of range\";");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    public CharSequence messageSignature(Message m) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isPriv = m.isPriv();
        if (_isPriv) {
            _builder.append((Object)"private:");
        } else {
            _builder.append((Object)"public:");
        }
        _builder.append((Object)" void ");
        String _name = m.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"(");
        VarDecl _data = m.getData();
        boolean bl = _notEquals = !Objects.equal((Object)_data, null);
        if (_notEquals) {
            VarDecl _data_1 = m.getData();
            RefableType _refType = _data_1.getRefType();
            DataType _type = _refType.getType();
            String _typeName = this._typeHelpers.typeName(_type);
            _builder.append((Object)_typeName, "");
            _builder.append((Object)" ");
            VarDecl _data_2 = m.getData();
            String _name_1 = _data_2.getName();
            _builder.append((Object)_name_1, "");
        }
        _builder.append((Object)")");
        return _builder;
    }

    public CharSequence messageSignatureExplicit(Message m) {
        boolean _notEquals;
        StringConcatenation _xblockexpression = null;
        VarDecl _data = m.getData();
        RefableType _refType = _data.getRefType();
        DataType _type = _refType.getType();
        DataClass dc = (DataClass)_type;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"public: void ");
        String _name = m.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"(");
        DataClass _base = dc.getBase();
        boolean bl = _notEquals = !Objects.equal((Object)_base, null);
        if (_notEquals) {
            DataClass _base_1 = dc.getBase();
            String _typeName = this._typeHelpers.typeName((DataType)_base_1);
            _builder.append((Object)_typeName, "");
            _builder.append((Object)" _super, ");
        }
        EList _attributes = dc.getAttributes();
        boolean _hasElements = false;
        for (Attribute a : _attributes) {
            boolean _greaterThan;
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            RefableType _type_1 = a.getType();
            DataType _type_2 = _type_1.getType();
            String _typeName_1 = this._typeHelpers.typeName(_type_2);
            _builder.append((Object)_typeName_1, "");
            int _size = a.getSize();
            boolean bl2 = _greaterThan = _size > 1;
            if (_greaterThan) {
                _builder.append((Object)"[]");
            }
            _builder.append((Object)" ");
            String _name_1 = a.getName();
            _builder.append((Object)_name_1, "");
        }
        _builder.append((Object)")");
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence messageSignatureDefinition(Message m, String classPrefix) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"void ");
        _builder.append((Object)classPrefix, "");
        _builder.append((Object)"::");
        String _name = m.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"(");
        VarDecl _data = m.getData();
        boolean bl = _notEquals = !Objects.equal((Object)_data, null);
        if (_notEquals) {
            VarDecl _data_1 = m.getData();
            RefableType _refType = _data_1.getRefType();
            DataType _type = _refType.getType();
            String _typeName = this._typeHelpers.typeName(_type);
            _builder.append((Object)_typeName, "");
            _builder.append((Object)" ");
            VarDecl _data_2 = m.getData();
            String _name_1 = _data_2.getName();
            _builder.append((Object)_name_1, "");
        }
        _builder.append((Object)")");
        return _builder;
    }

    public CharSequence messageSignatureExplicitDefinition(Message m, String classPrefix) {
        boolean _notEquals;
        StringConcatenation _xblockexpression = null;
        VarDecl _data = m.getData();
        RefableType _refType = _data.getRefType();
        DataType _type = _refType.getType();
        DataClass dc = (DataClass)_type;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"void ");
        _builder.append((Object)classPrefix, "");
        _builder.append((Object)"::");
        String _name = m.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"(");
        DataClass _base = dc.getBase();
        boolean bl = _notEquals = !Objects.equal((Object)_base, null);
        if (_notEquals) {
            DataClass _base_1 = dc.getBase();
            String _typeName = this._typeHelpers.typeName((DataType)_base_1);
            _builder.append((Object)_typeName, "");
            _builder.append((Object)" _super, ");
        }
        EList _attributes = dc.getAttributes();
        boolean _hasElements = false;
        for (Attribute a : _attributes) {
            boolean _greaterThan;
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            RefableType _type_1 = a.getType();
            DataType _type_2 = _type_1.getType();
            String _typeName_1 = this._typeHelpers.typeName(_type_2);
            _builder.append((Object)_typeName_1, "");
            int _size = a.getSize();
            boolean bl2 = _greaterThan = _size > 1;
            if (_greaterThan) {
                _builder.append((Object)"[]");
            }
            _builder.append((Object)" ");
            String _name_1 = a.getName();
            _builder.append((Object)_name_1, "");
        }
        _builder.append((Object)")");
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence sendMessageDeclaration(Message m, boolean conj) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _messageSignature = this.messageSignature(m);
        _builder.append((Object)_messageSignature, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        boolean _and = false;
        VarDecl _data = m.getData();
        boolean bl = _notEquals = !Objects.equal((Object)_data, null);
        if (!_notEquals) {
            _and = false;
        } else {
            VarDecl _data_1 = m.getData();
            RefableType _refType = _data_1.getRefType();
            DataType _type = _refType.getType();
            boolean bl2 = _and = _notEquals && _type instanceof DataClass;
        }
        if (_and) {
            CharSequence _messageSignatureExplicit = this.messageSignatureExplicit(m);
            _builder.append((Object)_messageSignatureExplicit, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence sendMessage(Message m, String portClassName, String classPrefix, boolean conj) {
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _xblockexpression = null;
        String _xifexpression = null;
        _xifexpression = conj ? "IN" : "OUT";
        String dir = _xifexpression;
        MessageHandler hdlr = this.roomExt.getSendHandler(m, conj);
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _messageSignatureDefinition = this.messageSignatureDefinition(m, classPrefix);
        _builder.append((Object)_messageSignatureDefinition, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        boolean bl = _notEquals = !Objects.equal((Object)hdlr, null);
        if (_notEquals) {
            _builder.append((Object)"\t");
            DetailCode _detailCode = hdlr.getDetailCode();
            EList _lines = _detailCode.getLines();
            for (String command : _lines) {
                _builder.append((Object)"\t");
                _builder.append((Object)command, "\t");
                _builder.newLineIfNotEmpty();
            }
        } else {
            _builder.append((Object)"\t");
            _builder.append((Object)"DebuggingService::getInstance().addMessageAsyncOut(getAddress(), getPeerAddress(),");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t\t\t\t\t\t\t\t\t\t\t   ");
            _builder.append((Object)portClassName, "\t\t\t\t\t\t\t\t\t\t\t\t\t   ");
            _builder.append((Object)"::getMessageString(");
            _builder.append((Object)portClassName, "\t\t\t\t\t\t\t\t\t\t\t\t\t   ");
            _builder.append((Object)"::");
            _builder.append((Object)dir, "\t\t\t\t\t\t\t\t\t\t\t\t\t   ");
            _builder.append((Object)"_");
            String _name = m.getName();
            _builder.append((Object)_name, "\t\t\t\t\t\t\t\t\t\t\t\t\t   ");
            _builder.append((Object)"));");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"if (getPeerAddress().isValid()){");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            VarDecl _data = m.getData();
            boolean _equals = Objects.equal((Object)_data, null);
            if (_equals) {
                _builder.append((Object)"getPeerMsgReceiver()->receive(new Message(getPeerAddress(), ");
                _builder.append((Object)portClassName, "\t\t");
                _builder.append((Object)"::");
                _builder.append((Object)dir, "\t\t");
                _builder.append((Object)"_");
                String _name_1 = m.getName();
                _builder.append((Object)_name_1, "\t\t");
                _builder.append((Object)"));");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
            } else {
                boolean _not;
                _builder.append((Object)"getPeerMsgReceiver()->receive(new Message(getPeerAddress(),");
                _builder.append((Object)portClassName, "\t\t");
                _builder.append((Object)"::");
                _builder.append((Object)dir, "\t\t");
                _builder.append((Object)"_");
                String _name_2 = m.getName();
                _builder.append((Object)_name_2, "\t\t");
                _builder.append((Object)", ");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"                                                ");
                _builder.append((Object)"reinterpret_cast<void*>(");
                boolean _and = false;
                VarDecl _data_1 = m.getData();
                RefableType _refType = _data_1.getRefType();
                boolean _isRef = _refType.isRef();
                boolean bl2 = _not = !_isRef;
                if (!_not) {
                    _and = false;
                } else {
                    VarDecl _data_2 = m.getData();
                    RefableType _refType_1 = _data_2.getRefType();
                    DataType _type = _refType_1.getType();
                    boolean _not_1 = !(_type instanceof PrimitiveType);
                    boolean bl3 = _and = _not && _not_1;
                }
                if (_and) {
                    _builder.append((Object)"&");
                }
                VarDecl _data_3 = m.getData();
                String _name_3 = _data_3.getName();
                _builder.append((Object)_name_3, "\t\t                                                ");
                _builder.append((Object)"),");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"                                                ");
                _builder.append((Object)"sizeof(");
                VarDecl _data_4 = m.getData();
                RefableType _refType_2 = _data_4.getRefType();
                DataType _type_1 = _refType_2.getType();
                String _typeName = this._typeHelpers.typeName(_type_1);
                _builder.append((Object)_typeName, "\t\t                                                ");
                _builder.append((Object)")));");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        boolean _and_1 = false;
        VarDecl _data_5 = m.getData();
        boolean bl4 = _notEquals_1 = !Objects.equal((Object)_data_5, null);
        if (!_notEquals_1) {
            _and_1 = false;
        } else {
            VarDecl _data_6 = m.getData();
            RefableType _refType_3 = _data_6.getRefType();
            DataType _type_2 = _refType_3.getType();
            boolean bl5 = _and_1 = _notEquals_1 && _type_2 instanceof DataClass;
        }
        if (_and_1) {
            boolean _notEquals_2;
            CharSequence _messageSignatureExplicitDefinition = this.messageSignatureExplicitDefinition(m, classPrefix);
            _builder.append((Object)_messageSignatureExplicitDefinition, "");
            _builder.append((Object)" {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            String _name_4 = m.getName();
            _builder.append((Object)_name_4, "\t");
            _builder.append((Object)"(");
            VarDecl _data_7 = m.getData();
            RefableType _refType_4 = _data_7.getRefType();
            DataType _type_3 = _refType_4.getType();
            String _name_5 = _type_3.getName();
            _builder.append((Object)_name_5, "\t");
            _builder.append((Object)"(");
            VarDecl _data_8 = m.getData();
            RefableType _refType_5 = _data_8.getRefType();
            DataType _type_4 = _refType_5.getType();
            DataClass _base = ((DataClass)_type_4).getBase();
            boolean bl6 = _notEquals_2 = !Objects.equal((Object)_base, null);
            if (_notEquals_2) {
                _builder.append((Object)"_super, ");
            }
            VarDecl _data_9 = m.getData();
            RefableType _refType_6 = _data_9.getRefType();
            DataType _type_5 = _refType_6.getType();
            EList _attributes = ((DataClass)_type_5).getAttributes();
            boolean _hasElements = false;
            for (Attribute a : _attributes) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "\t");
                }
                String _name_6 = a.getName();
                _builder.append((Object)_name_6, "\t");
            }
            _builder.append((Object)"));");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public String getMessageID(Message msg, InterfaceItem item) {
        if (item instanceof Port) {
            Port p = (Port)item;
            String _xifexpression = null;
            boolean _isConjugated = p.isConjugated();
            _xifexpression = _isConjugated ? "OUT_" : "IN_";
            String direction = _xifexpression;
            GeneralProtocolClass _protocol = p.getProtocol();
            String _name = _protocol.getName();
            String _name_1 = msg.getName();
            String _plus = String.valueOf(direction) + _name_1;
            return this.enumInUse(_name, _plus);
        }
        if (item instanceof SAP) {
            SAP sap = (SAP)item;
            ProtocolClass _protocol_1 = sap.getProtocol();
            String _name_2 = _protocol_1.getName();
            String _name_3 = msg.getName();
            String _plus_1 = "OUT_" + _name_3;
            return this.enumInUse(_name_2, _plus_1);
        }
        if (item instanceof SPP) {
            SPP spp = (SPP)item;
            ProtocolClass _protocol_2 = spp.getProtocol();
            String _name_4 = _protocol_2.getName();
            String _name_5 = msg.getName();
            String _plus_2 = "IN_" + _name_5;
            return this.enumInUse(_name_4, _plus_2);
        }
        return "unknown interface item";
    }

    public String enumInUse(String namespace, String member) {
        String _plus = String.valueOf(namespace) + "::";
        return String.valueOf(_plus) + member;
    }
}

