/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.MessageFromIf;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.generator.base.CodegenHelpers;
import org.eclipse.etrice.generator.cpp.gen.ProtocolClassGen;
import org.eclipse.etrice.generator.generic.GenericStateMachineGenerator;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class StateMachineGen
extends GenericStateMachineGenerator {
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    private ProtocolClassGen cppProtGen;

    public CharSequence genExtraDecl(ExpandedActorClass xpac) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"protected:");
        _builder.newLine();
        _builder.append((Object)" \t");
        _builder.append((Object)"static std::string s_stateStrings[];");
        _builder.newLine();
        _builder.append((Object)" \t");
        _builder.append((Object)"static const int s_numberOfStates;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"private:");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"void setState(int new_state);");
        _builder.newLine();
        return _builder;
    }

    public CharSequence genExtra(ExpandedActorClass xpac) {
        StringConcatenation _xblockexpression = null;
        ActorClass ac = xpac.getActorClass();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"std::string ");
        String _name = ac.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"::s_stateStrings[] = {\"<no state>\",\"<top>\",");
        List _allBaseStatesLeavesLast = this._roomExtensions.getAllBaseStatesLeavesLast(ac);
        boolean _hasElements = false;
        for (State state : _allBaseStatesLeavesLast) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)",", "");
            }
            _builder.append((Object)"\"");
            String _genStatePathName = CodegenHelpers.getGenStatePathName((State)state);
            _builder.append((Object)_genStatePathName, "");
            _builder.append((Object)"\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"};");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"const int ");
        String _name_1 = ac.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"::s_numberOfStates = ");
        List _allBaseStatesLeavesLast_1 = this._roomExtensions.getAllBaseStatesLeavesLast(ac);
        int _size = _allBaseStatesLeavesLast_1.size();
        int _plus = _size + 2;
        _builder.append((Object)_plus, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"void ");
        String _name_2 = ac.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)"::setState(int new_state) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"DebuggingService::getInstance().addActorState(*this, s_stateStrings[new_state]);");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (s_stateStrings[new_state]!=\"Idle\") {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"std::cout << getInstancePath() << \" -> \" << s_stateStrings[new_state] << std::endl;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"m_state = new_state;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public String genTriggerConstants(ExpandedActorClass xpac) {
        ArrayList<Pair> _arrayList;
        EList _triggers;
        EList _ownTriggers;
        EList _xifexpression = null;
        boolean _usesInheritance = this.langExt.usesInheritance();
        _xifexpression = _usesInheritance ? (_ownTriggers = xpac.getOwnTriggers()) : (_triggers = xpac.getTriggers());
        EList triggers = _xifexpression;
        ArrayList<Pair> list = _arrayList = new ArrayList<Pair>();
        Pair _pair = Tuples.pair((Object)"POLLING", (Object)"0");
        list.add(_pair);
        for (MessageFromIf mif : triggers) {
            String _triggerCodeName = xpac.getTriggerCodeName(mif);
            InterfaceItem _from = mif.getFrom();
            String _name = _from.getName();
            String _plus = "IFITEM_" + _name;
            String _plus_1 = String.valueOf(_plus) + " + EVT_SHIFT*";
            String _messageID = this.cppProtGen.getMessageID(mif);
            String _plus_2 = String.valueOf(_plus_1) + _messageID;
            Pair _pair_1 = Tuples.pair((Object)_triggerCodeName, (Object)_plus_2);
            list.add(_pair_1);
        }
        return this.langExt.genEnumeration("triggers", list);
    }

    public String constPointer(String classname) {
        String _plus = "const " + classname;
        return String.valueOf(_plus) + "*";
    }

    public String boolType() {
        return "bool";
    }
}

