/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.doc;

import com.google.inject.Inject;
import com.google.inject.Module;
import java.util.Iterator;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.generator.base.AbstractGenerator;
import org.eclipse.etrice.generator.doc.gen.GlobalSettings;
import org.eclipse.etrice.generator.doc.gen.InstanceDiagramGen;
import org.eclipse.etrice.generator.doc.setup.GeneratorModule;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;

public class Main
extends AbstractGenerator {
    public static final String OPTION_GEN_INST_DIAG = "-genInstDiag";
    @Inject
    private IGenerator mainGenerator;
    @Inject
    protected InstanceDiagramGen instanceDiagramGenerator;

    protected void printUsage() {
        output.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + this.getCommonOptions() + " <list of model file paths>");
        output.println(this.getCommonOptionDescriptions());
        output.println("      -genInstDiag                      # if specified then an instance diagram is created for each subsystem");
    }

    public static void main(String[] args) {
        int ret = Main.createAndRunGenerator((Module)new GeneratorModule(), (String[])args);
        if (Main.isTerminateOnError() && ret != 0) {
            System.exit(ret);
        }
    }

    public static GlobalSettings getSettings() {
        return (GlobalSettings)Main.getInstance().getGeneratorSettings();
    }

    protected boolean parseOption(String arg, Iterator<String> it) {
        if (arg.equals(OPTION_GEN_INST_DIAG)) {
            Main.getSettings().setGenerateInstanceDiagram(true);
            return true;
        }
        return super.parseOption(arg, it);
    }

    protected int runGenerator() {
        this.setupRoomModel();
        if (!this.loadModels(Main.getSettings().getInputModelURIs())) {
            this.logger.logInfo("loading of models failed");
            this.logger.logError("-- terminating", null);
            return 1;
        }
        if (!this.validateModels()) {
            this.logger.logInfo("validation failed");
            this.logger.logError("-- terminating", null);
            return 1;
        }
        Root genModel = this.createGeneratorModel(Main.getSettings().isGenerateAsLibrary(), Main.getSettings().getGeneratorModelPath());
        if (this.diagnostician.isFailed() || genModel == null) {
            this.logger.logInfo("errors during build of generator model");
            this.logger.logError("-- terminating", null);
            return 1;
        }
        this.logger.logInfo("-- starting code generation");
        this.fileAccess.setOutputPath("doc-gen/");
        this.mainGenerator.doGenerate(genModel.eResource(), (IFileSystemAccess)this.fileAccess);
        if (Main.getSettings().isGenerateInstanceDiagram()) {
            this.instanceDiagramGenerator.doGenerate(genModel);
        }
        if (this.diagnostician.isFailed()) {
            this.logger.logInfo("errors during code generation");
            this.logger.logError("-- terminating", null);
            return 1;
        }
        this.logger.logInfo("-- finished code generation");
        return 0;
    }
}

