/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.ui.wizard;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.etrice.generator.ui.wizard.EmptyProjectConfigPage;
import org.eclipse.etrice.generator.ui.wizard.ProjectCreator;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class EmptyProjectWizard
extends Wizard
implements INewWizard {
    protected IWorkbench workbench;
    protected IPath projectLocation;
    protected IPath sourcePath;
    protected IPath sourceGenPath;
    protected IProject project;
    protected IProject runtimeProject;
    protected String initialProjectName;
    protected URI modelURI;
    private EmptyProjectConfigPage config;
    private static final String[] additionalLaunchConfigLines = new String[]{"<stringAttribute key=\"org.eclipse.debug.core.ATTR_REFRESH_SCOPE\" value=\"${workspace}\"/>"};

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.setDefaultPageImageDescriptor(ProjectCreator.getImageDescriptor("icons/NewETriceProjectWizban.gif"));
        this.setWindowTitle("New Empty eTrice Project");
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.runtimeProject = workspace.getRoot().getProject("org.eclipse.etrice.runtime.java");
    }

    public void addPages() {
        WizardNewProjectCreationPage newProjectCreationPage = new WizardNewProjectCreationPage("NewProjectCreationPage"){

            protected boolean validatePage() {
                if (super.validatePage()) {
                    IPath locationPath = this.getLocationPath();
                    EmptyProjectWizard.this.projectLocation = Platform.getLocation().equals((Object)locationPath) ? null : locationPath;
                    IPath projectPath = this.getProjectHandle().getFullPath();
                    EmptyProjectWizard.this.sourcePath = projectPath.append("src");
                    EmptyProjectWizard.this.sourceGenPath = projectPath.append("src-gen");
                    return true;
                }
                return false;
            }
        };
        newProjectCreationPage.setInitialProjectName(this.initialProjectName);
        newProjectCreationPage.setTitle("Empty eTrice Project");
        newProjectCreationPage.setDescription("Create an empty Java project with eTrice dependencies");
        this.addPage((IWizardPage)newProjectCreationPage);
        this.config = new EmptyProjectConfigPage("config", this.runtimeProject);
        this.config.setTitle("Project Configuration");
        this.config.setDescription("Choose a build type for the project");
        this.addPage((IWizardPage)this.config);
    }

    public boolean performFinish() {
        IWorkbenchPage page;
        IWorkbenchPart activePart;
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) {
                try {
                    try {
                        if (!EmptyProjectWizard.this.config.useJDTBuild()) {
                            EmptyProjectWizard.this.runtimeProject = null;
                        }
                        ArrayList<String> natures = new ArrayList<String>(ProjectCreator.getCommonNatureIDs());
                        if (EmptyProjectWizard.this.config.useMVNBuild()) {
                            natures.add("org.eclipse.m2e.core.maven2Nature");
                        }
                        ArrayList<String> builders = new ArrayList<String>(ProjectCreator.getCommonBuilderIDs());
                        if (EmptyProjectWizard.this.config.useMVNBuild()) {
                            builders.add("org.eclipse.m2e.core.maven2Builder");
                        }
                        ArrayList<IClasspathEntry> pathEntries = new ArrayList<IClasspathEntry>();
                        if (EmptyProjectWizard.this.config.useMVNBuild()) {
                            IClasspathEntry mvnContainer = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.m2e.MAVEN2_CLASSPATH_CONTAINER"), (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"maven.pomderived", (String)"true")}, (boolean)false);
                            pathEntries.add(mvnContainer);
                        }
                        URI modelProjectURI = EmptyProjectWizard.this.projectLocation == null ? null : URI.createFileURI((String)EmptyProjectWizard.this.projectLocation.toOSString());
                        EmptyProjectWizard.this.project = ProjectCreator.createETriceProject((IPath)new Path(EmptyProjectWizard.this.sourcePath.toString()), (IPath)new Path(EmptyProjectWizard.this.sourceGenPath.toString()), modelProjectURI, EmptyProjectWizard.this.runtimeProject, natures, builders, pathEntries, BasicMonitor.toMonitor((IProgressMonitor)progressMonitor));
                        String baseName = EmptyProjectWizard.this.sourcePath.segment(0);
                        ProjectCreator.findOrCreateContainer((IPath)new Path("/" + baseName + "/model"), true, EmptyProjectWizard.this.projectLocation, progressMonitor);
                        EmptyProjectWizard.this.modelURI = URI.createPlatformResourceURI((String)("/" + baseName + "/model/" + baseName + ".room"), (boolean)true);
                        ProjectCreator.createModel(EmptyProjectWizard.this.modelURI, baseName);
                        URI physModelURI = URI.createPlatformResourceURI((String)("/" + baseName + "/model/" + baseName + ".etphys"), (boolean)true);
                        ProjectCreator.createPhysicalModel(physModelURI, baseName);
                        URI mapModelURI = URI.createPlatformResourceURI((String)("/" + baseName + "/model/" + baseName + ".etmap"), (boolean)true);
                        ProjectCreator.createMappingModel(mapModelURI, baseName);
                        ProjectCreator.createBuildProperties(URI.createPlatformResourceURI((String)("/" + baseName + "/build.properties"), (boolean)true), baseName);
                        ProjectCreator.createLaunchGeneratorConfig(URI.createPlatformResourceURI((String)("/" + baseName + "/gen_" + baseName + ".launch"), (boolean)true), "java", "/" + baseName + "/model", baseName, additionalLaunchConfigLines);
                        ProjectCreator.createLaunchJavaApplicationConfig(URI.createPlatformResourceURI((String)("/" + baseName + "/run_" + baseName + ".launch"), (boolean)true), baseName, baseName, "Node_nodeRef1_subSysRef1Runner");
                        ProjectCreator.findOrCreateContainer((IPath)new Path("/" + baseName + "/tmp/log"), true, EmptyProjectWizard.this.projectLocation, progressMonitor);
                        if (EmptyProjectWizard.this.config.useMVNBuild()) {
                            ProjectCreator.createMavenPOM(URI.createPlatformResourceURI((String)("/" + baseName + "/pom.xml"), (boolean)true), baseName, baseName, "Node_nodeRef1_subSysRef1Runner");
                            ProjectCreator.createMavenBuilder(URI.createPlatformResourceURI((String)("/" + baseName + "/build_" + baseName + ".launch"), (boolean)true), baseName);
                            ProjectCreator.createMavenLauncher(URI.createPlatformResourceURI((String)("/" + baseName + "/runjar_" + baseName + ".launch"), (boolean)true), baseName, baseName);
                        }
                    }
                    catch (Exception e) {
                        Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)e.getMessage(), (Throwable)e);
                        progressMonitor.done();
                    }
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        if (this.project != null && (activePart = (page = this.workbench.getActiveWorkbenchWindow().getActivePage()).getActivePart()) instanceof ISetSelectionTarget) {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            IFile model = workspaceRoot.getFile((IPath)new Path(this.modelURI.toPlatformString(true)));
            StructuredSelection targetSelection = new StructuredSelection((Object)model);
            FileEditorInput input = new FileEditorInput(model);
            this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection, (IFileEditorInput)input){
                private final /* synthetic */ ISelection val$targetSelection;
                private final /* synthetic */ IFileEditorInput val$input;
                {
                    this.val$targetSelection = iSelection;
                    this.val$input = iFileEditorInput;
                }

                @Override
                public void run() {
                    ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                    try {
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)this.val$input, "org.eclipse.etrice.core.Room");
                    }
                    catch (PartInitException partInitException) {
                        // empty catch block
                    }
                }
            });
        }
        return true;
    }

    public void setInitialProjectName(String value) {
        this.initialProjectName = value;
    }
}

