/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.markers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.Trigger;
import org.eclipse.xtext.validation.FeatureBasedDiagnostic;

public class DiagnosingModelObserver
extends EContentAdapter {
    private HashMap<EObject, ArrayList<Diagnostic>> elementDiagnosticMap = new HashMap();
    private RoomModel roomModel;

    public void observeRoomModel(RoomModel roomModel) {
        this.roomModel = roomModel;
        this.setTarget((EObject)roomModel);
        this.updateElementDiagonosticMap();
    }

    public void removeObserver() {
        this.unsetTarget((EObject)this.roomModel);
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (notification.getEventType() < 8) {
            this.updateElementDiagonosticMap();
        }
    }

    public HashMap<EObject, ArrayList<Diagnostic>> getElementDiagonsticMap() {
        return this.elementDiagnosticMap;
    }

    private void updateElementDiagonosticMap() {
        this.elementDiagnosticMap.clear();
        Diagnostic diagnostics = Diagnostician.INSTANCE.validate((EObject)this.roomModel);
        HashMap uniqueEnsurer = new HashMap();
        uniqueEnsurer.clear();
        for (Diagnostic diagnostic : diagnostics.getChildren()) {
            FeatureBasedDiagnostic featureBasedDiagnostic = (FeatureBasedDiagnostic)diagnostic;
            EObject source = featureBasedDiagnostic.getSourceEObject();
            EObject eObject = null;
            if (source instanceof StateGraph) {
                EStructuralFeature feature = featureBasedDiagnostic.getFeature();
                int index = featureBasedDiagnostic.getIndex();
                if (!feature.isMany()) {
                    eObject = (EObject)source.eGet(feature);
                } else if (index != -1) {
                    List list = (List)source.eGet(feature);
                    eObject = (EObject)list.get(index);
                }
            } else {
                eObject = source instanceof Trigger ? source.eContainer() : source;
            }
            if (eObject == null) continue;
            if (this.elementDiagnosticMap.get(eObject) == null) {
                this.elementDiagnosticMap.put(eObject, new ArrayList());
                uniqueEnsurer.put(eObject, new HashSet());
            }
            String certificate = featureBasedDiagnostic.getIssueCode();
            String[] stringArray = featureBasedDiagnostic.getIssueData();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String data = stringArray[n2];
                certificate = String.valueOf(certificate) + data;
                ++n2;
            }
            if (((HashSet)uniqueEnsurer.get(eObject)).contains(certificate)) continue;
            ((HashSet)uniqueEnsurer.get(eObject)).add(certificate);
            this.elementDiagnosticMap.get(eObject).add(diagnostic);
        }
    }
}

