/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.support;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.etrice.ui.behavior.dialogs.QuickFixDialog;
import org.eclipse.etrice.ui.behavior.editor.BehaviorEditor;
import org.eclipse.etrice.ui.behavior.quickfix.BehaviorQuickfixProvider;
import org.eclipse.etrice.ui.common.quickfix.IssueResolution;
import org.eclipse.etrice.ui.common.support.ChangeAwareCustomFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.validation.FeatureBasedDiagnostic;

public class QuickFixFeature
extends ChangeAwareCustomFeature {
    public QuickFixFeature(IFeatureProvider fp) {
        super(fp);
    }

    public String getName() {
        return "Quick Fix";
    }

    public String getDescription() {
        return "Apply Quick fixes";
    }

    public String getImageId() {
        return "org.eclipse.etrice.ui.behavior.quickfix";
    }

    public boolean canExecute(ICustomContext context) {
        return true;
    }

    public boolean doExecute(ICustomContext context) {
        Object[] result;
        Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElements()[0]);
        ArrayList<Diagnostic> issues = ((BehaviorEditor)this.getDiagramBehavior().getDiagramContainer()).getDiagnosingModelObserver().getElementDiagonsticMap().get(bo);
        HashMap<FeatureBasedDiagnostic, List<IssueResolution>> issueResolutionsMap = new HashMap<FeatureBasedDiagnostic, List<IssueResolution>>();
        BehaviorQuickfixProvider behaviorQuickfixProvider = new BehaviorQuickfixProvider();
        for (Diagnostic issue : issues) {
            issueResolutionsMap.put((FeatureBasedDiagnostic)issue, behaviorQuickfixProvider.getResolutions((FeatureBasedDiagnostic)issue));
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        QuickFixDialog dlg = new QuickFixDialog(shell, issueResolutionsMap);
        if (dlg.open() == 0 && (result = dlg.getResult()) != null) {
            return ((IssueResolution)result[0]).apply(this.getDiagram(), this.getFeatureProvider());
        }
        return false;
    }
}

