/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.layout;

import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KLabel;
import de.cau.cs.kieler.core.kgraph.KLabeledGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import de.cau.cs.kieler.kiml.LayoutContext;
import de.cau.cs.kieler.kiml.config.ILayoutConfig;
import de.cau.cs.kieler.kiml.config.VolatileLayoutConfig;
import de.cau.cs.kieler.kiml.graphiti.GefDiagramLayoutManager;
import de.cau.cs.kieler.kiml.graphiti.GraphitiLayoutCommand;
import de.cau.cs.kieler.kiml.graphiti.GraphitiLayoutConfig;
import de.cau.cs.kieler.kiml.graphiti.KimlGraphitiUtil;
import de.cau.cs.kieler.kiml.klayoutdata.KInsets;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.klayoutdata.impl.KShapeLayoutImpl;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.ui.diagram.LayoutMapping;
import de.cau.cs.kieler.kiml.util.KimlUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.etrice.ui.behavior.editor.BehaviorEditor;
import org.eclipse.etrice.ui.common.editor.RoomDiagramEditor;
import org.eclipse.etrice.ui.layout.BehaviorLayoutCommand;
import org.eclipse.etrice.ui.layout.ETriceLayoutCommand;
import org.eclipse.etrice.ui.layout.StructureLayoutCommand;
import org.eclipse.gef.EditPart;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.internal.parts.IPictogramElementEditPart;
import org.eclipse.ui.IWorkbenchPart;

public abstract class ETriceDiagramLayoutManager
extends GefDiagramLayoutManager<PictogramElement> {
    private GraphitiLayoutConfig layoutConfig = new GraphitiLayoutConfig();

    public abstract boolean supports(Object var1);

    public Object getAdapter(Object object, Class adapterType) {
        if (adapterType.isAssignableFrom(GraphitiLayoutConfig.class)) {
            return this.layoutConfig;
        }
        if (adapterType.isAssignableFrom(IPictogramElementEditPart.class)) {
            if (object instanceof IPictogramElementEditPart) {
                return object;
            }
            if (object instanceof DiagramEditor) {
                return ((DiagramEditor)object).getGraphicalViewer().getContents();
            }
        } else if (adapterType.isAssignableFrom(EObject.class)) {
            EList businessObjects;
            PictogramElement pe;
            if (object instanceof IPictogramElementEditPart) {
                EList businessObjects2;
                PictogramElement pe2 = ((IPictogramElementEditPart)object).getPictogramElement();
                if (pe2.getLink() != null && !(businessObjects2 = pe2.getLink().getBusinessObjects()).isEmpty()) {
                    return businessObjects2.get(0);
                }
            } else if (object instanceof PictogramElement && (pe = (PictogramElement)object).getLink() != null && !(businessObjects = pe.getLink().getBusinessObjects()).isEmpty()) {
                return businessObjects.get(0);
            }
        } else if (adapterType.isAssignableFrom(PictogramElement.class)) {
            EditPart contents;
            if (object instanceof PictogramElement) {
                return object;
            }
            if (object instanceof IPictogramElementEditPart) {
                return ((IPictogramElementEditPart)object).getPictogramElement();
            }
            if (object instanceof DiagramEditor && (contents = ((DiagramEditor)object).getGraphicalViewer().getContents()) instanceof IPictogramElementEditPart) {
                return ((IPictogramElementEditPart)contents).getPictogramElement();
            }
        } else if (adapterType.isAssignableFrom(TransactionalEditingDomain.class)) {
            if (object instanceof DiagramEditor) {
                return ((DiagramEditor)object).getEditingDomain();
            }
            if (object instanceof IPictogramElementEditPart) {
                return ((IPictogramElementEditPart)object).getConfigurationProvider().getDiagramBehavior().getEditingDomain();
            }
        }
        if (object instanceof IAdaptable) {
            return ((IAdaptable)object).getAdapter(adapterType);
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return new Class[]{PictogramElement.class};
    }

    protected void transferLayout(LayoutMapping<PictogramElement> mapping) {
        DiagramEditor diagramEditor = (DiagramEditor)mapping.getProperty(KimlGraphitiUtil.DIAGRAM_EDITOR);
        ETriceLayoutCommand command = null;
        command = diagramEditor instanceof BehaviorEditor ? new BehaviorLayoutCommand(diagramEditor.getEditingDomain(), diagramEditor.getDiagramTypeProvider().getFeatureProvider()) : new StructureLayoutCommand(diagramEditor.getEditingDomain(), diagramEditor.getDiagramTypeProvider().getFeatureProvider());
        for (Map.Entry entry : mapping.getGraphMap().entrySet()) {
            command.add((KGraphElement)entry.getKey(), (PictogramElement)entry.getValue());
        }
        mapping.setProperty(KimlGraphitiUtil.LAYOUT_COMMAND, (Object)command);
    }

    protected void applyLayout(LayoutMapping<PictogramElement> mapping) {
        TransactionalEditingDomain editingDomain = ((DiagramEditor)mapping.getProperty(KimlGraphitiUtil.DIAGRAM_EDITOR)).getEditingDomain();
        editingDomain.getCommandStack().execute((Command)mapping.getProperty(KimlGraphitiUtil.LAYOUT_COMMAND));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LayoutMapping<PictogramElement> buildLayoutGraph(IWorkbenchPart workbenchPart, Object diagramPart) {
        LayoutMapping mapping = new LayoutMapping((IAdapterFactory)this);
        mapping.setProperty(KimlGraphitiUtil.CONNECTIONS, new LinkedList());
        mapping.setProperty(KimlGraphitiUtil.STATIC_CONFIG, (Object)new VolatileLayoutConfig());
        if (workbenchPart instanceof RoomDiagramEditor) {
            mapping.setProperty(KimlGraphitiUtil.DIAGRAM_EDITOR, (Object)((RoomDiagramEditor)workbenchPart));
        }
        EditPart layoutRootPart = null;
        if (diagramPart instanceof IPictogramElementEditPart) {
            layoutRootPart = (EditPart)diagramPart;
        } else if (mapping.getProperty(KimlGraphitiUtil.DIAGRAM_EDITOR) != null) {
            layoutRootPart = ((DiagramEditor)mapping.getProperty(KimlGraphitiUtil.DIAGRAM_EDITOR)).getGraphicalViewer().getContents();
        }
        if (!(layoutRootPart instanceof IPictogramElementEditPart)) {
            throw new UnsupportedOperationException("Not supported by this layout manager: Workbench part " + workbenchPart + ", Edit part " + diagramPart);
        }
        PictogramElement element = ((IPictogramElementEditPart)layoutRootPart).getPictogramElement();
        mapping.setParentElement((Object)element);
        if (element instanceof Diagram) {
            KNode diagramNode = KimlUtil.createInitializedNode();
            KShapeLayout shapeLayout = (KShapeLayout)diagramNode.getData(KShapeLayout.class);
            GraphicsAlgorithm ga = element.getGraphicsAlgorithm();
            shapeLayout.setPos((float)ga.getX(), (float)ga.getY());
            shapeLayout.setSize((float)ga.getWidth(), (float)ga.getHeight());
            mapping.getGraphMap().put((Object)diagramNode, (Object)element);
            this.buildLayoutGraphForBoundingBox((LayoutMapping<PictogramElement>)mapping, (Diagram)element, diagramNode, true);
            mapping.setLayoutGraph(diagramNode);
        } else if (element instanceof Shape) {
            if (this.isTopLevelBoundingBox((Shape)element)) {
                mapping.setLayoutGraph(this.buildAllLevels((LayoutMapping<PictogramElement>)mapping, (Shape)element, null));
            } else {
                KGraphElement internalKGraphElement = this.createKGraphElementFromShape((LayoutMapping<PictogramElement>)mapping, null, (Shape)element);
                if (!(internalKGraphElement instanceof KNode) || this.isInternalPort((Shape)element)) throw new IllegalArgumentException("The seleted element cannot be lay-outed separately");
                for (Shape childShape : ((ContainerShape)element).getChildren()) {
                    this.createKGraphElementFromShape((LayoutMapping<PictogramElement>)mapping, internalKGraphElement, childShape);
                }
                mapping.setLayoutGraph((KNode)internalKGraphElement);
            }
        } else if (element instanceof FreeFormConnection) {
            throw new IllegalArgumentException("A connection cannot be layouted separately");
        }
        for (Connection entry : (List)mapping.getProperty(KimlGraphitiUtil.CONNECTIONS)) {
            KimlGraphitiUtil.createEdge((LayoutMapping)mapping, (Connection)entry);
        }
        mapping.getLayoutConfigs().add((ILayoutConfig)mapping.getProperty(KimlGraphitiUtil.STATIC_CONFIG));
        mapping.getLayoutConfigs().add(this.layoutConfig);
        return mapping;
    }

    protected abstract void buildLayoutGraphForBoundingBox(LayoutMapping<PictogramElement> var1, Diagram var2, KNode var3, boolean var4);

    protected KNode buildAllLevels(LayoutMapping<PictogramElement> mapping, Shape topLevelBoundingBox, KNode diagramNode) {
        KNode topLevelBoundingBoxNode = this.createNode(mapping, diagramNode, topLevelBoundingBox);
        for (Shape secondLevelShape : ((ContainerShape)topLevelBoundingBox).getChildren()) {
            KGraphElement secondLevelKGraphElement = this.createKGraphElementFromShape(mapping, (KGraphElement)topLevelBoundingBoxNode, secondLevelShape);
            if (!(secondLevelKGraphElement instanceof KNode)) continue;
            for (Shape thirdLevelShape : ((ContainerShape)secondLevelShape).getChildren()) {
                this.createKGraphElementFromShape(mapping, secondLevelKGraphElement, thirdLevelShape);
            }
            if (this.isInternalPort(secondLevelShape)) continue;
            this.setNodeLayoutOptions(mapping, (KNode)secondLevelKGraphElement, secondLevelShape);
        }
        this.setNodeLayoutOptions(mapping, topLevelBoundingBoxNode, topLevelBoundingBox);
        return topLevelBoundingBoxNode;
    }

    private KGraphElement createKGraphElementFromShape(LayoutMapping<PictogramElement> mapping, KGraphElement parent, Shape shape) {
        GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
        if (ga instanceof AbstractText) {
            KInsets parentInsets = (KInsets)((KShapeLayout)parent.getData(KShapeLayout.class)).getProperty(GraphitiLayoutCommand.INVIS_INSETS);
            assert (parentInsets != null) : "There must be an invisible insets attached to all ports and nodes(except diagramNode)";
            return KimlGraphitiUtil.createLabel((KLabeledGraphElement)((KLabeledGraphElement)parent), (AbstractText)((AbstractText)ga), (float)(-parentInsets.getLeft()), (float)(-parentInsets.getTop()));
        }
        if (shape instanceof ContainerShape) {
            if (this.isBoundaryPort(shape)) {
                return this.createPort(mapping, (KNode)parent, shape);
            }
            return this.createNode(mapping, (KNode)parent, shape);
        }
        return null;
    }

    protected abstract KNode createNode(LayoutMapping<PictogramElement> var1, KNode var2, Shape var3);

    protected KPort createPort(LayoutMapping<PictogramElement> mapping, KNode parentNode, Shape shape) {
        KPort port = KimlUtil.createInitializedPort();
        port.setNode(parentNode);
        this.setCurrentPositionAndSize(mapping, parentNode, (KGraphElement)port, shape);
        mapping.getGraphMap().put((Object)port, (Object)((PictogramElement)shape.getAnchors().get(0)));
        Shape portLabelShape = (Shape)((ContainerShape)shape).getChildren().get(0);
        this.createKGraphElementFromShape(mapping, (KGraphElement)port, portLabelShape);
        for (Anchor anchor : shape.getAnchors()) {
            ((List)mapping.getProperty(KimlGraphitiUtil.CONNECTIONS)).addAll(anchor.getOutgoingConnections());
        }
        return port;
    }

    protected void setCurrentPositionAndSize(LayoutMapping<PictogramElement> mapping, KNode parentNode, KGraphElement kelem, Shape shape) {
        KInsets parentInsets;
        VolatileLayoutConfig staticConfig = (VolatileLayoutConfig)mapping.getProperty(KimlGraphitiUtil.STATIC_CONFIG);
        KShapeLayout shapeLayout = (KShapeLayout)kelem.getData(KShapeLayout.class);
        GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
        KInsets shapeInsets = KimlGraphitiUtil.calcInsets((GraphicsAlgorithm)ga);
        shapeLayout.setProperty(GraphitiLayoutCommand.INVIS_INSETS, (Object)shapeInsets);
        staticConfig.setValue(GraphitiLayoutCommand.INVIS_INSETS, (Object)kelem, LayoutContext.GRAPH_ELEM, (Object)shapeInsets);
        KInsets kInsets = parentInsets = parentNode == null ? null : (KInsets)((KShapeLayout)parentNode.getData(KShapeLayout.class)).getProperty(GraphitiLayoutCommand.INVIS_INSETS);
        if (parentInsets == null) {
            shapeLayout.setPos((float)ga.getX() + shapeInsets.getLeft(), (float)ga.getY() + shapeInsets.getTop());
        } else {
            shapeLayout.setPos((float)ga.getX() + shapeInsets.getLeft() - parentInsets.getLeft(), (float)ga.getY() + shapeInsets.getTop() - parentInsets.getTop());
        }
        shapeLayout.setSize((float)ga.getWidth() - shapeInsets.getLeft() - shapeInsets.getRight(), (float)ga.getHeight() - shapeInsets.getTop() - shapeInsets.getBottom());
        ((KShapeLayoutImpl)shapeLayout).resetModificationFlag();
    }

    protected void setNodeLayoutOptions(LayoutMapping<PictogramElement> mapping, KNode node, Shape shape) {
        float labelWidth = 0.0f;
        float labelHeight = 0.0f;
        if (!node.getLabels().isEmpty()) {
            KShapeLayout labelLayout = (KShapeLayout)((KLabel)node.getLabels().get(0)).getData(KShapeLayout.class);
            labelWidth = labelLayout.getWidth();
            labelHeight = labelLayout.getHeight();
        }
        VolatileLayoutConfig staticConfig = (VolatileLayoutConfig)mapping.getProperty(KimlGraphitiUtil.STATIC_CONFIG);
        Dimension defaultSize = this.getDefaultSize(shape);
        staticConfig.setValue(LayoutOptions.MIN_WIDTH, (Object)node, LayoutContext.GRAPH_ELEM, (Object)Float.valueOf((float)defaultSize.width() + labelWidth));
        staticConfig.setValue(LayoutOptions.MIN_HEIGHT, (Object)node, LayoutContext.GRAPH_ELEM, (Object)Float.valueOf((float)defaultSize.height() + labelHeight));
    }

    public abstract boolean isBoundaryPort(Shape var1);

    public abstract boolean isInternalPort(Shape var1);

    public abstract boolean isTopLevelBoundingBox(Shape var1);

    protected abstract Dimension getDefaultSize(Shape var1);
}

