/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.editor;

import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.ui.structure.editor.StructureEditor;
import org.eclipse.etrice.ui.structure.support.context.PositionUpdateContext;
import org.eclipse.etrice.ui.structure.support.provider.SuperDiagramPositionProvider;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.editor.DefaultRefreshBehavior;

public class DiagramRefreshBehavior
extends DefaultRefreshBehavior {
    private StructureEditor structureEditor;

    public DiagramRefreshBehavior(StructureEditor structureEditor) {
        super(structureEditor.getDiagramBehavior());
        this.structureEditor = structureEditor;
    }

    protected void handleAutoUpdateAtStartup() {
        IDiagramTypeProvider diagramTypeProvider = this.diagramBehavior.getDiagramTypeProvider();
        if (diagramTypeProvider.isAutoUpdateAtStartup()) {
            StructureClass sc = this.structureEditor.getStructureClass();
            Diagram diagram = diagramTypeProvider.getDiagram();
            if (sc instanceof ActorClass && ((ActorClass)sc).getBase() != null) {
                this.autoUpdate((IUpdateContext)new PositionUpdateContext((PictogramElement)diagram, new SuperDiagramPositionProvider(sc)));
            } else {
                this.autoUpdate((IUpdateContext)new UpdateContext((PictogramElement)diagram));
            }
        }
    }

    protected void handleAutoUpdateAtReset() {
        super.handleAutoUpdateAtReset();
    }

    public void autoUpdate(IUpdateContext updateCtx) {
        IDiagramTypeProvider diagramTypeProvider = this.diagramBehavior.getDiagramTypeProvider();
        IFeatureProvider featureProvider = diagramTypeProvider.getFeatureProvider();
        featureProvider.updateIfPossible(updateCtx);
        this.refresh();
    }
}

