/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.graphviz.layouter;

import de.cau.cs.kieler.core.WrappedException;
import de.cau.cs.kieler.core.alg.IKielerProgressMonitor;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.util.ForkedOutputStream;
import de.cau.cs.kieler.core.util.ForwardingInputStream;
import de.cau.cs.kieler.kiml.AbstractLayoutProvider;
import de.cau.cs.kieler.kiml.graphviz.dot.dot.GraphvizModel;
import de.cau.cs.kieler.kiml.graphviz.dot.transform.Command;
import de.cau.cs.kieler.kiml.graphviz.dot.transform.DotExporter;
import de.cau.cs.kieler.kiml.graphviz.dot.transform.DotHandler;
import de.cau.cs.kieler.kiml.graphviz.layouter.GraphvizException;
import de.cau.cs.kieler.kiml.graphviz.layouter.GraphvizTool;
import de.cau.cs.kieler.kiml.klayoutdata.KShapeLayout;
import de.cau.cs.kieler.kiml.options.LayoutOptions;
import de.cau.cs.kieler.kiml.service.TransformationService;
import de.cau.cs.kieler.kiml.service.formats.ITransformationHandler;
import de.cau.cs.kieler.kiml.service.formats.TransformationData;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;

public class GraphvizLayoutProvider
extends AbstractLayoutProvider {
    private static int serialCallNo = 0;
    private Command command = Command.INVALID;
    private GraphvizTool graphvizTool;
    private DotHandler dotHandler;
    private int myCallNo;

    public void initialize(String parameter) {
        this.command = Command.valueOf((String)parameter);
        this.graphvizTool = new GraphvizTool(this.command);
        ITransformationHandler handler = TransformationService.getInstance().getFormatData("org.graphviz.dot").getHandler();
        if (!(handler instanceof DotHandler)) {
            throw new IllegalStateException("The Graphviz Dot language support is not available.");
        }
        this.dotHandler = (DotHandler)handler;
    }

    public void dispose() {
        this.graphvizTool.cleanup(GraphvizTool.Cleanup.STOP);
    }

    public void doLayout(KNode parentNode, IKielerProgressMonitor progressMonitor) {
        if (this.command == Command.INVALID) {
            throw new IllegalStateException("The Graphviz layout provider is not initialized.");
        }
        progressMonitor.begin("Graphviz layout (" + this.command + ")", 2.0f);
        if (parentNode.getChildren().isEmpty()) {
            progressMonitor.done();
            return;
        }
        boolean debugMode = (Boolean)((KShapeLayout)parentNode.getData(KShapeLayout.class)).getProperty(LayoutOptions.DEBUG_MODE);
        this.myCallNo = ++serialCallNo;
        this.graphvizTool.initialize();
        XtextResourceSet resourceSet = (XtextResourceSet)this.dotHandler.createResourceSet();
        TransformationData transData = new TransformationData();
        transData.setSourceGraph((Object)parentNode);
        transData.setProperty(DotExporter.USE_EDGE_IDS, (Object)true);
        transData.setProperty(DotExporter.FULL_EXPORT, (Object)false);
        transData.setProperty(DotExporter.COMMAND, (Object)this.command);
        this.dotHandler.getExporter().transform(transData);
        GraphvizModel graphvizInput = (GraphvizModel)transData.getTargetGraphs().get(0);
        this.writeDotGraph(graphvizInput, progressMonitor.subTask(1.0f), debugMode, resourceSet);
        try {
            GraphvizModel graphvizOutput = this.readDotGraph(progressMonitor.subTask(1.0f), debugMode, resourceSet);
            transData.getTargetGraphs().set(0, graphvizOutput);
            this.dotHandler.getExporter().transferLayout(transData);
        }
        finally {
            this.graphvizTool.cleanup(GraphvizTool.Cleanup.NORMAL);
            progressMonitor.done();
        }
    }

    private void writeDotGraph(GraphvizModel graphvizModel, IKielerProgressMonitor monitor, boolean debugMode, XtextResourceSet resourceSet) {
        monitor.begin("Serialize model", 1.0f);
        OutputStream outputStream = this.graphvizTool.input();
        FileOutputStream debugStream = null;
        if (debugMode) {
            try {
                String path = System.getProperty("user.home");
                path = path.endsWith(File.separator) ? String.valueOf(path) + "tmp" + File.separator + "graphviz" : String.valueOf(path) + File.separator + "tmp" + File.separator + "graphviz";
                new File(path).mkdirs();
                debugStream = new FileOutputStream(new File(String.valueOf(path) + File.separator + this.debugFileBase() + "-in.dot"));
                outputStream = new ForkedOutputStream(outputStream, (OutputStream)debugStream);
            }
            catch (Exception exception) {
                System.out.println("GraphvizLayouter: Could not initialize debug output: " + exception.getMessage());
            }
        }
        try {
            try {
                XtextResource resource = (XtextResource)resourceSet.createResource(URI.createURI((String)"output.graphviz_dot"));
                resource.getContents().add((Object)graphvizModel);
                resource.save(outputStream, null);
                outputStream.write(10);
                outputStream.flush();
            }
            catch (IOException exception) {
                this.graphvizTool.cleanup(GraphvizTool.Cleanup.ERROR);
                throw new WrappedException((Throwable)exception, "Failed to send the graph to Graphviz.");
            }
        }
        catch (Throwable throwable) {
            if (debugStream != null) {
                try {
                    debugStream.close();
                }
                catch (IOException iOException) {}
            }
            monitor.done();
            throw throwable;
        }
        if (debugStream != null) {
            try {
                debugStream.close();
            }
            catch (IOException iOException) {}
        }
        monitor.done();
    }

    private GraphvizModel readDotGraph(IKielerProgressMonitor monitor, boolean debugMode, XtextResourceSet resourceSet) {
        monitor.begin("Parse output", 1.0f);
        InputStream inputStream = this.graphvizTool.output();
        FileOutputStream debugStream = null;
        if (debugMode) {
            try {
                String path = System.getProperty("user.home");
                path = path.endsWith(File.separator) ? String.valueOf(path) + "tmp" + File.separator + "graphviz" : String.valueOf(path) + File.separator + "tmp" + File.separator + "graphviz";
                new File(path).mkdirs();
                debugStream = new FileOutputStream(new File(String.valueOf(path) + File.separator + this.debugFileBase() + "-out.dot"));
                inputStream = new ForwardingInputStream(inputStream, (OutputStream)debugStream);
            }
            catch (Exception exception) {
                System.out.println("GraphvizLayouter: Could not initialize debug output: " + exception.getMessage());
            }
        }
        XtextResource resource = (XtextResource)resourceSet.createResource(URI.createURI((String)"input.graphviz_dot"));
        try {
            try {
                resource.load(inputStream, null);
            }
            catch (IOException exception) {
                this.graphvizTool.cleanup(GraphvizTool.Cleanup.ERROR);
                throw new WrappedException((Throwable)exception, "Failed to read Graphviz output.");
            }
        }
        catch (Throwable throwable) {
            if (debugStream != null) {
                try {
                    debugStream.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (debugStream != null) {
            try {
                debugStream.close();
            }
            catch (IOException iOException) {}
        }
        if (!resource.getErrors().isEmpty()) {
            StringBuilder errorString = new StringBuilder("Errors in Graphviz output:");
            for (Resource.Diagnostic diagnostic : resource.getErrors()) {
                errorString.append("\n" + diagnostic.getLine() + ": " + diagnostic.getMessage());
            }
            this.graphvizTool.cleanup(GraphvizTool.Cleanup.ERROR);
            throw new GraphvizException(errorString.toString());
        }
        GraphvizModel graphvizModel = (GraphvizModel)resource.getParseResult().getRootASTElement();
        if (graphvizModel == null || graphvizModel.getGraphs().isEmpty()) {
            this.graphvizTool.cleanup(GraphvizTool.Cleanup.ERROR);
            throw new GraphvizException("No output from the Graphviz process. Try increasing the timeout value in the preferences (KIELER / Layout / Graphviz).");
        }
        monitor.done();
        return graphvizModel;
    }

    private String debugFileBase() {
        String no = Integer.toString(this.myCallNo);
        switch (no.length()) {
            case 1: {
                return "debug00" + no;
            }
            case 2: {
                return "debug0" + no;
            }
        }
        return "debug" + no;
    }
}

