/*
 * Decompiled with CFR 0.152.
 */
package de.cau.cs.kieler.kiml.service;

import de.cau.cs.kieler.kiml.service.formats.AbstractEmfHandler;
import de.cau.cs.kieler.kiml.service.formats.GraphFormatData;
import de.cau.cs.kieler.kiml.service.formats.ITransformationHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TransformationService {
    protected static final String EXTP_ID_GRAPH_TRANS = "de.cau.cs.kieler.kiml.service.graphTransformers";
    protected static final String ELEMENT_HANDLER = "handler";
    protected static final String ATTRIBUTE_CLASS = "class";
    protected static final String ATTRIBUTE_DESCRIPTION = "description";
    protected static final String ATTRIBUTE_EXTENSIONS = "extensions";
    protected static final String ATTRIBUTE_ID = "id";
    protected static final String ATTRIBUTE_NAME = "name";
    private static TransformationService instance;
    private final Map<String, GraphFormatData> graphFormatMap = new LinkedHashMap<String, GraphFormatData>();
    private final Map<String, GraphFormatData> formatSuffixMap = new HashMap<String, GraphFormatData>();

    public static TransformationService getInstance() {
        return instance;
    }

    protected TransformationService() {
        instance = this;
    }

    protected abstract void reportError(String var1, IConfigurationElement var2, String var3, Throwable var4);

    protected abstract void reportError(CoreException var1);

    protected final void loadGraphTransExtensions() {
        IConfigurationElement[] extensions;
        IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTP_ID_GRAPH_TRANS);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (ELEMENT_HANDLER.equals(element.getName())) {
                try {
                    ITransformationHandler handler = (ITransformationHandler)element.createExecutableExtension(ATTRIBUTE_CLASS);
                    String id = element.getAttribute(ATTRIBUTE_ID);
                    String name = element.getAttribute(ATTRIBUTE_NAME);
                    if (handler == null) {
                        this.reportError(EXTP_ID_GRAPH_TRANS, element, ATTRIBUTE_CLASS, null);
                    } else if (id == null || id.length() == 0) {
                        this.reportError(EXTP_ID_GRAPH_TRANS, element, ATTRIBUTE_ID, null);
                    } else if (name == null || name.length() == 0) {
                        this.reportError(EXTP_ID_GRAPH_TRANS, element, ATTRIBUTE_NAME, null);
                    } else {
                        GraphFormatData formatData = new GraphFormatData();
                        formatData.setId(id);
                        formatData.setName(name);
                        formatData.setDescription(element.getAttribute(ATTRIBUTE_DESCRIPTION));
                        formatData.setHandler(handler);
                        String extElem = element.getAttribute(ATTRIBUTE_EXTENSIONS);
                        if (extElem != null) {
                            StringTokenizer tokenizer = new StringTokenizer(extElem, ",");
                            String[] extArray = new String[tokenizer.countTokens()];
                            int i = 0;
                            while (i < extArray.length) {
                                extArray[i] = tokenizer.nextToken();
                                ++i;
                            }
                            formatData.setExtensions(extArray);
                        }
                        this.graphFormatMap.put(id, formatData);
                        if (handler instanceof AbstractEmfHandler) {
                            if (formatData.getExtensions() == null || formatData.getExtensions().length == 0) {
                                this.reportError(EXTP_ID_GRAPH_TRANS, element, ATTRIBUTE_EXTENSIONS, null);
                            } else {
                                String extension = formatData.getExtensions()[0];
                                ((AbstractEmfHandler)handler).setFileExtension(extension);
                            }
                        }
                    }
                }
                catch (CoreException exception) {
                    this.reportError(exception);
                }
            }
            ++n2;
        }
    }

    public GraphFormatData getFormatData(String id) {
        return this.graphFormatMap.get(id);
    }

    public Collection<GraphFormatData> getFormatData() {
        return Collections.unmodifiableCollection(this.graphFormatMap.values());
    }

    public final GraphFormatData getFormatDataBySuffix(String suffix) {
        GraphFormatData data = this.graphFormatMap.get(suffix);
        if (data == null && (data = this.formatSuffixMap.get(suffix)) == null) {
            for (GraphFormatData d : this.graphFormatMap.values()) {
                String id = d.getId();
                if (id.endsWith(suffix) && (suffix.length() == id.length() || id.charAt(id.length() - suffix.length() - 1) == '.')) {
                    this.formatSuffixMap.put(suffix, d);
                    return d;
                }
                String[] stringArray = d.getExtensions();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String ext = stringArray[n2];
                    if (ext.equals(suffix)) {
                        this.formatSuffixMap.put(suffix, d);
                        return d;
                    }
                    ++n2;
                }
            }
        }
        return data;
    }
}

