/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.abstractexec.behavior;

import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.abstractexec.behavior.Activator;
import org.eclipse.etrice.abstractexec.behavior.HandledMessage;
import org.eclipse.etrice.abstractexec.behavior.ProposalGenerator;
import org.eclipse.etrice.abstractexec.behavior.SemanticsCheck;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.base.NullDiagnostician;
import org.eclipse.etrice.core.genmodel.base.NullLogger;
import org.eclipse.etrice.core.genmodel.builder.GeneratorModelBuilder;
import org.eclipse.etrice.core.genmodel.etricegen.ActiveTrigger;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.IDiagnostician;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.GeneralProtocolClass;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.MessageFromIf;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.Trigger;
import org.eclipse.etrice.core.room.TriggeredTransition;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.core.validation.IRoomValidator;
import org.eclipse.etrice.core.validation.ValidationUtil;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public class AbstractExecutionValidator
implements IRoomValidator {
    public static final String DIAG_CODE_VIOLATION_TRIGGER = "etrice.violation_trigger";
    public static final String DIAG_CODE_VIOLATION_MESSAGESEND = "etrice.violation_messagesend";
    public static final String DIAG_CODE_MISSING_TRIGGER = "etrice.receive_message";
    public static final String DIAG_CODE_MISSING_MESSAGESEND = "etrice.send_message";
    private static boolean traceExec = false;
    private static String traceName = "";

    static {
        if (Activator.getDefault().isDebugging()) {
            String value = Platform.getDebugOption((String)"org.eclipse.etrice.abstractexec.behavior/trace/abstractexec");
            if (value != null && value.equalsIgnoreCase(Boolean.toString(true))) {
                traceExec = true;
            }
            traceName = Platform.getDebugOption((String)"org.eclipse.etrice.abstractexec.behavior/trace/abstractexec/name");
        }
    }

    public void validate(EObject object, ValidationMessageAcceptor messageAcceptor) {
        if (!(object instanceof ActorClass)) {
            return;
        }
        ActorClass ac = (ActorClass)object;
        if (traceExec) {
            if (!traceName.isEmpty() && !ac.getName().equals(traceName)) {
                return;
            }
            System.out.println("AbstractExecutionValidator checking class " + ac.getName());
        }
        if (ac.isAbstract()) {
            return;
        }
        if (ValidationUtil.isCircularClassHierarchy((ActorClass)ac)) {
            return;
        }
        boolean oneProtocolsWithSemantics = false;
        List ifItems = RoomHelpers.getAllInterfaceItems((ActorClass)ac);
        for (InterfaceItem item : ifItems) {
            GeneralProtocolClass pc = item.getGeneralProtocol();
            if (!(pc instanceof ProtocolClass)) continue;
            if (traceExec) {
                System.out.println("  Checking protocolClass " + pc.getName() + " for semantics");
            }
            if (((ProtocolClass)pc).getSemantics() == null) continue;
            oneProtocolsWithSemantics = true;
            if (!traceExec) break;
            System.out.println("  Will execute because semantics defined for " + pc.getName());
            break;
        }
        if (oneProtocolsWithSemantics) {
            NullDiagnostician diagnostician;
            GeneratorModelBuilder builder;
            ExpandedActorClass xpac;
            if (traceExec) {
                System.out.println("  Reached where at least one interface items has semantics");
            }
            if ((xpac = (builder = new GeneratorModelBuilder((ILogger)new NullLogger(), (IDiagnostician)(diagnostician = new NullDiagnostician()))).createExpandedActorClass(ac)) != null && !diagnostician.isFailed()) {
                SemanticsCheck checker = new SemanticsCheck(xpac);
                checker.checkSemantics();
                if (traceExec) {
                    System.out.println("  Rule checking for " + xpac.getActorClass().getName() + " is over");
                }
                TreeIterator it = xpac.getStateMachine().eAllContents();
                while (it.hasNext()) {
                    EObject obj = (EObject)it.next();
                    if (obj instanceof State) {
                        ProposalGenerator propGen = new ProposalGenerator(xpac, checker);
                        State st = (State)obj;
                        propGen.createProposals(st);
                        this.createMarkersForProposals(propGen, messageAcceptor, st, xpac);
                    }
                    if (!(obj instanceof StateGraphItem)) continue;
                    StateGraphItem item = (StateGraphItem)obj;
                    this.createMarkersForWarnings(checker, messageAcceptor, item, xpac);
                }
                if (traceExec) {
                    System.out.println("AbstractExecutionValidator done checking class " + ac.getName());
                }
            } else if (traceExec) {
                System.out.println("No checking because internal generation failed");
            }
        }
    }

    public String getName() {
        return "Abstract FSM Execution Validator";
    }

    public String getDescription() {
        return "This validator checks the state machine against the protocol semantics of its ports.";
    }

    private void createMarkersForProposals(ProposalGenerator propGen, ValidationMessageAcceptor messageAcceptor, State st, ExpandedActorClass xpac) {
        List<MessageFromIf> incoming = propGen.getIncomingProposals();
        EObject orig = xpac.getOrig((EObject)st);
        EObject container = orig.eContainer();
        int idx = ((List)container.eGet(orig.eContainingFeature())).indexOf(orig);
        for (MessageFromIf msg : incoming) {
            messageAcceptor.acceptWarning("State should handle the message " + msg.getMessage().getName() + " from port " + msg.getFrom().getName() + " ", container, orig.eContainingFeature(), idx, DIAG_CODE_MISSING_TRIGGER, new String[]{st.getName(), msg.getMessage().getName(), msg.getFrom().getName()});
        }
        List<MessageFromIf> outgoing = propGen.getOutgoingProposals();
        for (MessageFromIf msg : outgoing) {
            messageAcceptor.acceptInfo("State should send the message " + msg.getMessage().getName() + " to port " + msg.getFrom().getName() + " ", container, orig.eContainingFeature(), idx, DIAG_CODE_MISSING_MESSAGESEND, new String[]{st.getName(), msg.getMessage().getName(), msg.getFrom().getName()});
        }
    }

    private void createMarkersForWarnings(SemanticsCheck checker, ValidationMessageAcceptor messageAcceptor, StateGraphItem item, ExpandedActorClass xpac) {
        List<HandledMessage> warningList = checker.getWarningMsg(item);
        if (traceExec && warningList != null) {
            System.out.println("Messages in the warning list for item " + item.getName());
        }
        if (warningList != null) {
            for (HandledMessage msg : warningList) {
                EObject origin = msg.getOrigin();
                if (origin instanceof ActiveTrigger) {
                    ActiveTrigger trigger = (ActiveTrigger)origin;
                    for (TriggeredTransition trans : trigger.getTransitions()) {
                        TriggeredTransition orig = (TriggeredTransition)xpac.getOrig((EObject)trans);
                        for (Trigger trig : orig.getTriggers()) {
                            for (MessageFromIf mif : trig.getMsgFromIfPairs()) {
                                if (mif.getMessage() != msg.getMsg() || mif.getFrom() != msg.getIfitem()) continue;
                                messageAcceptor.acceptWarning("The message violates the semantic rule", (EObject)trig, mif.eContainingFeature(), trig.getMsgFromIfPairs().indexOf((Object)trig), DIAG_CODE_VIOLATION_TRIGGER, new String[]{trigger.getMsg().getName(), mif.getMessage().getName(), mif.getFrom().getName()});
                            }
                        }
                    }
                    continue;
                }
                if (!(origin instanceof DetailCode)) continue;
                DetailCode dc = (DetailCode)origin;
                EObject orig = xpac.getOrig((EObject)dc);
                messageAcceptor.acceptWarning("The message violates the semantic rule", orig.eContainer(), orig.eContainingFeature(), -1, DIAG_CODE_VIOLATION_MESSAGESEND, new String[]{msg.getMsg().getName(), msg.getIfitem().getName()});
            }
        }
    }
}

