/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.abstractexec.behavior;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.abstractexec.behavior.ActionCodeAnalyzer;
import org.eclipse.etrice.abstractexec.behavior.Activator;
import org.eclipse.etrice.abstractexec.behavior.ActiveRules;
import org.eclipse.etrice.abstractexec.behavior.HandledMessage;
import org.eclipse.etrice.core.genmodel.etricegen.ActiveTrigger;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.room.InitialTransition;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.StateGraphNode;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.TransitionTerminal;
import org.eclipse.etrice.core.room.util.RoomHelpers;

public class SemanticsCheck {
    private Queue<StateGraphNode> queue;
    private Set<StateGraphNode> visited;
    private ExpandedActorClass xpAct;
    private HashMap<StateGraphItem, ActiveRules> mapToRules = new HashMap();
    private ActionCodeAnalyzer codeAnalyzer;
    private HashMap<StateGraphItem, List<HandledMessage>> mapToWarnings = new HashMap();
    private static boolean traceChecks = false;
    private static int traceLevel = 0;
    private static final int TRACE_RESULT = 1;
    private static final int TRACE_DETAILS = 2;

    static {
        if (Activator.getDefault().isDebugging()) {
            String value = Platform.getDebugOption((String)"org.eclipse.etrice.abstractexec.behavior/trace/checks");
            if (value != null && value.equalsIgnoreCase(Boolean.toString(true))) {
                traceChecks = true;
            }
            if ((value = Platform.getDebugOption((String)"org.eclipse.etrice.abstractexec.behavior/trace/checks/level")) != null) {
                traceLevel = Integer.parseInt(value);
            }
        }
    }

    public SemanticsCheck(ExpandedActorClass xpac) {
        this.queue = new LinkedList<StateGraphNode>();
        this.xpAct = xpac;
        this.visited = new HashSet<StateGraphNode>();
        this.codeAnalyzer = new ActionCodeAnalyzer(xpac.getActorClass());
    }

    public void checkSemantics() {
        if (traceChecks) {
            System.out.println("checkSemantics: check of ActorClass " + this.xpAct.getActorClass().getName());
        }
        StateGraph graph = this.xpAct.getStateMachine();
        ActiveRules localRules = new ActiveRules();
        localRules.buildInitLocalRules(this.xpAct);
        this.addStartingPoints(graph, localRules);
        this.doTraversal();
        if (traceChecks) {
            if (traceLevel >= 1) {
                this.printRules();
            }
            System.out.println("checkSemantics: done with check of ActorClass " + this.xpAct.getActorClass().getName());
        }
    }

    private void addStartingPoints(StateGraph graph, ActiveRules localRules) {
        EList transitions = graph.getTransitions();
        for (Transition trans : transitions) {
            if (!(trans instanceof InitialTransition)) continue;
            StateGraphNode cur = RoomHelpers.getNode((TransitionTerminal)trans.getTo());
            List<HandledMessage> msgList = this.codeAnalyzer.analyze(trans.getAction());
            if (cur instanceof State) {
                msgList.addAll(this.codeAnalyzer.analyze(((State)cur).getEntryCode()));
            }
            List<HandledMessage> wrongMsgList = localRules.consumeMessages(msgList);
            this.addToWarning((StateGraphItem)trans, wrongMsgList);
            boolean rulesChanged = false;
            if (this.mapToRules.containsKey(cur)) {
                rulesChanged = this.mapToRules.get(cur).merge(localRules);
            } else {
                this.mapToRules.put((StateGraphItem)cur, localRules);
                rulesChanged = true;
            }
            if (this.visited.contains(cur) && !rulesChanged) break;
            this.queue.add(cur);
            break;
        }
    }

    private void doTraversal() {
        while (!this.queue.isEmpty()) {
            this.Visit(this.queue.poll());
        }
    }

    private void Visit(StateGraphNode node) {
        this.visited.add(node);
        if (node instanceof State) {
            State st = (State)node;
            if (RoomHelpers.hasDirectSubStructure((State)st)) {
                this.addStartingPoints(st.getSubgraph(), this.mapToRules.get(st));
            } else {
                for (ActiveTrigger trigger : this.xpAct.getActiveTriggers(st)) {
                    if (traceChecks && traceLevel >= 2) {
                        System.out.println("  Currently visiting: " + st.getName());
                        System.out.println("  Trigger: " + trigger.getMsg().getName());
                    }
                    for (Transition trans : trigger.getTransitions()) {
                        StateGraphNode target = RoomHelpers.getNode((TransitionTerminal)trans.getTo());
                        LinkedList<HandledMessage> msgList = new LinkedList<HandledMessage>();
                        msgList.add(new HandledMessage(trigger.getIfitem(), trigger.getMsg(), (EObject)trigger));
                        StateGraph triggerContext = (StateGraph)trans.eContainer();
                        State exitCalled = st;
                        while (true) {
                            msgList.addAll(this.codeAnalyzer.analyze(exitCalled.getExitCode()));
                            if (exitCalled.eContainer() == triggerContext) break;
                            exitCalled = (State)exitCalled.eContainer().eContainer();
                        }
                        msgList.addAll(this.codeAnalyzer.analyze(trans.getAction()));
                        if (target instanceof State) {
                            msgList.addAll(this.codeAnalyzer.analyze(((State)target).getEntryCode()));
                        }
                        ActiveRules tempRule = this.mapToRules.get(node).createCopy();
                        if (traceChecks && traceLevel >= 2) {
                            System.out.println("  Messages in msglist before consuming: ");
                            for (HandledMessage msg : msgList) {
                                System.out.println("  Msg: " + msg.getMsg().getName());
                            }
                        }
                        if (traceChecks && traceLevel >= 2) {
                            System.out.println("  rules before consuming message list : ");
                            this.printRules();
                        }
                        List<HandledMessage> wrongMsgList = tempRule.consumeMessages(msgList);
                        this.addToWarning((StateGraphItem)node, wrongMsgList);
                        if (traceChecks && traceLevel >= 2) {
                            System.out.println("  Messages consumed");
                        }
                        this.addAndMergeRules(target, tempRule);
                        if (!traceChecks || traceLevel < 2) continue;
                        System.out.println("  rules after consuming and merging message list : ");
                        this.printRules();
                    }
                }
            }
        } else {
            for (Transition trans : this.xpAct.getOutgoingTransitions(node)) {
                ActiveRules tempRule = this.mapToRules.get(node).createCopy();
                List<HandledMessage> msgList = this.codeAnalyzer.analyze(trans.getAction());
                StateGraphNode target = RoomHelpers.getNode((TransitionTerminal)trans.getTo());
                if (target instanceof State) {
                    msgList.addAll(this.codeAnalyzer.analyze(((State)target).getEntryCode()));
                }
                List<HandledMessage> wrongMsgList = tempRule.consumeMessages(msgList);
                this.addToWarning((StateGraphItem)node, wrongMsgList);
                this.addAndMergeRules(target, tempRule);
            }
        }
    }

    private void addToWarning(StateGraphItem item, List<HandledMessage> wrongMsgList) {
        if (this.mapToWarnings.containsKey(item)) {
            this.mapToWarnings.get(item).addAll(wrongMsgList);
        } else {
            this.mapToWarnings.put(item, wrongMsgList);
        }
    }

    private void addAndMergeRules(StateGraphNode target, ActiveRules tempRule) {
        boolean rulesChanged = false;
        if (this.mapToRules.containsKey(target)) {
            rulesChanged = this.mapToRules.get(target).merge(tempRule);
        } else {
            this.mapToRules.put((StateGraphItem)target, tempRule);
            rulesChanged = true;
        }
        if (!this.visited.contains(target) || rulesChanged) {
            this.queue.add(target);
        }
    }

    public void printRules() {
        System.out.println("  Current Rules: ");
        System.out.println("    MapToRules size: " + this.mapToRules.size());
        for (StateGraphItem item : this.mapToRules.keySet()) {
            System.out.println("    Rules for " + item.getName() + " : ");
            this.mapToRules.get(item).print();
        }
    }

    public ActiveRules getActiveRules(StateGraphItem item) {
        return this.mapToRules.get(item);
    }

    public List<HandledMessage> getWarningMsg(StateGraphItem item) {
        return this.mapToWarnings.get(item);
    }
}

