/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.etphys.converters;

import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractLexerBasedConverter;
import org.eclipse.xtext.nodemodel.INode;

public class TimeConverter
extends AbstractLexerBasedConverter<Integer> {
    public Integer toValue(String string, INode node) throws ValueConverterException {
        int power;
        String value;
        if (string == null || string.isEmpty()) {
            throw new ValueConverterException("Couldn't convert empty string to time.", node, null);
        }
        int pos = string.indexOf("ns");
        if (pos > 0) {
            value = string.substring(0, pos);
            power = 1;
        } else {
            pos = string.indexOf("us");
            if (pos > 0) {
                value = string.substring(0, pos);
                power = 1000;
            } else {
                pos = string.indexOf("ms");
                if (pos > 0) {
                    value = string.substring(0, pos);
                    power = 1000000;
                } else {
                    pos = string.indexOf("s");
                    if (pos > 0) {
                        value = string.substring(0, pos);
                        power = 1000000000;
                    } else {
                        throw new ValueConverterException("No unit specified with time (s, ms, us or ns).", node, null);
                    }
                }
            }
        }
        try {
            int val = Integer.parseInt(value.trim());
            return Integer.valueOf(val) * power;
        }
        catch (NumberFormatException e) {
            throw new ValueConverterException("Could not parse time value.", node, (Exception)e);
        }
    }

    protected String toEscapedString(Integer value) {
        if (value % 1000 == 0) {
            if (value % 1000000 == 0) {
                if (value % 1000000000 == 0) {
                    return String.valueOf(value / 1000000000) + "s";
                }
                return String.valueOf(value / 1000000) + "ms";
            }
            return String.valueOf(value / 1000) + "us";
        }
        return value + "ns";
    }
}

