/**
 * Copyright (c) 2012 protos software gmbh (http://www.protos.de).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * CONTRIBUTORS:
 * 		Juergen Haug (initial contribution)
 */
package org.eclipse.etrice.core.postprocessing;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.etrice.core.common.postprocessing.PostprocessingHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.GeneratedMetamodel;

/**
 * This post processor adds documentation to the generated EMF model.
 * By intention no {@code null} checks are performed. This way developers
 * find easier if the referenced class, attribute or reference isn't found.
 */
@SuppressWarnings("all")
public class DocuPostprocessor {
  public void process(final GeneratedMetamodel metamodel) {
    final EPackage pckg = metamodel.getEPackage();
    EClass cls = PostprocessingHelpers.getClass(pckg, "RoomModel");
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("The root object for the ROOM model. It gives access to {@link Import imports} and");
    _builder.newLine();
    _builder.append("the {@link SubSystemClass sub system},");
    _builder.newLine();
    _builder.append("{@link ActorClass actor}, {@link ProtocolClass protocol} and");
    _builder.newLine();
    _builder.append("{@link DataClass data} classes defined.");
    _builder.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder.toString());
    EAttribute _attribute = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_1 = new StringConcatenation();
    _builder_1.append("The model name is a dot separated fully qualified name and is");
    _builder_1.newLine();
    _builder_1.append("used to provide a name space. The generators may use that also");
    _builder_1.newLine();
    _builder_1.append("to place the generated code into separate directories.");
    _builder_1.newLine();
    PostprocessingHelpers.setDocumentation(_attribute, _builder_1.toString());
    EReference _reference = PostprocessingHelpers.getReference(cls, "docu");
    StringConcatenation _builder_2 = new StringConcatenation();
    _builder_2.append("This is an optional documentation.");
    _builder_2.newLine();
    PostprocessingHelpers.setDocumentation(_reference, _builder_2.toString());
    EReference _reference_1 = PostprocessingHelpers.getReference(cls, "imports");
    StringConcatenation _builder_3 = new StringConcatenation();
    _builder_3.append("This is a list of all imported models.");
    _builder_3.newLine();
    PostprocessingHelpers.setDocumentation(_reference_1, _builder_3.toString());
    EReference _reference_2 = PostprocessingHelpers.getReference(cls, "primitiveTypes");
    StringConcatenation _builder_4 = new StringConcatenation();
    _builder_4.append("This is a list of all primitive types defined by this model.");
    _builder_4.newLine();
    PostprocessingHelpers.setDocumentation(_reference_2, _builder_4.toString());
    EReference _reference_3 = PostprocessingHelpers.getReference(cls, "externalTypes");
    StringConcatenation _builder_5 = new StringConcatenation();
    _builder_5.append("This is a list of all external types defined by this model.");
    _builder_5.newLine();
    PostprocessingHelpers.setDocumentation(_reference_3, _builder_5.toString());
    EReference _reference_4 = PostprocessingHelpers.getReference(cls, "dataClasses");
    StringConcatenation _builder_6 = new StringConcatenation();
    _builder_6.append("This is a list of all data classes defined by this model.");
    _builder_6.newLine();
    PostprocessingHelpers.setDocumentation(_reference_4, _builder_6.toString());
    EReference _reference_5 = PostprocessingHelpers.getReference(cls, "protocolClasses");
    StringConcatenation _builder_7 = new StringConcatenation();
    _builder_7.append("This is a list of all protocol classes defined by this model.");
    _builder_7.newLine();
    PostprocessingHelpers.setDocumentation(_reference_5, _builder_7.toString());
    EReference _reference_6 = PostprocessingHelpers.getReference(cls, "actorClasses");
    StringConcatenation _builder_8 = new StringConcatenation();
    _builder_8.append("This is a list of all actor classes defined by this model.");
    _builder_8.newLine();
    PostprocessingHelpers.setDocumentation(_reference_6, _builder_8.toString());
    EReference _reference_7 = PostprocessingHelpers.getReference(cls, "subSystemClasses");
    StringConcatenation _builder_9 = new StringConcatenation();
    _builder_9.append("This is a list of all sub system classes defined by this model.");
    _builder_9.newLine();
    PostprocessingHelpers.setDocumentation(_reference_7, _builder_9.toString());
    EReference _reference_8 = PostprocessingHelpers.getReference(cls, "systems");
    StringConcatenation _builder_10 = new StringConcatenation();
    _builder_10.append("This is a list of all logical systems defined by this model.");
    _builder_10.newLine();
    PostprocessingHelpers.setDocumentation(_reference_8, _builder_10.toString());
    EClass _class = PostprocessingHelpers.getClass(pckg, "RoomClass");
    cls = _class;
    StringConcatenation _builder_11 = new StringConcatenation();
    _builder_11.append("This class is the super class of all classes");
    _builder_11.newLine();
    _builder_11.append("of the ROOM class model:");
    _builder_11.newLine();
    _builder_11.append("<ul>");
    _builder_11.newLine();
    _builder_11.append("  ");
    _builder_11.append("<li>{@link DataType}</li>");
    _builder_11.newLine();
    _builder_11.append("  ");
    _builder_11.append("<li>{@link GeneralProtocolClass}</li>");
    _builder_11.newLine();
    _builder_11.append("  ");
    _builder_11.append("<li>{@link StructureClass}</li>");
    _builder_11.newLine();
    _builder_11.append("</ul>");
    _builder_11.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_11.toString());
    EReference _reference_9 = PostprocessingHelpers.getReference(cls, "docu");
    StringConcatenation _builder_12 = new StringConcatenation();
    _builder_12.append("This is an optional documentation.");
    _builder_12.newLine();
    PostprocessingHelpers.setDocumentation(_reference_9, _builder_12.toString());
    EClass _class_1 = PostprocessingHelpers.getClass(pckg, "StructureClass");
    cls = _class_1;
    StringConcatenation _builder_13 = new StringConcatenation();
    _builder_13.append("This class is the super class of the structural classes");
    _builder_13.newLine();
    _builder_13.append("<ul>");
    _builder_13.newLine();
    _builder_13.append("  ");
    _builder_13.append("<li>{@link ActorContainerClass}</li>");
    _builder_13.newLine();
    _builder_13.append("  ");
    _builder_13.append("<li>{@link LogicalSystem}</li>");
    _builder_13.newLine();
    _builder_13.append("</ul>");
    _builder_13.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_13.toString());
    EReference _reference_10 = PostprocessingHelpers.getReference(cls, "annotations");
    StringConcatenation _builder_14 = new StringConcatenation();
    _builder_14.append("This is a list of structure class annotations.");
    _builder_14.newLine();
    PostprocessingHelpers.setDocumentation(_reference_10, _builder_14.toString());
    EReference _reference_11 = PostprocessingHelpers.getReference(cls, "bindings");
    StringConcatenation _builder_15 = new StringConcatenation();
    _builder_15.append("This is a list of structure class bindings.");
    _builder_15.newLine();
    PostprocessingHelpers.setDocumentation(_reference_11, _builder_15.toString());
    EReference _reference_12 = PostprocessingHelpers.getReference(cls, "connections");
    StringConcatenation _builder_16 = new StringConcatenation();
    _builder_16.append("This is a list of structure class connections.");
    _builder_16.newLine();
    PostprocessingHelpers.setDocumentation(_reference_12, _builder_16.toString());
    EClass _class_2 = PostprocessingHelpers.getClass(pckg, "ActorContainerClass");
    cls = _class_2;
    StringConcatenation _builder_17 = new StringConcatenation();
    _builder_17.append("This class is the super class of the structural classes");
    _builder_17.newLine();
    _builder_17.append("<ul>");
    _builder_17.newLine();
    _builder_17.append("  ");
    _builder_17.append("<li>{@link ActorClass}</li>");
    _builder_17.newLine();
    _builder_17.append("  ");
    _builder_17.append("<li>{@link SubSystemClass}</li>");
    _builder_17.newLine();
    _builder_17.append("</ul>");
    _builder_17.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_17.toString());
    EReference _reference_13 = PostprocessingHelpers.getReference(cls, "serviceProvisionPoints");
    StringConcatenation _builder_18 = new StringConcatenation();
    _builder_18.append("This is a list of all interface SPPs.");
    _builder_18.newLine();
    PostprocessingHelpers.setDocumentation(_reference_13, _builder_18.toString());
    EReference _reference_14 = PostprocessingHelpers.getReference(cls, "actorRefs");
    StringConcatenation _builder_19 = new StringConcatenation();
    _builder_19.append("This is a list of all actor refs.");
    _builder_19.newLine();
    PostprocessingHelpers.setDocumentation(_reference_14, _builder_19.toString());
    EReference _reference_15 = PostprocessingHelpers.getReference(cls, "userCode1");
    StringConcatenation _builder_20 = new StringConcatenation();
    _builder_20.append("The user code is treated in a generator dependent way.");
    _builder_20.newLine();
    PostprocessingHelpers.setDocumentation(_reference_15, _builder_20.toString());
    EReference _reference_16 = PostprocessingHelpers.getReference(cls, "userCode2");
    StringConcatenation _builder_21 = new StringConcatenation();
    _builder_21.append("The user code is treated in a generator dependent way.");
    _builder_21.newLine();
    PostprocessingHelpers.setDocumentation(_reference_16, _builder_21.toString());
    EReference _reference_17 = PostprocessingHelpers.getReference(cls, "userCode3");
    StringConcatenation _builder_22 = new StringConcatenation();
    _builder_22.append("The user code is treated in a generator dependent way.");
    _builder_22.newLine();
    PostprocessingHelpers.setDocumentation(_reference_17, _builder_22.toString());
    EClass _class_3 = PostprocessingHelpers.getClass(pckg, "VarDecl");
    cls = _class_3;
    StringConcatenation _builder_23 = new StringConcatenation();
    _builder_23.append("A variable declaration consists of a name and a type.");
    _builder_23.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_23.toString());
    EAttribute _attribute_1 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_24 = new StringConcatenation();
    _builder_24.append("By this name the variable is referred to in the model.");
    _builder_24.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_1, _builder_24.toString());
    EReference _reference_18 = PostprocessingHelpers.getReference(cls, "refType");
    StringConcatenation _builder_25 = new StringConcatenation();
    _builder_25.append("This is the data type of the variable.");
    _builder_25.newLine();
    PostprocessingHelpers.setDocumentation(_reference_18, _builder_25.toString());
    EClass _class_4 = PostprocessingHelpers.getClass(pckg, "RefableType");
    cls = _class_4;
    StringConcatenation _builder_26 = new StringConcatenation();
    _builder_26.append("This is a type with an optional reference attribute.");
    _builder_26.newLine();
    _builder_26.append("If \'ref\' is {@code true} then by reference semantic is chosen.");
    _builder_26.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_26.toString());
    EReference _reference_19 = PostprocessingHelpers.getReference(cls, "type");
    StringConcatenation _builder_27 = new StringConcatenation();
    _builder_27.append("This is the data type.");
    _builder_27.newLine();
    PostprocessingHelpers.setDocumentation(_reference_19, _builder_27.toString());
    EAttribute _attribute_2 = PostprocessingHelpers.getAttribute(cls, "ref");
    StringConcatenation _builder_28 = new StringConcatenation();
    _builder_28.append("If {@code true} then by reference semantics is chosen, by value semantics else.");
    _builder_28.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_2, _builder_28.toString());
    EClass _class_5 = PostprocessingHelpers.getClass(pckg, "DataType");
    cls = _class_5;
    StringConcatenation _builder_29 = new StringConcatenation();
    _builder_29.append("The super class of");
    _builder_29.newLine();
    _builder_29.append("<ul>");
    _builder_29.newLine();
    _builder_29.append("  ");
    _builder_29.append("<li>{@link PrimitiveType}</li>");
    _builder_29.newLine();
    _builder_29.append("  ");
    _builder_29.append("<li>{@link EnumerationType}</li>");
    _builder_29.newLine();
    _builder_29.append("  ");
    _builder_29.append("<li>{@link ComplexType}</li>");
    _builder_29.newLine();
    _builder_29.append("</ul>");
    _builder_29.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_29.toString());
    EClass _class_6 = PostprocessingHelpers.getClass(pckg, "EnumerationType");
    cls = _class_6;
    StringConcatenation _builder_30 = new StringConcatenation();
    _builder_30.append("A sub type of {@link DataType} for enumerations.");
    _builder_30.newLine();
    _builder_30.append("The EnumerationType can be associated with a {@link PrimitiveType} as value type for");
    _builder_30.newLine();
    _builder_30.append("the {@link EnumLiteral}s. It has to contain at least one literal.");
    _builder_30.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_30.toString());
    EReference _reference_20 = PostprocessingHelpers.getReference(cls, "primitiveType");
    StringConcatenation _builder_31 = new StringConcatenation();
    _builder_31.append("The value type of the literals.");
    _builder_31.newLine();
    PostprocessingHelpers.setDocumentation(_reference_20, _builder_31.toString());
    EClass _class_7 = PostprocessingHelpers.getClass(pckg, "EnumLiteral");
    cls = _class_7;
    StringConcatenation _builder_32 = new StringConcatenation();
    _builder_32.append("A literal value of the enumeration.");
    _builder_32.newLine();
    _builder_32.append("It can have a value associated.");
    _builder_32.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_32.toString());
    EAttribute _attribute_3 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_33 = new StringConcatenation();
    _builder_33.append("The name of the literal.");
    _builder_33.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_3, _builder_33.toString());
    EReference _reference_21 = PostprocessingHelpers.getReference(cls, "literal");
    StringConcatenation _builder_34 = new StringConcatenation();
    _builder_34.append("The value of the literal. It is associated with a target type which defaults to");
    _builder_34.newLine();
    _builder_34.append("{@code int} and can be set explicitly using the {@link EnumerationType#getPrimitiveType()}");
    _builder_34.newLine();
    PostprocessingHelpers.setDocumentation(_reference_21, _builder_34.toString());
    EClass _class_8 = PostprocessingHelpers.getClass(pckg, "ComplexType");
    cls = _class_8;
    StringConcatenation _builder_35 = new StringConcatenation();
    _builder_35.append("The super class of");
    _builder_35.newLine();
    _builder_35.append("<ul>");
    _builder_35.newLine();
    _builder_35.append("  ");
    _builder_35.append("<li>{@link DataClass}</li>");
    _builder_35.newLine();
    _builder_35.append("  ");
    _builder_35.append("<li>{@link ExternalType}</li>");
    _builder_35.newLine();
    _builder_35.append("</ul>");
    _builder_35.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_35.toString());
    EClass _class_9 = PostprocessingHelpers.getClass(pckg, "PrimitiveType");
    cls = _class_9;
    StringConcatenation _builder_36 = new StringConcatenation();
    _builder_36.append("A primitive type describes a type like int, char, float");
    _builder_36.newLine();
    _builder_36.append("and can represent the type with a certain precision");
    _builder_36.newLine();
    _builder_36.append("in the target language");
    _builder_36.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_36.toString());
    EAttribute _attribute_4 = PostprocessingHelpers.getAttribute(cls, "type");
    StringConcatenation _builder_37 = new StringConcatenation();
    _builder_37.append("This is one of the basic variable types.");
    _builder_37.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_4, _builder_37.toString());
    EAttribute _attribute_5 = PostprocessingHelpers.getAttribute(cls, "targetName");
    StringConcatenation _builder_38 = new StringConcatenation();
    _builder_38.append("This is the type name in the target language.");
    _builder_38.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_5, _builder_38.toString());
    EAttribute _attribute_6 = PostprocessingHelpers.getAttribute(cls, "castName");
    StringConcatenation _builder_39 = new StringConcatenation();
    _builder_39.append("This (optional) name is used for casts to this type.");
    _builder_39.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_6, _builder_39.toString());
    EAttribute _attribute_7 = PostprocessingHelpers.getAttribute(cls, "defaultValueLiteral");
    StringConcatenation _builder_40 = new StringConcatenation();
    _builder_40.append("This is an optional default value literal.");
    _builder_40.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_7, _builder_40.toString());
    EClass _class_10 = PostprocessingHelpers.getClass(pckg, "ExternalType");
    cls = _class_10;
    StringConcatenation _builder_41 = new StringConcatenation();
    _builder_41.append("An external type is not defined in the ROOM model");
    _builder_41.newLine();
    _builder_41.append("but only referenced. It can not be instantiated.");
    _builder_41.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_41.toString());
    EAttribute _attribute_8 = PostprocessingHelpers.getAttribute(cls, "targetName");
    StringConcatenation _builder_42 = new StringConcatenation();
    _builder_42.append("This is the type name in the target language.");
    _builder_42.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_8, _builder_42.toString());
    EAttribute _attribute_9 = PostprocessingHelpers.getAttribute(cls, "defaultValueLiteral");
    StringConcatenation _builder_43 = new StringConcatenation();
    _builder_43.append("This is an optional default value literal.");
    _builder_43.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_9, _builder_43.toString());
    EClass _class_11 = PostprocessingHelpers.getClass(pckg, "DataClass");
    cls = _class_11;
    StringConcatenation _builder_44 = new StringConcatenation();
    _builder_44.append("Together with {@link ProtocolClass} and {@link ActorClass} one of");
    _builder_44.newLine();
    _builder_44.append("the main class types of the ROOM language.");
    _builder_44.newLine();
    _builder_44.newLine();
    _builder_44.append("<p>");
    _builder_44.newLine();
    _builder_44.append("In ROOM this is the equivalent to a class in Java or C++.");
    _builder_44.newLine();
    _builder_44.append("A data class can be derived from a base class (single");
    _builder_44.newLine();
    _builder_44.append("inheritance), has {@link Attribute}s and {@link Operation}s.");
    _builder_44.newLine();
    _builder_44.append("</p>");
    _builder_44.newLine();
    _builder_44.newLine();
    _builder_44.append("<p>");
    _builder_44.newLine();
    _builder_44.append("Additionally it can be annotated with generator specific");
    _builder_44.newLine();
    _builder_44.append("meaning and user ocde can be added in several places");
    _builder_44.newLine();
    _builder_44.append("(again generator specific).");
    _builder_44.newLine();
    _builder_44.append("</p>");
    _builder_44.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_44.toString());
    EAttribute _attribute_10 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_45 = new StringConcatenation();
    _builder_45.append("The name of the data class by which it is referred to in the model.");
    _builder_45.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_10, _builder_45.toString());
    EReference _reference_22 = PostprocessingHelpers.getReference(cls, "base");
    StringConcatenation _builder_46 = new StringConcatenation();
    _builder_46.append("The base class from which all attributes and operations are inherited.");
    _builder_46.newLine();
    PostprocessingHelpers.setDocumentation(_reference_22, _builder_46.toString());
    EReference _reference_23 = PostprocessingHelpers.getReference(cls, "attributes");
    StringConcatenation _builder_47 = new StringConcatenation();
    _builder_47.append("Attributes are the data members of the data class.");
    _builder_47.newLine();
    PostprocessingHelpers.setDocumentation(_reference_23, _builder_47.toString());
    EReference _reference_24 = PostprocessingHelpers.getReference(cls, "operations");
    StringConcatenation _builder_48 = new StringConcatenation();
    _builder_48.append("Operations are the methods of the data class.");
    _builder_48.newLine();
    PostprocessingHelpers.setDocumentation(_reference_24, _builder_48.toString());
    EReference _reference_25 = PostprocessingHelpers.getReference(cls, "annotations");
    StringConcatenation _builder_49 = new StringConcatenation();
    _builder_49.append("This is a list of data class annotations.");
    _builder_49.newLine();
    PostprocessingHelpers.setDocumentation(_reference_25, _builder_49.toString());
    EReference _reference_26 = PostprocessingHelpers.getReference(cls, "userCode1");
    StringConcatenation _builder_50 = new StringConcatenation();
    _builder_50.append("The user code is treated in a generator dependent way.");
    _builder_50.newLine();
    PostprocessingHelpers.setDocumentation(_reference_26, _builder_50.toString());
    EReference _reference_27 = PostprocessingHelpers.getReference(cls, "userCode2");
    StringConcatenation _builder_51 = new StringConcatenation();
    _builder_51.append("The user code is treated in a generator dependent way.");
    _builder_51.newLine();
    PostprocessingHelpers.setDocumentation(_reference_27, _builder_51.toString());
    EReference _reference_28 = PostprocessingHelpers.getReference(cls, "userCode3");
    StringConcatenation _builder_52 = new StringConcatenation();
    _builder_52.append("The user code is treated in a generator dependent way.");
    _builder_52.newLine();
    PostprocessingHelpers.setDocumentation(_reference_28, _builder_52.toString());
    EClass _class_12 = PostprocessingHelpers.getClass(pckg, "Attribute");
    cls = _class_12;
    StringConcatenation _builder_53 = new StringConcatenation();
    _builder_53.append("An attribute is a named member of a");
    _builder_53.newLine();
    _builder_53.append("<ul>");
    _builder_53.newLine();
    _builder_53.append("  ");
    _builder_53.append("<li>{@link DataClass}</li>");
    _builder_53.newLine();
    _builder_53.append("  ");
    _builder_53.append("<li>{@link ActorClass}</li>");
    _builder_53.newLine();
    _builder_53.append("  ");
    _builder_53.append("<li>{@link PortClass}</li>");
    _builder_53.newLine();
    _builder_53.append("</ul>");
    _builder_53.newLine();
    _builder_53.append("<p>");
    _builder_53.newLine();
    _builder_53.append("It can be of scalar or array type and is of a {@link RefableType}.");
    _builder_53.newLine();
    _builder_53.append("It is possible to assign a default value literal.");
    _builder_53.newLine();
    _builder_53.append("</p>");
    _builder_53.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_53.toString());
    EAttribute _attribute_11 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_54 = new StringConcatenation();
    _builder_54.append("The name of the attribute by which it is referred to in the model.");
    _builder_54.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_11, _builder_54.toString());
    EAttribute _attribute_12 = PostprocessingHelpers.getAttribute(cls, "size");
    StringConcatenation _builder_55 = new StringConcatenation();
    _builder_55.append("The default is scalar ({@code size=1}), values {@code >1} indicate an array.");
    _builder_55.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_12, _builder_55.toString());
    EReference _reference_29 = PostprocessingHelpers.getReference(cls, "type");
    StringConcatenation _builder_56 = new StringConcatenation();
    _builder_56.append("This is the attribute\'s type.");
    _builder_56.newLine();
    PostprocessingHelpers.setDocumentation(_reference_29, _builder_56.toString());
    EAttribute _attribute_13 = PostprocessingHelpers.getAttribute(cls, "defaultValueLiteral");
    StringConcatenation _builder_57 = new StringConcatenation();
    _builder_57.append("This is an optional default value literal.");
    _builder_57.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_13, _builder_57.toString());
    EReference _reference_30 = PostprocessingHelpers.getReference(cls, "docu");
    StringConcatenation _builder_58 = new StringConcatenation();
    _builder_58.append("This is an optional documentation.");
    _builder_58.newLine();
    PostprocessingHelpers.setDocumentation(_reference_30, _builder_58.toString());
    EClass _class_13 = PostprocessingHelpers.getClass(pckg, "Operation");
    cls = _class_13;
    StringConcatenation _builder_59 = new StringConcatenation();
    _builder_59.append("The super class of");
    _builder_59.newLine();
    _builder_59.append("<ul>");
    _builder_59.newLine();
    _builder_59.append("  ");
    _builder_59.append("<li>{@link StandardOperation}</li>");
    _builder_59.newLine();
    _builder_59.append("  ");
    _builder_59.append("<li>{@link PortOperation}</li>");
    _builder_59.newLine();
    _builder_59.append("</ul>");
    _builder_59.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_59.toString());
    EAttribute _attribute_14 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_60 = new StringConcatenation();
    _builder_60.append("The name of the operation by which it is referred to in the model.");
    _builder_60.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_14, _builder_60.toString());
    EReference _reference_31 = PostprocessingHelpers.getReference(cls, "arguments");
    StringConcatenation _builder_61 = new StringConcatenation();
    _builder_61.append("This is a list of arguments for the operation.");
    _builder_61.newLine();
    PostprocessingHelpers.setDocumentation(_reference_31, _builder_61.toString());
    EReference _reference_32 = PostprocessingHelpers.getReference(cls, "returnType");
    StringConcatenation _builder_62 = new StringConcatenation();
    _builder_62.append("This is an optional return type of the operation.");
    _builder_62.newLine();
    PostprocessingHelpers.setDocumentation(_reference_32, _builder_62.toString());
    EReference _reference_33 = PostprocessingHelpers.getReference(cls, "docu");
    StringConcatenation _builder_63 = new StringConcatenation();
    _builder_63.append("This is an optional documentation.");
    _builder_63.newLine();
    PostprocessingHelpers.setDocumentation(_reference_33, _builder_63.toString());
    EReference _reference_34 = PostprocessingHelpers.getReference(cls, "detailCode");
    StringConcatenation _builder_64 = new StringConcatenation();
    _builder_64.append("This is the operation body written in code generator target language.");
    _builder_64.newLine();
    PostprocessingHelpers.setDocumentation(_reference_34, _builder_64.toString());
    EClass _class_14 = PostprocessingHelpers.getClass(pckg, "StandardOperation");
    cls = _class_14;
    StringConcatenation _builder_65 = new StringConcatenation();
    _builder_65.append("The standard form of an operation as used by");
    _builder_65.newLine();
    _builder_65.append("{@link ActorClass} and {@link DataClass}.");
    _builder_65.newLine();
    _builder_65.append("<p>");
    _builder_65.newLine();
    _builder_65.append("If the name coincides with it\'s containing classes name");
    _builder_65.newLine();
    _builder_65.append("then it is a constructor (with void return type).");
    _builder_65.newLine();
    _builder_65.append("If the name additionally is preceded by a tilde ~ then it");
    _builder_65.newLine();
    _builder_65.append("is a destructor.");
    _builder_65.newLine();
    _builder_65.append("</p>");
    _builder_65.newLine();
    _builder_65.append("<p>");
    _builder_65.newLine();
    _builder_65.append("The operation has a list of {@link VarDecl} arguments, an");
    _builder_65.newLine();
    _builder_65.append("optional return {@link RefableType} and a body (specified");
    _builder_65.newLine();
    _builder_65.append("as {@link DetailCode}).");
    _builder_65.newLine();
    _builder_65.append("</p>");
    _builder_65.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_65.toString());
    EAttribute _attribute_15 = PostprocessingHelpers.getAttribute(cls, "destructor");
    StringConcatenation _builder_66 = new StringConcatenation();
    _builder_66.append("If this flag is {@code true} <em>and</em> the name conincides with the class name");
    _builder_66.newLine();
    _builder_66.append("it is treated as a destructor.");
    _builder_66.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_15, _builder_66.toString());
    EClass _class_15 = PostprocessingHelpers.getClass(pckg, "PortOperation");
    cls = _class_15;
    StringConcatenation _builder_67 = new StringConcatenation();
    _builder_67.append("The port operation is very similar to the {@link StandardOperation}");
    _builder_67.newLine();
    _builder_67.append("and is used in the {@link PortClass}. It is not possible to");
    _builder_67.newLine();
    _builder_67.append("define constructor or destructor.");
    _builder_67.newLine();
    _builder_67.append("<p>");
    _builder_67.newLine();
    _builder_67.append("Optionally a {@link Message} can be specified which is sent");
    _builder_67.newLine();
    _builder_67.append("when the method is invoked. For this reason these operations");
    _builder_67.newLine();
    _builder_67.append("are also shown in the \'messages\' dialog of the behavior editor.");
    _builder_67.newLine();
    _builder_67.append("</p>");
    _builder_67.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_67.toString());
    EReference _reference_35 = PostprocessingHelpers.getReference(cls, "sendsMsg");
    StringConcatenation _builder_68 = new StringConcatenation();
    _builder_68.append("This optional reference to a message means that the operation sends a message.");
    _builder_68.newLine();
    PostprocessingHelpers.setDocumentation(_reference_35, _builder_68.toString());
    EClass _class_16 = PostprocessingHelpers.getClass(pckg, "GeneralProtocolClass");
    cls = _class_16;
    StringConcatenation _builder_69 = new StringConcatenation();
    _builder_69.append("The super class of");
    _builder_69.newLine();
    _builder_69.append("<ul>");
    _builder_69.newLine();
    _builder_69.append("  ");
    _builder_69.append("<li>{@link ProtocolClass}</li>");
    _builder_69.newLine();
    _builder_69.append("  ");
    _builder_69.append("<li>{@link CompoundProtocolClass}</li>");
    _builder_69.newLine();
    _builder_69.append("</ul>");
    _builder_69.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_69.toString());
    EReference _reference_36 = PostprocessingHelpers.getReference(cls, "annotations");
    StringConcatenation _builder_70 = new StringConcatenation();
    _builder_70.append("This is a list of protocol class annotations.");
    _builder_70.newLine();
    PostprocessingHelpers.setDocumentation(_reference_36, _builder_70.toString());
    EClass _class_17 = PostprocessingHelpers.getClass(pckg, "ProtocolClass");
    cls = _class_17;
    StringConcatenation _builder_71 = new StringConcatenation();
    _builder_71.append("Together with {@link ActorClass} and {@link DataClass} one of");
    _builder_71.newLine();
    _builder_71.append("the main class types of the ROOM language.");
    _builder_71.newLine();
    _builder_71.append("<p>");
    _builder_71.newLine();
    _builder_71.append("A protocol class specifies a directed {@link Port} interface");
    _builder_71.newLine();
    _builder_71.append("by two sets of {@link Message}s: incoming and outgoing.");
    _builder_71.newLine();
    _builder_71.append("</p>");
    _builder_71.newLine();
    _builder_71.append("<p>");
    _builder_71.newLine();
    _builder_71.append("A protocol class can derive from a base class (single inheritance).");
    _builder_71.newLine();
    _builder_71.append("In this case it must only extend <em>one</em> of the message sets:");
    _builder_71.newLine();
    _builder_71.append("incoming <em>or</em> outgoing.");
    _builder_71.newLine();
    _builder_71.append("</p>");
    _builder_71.newLine();
    _builder_71.append("<p>");
    _builder_71.newLine();
    _builder_71.append("Optionally {@link PortClass}es may be defined for regular and");
    _builder_71.newLine();
    _builder_71.append("conjugate {@link Port}s. These classes can be used to add specific");
    _builder_71.newLine();
    _builder_71.append("behavior e.g. by adding message handlers. This kind of felxibility");
    _builder_71.newLine();
    _builder_71.append("can be used in particular for the efficient implementation of");
    _builder_71.newLine();
    _builder_71.append("services (SAPs and SPPs).");
    _builder_71.newLine();
    _builder_71.append("</p>");
    _builder_71.newLine();
    _builder_71.append("<p>");
    _builder_71.newLine();
    _builder_71.append("Last not least a so called \'legal execution tree\' can be specified");
    _builder_71.newLine();
    _builder_71.append("using {@link ProtocolSemantics}.");
    _builder_71.newLine();
    _builder_71.append("</p>");
    _builder_71.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_71.toString());
    EAttribute _attribute_16 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_72 = new StringConcatenation();
    _builder_72.append("The name of the protocol class by which it is referred to in the model.");
    _builder_72.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_16, _builder_72.toString());
    EReference _reference_37 = PostprocessingHelpers.getReference(cls, "base");
    StringConcatenation _builder_73 = new StringConcatenation();
    _builder_73.append("The base class from which all messages are inherited.");
    _builder_73.newLine();
    _builder_73.append("The port classes and the semantics are not inherited.");
    _builder_73.newLine();
    PostprocessingHelpers.setDocumentation(_reference_37, _builder_73.toString());
    EAttribute _attribute_17 = PostprocessingHelpers.getAttribute(cls, "commType");
    StringConcatenation _builder_74 = new StringConcatenation();
    _builder_74.append("This is the communication type of the protocol.");
    _builder_74.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_17, _builder_74.toString());
    EReference _reference_38 = PostprocessingHelpers.getReference(cls, "userCode1");
    StringConcatenation _builder_75 = new StringConcatenation();
    _builder_75.append("The user code is treated in a generator dependent way.");
    _builder_75.newLine();
    PostprocessingHelpers.setDocumentation(_reference_38, _builder_75.toString());
    EReference _reference_39 = PostprocessingHelpers.getReference(cls, "userCode2");
    StringConcatenation _builder_76 = new StringConcatenation();
    _builder_76.append("The user code is treated in a generator dependent way.");
    _builder_76.newLine();
    PostprocessingHelpers.setDocumentation(_reference_39, _builder_76.toString());
    EReference _reference_40 = PostprocessingHelpers.getReference(cls, "userCode3");
    StringConcatenation _builder_77 = new StringConcatenation();
    _builder_77.append("The user code is treated in a generator dependent way.");
    _builder_77.newLine();
    PostprocessingHelpers.setDocumentation(_reference_40, _builder_77.toString());
    EReference _reference_41 = PostprocessingHelpers.getReference(cls, "incomingMessages");
    StringConcatenation _builder_78 = new StringConcatenation();
    _builder_78.append("This is the set of incoming messages of this protocol.");
    _builder_78.newLine();
    PostprocessingHelpers.setDocumentation(_reference_41, _builder_78.toString());
    EReference _reference_42 = PostprocessingHelpers.getReference(cls, "outgoingMessages");
    StringConcatenation _builder_79 = new StringConcatenation();
    _builder_79.append("This is the set of outgoing messages of this protocol.");
    _builder_79.newLine();
    PostprocessingHelpers.setDocumentation(_reference_42, _builder_79.toString());
    EReference _reference_43 = PostprocessingHelpers.getReference(cls, "regular");
    StringConcatenation _builder_80 = new StringConcatenation();
    _builder_80.append("This is the optional regular port class specification.");
    _builder_80.newLine();
    PostprocessingHelpers.setDocumentation(_reference_43, _builder_80.toString());
    EReference _reference_44 = PostprocessingHelpers.getReference(cls, "conjugated");
    StringConcatenation _builder_81 = new StringConcatenation();
    _builder_81.append("This is the optional conjugate port class specification.");
    _builder_81.newLine();
    PostprocessingHelpers.setDocumentation(_reference_44, _builder_81.toString());
    EReference _reference_45 = PostprocessingHelpers.getReference(cls, "semantics");
    StringConcatenation _builder_82 = new StringConcatenation();
    _builder_82.append("This is the optional semantics specification for this protocol.");
    _builder_82.newLine();
    PostprocessingHelpers.setDocumentation(_reference_45, _builder_82.toString());
    EClass _class_18 = PostprocessingHelpers.getClass(pckg, "CompoundProtocolClass");
    cls = _class_18;
    StringConcatenation _builder_83 = new StringConcatenation();
    _builder_83.append("This special protocol class is used to bundle several protocols");
    _builder_83.newLine();
    _builder_83.append("in relay ports. This can be useful to avoid parallel chains");
    _builder_83.newLine();
    _builder_83.append("of {@link Binding}s traversing the structural hierarchy.");
    _builder_83.newLine();
    _builder_83.append("<p>");
    _builder_83.newLine();
    _builder_83.append("The compound protocol class consists of several {@link SubProtocol}s.");
    _builder_83.newLine();
    _builder_83.append("</p>");
    _builder_83.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_83.toString());
    EReference _reference_46 = PostprocessingHelpers.getReference(cls, "subProtocols");
    StringConcatenation _builder_84 = new StringConcatenation();
    _builder_84.append("This is a list of sub protocols.");
    _builder_84.newLine();
    PostprocessingHelpers.setDocumentation(_reference_46, _builder_84.toString());
    EClass _class_19 = PostprocessingHelpers.getClass(pckg, "SubProtocol");
    cls = _class_19;
    StringConcatenation _builder_85 = new StringConcatenation();
    _builder_85.append("The sub protocol is part of the {@link CompoundProtocolClass} and defines");
    _builder_85.newLine();
    _builder_85.append("kind of a named channel for messages. The sub protocols are used to associate an");
    _builder_85.newLine();
    _builder_85.append("end port with a particular channel.");
    _builder_85.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_85.toString());
    EAttribute _attribute_18 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_86 = new StringConcatenation();
    _builder_86.append("By this name the sub protocols or channels are distinguished.");
    _builder_86.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_18, _builder_86.toString());
    EReference _reference_47 = PostprocessingHelpers.getReference(cls, "protocol");
    StringConcatenation _builder_87 = new StringConcatenation();
    _builder_87.append("This is the protocol of this channel.");
    _builder_87.newLine();
    PostprocessingHelpers.setDocumentation(_reference_47, _builder_87.toString());
    EClass _class_20 = PostprocessingHelpers.getClass(pckg, "Message");
    cls = _class_20;
    StringConcatenation _builder_88 = new StringConcatenation();
    _builder_88.append("A message in ROOM is part of a {@link ProtocolClass}. Messages are exchanged via {@link Port}s.");
    _builder_88.newLine();
    _builder_88.append("For event driven protocols the message is an object that is deliverd using a message");
    _builder_88.newLine();
    _builder_88.append("service of the runtime. For data driven systems only messages holding data are valid. In this");
    _builder_88.newLine();
    _builder_88.append("case the conjugate port is the one holding (and writing) the data and the regular port is");
    _builder_88.newLine();
    _builder_88.append("reading the data.");
    _builder_88.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_88.toString());
    EAttribute _attribute_19 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_89 = new StringConcatenation();
    _builder_89.append("By this name the message is referred to in the model.");
    _builder_89.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_19, _builder_89.toString());
    EAttribute _attribute_20 = PostprocessingHelpers.getAttribute(cls, "priv");
    StringConcatenation _builder_90 = new StringConcatenation();
    _builder_90.append("If this flag is {@code true} then the message is treated as private for this protocol");
    _builder_90.newLine();
    _builder_90.append("and can only be sent by a PortClass.");
    _builder_90.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_20, _builder_90.toString());
    EReference _reference_48 = PostprocessingHelpers.getReference(cls, "data");
    StringConcatenation _builder_91 = new StringConcatenation();
    _builder_91.append("This is a reference to optional message data.");
    _builder_91.newLine();
    PostprocessingHelpers.setDocumentation(_reference_48, _builder_91.toString());
    EReference _reference_49 = PostprocessingHelpers.getReference(cls, "docu");
    StringConcatenation _builder_92 = new StringConcatenation();
    _builder_92.append("This is an optional documentation.");
    _builder_92.newLine();
    PostprocessingHelpers.setDocumentation(_reference_49, _builder_92.toString());
    EClass _class_21 = PostprocessingHelpers.getClass(pckg, "PortClass");
    cls = _class_21;
    StringConcatenation _builder_93 = new StringConcatenation();
    _builder_93.append("A port class can be specified to customize the behavior of a {@link ProtocolClass}.");
    _builder_93.newLine();
    _builder_93.append("There can be one for regular ports and another one for conjugate ports independently.");
    _builder_93.newLine();
    _builder_93.newLine();
    _builder_93.append("<p>");
    _builder_93.newLine();
    _builder_93.append("Port classes can be used to define attributes and operations and message handlers");
    _builder_93.newLine();
    _builder_93.append("(or interceptors).");
    _builder_93.newLine();
    _builder_93.append("</p>");
    _builder_93.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_93.toString());
    EReference _reference_50 = PostprocessingHelpers.getReference(cls, "operations");
    StringConcatenation _builder_94 = new StringConcatenation();
    _builder_94.append("This is a list of operations of this nested class.");
    _builder_94.newLine();
    PostprocessingHelpers.setDocumentation(_reference_50, _builder_94.toString());
    EReference _reference_51 = PostprocessingHelpers.getReference(cls, "attributes");
    StringConcatenation _builder_95 = new StringConcatenation();
    _builder_95.append("This is a list of attributes of this nested class.");
    _builder_95.newLine();
    PostprocessingHelpers.setDocumentation(_reference_51, _builder_95.toString());
    EReference _reference_52 = PostprocessingHelpers.getReference(cls, "userCode");
    StringConcatenation _builder_96 = new StringConcatenation();
    _builder_96.append("The user code is treated in a generator dependent way.");
    _builder_96.newLine();
    PostprocessingHelpers.setDocumentation(_reference_52, _builder_96.toString());
    EReference _reference_53 = PostprocessingHelpers.getReference(cls, "msgHandlers");
    StringConcatenation _builder_97 = new StringConcatenation();
    _builder_97.append("This is a list of message handlers.");
    _builder_97.newLine();
    PostprocessingHelpers.setDocumentation(_reference_53, _builder_97.toString());
    EClass _class_22 = PostprocessingHelpers.getClass(pckg, "MessageHandler");
    cls = _class_22;
    StringConcatenation _builder_98 = new StringConcatenation();
    _builder_98.append("The super class of");
    _builder_98.newLine();
    _builder_98.append("<ul>");
    _builder_98.newLine();
    _builder_98.append("  ");
    _builder_98.append("<li>{@link InMessageHandler}</li>");
    _builder_98.newLine();
    _builder_98.append("  ");
    _builder_98.append("<li>{@link OutMessageHandler}</li>");
    _builder_98.newLine();
    _builder_98.append("</ul>");
    _builder_98.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_98.toString());
    EReference _reference_54 = PostprocessingHelpers.getReference(cls, "msg");
    StringConcatenation _builder_99 = new StringConcatenation();
    _builder_99.append("This is the message that is handled.");
    _builder_99.newLine();
    PostprocessingHelpers.setDocumentation(_reference_54, _builder_99.toString());
    EReference _reference_55 = PostprocessingHelpers.getReference(cls, "detailCode");
    StringConcatenation _builder_100 = new StringConcatenation();
    _builder_100.append("This is the handler code written in code generator target language.");
    _builder_100.newLine();
    PostprocessingHelpers.setDocumentation(_reference_55, _builder_100.toString());
    EClass _class_23 = PostprocessingHelpers.getClass(pckg, "InMessageHandler");
    cls = _class_23;
    StringConcatenation _builder_101 = new StringConcatenation();
    _builder_101.append("Is a handler (or interceptor) for incoming messages. In the generated code the");
    _builder_101.newLine();
    _builder_101.append("message is available. It is derived from {@link MessageHandler}.");
    _builder_101.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_101.toString());
    EClass _class_24 = PostprocessingHelpers.getClass(pckg, "OutMessageHandler");
    cls = _class_24;
    StringConcatenation _builder_102 = new StringConcatenation();
    _builder_102.append("Is a handler (or interceptor) for outgoing messages. In the generated code the");
    _builder_102.newLine();
    _builder_102.append("message is available. It is derived from {@link MessageHandler}.");
    _builder_102.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_102.toString());
    EClass _class_25 = PostprocessingHelpers.getClass(pckg, "ProtocolSemantics");
    cls = _class_25;
    StringConcatenation _builder_103 = new StringConcatenation();
    _builder_103.append("An optional semantics specification as part of a {@link ProtocolClass}.");
    _builder_103.newLine();
    _builder_103.append("The semantic is defined as a <em>legal execution tree</em>.");
    _builder_103.newLine();
    _builder_103.append("This tree is composed of incoming and outgoing messages and each path through");
    _builder_103.newLine();
    _builder_103.append("this tree is a valid sequence of messages exchanged through a port instance.");
    _builder_103.newLine();
    _builder_103.newLine();
    _builder_103.append("<p>");
    _builder_103.newLine();
    _builder_103.append("The semantics are composed using {@link SemanticsRule}s.");
    _builder_103.newLine();
    _builder_103.append("</p>");
    _builder_103.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_103.toString());
    EReference _reference_56 = PostprocessingHelpers.getReference(cls, "rules");
    StringConcatenation _builder_104 = new StringConcatenation();
    _builder_104.append("This is a list of semantic rules.");
    _builder_104.newLine();
    PostprocessingHelpers.setDocumentation(_reference_56, _builder_104.toString());
    EClass _class_26 = PostprocessingHelpers.getClass(pckg, "SemanticsRule");
    cls = _class_26;
    StringConcatenation _builder_105 = new StringConcatenation();
    _builder_105.append("The super class of");
    _builder_105.newLine();
    _builder_105.append("<ul>");
    _builder_105.newLine();
    _builder_105.append("  ");
    _builder_105.append("<li>{@link InSemanticsRule}</li>");
    _builder_105.newLine();
    _builder_105.append("  ");
    _builder_105.append("<li>{@link OutSemanticsRule}</li>");
    _builder_105.newLine();
    _builder_105.append("</ul>");
    _builder_105.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_105.toString());
    EReference _reference_57 = PostprocessingHelpers.getReference(cls, "msg");
    StringConcatenation _builder_106 = new StringConcatenation();
    _builder_106.append("The message to which this rule applies.");
    _builder_106.newLine();
    PostprocessingHelpers.setDocumentation(_reference_57, _builder_106.toString());
    EReference _reference_58 = PostprocessingHelpers.getReference(cls, "followUps");
    StringConcatenation _builder_107 = new StringConcatenation();
    _builder_107.append("The possible follow up rules.");
    _builder_107.newLine();
    PostprocessingHelpers.setDocumentation(_reference_58, _builder_107.toString());
    EClass _class_27 = PostprocessingHelpers.getClass(pckg, "InSemanticsRule");
    cls = _class_27;
    StringConcatenation _builder_108 = new StringConcatenation();
    _builder_108.append("A {@link SemanticsRule} for incoming messages.");
    _builder_108.newLine();
    _builder_108.append("The rule points to an incoming messages and allows follow-up rules.");
    _builder_108.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_108.toString());
    EClass _class_28 = PostprocessingHelpers.getClass(pckg, "OutSemanticsRule");
    cls = _class_28;
    StringConcatenation _builder_109 = new StringConcatenation();
    _builder_109.append("A {@link SemanticsRule} for outgoing messages.");
    _builder_109.newLine();
    _builder_109.append("The rule points to an outgoing messages and allows follow-up rules.");
    _builder_109.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_109.toString());
    EClass _class_29 = PostprocessingHelpers.getClass(pckg, "ActorClass");
    cls = _class_29;
    StringConcatenation _builder_110 = new StringConcatenation();
    _builder_110.append("Together with {@link ProtocolClass} and {@link DataClass} one of");
    _builder_110.newLine();
    _builder_110.append("the main class types of the ROOM language.");
    _builder_110.newLine();
    _builder_110.newLine();
    _builder_110.append("<p>");
    _builder_110.newLine();
    _builder_110.append("The actor class in ROOM has three compartments which aren\'t represented as separate model objects.");
    _builder_110.newLine();
    _builder_110.append("To understand to which compartment an attribute or reference belongs to here is a list");
    _builder_110.newLine();
    _builder_110.append("<ul>");
    _builder_110.newLine();
    _builder_110.append("  ");
    _builder_110.append("<li>Interface: everything which is visible from the outside from a model point of view");
    _builder_110.newLine();
    _builder_110.append("  ");
    _builder_110.append("<ul>");
    _builder_110.newLine();
    _builder_110.append("    ");
    _builder_110.append("<li>{@link #getInterfacePorts}: a list of all interface {@link Port}s</li>");
    _builder_110.newLine();
    _builder_110.append("    ");
    _builder_110.append("<li>{@link ActorContainerClass#getServiceProvisionPoints()}: a list of all interface {@link SPP}s</li>");
    _builder_110.newLine();
    _builder_110.append("  ");
    _builder_110.append("</ul>");
    _builder_110.newLine();
    _builder_110.append("  ");
    _builder_110.append("<li>Structure: all internal structural aspects of an actor class</li>");
    _builder_110.newLine();
    _builder_110.append("  ");
    _builder_110.append("<ul>");
    _builder_110.newLine();
    _builder_110.append("    ");
    _builder_110.append("<li>{@link #getUserCode1}-3: user defined code with generator dependent meaning</li>");
    _builder_110.newLine();
    _builder_110.append("    ");
    _builder_110.append("<li>{@link #getInternalPorts}: a list of all internal end {@link Port}s</li>");
    _builder_110.newLine();
    _builder_110.append("    ");
    _builder_110.append("<li>{@link #getExternalPorts}: a list of all {@link ExternalPort}s (the interface ports that");
    _builder_110.newLine();
    _builder_110.append("       ");
    _builder_110.append("are end ports, not relay ports</li>");
    _builder_110.newLine();
    _builder_110.append("    ");
    _builder_110.append("<li>{@link #getServiceImplementations}: a list of all {@link ServiceImplementation}s</li>");
    _builder_110.newLine();
    _builder_110.append("    ");
    _builder_110.append("<li>{@link #getServiceAccessPoints}: a list of all {@link SAP}s used by this actor class</li>");
    _builder_110.newLine();
    _builder_110.append("    ");
    _builder_110.append("<li>{@link #getAttributes}: a list of all actor class {@link Attribute}s</li>");
    _builder_110.newLine();
    _builder_110.append("    ");
    _builder_110.append("<li>{@link #getActorRefs}: a list of all referenced actor classes (an {@link ActorRef}");
    _builder_110.newLine();
    _builder_110.append("       ");
    _builder_110.append("has the meaning of a composition)</li>");
    _builder_110.newLine();
    _builder_110.append("    ");
    _builder_110.append("<li>{@link #getBindings}: a list of all port {@link Binding}s of this actor class</li>");
    _builder_110.newLine();
    _builder_110.append("    ");
    _builder_110.append("<li>{@link #getConnections}: a list of all {@link LayerConnection}s</li>");
    _builder_110.newLine();
    _builder_110.append("  ");
    _builder_110.append("</ul>");
    _builder_110.newLine();
    _builder_110.append("  ");
    _builder_110.append("<li>Behavior: the behavioral aspects of an actor class</li>");
    _builder_110.newLine();
    _builder_110.append("  ");
    _builder_110.append("<ul>");
    _builder_110.newLine();
    _builder_110.append("    ");
    _builder_110.append("<li>{@link #getOperations}: a list of {@link Operation}s</li>");
    _builder_110.newLine();
    _builder_110.append("    ");
    _builder_110.append("<li>{@link #getStateMachine}: the {@link StateGraph state machine} definition</li>");
    _builder_110.newLine();
    _builder_110.append("  ");
    _builder_110.append("</ul>");
    _builder_110.newLine();
    _builder_110.append("</ul>");
    _builder_110.newLine();
    _builder_110.append("</p>");
    _builder_110.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_110.toString());
    EAttribute _attribute_21 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_111 = new StringConcatenation();
    _builder_111.append("By this name the actor class is referred to in the model.");
    _builder_111.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_21, _builder_111.toString());
    EAttribute _attribute_22 = PostprocessingHelpers.getAttribute(cls, "abstract");
    StringConcatenation _builder_112 = new StringConcatenation();
    _builder_112.append("If {@code true} this actor class can not be instantiated and can only be base class");
    _builder_112.newLine();
    _builder_112.append("for other actor classes.");
    _builder_112.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_22, _builder_112.toString());
    EAttribute _attribute_23 = PostprocessingHelpers.getAttribute(cls, "commType");
    StringConcatenation _builder_113 = new StringConcatenation();
    _builder_113.append("The communication type of this actor class.");
    _builder_113.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_23, _builder_113.toString());
    EReference _reference_59 = PostprocessingHelpers.getReference(cls, "base");
    StringConcatenation _builder_114 = new StringConcatenation();
    _builder_114.append("The base class from which all attributes, operations, ports, SAPs");
    _builder_114.newLine();
    _builder_114.append("and state machine are inherited.");
    _builder_114.newLine();
    PostprocessingHelpers.setDocumentation(_reference_59, _builder_114.toString());
    EReference _reference_60 = PostprocessingHelpers.getReference(cls, "interfacePorts");
    StringConcatenation _builder_115 = new StringConcatenation();
    _builder_115.append("This is a list containing all ports of the actor interface.");
    _builder_115.newLine();
    PostprocessingHelpers.setDocumentation(_reference_60, _builder_115.toString());
    EReference _reference_61 = PostprocessingHelpers.getReference(cls, "internalPorts");
    StringConcatenation _builder_116 = new StringConcatenation();
    _builder_116.append("This is a list containing all ports of the actor structure (internal end ports).");
    _builder_116.newLine();
    PostprocessingHelpers.setDocumentation(_reference_61, _builder_116.toString());
    EReference _reference_62 = PostprocessingHelpers.getReference(cls, "externalPorts");
    StringConcatenation _builder_117 = new StringConcatenation();
    _builder_117.append("This is a list containing all ports of the actor interface that are end ports.");
    _builder_117.newLine();
    PostprocessingHelpers.setDocumentation(_reference_62, _builder_117.toString());
    EReference _reference_63 = PostprocessingHelpers.getReference(cls, "structureDocu");
    StringConcatenation _builder_118 = new StringConcatenation();
    _builder_118.append("This is an optional documentation of the actor structure.");
    _builder_118.newLine();
    PostprocessingHelpers.setDocumentation(_reference_63, _builder_118.toString());
    EReference _reference_64 = PostprocessingHelpers.getReference(cls, "serviceImplementations");
    StringConcatenation _builder_119 = new StringConcatenation();
    _builder_119.append("This is a list of all service implementations.");
    _builder_119.newLine();
    PostprocessingHelpers.setDocumentation(_reference_64, _builder_119.toString());
    EReference _reference_65 = PostprocessingHelpers.getReference(cls, "serviceAccessPoints");
    StringConcatenation _builder_120 = new StringConcatenation();
    _builder_120.append("This is a list of all SAPs.");
    _builder_120.newLine();
    PostprocessingHelpers.setDocumentation(_reference_65, _builder_120.toString());
    EReference _reference_66 = PostprocessingHelpers.getReference(cls, "attributes");
    StringConcatenation _builder_121 = new StringConcatenation();
    _builder_121.append("This is a list of all actor class private attributes.");
    _builder_121.newLine();
    PostprocessingHelpers.setDocumentation(_reference_66, _builder_121.toString());
    EReference _reference_67 = PostprocessingHelpers.getReference(cls, "behaviorDocu");
    StringConcatenation _builder_122 = new StringConcatenation();
    _builder_122.append("This is an optional documentation of the actor behavior.");
    _builder_122.newLine();
    PostprocessingHelpers.setDocumentation(_reference_67, _builder_122.toString());
    EReference _reference_68 = PostprocessingHelpers.getReference(cls, "behaviorAnnotations");
    StringConcatenation _builder_123 = new StringConcatenation();
    _builder_123.append("This is a list of annotations to the actor behavior.");
    _builder_123.newLine();
    PostprocessingHelpers.setDocumentation(_reference_68, _builder_123.toString());
    EReference _reference_69 = PostprocessingHelpers.getReference(cls, "operations");
    StringConcatenation _builder_124 = new StringConcatenation();
    _builder_124.append("This is a list of all private operations of this actor class.");
    _builder_124.newLine();
    PostprocessingHelpers.setDocumentation(_reference_69, _builder_124.toString());
    EReference _reference_70 = PostprocessingHelpers.getReference(cls, "stateMachine");
    StringConcatenation _builder_125 = new StringConcatenation();
    _builder_125.append("This is the actor\'s optional state machine.");
    _builder_125.newLine();
    PostprocessingHelpers.setDocumentation(_reference_70, _builder_125.toString());
    EClass _class_30 = PostprocessingHelpers.getClass(pckg, "InterfaceItem");
    cls = _class_30;
    StringConcatenation _builder_126 = new StringConcatenation();
    _builder_126.append("The super class of");
    _builder_126.newLine();
    _builder_126.append("<ul>");
    _builder_126.newLine();
    _builder_126.append("  ");
    _builder_126.append("<li>{@link Port}</li>");
    _builder_126.newLine();
    _builder_126.append("  ");
    _builder_126.append("<li>{@link SAP}</li>");
    _builder_126.newLine();
    _builder_126.append("  ");
    _builder_126.append("<li>{@link SPP}</li>");
    _builder_126.newLine();
    _builder_126.append("</ul>");
    _builder_126.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_126.toString());
    EAttribute _attribute_24 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_127 = new StringConcatenation();
    _builder_127.append("By this name the interface item is referred to in the model.");
    _builder_127.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_24, _builder_127.toString());
    EClass _class_31 = PostprocessingHelpers.getClass(pckg, "Port");
    cls = _class_31;
    StringConcatenation _builder_128 = new StringConcatenation();
    _builder_128.append("A port defines a part of the interface of an {@link ActorClass} in a specific role.");
    _builder_128.newLine();
    _builder_128.append("The port is associated with a {@link ProtocolClass}. If it is conjugated then the");
    _builder_128.newLine();
    _builder_128.append("roles of incoming and outgoing messages of the protocol are inverted.");
    _builder_128.newLine();
    _builder_128.newLine();
    _builder_128.append("<p>");
    _builder_128.newLine();
    _builder_128.append("Ports can have a multiplicity. If it is greater one the port is called replicated.");
    _builder_128.newLine();
    _builder_128.append("</p>");
    _builder_128.newLine();
    _builder_128.newLine();
    _builder_128.append("<p>");
    _builder_128.newLine();
    _builder_128.append("Whether a port is a relay port or not is a property that is derived from how it is");
    _builder_128.newLine();
    _builder_128.append("referenced by its {@link ActorClass}:");
    _builder_128.newLine();
    _builder_128.append("<ul>");
    _builder_128.newLine();
    _builder_128.append("  ");
    _builder_128.append("<li>ports contained in the actor structure are called <em>internal end ports</em></li>");
    _builder_128.newLine();
    _builder_128.append("  ");
    _builder_128.append("<li>ports contained in the actor interface and are also referenced by an {@link ExternalPort}");
    _builder_128.newLine();
    _builder_128.append("     ");
    _builder_128.append("are called <em>external end ports</em></li>");
    _builder_128.newLine();
    _builder_128.append("  ");
    _builder_128.append("<li>ports contained in the actor interface only are called <em>relay ports</em></li>");
    _builder_128.newLine();
    _builder_128.append("</ul>");
    _builder_128.newLine();
    _builder_128.append("Relay ports delegate to sub actors and end ports are connected to the actor\'s state machine.");
    _builder_128.newLine();
    _builder_128.append("</p>");
    _builder_128.newLine();
    _builder_128.newLine();
    _builder_128.append("@see org.eclipse.etrice.core.room.util.RoomHelpers#isRelay(Port) RoomHelpers.isRelay(Port)");
    _builder_128.newLine();
    _builder_128.append("@see org.eclipse.etrice.core.room.util.RoomHelpers#isInternal(Port) RoomHelpers.isInternal(Port)");
    _builder_128.newLine();
    _builder_128.append("@see org.eclipse.etrice.core.room.util.RoomHelpers#isExternal(Port) RoomHelpers.isExternal(Port)");
    _builder_128.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_128.toString());
    EAttribute _attribute_25 = PostprocessingHelpers.getAttribute(cls, "conjugated");
    StringConcatenation _builder_129 = new StringConcatenation();
    _builder_129.append("If a port is conjugated then the roles of outgoing and incoming messages are interchanged.");
    _builder_129.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_25, _builder_129.toString());
    EAttribute _attribute_26 = PostprocessingHelpers.getAttribute(cls, "multiplicity");
    StringConcatenation _builder_130 = new StringConcatenation();
    _builder_130.append("Ports with multiplicity >1 are called relay ports. A multiplicity of {@code -1} means replicated");
    _builder_130.newLine();
    _builder_130.append("port with arbitrary multiplicity.");
    _builder_130.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_26, _builder_130.toString());
    EReference _reference_71 = PostprocessingHelpers.getReference(cls, "protocol");
    StringConcatenation _builder_131 = new StringConcatenation();
    _builder_131.append("This is the port\'s protocol class.");
    _builder_131.newLine();
    PostprocessingHelpers.setDocumentation(_reference_71, _builder_131.toString());
    EReference _reference_72 = PostprocessingHelpers.getReference(cls, "docu");
    StringConcatenation _builder_132 = new StringConcatenation();
    _builder_132.append("This is an optional documentation.");
    _builder_132.newLine();
    PostprocessingHelpers.setDocumentation(_reference_72, _builder_132.toString());
    EClass _class_32 = PostprocessingHelpers.getClass(pckg, "ExternalPort");
    cls = _class_32;
    StringConcatenation _builder_133 = new StringConcatenation();
    _builder_133.append("An external port is part of the actor structure and references an interface port.");
    _builder_133.newLine();
    _builder_133.append("An interface port which is referenced by an external port is an external end port.");
    _builder_133.newLine();
    _builder_133.append("If it is not referenced it is a relay port.");
    _builder_133.newLine();
    _builder_133.newLine();
    _builder_133.append("@see Port");
    _builder_133.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_133.toString());
    EReference _reference_73 = PostprocessingHelpers.getReference(cls, "interfacePort");
    StringConcatenation _builder_134 = new StringConcatenation();
    _builder_134.append("This is the referenced interface port of the actor class which is now an external end port.");
    _builder_134.newLine();
    PostprocessingHelpers.setDocumentation(_reference_73, _builder_134.toString());
    EClass _class_33 = PostprocessingHelpers.getClass(pckg, "SAP");
    cls = _class_33;
    StringConcatenation _builder_135 = new StringConcatenation();
    _builder_135.append("A service access point is similar to a {@link Port} but is not explicitly bound to a peer.");
    _builder_135.newLine();
    _builder_135.append("Rather, it is bound to a {@link ServiceImplementation} which is connected to one of the");
    _builder_135.newLine();
    _builder_135.append("containing actors.");
    _builder_135.newLine();
    _builder_135.newLine();
    _builder_135.append("<p>");
    _builder_135.newLine();
    _builder_135.append("An SAP is associated with a {@link ProtocolClass} and is conjugate to this protocol.");
    _builder_135.newLine();
    _builder_135.append("</p>");
    _builder_135.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_135.toString());
    EReference _reference_74 = PostprocessingHelpers.getReference(cls, "protocol");
    StringConcatenation _builder_136 = new StringConcatenation();
    _builder_136.append("This is the SAP\'s protocol class.");
    _builder_136.newLine();
    PostprocessingHelpers.setDocumentation(_reference_74, _builder_136.toString());
    EClass _class_34 = PostprocessingHelpers.getClass(pckg, "SPP");
    cls = _class_34;
    StringConcatenation _builder_137 = new StringConcatenation();
    _builder_137.append("A service provision point is used to connect an actor class with a {@link ServiceImplementation}.");
    _builder_137.newLine();
    _builder_137.append("It can (similar to relay ports) delegate to another actor class (using a {@link LayerConnection})");
    _builder_137.newLine();
    _builder_137.append("or connect to a {@link ServiceImplementation} of its actor class.");
    _builder_137.newLine();
    _builder_137.newLine();
    _builder_137.append("<p>");
    _builder_137.newLine();
    _builder_137.append("An SPP is associated with a {@link ProtocolClass} and is regular to this protocol.");
    _builder_137.newLine();
    _builder_137.append("</p>");
    _builder_137.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_137.toString());
    EReference _reference_75 = PostprocessingHelpers.getReference(cls, "protocol");
    StringConcatenation _builder_138 = new StringConcatenation();
    _builder_138.append("This is the SAP\'s protocol class.");
    _builder_138.newLine();
    PostprocessingHelpers.setDocumentation(_reference_75, _builder_138.toString());
    EClass _class_35 = PostprocessingHelpers.getClass(pckg, "ServiceImplementation");
    cls = _class_35;
    StringConcatenation _builder_139 = new StringConcatenation();
    _builder_139.append("A service implementation can be reagrded as the replicated peer port of all {@link SAP}s");
    _builder_139.newLine();
    _builder_139.append("that are bound to it following the service resolution logic.");
    _builder_139.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_139.toString());
    EReference _reference_76 = PostprocessingHelpers.getReference(cls, "spp");
    StringConcatenation _builder_140 = new StringConcatenation();
    _builder_140.append("This is the SPP connected to the service.");
    _builder_140.newLine();
    PostprocessingHelpers.setDocumentation(_reference_76, _builder_140.toString());
    EClass _class_36 = PostprocessingHelpers.getClass(pckg, "LogicalSystem");
    cls = _class_36;
    StringConcatenation _builder_141 = new StringConcatenation();
    _builder_141.append("The top level structural class. It can only contain sub systems using {@link SubSystemRef}s.");
    _builder_141.newLine();
    _builder_141.append("This way the logical system is composed of sub system instances. It also defines");
    _builder_141.newLine();
    _builder_141.append("{@link Binding}s and {@link LayerConnection}s between those sub systems.");
    _builder_141.newLine();
    _builder_141.newLine();
    _builder_141.append("<p>");
    _builder_141.newLine();
    _builder_141.append("The logical system is the root of the instance tree of the generator model.");
    _builder_141.newLine();
    _builder_141.append("Each {@link SubSystemRef} is turned into a {@link org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance} and each");
    _builder_141.newLine();
    _builder_141.append("{@link ActorRef} is turned into an {@link org.eclipse.etrice.core.genmodel.etricegen.ActorInstance}.");
    _builder_141.newLine();
    _builder_141.append("</p>");
    _builder_141.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_141.toString());
    EReference _reference_77 = PostprocessingHelpers.getReference(cls, "subSystems");
    StringConcatenation _builder_142 = new StringConcatenation();
    _builder_142.append("The list of all sub systems contained in the logical system.");
    _builder_142.newLine();
    PostprocessingHelpers.setDocumentation(_reference_77, _builder_142.toString());
    EClass _class_37 = PostprocessingHelpers.getClass(pckg, "ActorContainerRef");
    cls = _class_37;
    StringConcatenation _builder_143 = new StringConcatenation();
    _builder_143.append("The super class of");
    _builder_143.newLine();
    _builder_143.append("<ul>");
    _builder_143.newLine();
    _builder_143.append("  ");
    _builder_143.append("<li>{@link SubSystemRef}</li>");
    _builder_143.newLine();
    _builder_143.append("  ");
    _builder_143.append("<li>{@link ActorRef}</li>");
    _builder_143.newLine();
    _builder_143.append("</ul>");
    _builder_143.newLine();
    _builder_143.append("The reference designates a specific role of the referenced structure class.");
    _builder_143.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_143.toString());
    EAttribute _attribute_27 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_144 = new StringConcatenation();
    _builder_144.append("By this name the actor container reference is referred to in the model.");
    _builder_144.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_27, _builder_144.toString());
    EReference _reference_78 = PostprocessingHelpers.getReference(cls, "docu");
    StringConcatenation _builder_145 = new StringConcatenation();
    _builder_145.append("This is an optional documentation.");
    _builder_145.newLine();
    PostprocessingHelpers.setDocumentation(_reference_78, _builder_145.toString());
    EClass _class_38 = PostprocessingHelpers.getClass(pckg, "SubSystemRef");
    cls = _class_38;
    StringConcatenation _builder_146 = new StringConcatenation();
    _builder_146.append("A means to compose {@link LogicalSystem}s of {@link SubSystemClass}es. Each ref will");
    _builder_146.newLine();
    _builder_146.append("be turned into a sub system instance of the referenced type.");
    _builder_146.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_146.toString());
    EReference _reference_79 = PostprocessingHelpers.getReference(cls, "type");
    StringConcatenation _builder_147 = new StringConcatenation();
    _builder_147.append("The type of the reference.");
    _builder_147.newLine();
    PostprocessingHelpers.setDocumentation(_reference_79, _builder_147.toString());
    EClass _class_39 = PostprocessingHelpers.getClass(pckg, "SubSystemClass");
    cls = _class_39;
    StringConcatenation _builder_148 = new StringConcatenation();
    _builder_148.append("A sub system class corresponds to a process with a separate address space.");
    _builder_148.newLine();
    _builder_148.append("It has no behavior of its own and is composed of {@link ActorClass}es.");
    _builder_148.newLine();
    _builder_148.newLine();
    _builder_148.append("<p>");
    _builder_148.newLine();
    _builder_148.append("Sub systems can be connected using {@link Port}s and {@link Binding}s.");
    _builder_148.newLine();
    _builder_148.append("All ports of a sub system are relay ports.");
    _builder_148.newLine();
    _builder_148.append("</p>");
    _builder_148.newLine();
    _builder_148.newLine();
    _builder_148.append("<p>");
    _builder_148.newLine();
    _builder_148.append("Sub systems can define an arbitrary number of logical threads onto which their actor");
    _builder_148.newLine();
    _builder_148.append("instances are mapped.");
    _builder_148.newLine();
    _builder_148.append("</p>");
    _builder_148.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_148.toString());
    EReference _reference_80 = PostprocessingHelpers.getReference(cls, "relayPorts");
    StringConcatenation _builder_149 = new StringConcatenation();
    _builder_149.append("This is a list of all relay ports of the sub system.");
    _builder_149.newLine();
    PostprocessingHelpers.setDocumentation(_reference_80, _builder_149.toString());
    EReference _reference_81 = PostprocessingHelpers.getReference(cls, "threads");
    StringConcatenation _builder_150 = new StringConcatenation();
    _builder_150.append("This is a list of all threads of the sub system.");
    _builder_150.newLine();
    PostprocessingHelpers.setDocumentation(_reference_81, _builder_150.toString());
    EReference _reference_82 = PostprocessingHelpers.getReference(cls, "threads");
    StringConcatenation _builder_151 = new StringConcatenation();
    _builder_151.append("This is a list of all actor instance mappings of the sub system.");
    _builder_151.newLine();
    PostprocessingHelpers.setDocumentation(_reference_82, _builder_151.toString());
    EReference _reference_83 = PostprocessingHelpers.getReference(cls, "actorInstanceMappings");
    StringConcatenation _builder_152 = new StringConcatenation();
    _builder_152.append("This is a list of actor instance mappings.");
    _builder_152.newLine();
    PostprocessingHelpers.setDocumentation(_reference_83, _builder_152.toString());
    EClass _class_40 = PostprocessingHelpers.getClass(pckg, "LogicalThread");
    cls = _class_40;
    StringConcatenation _builder_153 = new StringConcatenation();
    _builder_153.append("A logical thread is addressed by the {@link ActorInstanceMapping}s of a {@link SubSystemClass}.");
    _builder_153.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_153.toString());
    EAttribute _attribute_28 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_154 = new StringConcatenation();
    _builder_154.append("By this name the thread is referred to in the model.");
    _builder_154.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_28, _builder_154.toString());
    EClass _class_41 = PostprocessingHelpers.getClass(pckg, "ActorInstanceMapping");
    cls = _class_41;
    StringConcatenation _builder_155 = new StringConcatenation();
    _builder_155.append("An actor instance mapping maps an actor instances (described as a path of actor references)");
    _builder_155.newLine();
    _builder_155.append("to a {@link LogicalThread}");
    _builder_155.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_155.toString());
    EReference _reference_84 = PostprocessingHelpers.getReference(cls, "path");
    StringConcatenation _builder_156 = new StringConcatenation();
    _builder_156.append("This is the path of references starting at this sub system that uniquely references an actor instance.");
    _builder_156.newLine();
    PostprocessingHelpers.setDocumentation(_reference_84, _builder_156.toString());
    EReference _reference_85 = PostprocessingHelpers.getReference(cls, "thread");
    StringConcatenation _builder_157 = new StringConcatenation();
    _builder_157.append("This is the logical thread to which the referenced actor instance and all of its contained instances");
    _builder_157.newLine();
    _builder_157.append("are mapped.");
    _builder_157.newLine();
    PostprocessingHelpers.setDocumentation(_reference_85, _builder_157.toString());
    EReference _reference_86 = PostprocessingHelpers.getReference(cls, "actorInstanceMappings");
    StringConcatenation _builder_158 = new StringConcatenation();
    _builder_158.append("This is a list of nested mappings which override parent mappings.");
    _builder_158.newLine();
    PostprocessingHelpers.setDocumentation(_reference_86, _builder_158.toString());
    EClass _class_42 = PostprocessingHelpers.getClass(pckg, "RefPath");
    cls = _class_42;
    StringConcatenation _builder_159 = new StringConcatenation();
    _builder_159.append("A path of strings that are interpreted as {@link org.eclipse.etrice.core.room.ActorRef}s starting at a {@link org.eclipse.etrice.core.room.SubSystemClass}.");
    _builder_159.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_159.toString());
    EReference _reference_87 = PostprocessingHelpers.getReference(cls, "refs");
    StringConcatenation _builder_160 = new StringConcatenation();
    _builder_160.append("This is a path in the instance tree where each segment corresponds to the name of the");
    _builder_160.newLine();
    _builder_160.append("corresponding {@link ActorContainerRef}.");
    _builder_160.newLine();
    PostprocessingHelpers.setDocumentation(_reference_87, _builder_160.toString());
    EClass _class_43 = PostprocessingHelpers.getClass(pckg, "RefSegment");
    cls = _class_43;
    StringConcatenation _builder_161 = new StringConcatenation();
    _builder_161.append("A segment of a {@link RefPath}. It consists of a name and an optional index.");
    _builder_161.newLine();
    _builder_161.append("If the index is not set it will be {@code -1}.");
    _builder_161.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_161.toString());
    EAttribute _attribute_29 = PostprocessingHelpers.getAttribute(cls, "ref");
    StringConcatenation _builder_162 = new StringConcatenation();
    _builder_162.append("The segment name corresponding to an actor reference.");
    _builder_162.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_29, _builder_162.toString());
    EAttribute _attribute_30 = PostprocessingHelpers.getAttribute(cls, "idx");
    StringConcatenation _builder_163 = new StringConcatenation();
    _builder_163.append("The optional index of the reference (for replicated actors).");
    _builder_163.newLine();
    _builder_163.append("If not set the index is {@code -1}.");
    _builder_163.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_30, _builder_163.toString());
    EClass _class_44 = PostprocessingHelpers.getClass(pckg, "Binding");
    cls = _class_44;
    StringConcatenation _builder_164 = new StringConcatenation();
    _builder_164.append("A binding connects two {@link Port}s.");
    _builder_164.newLine();
    _builder_164.append("To be able to distinguish the ports of two {@link ActorContainerRef}s of the same type");
    _builder_164.newLine();
    _builder_164.append("a {@link BindingEndPoint} is needed for disambiguation.");
    _builder_164.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_164.toString());
    EReference _reference_88 = PostprocessingHelpers.getReference(cls, "endpoint1");
    StringConcatenation _builder_165 = new StringConcatenation();
    _builder_165.append("The first end point of a binding.");
    _builder_165.newLine();
    PostprocessingHelpers.setDocumentation(_reference_88, _builder_165.toString());
    EReference _reference_89 = PostprocessingHelpers.getReference(cls, "endpoint2");
    StringConcatenation _builder_166 = new StringConcatenation();
    _builder_166.append("The second end point of a binding.");
    _builder_166.newLine();
    PostprocessingHelpers.setDocumentation(_reference_89, _builder_166.toString());
    EClass _class_45 = PostprocessingHelpers.getClass(pckg, "BindingEndPoint");
    cls = _class_45;
    StringConcatenation _builder_167 = new StringConcatenation();
    _builder_167.append("A binding end point is a pair of an {@link ActorContainerRef} and a {@link Port} and is used");
    _builder_167.newLine();
    _builder_167.append("to uniquely describe a port of a sub actor. If the actor container ref is {@code null} then");
    _builder_167.newLine();
    _builder_167.append("a port of the actor class itself is addressed.");
    _builder_167.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_167.toString());
    EReference _reference_90 = PostprocessingHelpers.getReference(cls, "actorRef");
    StringConcatenation _builder_168 = new StringConcatenation();
    _builder_168.append("The actor reference holding the bound port or {@code null} in case of a local port.");
    _builder_168.newLine();
    PostprocessingHelpers.setDocumentation(_reference_90, _builder_168.toString());
    EReference _reference_91 = PostprocessingHelpers.getReference(cls, "port");
    StringConcatenation _builder_169 = new StringConcatenation();
    _builder_169.append("This is the bound port.");
    _builder_169.newLine();
    PostprocessingHelpers.setDocumentation(_reference_91, _builder_169.toString());
    EReference _reference_92 = PostprocessingHelpers.getReference(cls, "sub");
    StringConcatenation _builder_170 = new StringConcatenation();
    _builder_170.append("This is the bound sub protocol or {@code null} if not applicable.");
    _builder_170.newLine();
    PostprocessingHelpers.setDocumentation(_reference_92, _builder_170.toString());
    EClass _class_46 = PostprocessingHelpers.getClass(pckg, "LayerConnection");
    cls = _class_46;
    StringConcatenation _builder_171 = new StringConcatenation();
    _builder_171.append("Layer connections are used to connect {@link SAP}s and {@link ServiceImplementation}s.");
    _builder_171.newLine();
    _builder_171.append("The source is described by a {@link SAPoint} and the target by a {@link SPPoint}.");
    _builder_171.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_171.toString());
    EReference _reference_93 = PostprocessingHelpers.getReference(cls, "from");
    StringConcatenation _builder_172 = new StringConcatenation();
    _builder_172.append("This is source point of the layer connection.");
    _builder_172.newLine();
    PostprocessingHelpers.setDocumentation(_reference_93, _builder_172.toString());
    EReference _reference_94 = PostprocessingHelpers.getReference(cls, "to");
    StringConcatenation _builder_173 = new StringConcatenation();
    _builder_173.append("This is target point of the layer connection.");
    _builder_173.newLine();
    PostprocessingHelpers.setDocumentation(_reference_94, _builder_173.toString());
    EClass _class_47 = PostprocessingHelpers.getClass(pckg, "SAPoint");
    cls = _class_47;
    StringConcatenation _builder_174 = new StringConcatenation();
    _builder_174.append("The super class of");
    _builder_174.newLine();
    _builder_174.append("<ul>");
    _builder_174.newLine();
    _builder_174.append("  ");
    _builder_174.append("<li>{@link RefSAPoint}</li>");
    _builder_174.newLine();
    _builder_174.append("  ");
    _builder_174.append("<li>{@link RelaySAPoint}</li>");
    _builder_174.newLine();
    _builder_174.append("</ul>");
    _builder_174.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_174.toString());
    EClass _class_48 = PostprocessingHelpers.getClass(pckg, "RefSAPoint");
    cls = _class_48;
    StringConcatenation _builder_175 = new StringConcatenation();
    _builder_175.append("Links from a {@link ActorContainerRef}, i.e. from a sub actor.");
    _builder_175.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_175.toString());
    EReference _reference_95 = PostprocessingHelpers.getReference(cls, "ref");
    StringConcatenation _builder_176 = new StringConcatenation();
    _builder_176.append("This is the referenced actor container ref.");
    _builder_176.newLine();
    PostprocessingHelpers.setDocumentation(_reference_95, _builder_176.toString());
    EClass _class_49 = PostprocessingHelpers.getClass(pckg, "RelaySAPoint");
    cls = _class_49;
    StringConcatenation _builder_177 = new StringConcatenation();
    _builder_177.append("Links from a relay {@link SPP} of the actor class.");
    _builder_177.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_177.toString());
    EReference _reference_96 = PostprocessingHelpers.getReference(cls, "relay");
    StringConcatenation _builder_178 = new StringConcatenation();
    _builder_178.append("This is the referenced SPP.");
    _builder_178.newLine();
    PostprocessingHelpers.setDocumentation(_reference_96, _builder_178.toString());
    EClass _class_50 = PostprocessingHelpers.getClass(pckg, "SPPoint");
    cls = _class_50;
    StringConcatenation _builder_179 = new StringConcatenation();
    _builder_179.append("Links to a {@link SPP} of an {@link ActorContainerRef}, i.e. an SPP of a sub actor");
    _builder_179.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_179.toString());
    EReference _reference_97 = PostprocessingHelpers.getReference(cls, "ref");
    StringConcatenation _builder_180 = new StringConcatenation();
    _builder_180.append("This is the referenced actor container ref.");
    _builder_180.newLine();
    PostprocessingHelpers.setDocumentation(_reference_97, _builder_180.toString());
    EReference _reference_98 = PostprocessingHelpers.getReference(cls, "service");
    StringConcatenation _builder_181 = new StringConcatenation();
    _builder_181.append("This is the referenced service.");
    _builder_181.newLine();
    PostprocessingHelpers.setDocumentation(_reference_98, _builder_181.toString());
    EClass _class_51 = PostprocessingHelpers.getClass(pckg, "ActorRef");
    cls = _class_51;
    StringConcatenation _builder_182 = new StringConcatenation();
    _builder_182.append("A means to compose {@link SubSystemClass}es of {@link ActorClass}es. Each ref will");
    _builder_182.newLine();
    _builder_182.append("be turned into an actor instance of the referenced type.");
    _builder_182.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_182.toString());
    EReference _reference_99 = PostprocessingHelpers.getReference(cls, "type");
    StringConcatenation _builder_183 = new StringConcatenation();
    _builder_183.append("This is the type (i.e. actor class) of the actor ref.");
    _builder_183.newLine();
    PostprocessingHelpers.setDocumentation(_reference_99, _builder_183.toString());
    EAttribute _attribute_31 = PostprocessingHelpers.getAttribute(cls, "multiplicity");
    StringConcatenation _builder_184 = new StringConcatenation();
    _builder_184.append("If the size is >1 then this is a replicated actor.");
    _builder_184.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_31, _builder_184.toString());
    EClass _class_52 = PostprocessingHelpers.getClass(pckg, "StateGraphNode");
    cls = _class_52;
    StringConcatenation _builder_185 = new StringConcatenation();
    _builder_185.append("The super class of");
    _builder_185.newLine();
    _builder_185.append("<ul>");
    _builder_185.newLine();
    _builder_185.append("  ");
    _builder_185.append("<li>{@link State}</li>");
    _builder_185.newLine();
    _builder_185.append("  ");
    _builder_185.append("<li>{@link ChoicePoint}</li>");
    _builder_185.newLine();
    _builder_185.append("  ");
    _builder_185.append("<li>{@link TrPoint}</li>");
    _builder_185.newLine();
    _builder_185.append("</ul>");
    _builder_185.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_185.toString());
    EClass _class_53 = PostprocessingHelpers.getClass(pckg, "StateGraphItem");
    cls = _class_53;
    StringConcatenation _builder_186 = new StringConcatenation();
    _builder_186.append("The super class of");
    _builder_186.newLine();
    _builder_186.append("<ul>");
    _builder_186.newLine();
    _builder_186.append("  ");
    _builder_186.append("<li>{@link StateGraphNode}</li>");
    _builder_186.newLine();
    _builder_186.append("  ");
    _builder_186.append("<li>{@link Transition}</li>");
    _builder_186.newLine();
    _builder_186.append("</ul>");
    _builder_186.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_186.toString());
    EClass _class_54 = PostprocessingHelpers.getClass(pckg, "State");
    cls = _class_54;
    StringConcatenation _builder_187 = new StringConcatenation();
    _builder_187.append("The super class of");
    _builder_187.newLine();
    _builder_187.append("<ul>");
    _builder_187.newLine();
    _builder_187.append("  ");
    _builder_187.append("<li>{@link SimpleState}</li>");
    _builder_187.newLine();
    _builder_187.append("  ");
    _builder_187.append("<li>{@link RefinedState}</li>");
    _builder_187.newLine();
    _builder_187.append("</ul>");
    _builder_187.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_187.toString());
    EReference _reference_100 = PostprocessingHelpers.getReference(cls, "docu");
    StringConcatenation _builder_188 = new StringConcatenation();
    _builder_188.append("This is an optional documentation.");
    _builder_188.newLine();
    PostprocessingHelpers.setDocumentation(_reference_100, _builder_188.toString());
    EReference _reference_101 = PostprocessingHelpers.getReference(cls, "entryCode");
    StringConcatenation _builder_189 = new StringConcatenation();
    _builder_189.append("This is an optional entry code written in the code generator\'s target language.");
    _builder_189.newLine();
    _builder_189.append("It is executed when the state is entered.");
    _builder_189.newLine();
    PostprocessingHelpers.setDocumentation(_reference_101, _builder_189.toString());
    EReference _reference_102 = PostprocessingHelpers.getReference(cls, "exitCode");
    StringConcatenation _builder_190 = new StringConcatenation();
    _builder_190.append("This is an optional entry code written in the code generator\'s target language.");
    _builder_190.newLine();
    _builder_190.append("It is executed when the state is left.");
    _builder_190.newLine();
    PostprocessingHelpers.setDocumentation(_reference_102, _builder_190.toString());
    EReference _reference_103 = PostprocessingHelpers.getReference(cls, "doCode");
    StringConcatenation _builder_191 = new StringConcatenation();
    _builder_191.append("This is an optional do code written in the code generator\'s target language.");
    _builder_191.newLine();
    _builder_191.append("It is executed whenever the actor instance is polled (applies only to");
    _builder_191.newLine();
    _builder_191.append("data driven and sync actor classes).");
    _builder_191.newLine();
    PostprocessingHelpers.setDocumentation(_reference_103, _builder_191.toString());
    EReference _reference_104 = PostprocessingHelpers.getReference(cls, "subgraph");
    StringConcatenation _builder_192 = new StringConcatenation();
    _builder_192.append("This is an optional sub state graph of this state.");
    _builder_192.newLine();
    PostprocessingHelpers.setDocumentation(_reference_104, _builder_192.toString());
    EClass _class_55 = PostprocessingHelpers.getClass(pckg, "StateGraph");
    cls = _class_55;
    StringConcatenation _builder_193 = new StringConcatenation();
    _builder_193.append("A state graph is a directed graph composed of");
    _builder_193.newLine();
    _builder_193.append("{@link StateGraphNode}s as nodes and {@link Transition}s as edges.");
    _builder_193.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_193.toString());
    EReference _reference_105 = PostprocessingHelpers.getReference(cls, "states");
    StringConcatenation _builder_194 = new StringConcatenation();
    _builder_194.append("This is a list of all states of this state graph.");
    _builder_194.newLine();
    PostprocessingHelpers.setDocumentation(_reference_105, _builder_194.toString());
    EReference _reference_106 = PostprocessingHelpers.getReference(cls, "trPoints");
    StringConcatenation _builder_195 = new StringConcatenation();
    _builder_195.append("This is a list of all transition, entry and exit points of this state graph.");
    _builder_195.newLine();
    PostprocessingHelpers.setDocumentation(_reference_106, _builder_195.toString());
    EReference _reference_107 = PostprocessingHelpers.getReference(cls, "chPoints");
    StringConcatenation _builder_196 = new StringConcatenation();
    _builder_196.append("This is a list of all choice points of this state graph.");
    _builder_196.newLine();
    PostprocessingHelpers.setDocumentation(_reference_107, _builder_196.toString());
    EReference _reference_108 = PostprocessingHelpers.getReference(cls, "transitions");
    StringConcatenation _builder_197 = new StringConcatenation();
    _builder_197.append("This is a list of all transitions of this state graph.");
    _builder_197.newLine();
    PostprocessingHelpers.setDocumentation(_reference_108, _builder_197.toString());
    EReference _reference_109 = PostprocessingHelpers.getReference(cls, "refinedTransitions");
    StringConcatenation _builder_198 = new StringConcatenation();
    _builder_198.append("This is a list of all refined transitions of this state graph.");
    _builder_198.newLine();
    PostprocessingHelpers.setDocumentation(_reference_109, _builder_198.toString());
    EClass _class_56 = PostprocessingHelpers.getClass(pckg, "SimpleState");
    cls = _class_56;
    StringConcatenation _builder_199 = new StringConcatenation();
    _builder_199.append("A simple state is the standard case of a @link State}.");
    _builder_199.newLine();
    _builder_199.append("It comprises and <em>entry</em>, <em>exit</em> and <em>do</em> code");
    _builder_199.newLine();
    _builder_199.append("and it can contain another {@link StateGraph} as sub state");
    _builder_199.newLine();
    _builder_199.append("graph.");
    _builder_199.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_199.toString());
    EAttribute _attribute_32 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_200 = new StringConcatenation();
    _builder_200.append("By this name the state is referred to in the model.");
    _builder_200.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_32, _builder_200.toString());
    EClass _class_57 = PostprocessingHelpers.getClass(pckg, "RefinedState");
    cls = _class_57;
    StringConcatenation _builder_201 = new StringConcatenation();
    _builder_201.append("A refined state can be used only in a derived {@link ActorClass}.");
    _builder_201.newLine();
    _builder_201.append("It refers to a {@link State} in the inherited state machine");
    _builder_201.newLine();
    _builder_201.append("which is refined by adding detail code and/or");
    _builder_201.newLine();
    _builder_201.append("{@link StateGraphItem}s in the sub state graph.");
    _builder_201.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_201.toString());
    EReference _reference_110 = PostprocessingHelpers.getReference(cls, "target");
    StringConcatenation _builder_202 = new StringConcatenation();
    _builder_202.append("This is the referenced state in the base class state machine.");
    _builder_202.newLine();
    PostprocessingHelpers.setDocumentation(_reference_110, _builder_202.toString());
    EClass _class_58 = PostprocessingHelpers.getClass(pckg, "DetailCode");
    cls = _class_58;
    StringConcatenation _builder_203 = new StringConcatenation();
    _builder_203.append("The detail code contains a list of strings which");
    _builder_203.newLine();
    _builder_203.append("are considered verbatim code of the code generator");
    _builder_203.newLine();
    _builder_203.append("target language.");
    _builder_203.newLine();
    _builder_203.newLine();
    _builder_203.append("<p>");
    _builder_203.newLine();
    _builder_203.append("The detail code is parsed by the {@link org.eclipse.etrice.generator.base.DetailCodeTranslator}");
    _builder_203.newLine();
    _builder_203.append("which replaces certain frequent constructs like access of members");
    _builder_203.newLine();
    _builder_203.append("and sending a message via a port by target language specific code.");
    _builder_203.newLine();
    _builder_203.append("</p>");
    _builder_203.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_203.toString());
    EAttribute _attribute_33 = PostprocessingHelpers.getAttribute(cls, "lines");
    StringConcatenation _builder_204 = new StringConcatenation();
    _builder_204.append("This is a list of commands in the code generator\'s target language.");
    _builder_204.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_33, _builder_204.toString());
    EClass _class_59 = PostprocessingHelpers.getClass(pckg, "TrPoint");
    cls = _class_59;
    StringConcatenation _builder_205 = new StringConcatenation();
    _builder_205.append("The super class of");
    _builder_205.newLine();
    _builder_205.append("<ul>");
    _builder_205.newLine();
    _builder_205.append("  ");
    _builder_205.append("<li>{@link TransitionPoint}</li>");
    _builder_205.newLine();
    _builder_205.append("  ");
    _builder_205.append("<li>{@link EntryPoint}</li>");
    _builder_205.newLine();
    _builder_205.append("  ");
    _builder_205.append("<li>{@link ExitPoint}</li>");
    _builder_205.newLine();
    _builder_205.append("</ul>");
    _builder_205.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_205.toString());
    EAttribute _attribute_34 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_206 = new StringConcatenation();
    _builder_206.append("By this name the transition, entry or exit point is referred to in the model.");
    _builder_206.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_34, _builder_206.toString());
    EClass _class_60 = PostprocessingHelpers.getClass(pckg, "TransitionPoint");
    cls = _class_60;
    StringConcatenation _builder_207 = new StringConcatenation();
    _builder_207.append("A transition point is located at the border of a {@link State}");
    _builder_207.newLine();
    _builder_207.append("and is not visible or accessible outside. It is used");
    _builder_207.newLine();
    _builder_207.append("to globally handle messages. If a {@link Transition} starting");
    _builder_207.newLine();
    _builder_207.append("at a transition point triggers then exit and entry codes");
    _builder_207.newLine();
    _builder_207.append("are executed as usual as long as the handler flag of the");
    _builder_207.newLine();
    _builder_207.append("transition point isn\'t set.");
    _builder_207.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_207.toString());
    EAttribute _attribute_35 = PostprocessingHelpers.getAttribute(cls, "handler");
    StringConcatenation _builder_208 = new StringConcatenation();
    _builder_208.append("If this flag is {@code true} then for a transition triggerd from this point");
    _builder_208.newLine();
    _builder_208.append("no exit and entry codes of the states left and entered are executed.");
    _builder_208.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_35, _builder_208.toString());
    EClass _class_61 = PostprocessingHelpers.getClass(pckg, "EntryPoint");
    cls = _class_61;
    StringConcatenation _builder_209 = new StringConcatenation();
    _builder_209.append("An entry point is located at the border of a {@link State}");
    _builder_209.newLine();
    _builder_209.append("and is visible and accessible outside. Outside");
    _builder_209.newLine();
    _builder_209.append("it can be the target of a {@link Transition} and inside the source.");
    _builder_209.newLine();
    _builder_209.append("If it is not connected in the interior then it is a");
    _builder_209.newLine();
    _builder_209.append("<em>transition to history</em>.");
    _builder_209.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_209.toString());
    EClass _class_62 = PostprocessingHelpers.getClass(pckg, "ExitPoint");
    cls = _class_62;
    StringConcatenation _builder_210 = new StringConcatenation();
    _builder_210.append("An exit point is located at the border of a {@link State}");
    _builder_210.newLine();
    _builder_210.append("and is visible and accessible outside. Outside");
    _builder_210.newLine();
    _builder_210.append("it can be the source of a {@link Transition} and inside the target.");
    _builder_210.newLine();
    _builder_210.append("If it is not connected in the interior then it is a");
    _builder_210.newLine();
    _builder_210.append("<em>group transition</em>.");
    _builder_210.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_210.toString());
    EClass _class_63 = PostprocessingHelpers.getClass(pckg, "ChoicePoint");
    cls = _class_63;
    StringConcatenation _builder_211 = new StringConcatenation();
    _builder_211.append("A choice point corresponds to an {@code if else} construct.");
    _builder_211.newLine();
    _builder_211.append("It is the target of one or more {@link Transition}s and the");
    _builder_211.newLine();
    _builder_211.append("source of several {@link Transition}s.");
    _builder_211.newLine();
    _builder_211.append("One outgoing transitions must be a {@link ContinuationTransition}");
    _builder_211.newLine();
    _builder_211.append("and corresponds to the final else. It is called the");
    _builder_211.newLine();
    _builder_211.append("<em>default branch</em> of the choice point.");
    _builder_211.newLine();
    _builder_211.append("All other outgoing transitions have to be {@link CPBranchTransition}s.");
    _builder_211.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_211.toString());
    EAttribute _attribute_36 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_212 = new StringConcatenation();
    _builder_212.append("By this name the choice point is referred to in the model.");
    _builder_212.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_36, _builder_212.toString());
    EReference _reference_111 = PostprocessingHelpers.getReference(cls, "docu");
    StringConcatenation _builder_213 = new StringConcatenation();
    _builder_213.append("This is an optional documentation.");
    _builder_213.newLine();
    PostprocessingHelpers.setDocumentation(_reference_111, _builder_213.toString());
    EClass _class_64 = PostprocessingHelpers.getClass(pckg, "Transition");
    cls = _class_64;
    StringConcatenation _builder_214 = new StringConcatenation();
    _builder_214.append("The super class of");
    _builder_214.newLine();
    _builder_214.append("<ul>");
    _builder_214.newLine();
    _builder_214.append("  ");
    _builder_214.append("<li>{@link InitialTransition}</li>");
    _builder_214.newLine();
    _builder_214.append("  ");
    _builder_214.append("<li>{@link NonInitialTransition}</li>");
    _builder_214.newLine();
    _builder_214.append("</ul>");
    _builder_214.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_214.toString());
    EAttribute _attribute_37 = PostprocessingHelpers.getAttribute(cls, "name");
    StringConcatenation _builder_215 = new StringConcatenation();
    _builder_215.append("This is an optional name of the transition.");
    _builder_215.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_37, _builder_215.toString());
    EReference _reference_112 = PostprocessingHelpers.getReference(cls, "docu");
    StringConcatenation _builder_216 = new StringConcatenation();
    _builder_216.append("This is an optional documentation.");
    _builder_216.newLine();
    PostprocessingHelpers.setDocumentation(_reference_112, _builder_216.toString());
    EReference _reference_113 = PostprocessingHelpers.getReference(cls, "to");
    StringConcatenation _builder_217 = new StringConcatenation();
    _builder_217.append("This is the target node of the transition.");
    _builder_217.newLine();
    PostprocessingHelpers.setDocumentation(_reference_113, _builder_217.toString());
    EReference _reference_114 = PostprocessingHelpers.getReference(cls, "action");
    StringConcatenation _builder_218 = new StringConcatenation();
    _builder_218.append("This is an optional code in the code generator\'s target language.");
    _builder_218.newLine();
    _builder_218.append("It is execute when the transition fires.");
    _builder_218.newLine();
    PostprocessingHelpers.setDocumentation(_reference_114, _builder_218.toString());
    EClass _class_65 = PostprocessingHelpers.getClass(pckg, "NonInitialTransition");
    cls = _class_65;
    StringConcatenation _builder_219 = new StringConcatenation();
    _builder_219.append("The super class of");
    _builder_219.newLine();
    _builder_219.append("<ul>");
    _builder_219.newLine();
    _builder_219.append("  ");
    _builder_219.append("<li>{@link TransitionChainStartTransition}</li>");
    _builder_219.newLine();
    _builder_219.append("  ");
    _builder_219.append("<li>{@link ContinuationTransition}</li>");
    _builder_219.newLine();
    _builder_219.append("  ");
    _builder_219.append("<li>{@link CPBranchTransition}</li>");
    _builder_219.newLine();
    _builder_219.append("</ul>");
    _builder_219.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_219.toString());
    EReference _reference_115 = PostprocessingHelpers.getReference(cls, "from");
    StringConcatenation _builder_220 = new StringConcatenation();
    _builder_220.append("This is the source node of the transition.");
    _builder_220.newLine();
    PostprocessingHelpers.setDocumentation(_reference_115, _builder_220.toString());
    EClass _class_66 = PostprocessingHelpers.getClass(pckg, "TransitionChainStartTransition");
    cls = _class_66;
    StringConcatenation _builder_221 = new StringConcatenation();
    _builder_221.append("The super class of");
    _builder_221.newLine();
    _builder_221.append("<ul>");
    _builder_221.newLine();
    _builder_221.append("  ");
    _builder_221.append("<li>{@link TriggeredTransition}</li>");
    _builder_221.newLine();
    _builder_221.append("  ");
    _builder_221.append("<li>{@link GuardedTransition}</li>");
    _builder_221.newLine();
    _builder_221.append("</ul>");
    _builder_221.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_221.toString());
    EClass _class_67 = PostprocessingHelpers.getClass(pckg, "InitialTransition");
    cls = _class_67;
    StringConcatenation _builder_222 = new StringConcatenation();
    _builder_222.append("There can be at most one initial transition in a {@link StateGraph}.");
    _builder_222.newLine();
    _builder_222.append("It defines the starting point of the state graph and is traversed");
    _builder_222.newLine();
    _builder_222.append("exactly once when the state graph is accessed for the first time.");
    _builder_222.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_222.toString());
    EClass _class_68 = PostprocessingHelpers.getClass(pckg, "ContinuationTransition");
    cls = _class_68;
    StringConcatenation _builder_223 = new StringConcatenation();
    _builder_223.append("Continuation transitions start at entry or exit points");
    _builder_223.newLine();
    _builder_223.append("({@link EntryPoint}s or {@link ExitPoint}s) or form");
    _builder_223.newLine();
    _builder_223.append("the default branch of a {@link ChoicePoint}.");
    _builder_223.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_223.toString());
    EClass _class_69 = PostprocessingHelpers.getClass(pckg, "TriggeredTransition");
    cls = _class_69;
    StringConcatenation _builder_224 = new StringConcatenation();
    _builder_224.append("Triggered transitions start at a {@link State} or a {@link TransitionPoint}.");
    _builder_224.newLine();
    _builder_224.append("It defines a list of {@link Trigger}s that specify the conditions");
    _builder_224.newLine();
    _builder_224.append("when the transition fires and is traversed. This kind of");
    _builder_224.newLine();
    _builder_224.append("transition is only allowed in event driven and mixed (async) state");
    _builder_224.newLine();
    _builder_224.append("machines.");
    _builder_224.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_224.toString());
    EReference _reference_116 = PostprocessingHelpers.getReference(cls, "triggers");
    StringConcatenation _builder_225 = new StringConcatenation();
    _builder_225.append("This is a list of all triggers of the transition.");
    _builder_225.newLine();
    PostprocessingHelpers.setDocumentation(_reference_116, _builder_225.toString());
    EClass _class_70 = PostprocessingHelpers.getClass(pckg, "GuardedTransition");
    cls = _class_70;
    StringConcatenation _builder_226 = new StringConcatenation();
    _builder_226.append("A guarded transition is very similar to a {@link CPBranchTransition}.");
    _builder_226.newLine();
    _builder_226.append("It defines a guard condition which lets the transition fire if");
    _builder_226.newLine();
    _builder_226.append("evaluated to {@code true}. This kind of transition is only");
    _builder_226.newLine();
    _builder_226.append("allowed in data driven or moixed (async) state machines.");
    _builder_226.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_226.toString());
    EReference _reference_117 = PostprocessingHelpers.getReference(cls, "guard");
    StringConcatenation _builder_227 = new StringConcatenation();
    _builder_227.append("This is the guard condition of the transition specified in the code generator\'s target language.");
    _builder_227.newLine();
    _builder_227.append("It has to evaluate to a boolean value.");
    _builder_227.newLine();
    PostprocessingHelpers.setDocumentation(_reference_117, _builder_227.toString());
    EClass _class_71 = PostprocessingHelpers.getClass(pckg, "CPBranchTransition");
    cls = _class_71;
    StringConcatenation _builder_228 = new StringConcatenation();
    _builder_228.append("The choice point branch transitions is allowed only as outgoing");
    _builder_228.newLine();
    _builder_228.append("transition of {@link ChoicePoint}s.");
    _builder_228.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_228.toString());
    EReference _reference_118 = PostprocessingHelpers.getReference(cls, "condition");
    StringConcatenation _builder_229 = new StringConcatenation();
    _builder_229.append("This is the condition of the choice point branch specified in the code generator\'s target language.");
    _builder_229.newLine();
    _builder_229.append("It has to evaluate to a boolean value.");
    _builder_229.newLine();
    PostprocessingHelpers.setDocumentation(_reference_118, _builder_229.toString());
    EClass _class_72 = PostprocessingHelpers.getClass(pckg, "RefinedTransition");
    cls = _class_72;
    StringConcatenation _builder_230 = new StringConcatenation();
    _builder_230.append("The refined transition is only allowed in {@link StateGraph}s");
    _builder_230.newLine();
    _builder_230.append("of derived {@link ActorClass}es. It targets a {@link Transition}");
    _builder_230.newLine();
    _builder_230.append("of the base class state machine.");
    _builder_230.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_230.toString());
    EReference _reference_119 = PostprocessingHelpers.getReference(cls, "action");
    StringConcatenation _builder_231 = new StringConcatenation();
    _builder_231.append("This is an optional code in the code generator\'s target language.");
    _builder_231.newLine();
    _builder_231.append("It is execute when the transition fires.");
    _builder_231.newLine();
    PostprocessingHelpers.setDocumentation(_reference_119, _builder_231.toString());
    EReference _reference_120 = PostprocessingHelpers.getReference(cls, "target");
    StringConcatenation _builder_232 = new StringConcatenation();
    _builder_232.append("This is the referenced transition in the base class state machine.");
    _builder_232.newLine();
    PostprocessingHelpers.setDocumentation(_reference_120, _builder_232.toString());
    EReference _reference_121 = PostprocessingHelpers.getReference(cls, "docu");
    StringConcatenation _builder_233 = new StringConcatenation();
    _builder_233.append("This is an optional documentation.");
    _builder_233.newLine();
    PostprocessingHelpers.setDocumentation(_reference_121, _builder_233.toString());
    EClass _class_73 = PostprocessingHelpers.getClass(pckg, "TransitionTerminal");
    cls = _class_73;
    StringConcatenation _builder_234 = new StringConcatenation();
    _builder_234.append("The super class of");
    _builder_234.newLine();
    _builder_234.append("<ul>");
    _builder_234.newLine();
    _builder_234.append("  ");
    _builder_234.append("<li>{@link StateTerminal}</li>");
    _builder_234.newLine();
    _builder_234.append("  ");
    _builder_234.append("<li>{@link TrPointTerminal}</li>");
    _builder_234.newLine();
    _builder_234.append("  ");
    _builder_234.append("<li>{@link SubStateTrPointTerminal}</li>");
    _builder_234.newLine();
    _builder_234.append("  ");
    _builder_234.append("<li>{@link ChoicepointTerminal}</li>");
    _builder_234.newLine();
    _builder_234.append("</ul>");
    _builder_234.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_234.toString());
    EClass _class_74 = PostprocessingHelpers.getClass(pckg, "StateTerminal");
    cls = _class_74;
    StringConcatenation _builder_235 = new StringConcatenation();
    _builder_235.append("The terminal point (source or target) of a transition ending");
    _builder_235.newLine();
    _builder_235.append("at a {@link State}.");
    _builder_235.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_235.toString());
    EReference _reference_122 = PostprocessingHelpers.getReference(cls, "state");
    StringConcatenation _builder_236 = new StringConcatenation();
    _builder_236.append("This is the target state.");
    _builder_236.newLine();
    PostprocessingHelpers.setDocumentation(_reference_122, _builder_236.toString());
    EClass _class_75 = PostprocessingHelpers.getClass(pckg, "TrPointTerminal");
    cls = _class_75;
    StringConcatenation _builder_237 = new StringConcatenation();
    _builder_237.append("The terminal point (source or target) of a transition ending");
    _builder_237.newLine();
    _builder_237.append("at a local {@link TrPoint}.");
    _builder_237.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_237.toString());
    EReference _reference_123 = PostprocessingHelpers.getReference(cls, "trPoint");
    StringConcatenation _builder_238 = new StringConcatenation();
    _builder_238.append("This is the target transition, entry or exit point.");
    _builder_238.newLine();
    PostprocessingHelpers.setDocumentation(_reference_123, _builder_238.toString());
    EClass _class_76 = PostprocessingHelpers.getClass(pckg, "SubStateTrPointTerminal");
    cls = _class_76;
    StringConcatenation _builder_239 = new StringConcatenation();
    _builder_239.append("The terminal point (source or target) of a transition ending");
    _builder_239.newLine();
    _builder_239.append("at a {@link TrPoint} of a sub {@link State}.");
    _builder_239.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_239.toString());
    EReference _reference_124 = PostprocessingHelpers.getReference(cls, "state");
    StringConcatenation _builder_240 = new StringConcatenation();
    _builder_240.append("This is the target state.");
    _builder_240.newLine();
    PostprocessingHelpers.setDocumentation(_reference_124, _builder_240.toString());
    EReference _reference_125 = PostprocessingHelpers.getReference(cls, "trPoint");
    StringConcatenation _builder_241 = new StringConcatenation();
    _builder_241.append("This is the target entry or exit point contained in the target state.");
    _builder_241.newLine();
    PostprocessingHelpers.setDocumentation(_reference_125, _builder_241.toString());
    EClass _class_77 = PostprocessingHelpers.getClass(pckg, "ChoicepointTerminal");
    cls = _class_77;
    StringConcatenation _builder_242 = new StringConcatenation();
    _builder_242.append("The terminal point (source or target) of a transition ending");
    _builder_242.newLine();
    _builder_242.append("at a {@link ChoicepointTerminal}.");
    _builder_242.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_242.toString());
    EReference _reference_126 = PostprocessingHelpers.getReference(cls, "cp");
    StringConcatenation _builder_243 = new StringConcatenation();
    _builder_243.append("This is the target choice point.");
    _builder_243.newLine();
    PostprocessingHelpers.setDocumentation(_reference_126, _builder_243.toString());
    EClass _class_78 = PostprocessingHelpers.getClass(pckg, "Trigger");
    cls = _class_78;
    StringConcatenation _builder_244 = new StringConcatenation();
    _builder_244.append("A transition trigger is a list of {@link MessageFromIf} pairs");
    _builder_244.newLine();
    _builder_244.append("and an optional {@link Guard}.");
    _builder_244.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_244.toString());
    EReference _reference_127 = PostprocessingHelpers.getReference(cls, "msgFromIfPairs");
    StringConcatenation _builder_245 = new StringConcatenation();
    _builder_245.append("This is a list of message/interface item pairs.");
    _builder_245.newLine();
    PostprocessingHelpers.setDocumentation(_reference_127, _builder_245.toString());
    EReference _reference_128 = PostprocessingHelpers.getReference(cls, "guard");
    StringConcatenation _builder_246 = new StringConcatenation();
    _builder_246.append("This is an optional guard condition of the trigger specified in the code generator\'s target language.");
    _builder_246.newLine();
    _builder_246.append("It has to evaluate to a boolean value.");
    _builder_246.newLine();
    PostprocessingHelpers.setDocumentation(_reference_128, _builder_246.toString());
    EClass _class_79 = PostprocessingHelpers.getClass(pckg, "MessageFromIf");
    cls = _class_79;
    StringConcatenation _builder_247 = new StringConcatenation();
    _builder_247.append("A pair consisting of a {@link Message} arising from an");
    _builder_247.newLine();
    _builder_247.append("{@link InterfaceItem}.");
    _builder_247.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_247.toString());
    EReference _reference_129 = PostprocessingHelpers.getReference(cls, "message");
    StringConcatenation _builder_248 = new StringConcatenation();
    _builder_248.append("This is the triggerering message (or event).");
    _builder_248.newLine();
    PostprocessingHelpers.setDocumentation(_reference_129, _builder_248.toString());
    EReference _reference_130 = PostprocessingHelpers.getReference(cls, "from");
    StringConcatenation _builder_249 = new StringConcatenation();
    _builder_249.append("This is the interface item where the message occurred.");
    _builder_249.newLine();
    PostprocessingHelpers.setDocumentation(_reference_130, _builder_249.toString());
    EClass _class_80 = PostprocessingHelpers.getClass(pckg, "Guard");
    cls = _class_80;
    StringConcatenation _builder_250 = new StringConcatenation();
    _builder_250.append("A detail code that evaluates to a boolean in the target");
    _builder_250.newLine();
    _builder_250.append("language.");
    _builder_250.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_250.toString());
    EReference _reference_131 = PostprocessingHelpers.getReference(cls, "guard");
    StringConcatenation _builder_251 = new StringConcatenation();
    _builder_251.append("This is a guard condition specified in the code generator\'s target language.");
    _builder_251.newLine();
    _builder_251.append("It has to evaluate to a boolean value.");
    _builder_251.newLine();
    PostprocessingHelpers.setDocumentation(_reference_131, _builder_251.toString());
    EClass _class_81 = PostprocessingHelpers.getClass(pckg, "Import");
    cls = _class_81;
    StringConcatenation _builder_252 = new StringConcatenation();
    _builder_252.append("The import declares an imported model (given as a URI) and");
    _builder_252.newLine();
    _builder_252.append("an optional imported namespace.");
    _builder_252.newLine();
    PostprocessingHelpers.setDocumentation(cls, _builder_252.toString());
    EAttribute _attribute_38 = PostprocessingHelpers.getAttribute(cls, "importedNamespace");
    StringConcatenation _builder_253 = new StringConcatenation();
    _builder_253.append("The imported name space has to be a dot separated qualified name followed by .*.");
    _builder_253.newLine();
    _builder_253.append("Example: my.namespace.*");
    _builder_253.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_38, _builder_253.toString());
    EAttribute _attribute_39 = PostprocessingHelpers.getAttribute(cls, "importURI");
    StringConcatenation _builder_254 = new StringConcatenation();
    _builder_254.append("The import URI can be a relative or absolute file system path.");
    _builder_254.newLine();
    _builder_254.append("It may contain environment variables in ${} which will be expanded.");
    _builder_254.newLine();
    _builder_254.append("<p>");
    _builder_254.newLine();
    _builder_254.append("Examples:");
    _builder_254.newLine();
    _builder_254.append("<ul>");
    _builder_254.newLine();
    _builder_254.append("  ");
    _builder_254.append("<li>import model \"AnotherModel.room\"</li>");
    _builder_254.newLine();
    _builder_254.append("  ");
    _builder_254.append("<li>import my.namespace.* from \"AnotherModel.room\"</li>");
    _builder_254.newLine();
    _builder_254.append("  ");
    _builder_254.append("<li>import my.namespace.* from \"../../AnotherProject/models/AnotherModel.room\"</li>");
    _builder_254.newLine();
    _builder_254.append("  ");
    _builder_254.append("<li>import my.namespace.* from \"/${ROOM_MODELS}/SomeModel.room\"</li>");
    _builder_254.newLine();
    _builder_254.append("</ul>");
    _builder_254.newLine();
    _builder_254.append("</p>");
    _builder_254.newLine();
    PostprocessingHelpers.setDocumentation(_attribute_39, _builder_254.toString());
  }
}
