/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.contentassist;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.common.base.AnnotationType;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorInstanceMapping;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.RefPath;
import org.eclipse.etrice.core.room.RoomAnnotationTargetEnum;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.core.ui.contentassist.AbstractRoomProposalProvider;
import org.eclipse.etrice.core.ui.contentassist.IProposalFilter;
import org.eclipse.etrice.core.ui.contentassist.ImportModelAssist;
import org.eclipse.etrice.core.validation.ValidationUtil;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.editor.contentassist.AbstractContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class RoomProposalProvider
extends AbstractRoomProposalProvider {
    protected Function<IEObjectDescription, ICompletionProposal> getProposalFactory(String ruleName, ContentAssistContext contentAssistContext) {
        if (contentAssistContext != null && contentAssistContext.getCurrentModel().eClass() == RoomPackage.eINSTANCE.getActorRef()) {
            return new FilteredProposalCreator(new ActorRefFilter(), contentAssistContext, ruleName);
        }
        return super.getProposalFactory(ruleName, contentAssistContext);
    }

    @Override
    public void completeImport_ImportURI(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ImportModelAssist.addPaths((AbstractContentProposalProvider)this, context, acceptor, ".room");
    }

    @Override
    public void completeActorInstanceMapping_Path(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeActorInstanceMapping_Path(model, assignment, context, acceptor);
        List<ActorRef> instances = this.collectInstances((ActorInstanceMapping)model);
        for (ActorRef instance : instances) {
            acceptor.accept(this.createCompletionProposal(instance.getName(), context));
        }
    }

    @Override
    public void completeRefPath_Refs(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeRefPath_Refs(model, assignment, context, acceptor);
        if (model instanceof ActorInstanceMapping) {
            this.completeActorInstanceMapping_Path(model, assignment, context, acceptor);
            return;
        }
        RefPath path = (RefPath)model;
        if (path.eContainer() instanceof ActorInstanceMapping) {
            List<ActorRef> instances = this.collectInstances((ActorInstanceMapping)path.eContainer());
            for (ActorRef instance : instances) {
                acceptor.accept(this.createCompletionProposal(instance.getName(), context));
            }
        }
    }

    @Override
    public void complete_AnnotationTargetType(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        BasicEList existingTargets = new BasicEList();
        if (model instanceof AnnotationType) {
            existingTargets.addAll((Collection)((AnnotationType)model).getTargets());
        }
        RoomAnnotationTargetEnum[] roomAnnotationTargetEnumArray = RoomAnnotationTargetEnum.values();
        int n = roomAnnotationTargetEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            RoomAnnotationTargetEnum t = roomAnnotationTargetEnumArray[n2];
            String targetName = t.getLiteral();
            if (!existingTargets.isEmpty() && !existingTargets.contains((Object)targetName)) {
                acceptor.accept(this.createCompletionProposal(targetName, context));
            }
            ++n2;
        }
    }

    private List<ActorRef> collectInstances(ActorInstanceMapping aim) {
        ArrayList<ActorRef> refs = new ArrayList<ActorRef>();
        ActorContainerClass root = RoomHelpers.getParentContainer((ActorInstanceMapping)aim);
        if (root != null) {
            RefPath path = aim.getPath();
            if (path != null && !path.getRefs().isEmpty()) {
                root = RoomHelpers.getActorContainerClass((ActorInstanceMapping)aim);
            }
            if (root != null) {
                for (ActorContainerRef ref : RoomHelpers.getRefs((StructureClass)root, (boolean)true)) {
                    ActorRef aRef;
                    if (!(ref instanceof ActorRef) || (aRef = (ActorRef)ref).getMultiplicity() != 1) continue;
                    refs.add((ActorRef)ref);
                }
            }
        }
        return refs;
    }

    protected class ActorRefFilter
    implements IProposalFilter {
        protected ActorRefFilter() {
        }

        @Override
        public boolean accept(ContentAssistContext context, IEObjectDescription candidate) {
            if (!(context.getCurrentModel() instanceof ActorRef)) {
                return false;
            }
            ActorRef ar = (ActorRef)context.getCurrentModel();
            if (!(ar.eContainer() instanceof ActorClass)) {
                return true;
            }
            ActorClass ac = (ActorClass)ar.eContainer();
            EObject objectOrProxy = candidate.getEObjectOrProxy();
            if (objectOrProxy instanceof ActorClass) {
                ActorClass referenced = (ActorClass)objectOrProxy;
                return !ValidationUtil.isReferencing((ActorClass)referenced, (ActorClass)ac);
            }
            return false;
        }
    }

    protected class FilteredProposalCreator
    implements Function<IEObjectDescription, ICompletionProposal> {
        private IProposalFilter filter;
        private final ContentAssistContext contentAssistContext;
        private final String ruleName;

        protected FilteredProposalCreator(IProposalFilter filter, ContentAssistContext contentAssistContext, String ruleName) {
            this.filter = filter;
            this.contentAssistContext = contentAssistContext;
            this.ruleName = ruleName;
        }

        public ICompletionProposal apply(IEObjectDescription candidate) {
            EObject objectOrProxy;
            if (candidate == null) {
                return null;
            }
            ICompletionProposal result = null;
            String proposal = candidate.getName().toString();
            if (this.ruleName != null) {
                proposal = RoomProposalProvider.this.getValueConverter().toString((Object)proposal, this.ruleName);
            }
            if (!(objectOrProxy = candidate.getEObjectOrProxy()).eIsProxy() && this.filter != null && !this.filter.accept(this.contentAssistContext, candidate)) {
                return null;
            }
            StyledString displayString = RoomProposalProvider.this.getStyledDisplayString(objectOrProxy, candidate.getQualifiedName().toString(), candidate.getName().toString());
            Image image = RoomProposalProvider.this.getImage(objectOrProxy);
            result = RoomProposalProvider.this.createCompletionProposal(proposal, displayString, image, this.contentAssistContext);
            RoomProposalProvider.this.getPriorityHelper().adjustCrossReferencePriority(result, this.contentAssistContext.getPrefix());
            return result;
        }
    }
}

