/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.naming;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.BindingEndPoint;
import org.eclipse.etrice.core.room.CPBranchTransition;
import org.eclipse.etrice.core.room.ChoicePoint;
import org.eclipse.etrice.core.room.ChoicepointTerminal;
import org.eclipse.etrice.core.room.ContinuationTransition;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.GuardedTransition;
import org.eclipse.etrice.core.room.InitialTransition;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.MessageFromIf;
import org.eclipse.etrice.core.room.NonInitialTransition;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.RefinedState;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.SPP;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.StateTerminal;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubStateTrPointTerminal;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.SubSystemRef;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.TrPointTerminal;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.TransitionTerminal;
import org.eclipse.etrice.core.room.Trigger;
import org.eclipse.etrice.core.room.TriggeredTransition;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.core.room.util.RoomSwitch;

public class RoomNameProvider {
    public static final String TOP_STATE_NAME = "TOP";
    public static final String PATH_SEP = "_";
    private static RoomSwitch<String> nameProvider = new RoomSwitch<String>(){

        @Override
        public String caseState(State object) {
            return RoomNameProvider.getStateName(object);
        }

        @Override
        public String caseChoicePoint(ChoicePoint object) {
            return object.getName();
        }

        @Override
        public String caseTrPoint(TrPoint object) {
            return object.getName();
        }

        @Override
        public String caseTransition(Transition object) {
            return RoomNameProvider.getTransitionName(object);
        }

        @Override
        public String caseActorRef(ActorRef object) {
            return "ActorRef '" + object.getName() + "'";
        }

        @Override
        public String casePort(Port object) {
            return "Port '" + object.getName() + "'";
        }

        @Override
        public String caseSAP(SAP object) {
            return "SAP '" + object.getName() + "'";
        }

        @Override
        public String caseSPP(SPP object) {
            return "SPP '" + object.getName() + "'";
        }

        @Override
        public String caseActorClass(ActorClass object) {
            return "ActorClass " + object.getName();
        }

        @Override
        public String caseSubSystemClass(SubSystemClass object) {
            return "SubsystemClass " + object.getName();
        }
    };

    public static String getName(EObject item) {
        String name = (String)nameProvider.doSwitch(item);
        if (name == null) {
            name = item.toString();
        }
        return name;
    }

    public static String getFullPath(StateGraphItem item) {
        return String.valueOf(RoomNameProvider.getParentPath(item)) + RoomNameProvider.getName(item);
    }

    public static String getFullPath(StateGraph sg) {
        if (sg.eContainer() instanceof State) {
            return RoomNameProvider.getFullPath((State)sg.eContainer());
        }
        return TOP_STATE_NAME;
    }

    public static RoomClass getModelClass(EObject obj) {
        while (obj != null) {
            if (obj instanceof RoomClass) {
                return (RoomClass)obj;
            }
            obj = obj.eContainer();
        }
        return null;
    }

    public static String getClassLocation(RoomClass cls) {
        if (cls == null) {
            return null;
        }
        if (cls.eContainer() instanceof RoomModel) {
            return String.valueOf(((RoomModel)cls.eContainer()).getName()) + "." + cls.getName();
        }
        return cls.getName();
    }

    public static String getLocation(EObject source) {
        String location = null;
        String clsLocation = RoomNameProvider.getClassLocation(RoomNameProvider.getModelClass(source));
        while (source != null) {
            if (source instanceof StateGraph) {
                location = RoomNameProvider.getFullPath((StateGraph)source);
                break;
            }
            if (source instanceof StateGraphItem) {
                location = RoomNameProvider.getFullPath((StateGraphItem)source);
                break;
            }
            location = RoomNameProvider.getName(source);
            if (location != null) break;
            source = source.eContainer();
        }
        if (location == null) {
            location = "";
        }
        if (clsLocation != null) {
            location = String.valueOf(location) + " [" + clsLocation + "]";
        }
        return location;
    }

    public static String getTransitionName(Transition t) {
        String toName = RoomNameProvider.getTerminalName(t.getTo());
        if (t instanceof InitialTransition) {
            return "TRANS_INITIAL_TO__" + toName;
        }
        String fromName = RoomNameProvider.getTerminalName(((NonInitialTransition)t).getFrom());
        String fromTo = "TRANS_" + t.getName() + "_FROM_" + fromName + "_TO_" + toName;
        if (t instanceof TriggeredTransition) {
            if (fromName.equals(toName)) {
                return String.valueOf(fromTo) + "_BY_" + RoomNameProvider.getTriggerName((TriggeredTransition)t) + PATH_SEP + t.getName();
            }
            return String.valueOf(fromTo) + "_BY_" + RoomNameProvider.getTriggerName((TriggeredTransition)t);
        }
        if (t instanceof ContinuationTransition) {
            return fromTo;
        }
        if (t instanceof CPBranchTransition) {
            return String.valueOf(fromTo) + "_COND_" + t.getName();
        }
        if (t instanceof GuardedTransition) {
            return String.valueOf(fromTo) + "_GUARD_" + t.getName();
        }
        assert (false) : "Unexpected transition class " + t.eClass().getName();
        return null;
    }

    private static boolean isTopLevel(StateGraphItem item) {
        return item == null ? true : !(item.eContainer().eContainer() instanceof State);
    }

    private static State getParentState(StateGraphItem item) {
        if (RoomNameProvider.isTopLevel(item)) {
            return null;
        }
        return (State)item.eContainer().eContainer();
    }

    public static String getStateName(State s) {
        if (s == null) {
            return TOP_STATE_NAME;
        }
        return s.getName();
    }

    public static String getStatePathName(State s) {
        return String.valueOf(RoomNameProvider.getParentPath(s)) + RoomNameProvider.getStateName(s);
    }

    private static String getParentPath(StateGraphItem item) {
        State parent;
        if (item instanceof RefinedState) {
            item = ((RefinedState)item).getTarget();
        }
        if ((parent = RoomNameProvider.getParentState(item)) == null) {
            return "";
        }
        return String.valueOf(RoomNameProvider.getStatePathName(parent)) + PATH_SEP;
    }

    private static String getTriggerName(TriggeredTransition tr) {
        String result = "";
        for (Trigger tri : tr.getTriggers()) {
            for (MessageFromIf mif : tri.getMsgFromIfPairs()) {
                result = String.valueOf(result) + mif.getMessage().getName() + mif.getFrom().getName();
            }
        }
        return result;
    }

    private static String getTerminalName(TransitionTerminal tt) {
        if (tt instanceof StateTerminal) {
            return RoomNameProvider.getStateName(((StateTerminal)tt).getState());
        }
        if (tt instanceof TrPointTerminal) {
            return ((TrPointTerminal)tt).getTrPoint().getName();
        }
        if (tt instanceof SubStateTrPointTerminal) {
            return String.valueOf(RoomNameProvider.getStatePathName(((SubStateTrPointTerminal)tt).getState())) + PATH_SEP + ((SubStateTrPointTerminal)tt).getTrPoint().getName();
        }
        if (tt instanceof ChoicepointTerminal) {
            return ((ChoicepointTerminal)tt).getCp().getName();
        }
        assert (false) : "Unexpected TransitionTerminal class " + tt.eClass().getName();
        return null;
    }

    public static String getUniqueTransitionName(StateGraph sg) {
        Set<String> names = RoomHelpers.getAllNames(sg);
        int i = 0;
        while (i < 1000) {
            String name = "tr" + i;
            if (!names.contains(name)) {
                return name;
            }
            ++i;
        }
        return "not_unique";
    }

    public static String getUniqueInitialTransitionName(StateGraph sg) {
        Set<String> names = RoomHelpers.getAllNames(sg);
        if (!names.contains("init")) {
            return "init";
        }
        int i = 0;
        while (i < 1000) {
            String name = "init" + i;
            if (!names.contains(name)) {
                return name;
            }
            ++i;
        }
        return "not_unique";
    }

    public static String getUniqueChoicePointName(StateGraph sg) {
        Set<String> names = RoomHelpers.getAllNames(sg);
        int i = 0;
        while (i < 1000) {
            String name = "cp" + i;
            if (!names.contains(name)) {
                return name;
            }
            ++i;
        }
        return "not_unique";
    }

    public static String getUniqueTrPointName(StateGraph sg) {
        Set<String> names = RoomHelpers.getAllNames(sg);
        int i = 0;
        while (i < 1000) {
            String name = "tp" + i;
            if (!names.contains(name)) {
                return name;
            }
            ++i;
        }
        return "not_unique";
    }

    public static String getUniqueStateName(StateGraph sg) {
        Set<String> names = RoomHelpers.getAllNames(sg);
        int i = 0;
        while (i < 1000) {
            String name = "state" + i;
            if (!names.contains(name)) {
                return name;
            }
            ++i;
        }
        return "not_unique";
    }

    public static String getRefLabelName(ActorContainerRef acr) {
        String className = "<unknown>";
        if (acr instanceof ActorRef) {
            if (((ActorRef)acr).getType() != null) {
                className = ((ActorRef)acr).getType().getName();
            }
        } else if (acr instanceof SubSystemRef && ((SubSystemRef)acr).getType() != null) {
            className = ((SubSystemRef)acr).getType().getName();
        }
        return String.valueOf(acr.getName()) + "\n(" + className + ")";
    }

    public static String getTransitionLabelName(Transition t) {
        String name = null;
        if (t instanceof InitialTransition) {
            return "init";
        }
        name = t.getName() != null ? String.valueOf(t.getName()) + ": " : "";
        NonInitialTransition nit = (NonInitialTransition)t;
        if (nit.getFrom() instanceof ChoicepointTerminal) {
            CPBranchTransition cpt;
            if (nit instanceof ContinuationTransition) {
                return String.valueOf(name) + "[else]";
            }
            if (nit instanceof CPBranchTransition && (cpt = (CPBranchTransition)nit).getCondition() != null && !cpt.getCondition().getLines().isEmpty()) {
                return String.valueOf(name) + "[" + (String)cpt.getCondition().getLines().get(0) + "]";
            }
            return String.valueOf(name) + "[?]";
        }
        if (t instanceof TriggeredTransition) {
            boolean first = true;
            for (Trigger trig : ((TriggeredTransition)t).getTriggers()) {
                if (first) {
                    first = false;
                } else {
                    name = String.valueOf(name) + "or";
                }
                name = String.valueOf(name) + RoomNameProvider.getTriggerLabel(trig);
            }
        }
        if (t instanceof GuardedTransition) {
            name = String.valueOf(name) + " guard {" + (String)((GuardedTransition)t).getGuard().getLines().get(0) + "}";
        }
        return name;
    }

    public static String getTriggerLabel(Trigger trig) {
        String name = "<";
        boolean first = true;
        for (MessageFromIf mif : trig.getMsgFromIfPairs()) {
            if (first) {
                first = false;
            } else {
                name = String.valueOf(name) + "|";
            }
            name = String.valueOf(name) + RoomNameProvider.getMsgFromIfLabel(mif);
        }
        if (trig.getGuard() != null && !trig.getGuard().getGuard().getLines().isEmpty()) {
            name = String.valueOf(name) + " guard {" + (String)trig.getGuard().getGuard().getLines().get(0) + "}";
        }
        return String.valueOf(name) + ">";
    }

    public static String getMsgFromIfLabel(MessageFromIf mif) {
        return String.valueOf(mif.getMessage().getName()) + ":" + mif.getFrom().getName();
    }

    public static String getStateGraphLabel(StateGraph sg) {
        if (sg.eContainer() instanceof State) {
            State s = (State)sg.eContainer();
            return RoomNameProvider.getStatePathLabel(s);
        }
        return "/";
    }

    public static String getStatePathLabel(State s) {
        if (s.eContainer().eContainer() instanceof State) {
            return String.valueOf(RoomNameProvider.getStatePathLabel((State)s.eContainer().eContainer())) + "/" + s.getName();
        }
        return "/" + s.getName();
    }

    public static String getUniqueActorContainerRefName(StructureClass sc) {
        HashSet<String> names = new HashSet<String>();
        if (sc instanceof ActorContainerClass) {
            for (ActorContainerRef ar : ((ActorContainerClass)sc).getActorRefs()) {
                names.add(ar.getName());
            }
        } else if (sc instanceof LogicalSystem) {
            for (ActorContainerRef ar : ((LogicalSystem)sc).getSubSystems()) {
                names.add(ar.getName());
            }
        }
        int i = 0;
        while (i < 1000) {
            String name = "ref" + i;
            if (!names.contains(name)) {
                return name;
            }
            ++i;
        }
        return "not_unique";
    }

    public static String getUniqueInterfaceItemName(String prefix, ActorContainerClass acc) {
        HashSet<String> names = new HashSet<String>();
        if (acc instanceof ActorClass) {
            ActorClass ac = (ActorClass)acc;
            do {
                for (Port p : ac.getInterfacePorts()) {
                    names.add(p.getName());
                }
                for (Port p : ac.getInternalPorts()) {
                    names.add(p.getName());
                }
                for (SAP sap : ac.getServiceAccessPoints()) {
                    names.add(sap.getName());
                }
                for (Object spp : ac.getServiceProvisionPoints()) {
                    names.add(spp.getName());
                }
            } while ((ac = ac.getBase()) != null);
        } else if (acc instanceof SubSystemClass) {
            for (Port p : ((SubSystemClass)acc).getRelayPorts()) {
                names.add(p.getName());
            }
            for (SPP spp : ((SubSystemClass)acc).getServiceProvisionPoints()) {
                names.add(spp.getName());
            }
        }
        int i = 0;
        while (i < 1000) {
            String name = String.valueOf(prefix) + i;
            if (!names.contains(name)) {
                return name;
            }
            ++i;
        }
        return "not_unique";
    }

    public static String getDetailCodeLocation(DetailCode code) {
        if (code.eContainer() instanceof Transition) {
            Transition tr = (Transition)code.eContainer();
            String where = "?";
            if (code == tr.getAction()) {
                where = "action";
            } else if (tr instanceof CPBranchTransition && code == ((CPBranchTransition)tr).getCondition()) {
                where = "condition";
            } else if (tr instanceof GuardedTransition && code == ((GuardedTransition)tr).getGuard()) {
                where = "guard";
            }
            return "transition " + tr.getName() + ": " + RoomNameProvider.getTransitionName(tr) + " " + where + " code";
        }
        if (code.eContainer() instanceof Trigger) {
            Transition tr = (Transition)code.eContainer().eContainer();
            return "transition " + tr.getName() + ": " + RoomNameProvider.getTransitionName(tr) + " trigger guard";
        }
        if (code.eContainer() instanceof State) {
            State state = (State)code.eContainer();
            String where = "?";
            where = code == state.getEntryCode() ? "entry" : (code == state.getExitCode() ? "exit" : "do");
            return "state " + RoomNameProvider.getStatePathName(state) + " " + where + " code";
        }
        if (code.eContainer() instanceof Operation) {
            return "operation " + RoomHelpers.getSignature((Operation)code.eContainer());
        }
        assert (false) : "unexpected detaild code location";
        return "???";
    }

    public static String getDisplayName(BindingEndPoint ep) {
        if (ep.getSub() != null) {
            return String.valueOf(ep.getPort().getName()) + " sub " + ep.getSub().getName();
        }
        return ep.getPort().getName();
    }

    public static String getDisplayName(Binding bind) {
        return String.valueOf(RoomNameProvider.getDisplayName(bind.getEndpoint1())) + " and " + RoomNameProvider.getDisplayName(bind.getEndpoint2());
    }
}

