/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c;

import com.google.inject.Inject;
import com.google.inject.Module;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.etrice.core.etmap.ETMapStandaloneSetup;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.ETPhysStandaloneSetup;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.IDiagnostician;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.generator.base.AbstractGenerator;
import org.eclipse.etrice.generator.base.GlobalGeneratorSettings;
import org.eclipse.etrice.generator.base.IDataConfiguration;
import org.eclipse.etrice.generator.c.gen.Validator;
import org.eclipse.etrice.generator.c.setup.GeneratorModule;
import org.eclipse.etrice.generator.doc.gen.MainGen;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IGenerator;

public class Main
extends AbstractGenerator {
    @Inject
    private IGenerator mainGenerator;
    @Inject
    protected MainGen mainDocGenerator;
    @Inject
    private Validator validator;
    @Inject
    protected IDataConfiguration dataConfig;

    protected void printUsage() {
        output.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + this.getCommonOptions() + " <list of model file paths>");
        output.println(this.getCommonOptionDescriptions());
    }

    public static void main(String[] args) {
        int ret = Main.createAndRunGenerator((Module)new GeneratorModule(), (String[])args);
        if (Main.isTerminateOnError() && ret != 0) {
            System.exit(ret);
        }
    }

    public static GlobalGeneratorSettings getSettings() {
        return Main.getInstance().getGeneratorSettings();
    }

    protected void setupMappingModel() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            ETMapStandaloneSetup.doSetup();
        }
    }

    protected void setupPhysicalModel() {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            ETPhysStandaloneSetup.doSetup();
        }
    }

    protected int runGenerator() {
        this.setupRoomModel();
        this.dataConfig.doSetup();
        this.setupMappingModel();
        this.setupPhysicalModel();
        if (!this.loadModels(Main.getSettings().getInputModelURIs())) {
            this.logger.logInfo("loading of models failed");
            this.logger.logError("-- terminating", null);
            return 1;
        }
        if (!this.validateModels()) {
            this.logger.logInfo("validation failed");
            this.logger.logError("-- terminating", null);
            return 1;
        }
        if (!this.dataConfig.setResources(this.getResourceSet(), (ILogger)this.logger)) {
            this.logger.logInfo("configuration errors");
            this.logger.logError("-- terminating", null);
            return 1;
        }
        Root genModel = this.createGeneratorModel(Main.getSettings().isGenerateAsLibrary(), Main.getSettings().getGeneratorModelPath());
        if (this.diagnostician.isFailed() || genModel == null) {
            this.logger.logInfo("errors during build of generator model");
            this.logger.logError("-- terminating", null);
            return 1;
        }
        if (!this.validator.validate(genModel)) {
            this.logger.logInfo("validation failed during build of generator model");
            this.logger.logError("-- terminating", null);
            return 1;
        }
        ETMapUtil.processModels((Root)genModel, (ResourceSet)this.getResourceSet(), (IDiagnostician)this.diagnostician);
        if (Main.getSettings().isDebugMode()) {
            this.logger.logInfo("-- begin dump of mappings");
            this.logger.logInfo(ETMapUtil.dumpMappings());
            this.logger.logInfo("-- end dump of mappings");
        }
        if (this.diagnostician.isFailed() || genModel == null) {
            this.logger.logInfo("errors in mapping");
            this.logger.logError("-- terminating", null);
            return 1;
        }
        this.logger.logInfo("-- starting code generation");
        this.fileAccess.setOutputPath("src-gen/");
        this.mainGenerator.doGenerate(genModel.eResource(), (IFileSystemAccess)this.fileAccess);
        if (Main.getSettings().isGenerateDocumentation()) {
            this.mainDocGenerator.doGenerate(genModel.eResource(), (IFileSystemAccess)this.fileAccess);
        }
        if (this.diagnostician.isFailed()) {
            this.logger.logInfo("errors during code generation");
            this.logger.logError("-- terminating", null);
            return 1;
        }
        this.logger.logInfo("-- finished code generation");
        return 0;
    }
}

