/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumLiteral;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.generator.base.IGeneratorFileIo;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class EnumerationTypeGen {
    @Inject
    private IGeneratorFileIo fileIO;
    @Inject
    @Extension
    private CExtensions _cExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private TypeHelpers _typeHelpers;

    public void doGenerate(Root root) {
        EList _usedEnumClasses = root.getUsedEnumClasses();
        for (EnumerationType et : _usedEnumClasses) {
            String _cSourceFileName;
            String _generationTargetPath = this._roomExtensions.getGenerationTargetPath((EObject)et);
            String _path = this._roomExtensions.getPath((RoomClass)et);
            String path = String.valueOf(_generationTargetPath) + _path;
            String _generationInfoPath = this._roomExtensions.getGenerationInfoPath((EObject)et);
            String _path_1 = this._roomExtensions.getPath((RoomClass)et);
            String infopath = String.valueOf(_generationInfoPath) + _path_1;
            String file = this._cExtensions.getCHeaderFileName((RoomClass)et);
            CharSequence _generateHeaderFile = this.generateHeaderFile(root, et);
            this.fileIO.generateFile("generating Enumeration header", path, infopath, file, _generateHeaderFile);
            file = _cSourceFileName = this._cExtensions.getCSourceFileName((RoomClass)et);
            CharSequence _generateSourceFile = this.generateSourceFile(root, et);
            this.fileIO.generateFile("generating Enumeration source", path, infopath, file, _generateSourceFile);
        }
    }

    private CharSequence generateHeaderFile(Root root, EnumerationType et) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Header File of Enumeration ");
        String _name = et.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        CharSequence _generateIncludeGuardBegin = this._cExtensions.generateIncludeGuardBegin((RoomClass)et);
        _builder.append((Object)_generateIncludeGuardBegin, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"#include \"etDatatypes.h\"");
        _builder.newLine();
        _builder.newLine();
        PrimitiveType _primitiveType = et.getPrimitiveType();
        boolean bl = _notEquals = !Objects.equal((Object)_primitiveType, null);
        if (_notEquals) {
            EList _literals = et.getLiterals();
            for (EnumLiteral lit : _literals) {
                _builder.append((Object)"#define ");
                String _name_1 = et.getName();
                _builder.append((Object)_name_1, "");
                _builder.append((Object)"_");
                String _name_2 = lit.getName();
                _builder.append((Object)_name_2, "");
                _builder.append((Object)" ");
                String _castedValue = this._cExtensions.getCastedValue(lit);
                _builder.append((Object)_castedValue, "");
                _builder.newLineIfNotEmpty();
            }
        } else {
            _builder.append((Object)"typedef enum ");
            String _name_3 = et.getName();
            _builder.append((Object)_name_3, "");
            _builder.append((Object)" {");
            _builder.newLineIfNotEmpty();
            EList _literals_1 = et.getLiterals();
            boolean _hasElements = false;
            for (EnumLiteral lit_1 : _literals_1) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "\t");
                }
                _builder.append((Object)"\t");
                String _name_4 = et.getName();
                _builder.append((Object)_name_4, "\t");
                _builder.append((Object)"_");
                String _name_5 = lit_1.getName();
                _builder.append((Object)_name_5, "\t");
                _builder.append((Object)" = ");
                long _literalValue = lit_1.getLiteralValue();
                _builder.append((Object)_literalValue, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"}");
            _builder.newLine();
            String _name_6 = et.getName();
            _builder.append((Object)_name_6, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"const char* ");
        String _name_7 = et.getName();
        _builder.append((Object)_name_7, "");
        _builder.append((Object)"_getLiteralName(");
        String _typeName = this._typeHelpers.typeName((DataType)et);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" literal);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateIncludeGuardEnd = this._cExtensions.generateIncludeGuardEnd((RoomClass)et);
        _builder.append((Object)_generateIncludeGuardEnd, "");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence generateSourceFile(Root root, EnumerationType et) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* Source File of ProtocolClass ");
        String _name = et.getName();
        _builder.append((Object)_name, " ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)" ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"#include \"");
        String _cHeaderFileName = this._cExtensions.getCHeaderFileName((RoomClass)et);
        _builder.append((Object)_cHeaderFileName, "");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"const char* ");
        String _name_1 = et.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"_getLiteralName(");
        String _typeName = this._typeHelpers.typeName((DataType)et);
        _builder.append((Object)_typeName, "");
        _builder.append((Object)" literal) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"switch(literal) {");
        _builder.newLine();
        EList _literals = et.getLiterals();
        for (EnumLiteral lit : _literals) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"case ");
            String _name_2 = et.getName();
            _builder.append((Object)_name_2, "\t\t");
            _builder.append((Object)"_");
            String _name_3 = lit.getName();
            _builder.append((Object)_name_3, "\t\t");
            _builder.append((Object)": return \"");
            String _name_4 = lit.getName();
            _builder.append((Object)_name_4, "\t\t");
            _builder.append((Object)"\";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return NULL;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }
}

