/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.CodegenHelpers;
import org.eclipse.etrice.generator.base.GlobalGeneratorSettings;
import org.eclipse.etrice.generator.c.Main;
import org.eclipse.etrice.generator.generic.GenericStateMachineGenerator;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class StateMachineGen
extends GenericStateMachineGenerator {
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;

    public CharSequence genHeaderConstants(ExpandedActorClass xpac) {
        StringConcatenation _xblockexpression = null;
        ActorClass ac = xpac.getActorClass();
        StateGraph _stateMachine = xpac.getStateMachine();
        List _baseStateList = RoomHelpers.getBaseStateList((StateGraph)_stateMachine);
        int _size = _baseStateList.size();
        StateGraph _stateMachine_1 = xpac.getStateMachine();
        List _leafStateList = RoomHelpers.getLeafStateList((StateGraph)_stateMachine_1);
        int _size_1 = _leafStateList.size();
        int _minus = _size - _size_1;
        int historySize = _minus + 2;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/* constant for state machine data */");
        _builder.newLine();
        _builder.append((Object)"#define ");
        String _name = ac.getName();
        String _upperCase = _name.toUpperCase();
        _builder.append((Object)_upperCase, "");
        _builder.append((Object)"_HISTORY_SIZE ");
        _builder.append((Object)historySize, "");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence genDataMembers(ExpandedActorClass xpac) {
        StringConcatenation _xblockexpression = null;
        ActorClass ac = xpac.getActorClass();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/* state machine variables */");
        _builder.newLine();
        _builder.append((Object)"etInt16 state;");
        _builder.newLine();
        _builder.append((Object)"etInt16 history[");
        String _name = ac.getName();
        String _upperCase = _name.toUpperCase();
        _builder.append((Object)_upperCase, "");
        _builder.append((Object)"_HISTORY_SIZE];");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence genInitialization(ExpandedActorClass xpac) {
        StringConcatenation _xblockexpression = null;
        ActorClass ac = xpac.getActorClass();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"self->state = STATE_TOP;");
        _builder.newLine();
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"int i;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"for (i=0; i<");
        String _name = ac.getName();
        String _upperCase = _name.toUpperCase();
        _builder.append((Object)_upperCase, "\t");
        _builder.append((Object)"_HISTORY_SIZE; ++i)");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"self->history[i] = NO_STATE;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        String _name_1 = ac.getName();
        String _operationScope = this.langExt.operationScope(_name_1, false);
        _builder.append((Object)_operationScope, "");
        _builder.append((Object)"executeInitTransition(self);");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence genExtra(ExpandedActorClass xpac) {
        StringConcatenation _xblockexpression = null;
        ActorClass ac = xpac.getActorClass();
        StateGraph _stateMachine = xpac.getStateMachine();
        List _baseStateList = RoomHelpers.getBaseStateList((StateGraph)_stateMachine);
        List states = this._roomExtensions.getLeafStatesLast(_baseStateList);
        StringConcatenation _builder = new StringConcatenation();
        GlobalGeneratorSettings _settings = Main.getSettings();
        boolean _generateMSCInstrumentation = _settings.generateMSCInstrumentation();
        if (_generateMSCInstrumentation) {
            _builder.append((Object)"/* state names */");
            _builder.newLine();
            _builder.append((Object)"static char* stateStrings[] = {\"<no state>\",\"<top>\",");
            boolean _hasElements = false;
            for (State state : states) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",", "");
                }
                _builder.append((Object)"\"");
                String _genStatePathName = CodegenHelpers.getGenStatePathName((State)state);
                _builder.append((Object)_genStatePathName, "");
                _builder.append((Object)"\"");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"};");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        String _accessLevelPrivate = this.langExt.accessLevelPrivate();
        _builder.append((Object)_accessLevelPrivate, "");
        _builder.append((Object)"void setState(");
        String _name = ac.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"* self, ");
        String _stateType = this.stateType();
        _builder.append((Object)_stateType, "");
        _builder.append((Object)" new_state) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"self->state = new_state;");
        _builder.newLine();
        GlobalGeneratorSettings _settings_1 = Main.getSettings();
        boolean _generateMSCInstrumentation_1 = _settings_1.generateMSCInstrumentation();
        if (_generateMSCInstrumentation_1) {
            _builder.append((Object)"\t");
            _builder.append((Object)"ET_MSC_LOGGER_CHANGE_STATE(self->constData->instName, stateStrings[new_state])");
            _builder.newLine();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        String _accessLevelPrivate_1 = this.langExt.accessLevelPrivate();
        _builder.append((Object)_accessLevelPrivate_1, "");
        String _stateType_1 = this.stateType();
        _builder.append((Object)_stateType_1, "");
        _builder.append((Object)" getState(");
        String _name_1 = ac.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"* self) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"return self->state;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected String stateType() {
        return "etInt16";
    }

    protected String unreachableReturn() {
        return "/* return NO_STATE; // required by CDT but detected as unreachable by JDT because of while (true) */";
    }
}

