/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.base.ILogger;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.InterfaceItemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.LogicalThread;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.generator.base.IDataConfiguration;
import org.eclipse.etrice.generator.base.Indexed;
import org.eclipse.etrice.generator.cpp.gen.ConfigGenAddon;
import org.eclipse.etrice.generator.cpp.gen.CppExtensions;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.JavaIoFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Extension;

@Singleton
public class SubSystemClassGen {
    @Inject
    private JavaIoFileSystemAccess fileAccess;
    @Inject
    @Extension
    private CppExtensions _cppExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private ProcedureHelpers _procedureHelpers;
    @Inject
    private IDataConfiguration dataConfigExt;
    @Inject
    private ConfigGenAddon configGenAddon;
    @Inject
    private ConfigGenAddon configAddon;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        EList _subSystemInstances = root.getSubSystemInstances();
        for (SubSystemInstance ssi : _subSystemInstances) {
            String _cppSourceFileName;
            SubSystemClass _subSystemClass = ssi.getSubSystemClass();
            String _generationTargetPath = this._roomExtensions.getGenerationTargetPath((EObject)_subSystemClass);
            SubSystemClass _subSystemClass_1 = ssi.getSubSystemClass();
            String _path = this._roomExtensions.getPath((RoomClass)_subSystemClass_1);
            String path = String.valueOf(_generationTargetPath) + _path;
            SubSystemClass _subSystemClass_2 = ssi.getSubSystemClass();
            String file = this._cppExtensions.getCppHeaderFileName((RoomClass)_subSystemClass_2);
            String _plus = "generating SubSystemClass declaration: '" + file;
            String _plus_1 = String.valueOf(_plus) + "' in '";
            String _plus_2 = String.valueOf(_plus_1) + path;
            String _plus_3 = String.valueOf(_plus_2) + "'";
            this.logger.logInfo(_plus_3);
            this.fileAccess.setOutputPath(path);
            SubSystemClass _subSystemClass_3 = ssi.getSubSystemClass();
            CharSequence _generateHeaderFile = this.generateHeaderFile(root, ssi, _subSystemClass_3);
            this.fileAccess.generateFile(file, _generateHeaderFile);
            SubSystemClass _subSystemClass_4 = ssi.getSubSystemClass();
            file = _cppSourceFileName = this._cppExtensions.getCppSourceFileName((RoomClass)_subSystemClass_4);
            String _plus_4 = "generating SubSystemClass implementation: '" + file;
            String _plus_5 = String.valueOf(_plus_4) + "' in '";
            String _plus_6 = String.valueOf(_plus_5) + path;
            String _plus_7 = String.valueOf(_plus_6) + "'";
            this.logger.logInfo(_plus_7);
            this.fileAccess.setOutputPath(path);
            SubSystemClass _subSystemClass_5 = ssi.getSubSystemClass();
            CharSequence _generateSourceFile = this.generateSourceFile(root, ssi, _subSystemClass_5);
            this.fileAccess.generateFile(file, _generateSourceFile);
        }
    }

    public CharSequence generateHeaderFile(Root root, SubSystemInstance comp, SubSystemClass cc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* Header File of SubSystemClass ");
        String _name = cc.getName();
        _builder.append((Object)_name, "\t ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        String _name_1 = cc.getName();
        CharSequence _generateIncludeGuardBegin = this._cppExtensions.generateIncludeGuardBegin(_name_1);
        _builder.append((Object)_generateIncludeGuardBegin, "\t");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include \"platforms/generic/etDatatypes.h\"");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include \"common/messaging/IRTObject.h\"");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include \"common/modelbase/PortBase.h\"");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include \"common/modelbase/InterfaceItemBase.h\"");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include \"common/modelbase/ActorClassBase.h\"");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include \"common/modelbase/SubSystemClassBase.h\"");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include \"common/messaging/Address.h\"");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include \"common/messaging/IMessageReceiver.h\"");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include \"common/debugging/DebuggingService.h\"");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include <string>");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include <vector>");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        EList _referencedModels = root.getReferencedModels((RoomClass)cc);
        for (RoomModel roomModel : _referencedModels) {
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        CharSequence _userCode = this._procedureHelpers.userCode((ActorContainerClass)cc, 1, false);
        _builder.append((Object)_userCode, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"class ");
        String _name_2 = cc.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append((Object)" : public etRuntime::SubSystemClassBase{");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        CharSequence _userCode_1 = this._procedureHelpers.userCode((ActorContainerClass)cc, 2, false);
        _builder.append((Object)_userCode_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"public:");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        String _name_3 = cc.getName();
        _builder.append((Object)_name_3, "\t\t\t");
        _builder.append((Object)"(IRTObject* parent, std::string name)");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)": etRuntime::SubSystemClassBase(parent, name)");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"virtual void receiveEvent(etRuntime::InterfaceItemBase* ifitem, int evt, void* data);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"virtual void instantiateMessageServices();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"virtual void instantiateActors();");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"private:");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"std::vector<etRuntime::MessageService*> m_msgServices;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"};");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _name_4 = cc.getName();
        CharSequence _generateIncludeGuardEnd = this._cppExtensions.generateIncludeGuardEnd(_name_4);
        _builder.append((Object)_generateIncludeGuardEnd, "\t");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateSourceFile(Root root, SubSystemInstance comp, SubSystemClass cc) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @author generated by eTrice");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* Source File of SubsystemClass ");
        String _name = cc.getName();
        _builder.append((Object)_name, "\t ");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* ");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include \"");
        String _cppHeaderFileName = this._cppExtensions.getCppHeaderFileName((RoomClass)cc);
        _builder.append((Object)_cppHeaderFileName, "\t");
        _builder.append((Object)"\"");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include \"common/debugging/DebuggingService.h\"");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"#include \"common/messaging/RTSystemServicesProtocol.h\"");
        _builder.newLine();
        EList _allContainedInstances = comp.getAllContainedInstances();
        for (ActorInstance ai : _allContainedInstances) {
            _builder.append((Object)"\t");
            _builder.append((Object)"#include \"");
            ActorClass _actorClass = ai.getActorClass();
            String _path = this._roomExtensions.getPath((RoomClass)_actorClass);
            _builder.append((Object)_path, "\t");
            ActorClass _actorClass_1 = ai.getActorClass();
            String _name_1 = _actorClass_1.getName();
            _builder.append((Object)_name_1, "\t");
            _builder.append((Object)".h\"");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"#include <iostream>");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"using namespace etRuntime;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"void ");
        String _name_2 = cc.getName();
        _builder.append((Object)_name_2, "\t");
        _builder.append((Object)"::receiveEvent(InterfaceItemBase* ifitem, int evt, void* data){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"void ");
        String _name_3 = cc.getName();
        _builder.append((Object)_name_3, "\t");
        _builder.append((Object)"::instantiateMessageServices(){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"m_msgServices.push_back( new MessageService(this, Address(0, 0, 0),\"MessageService_Main\") );");
        _builder.newLine();
        EList _threads = cc.getThreads();
        for (LogicalThread thread : _threads) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"m_msgServices.push_back(new MessageService(this, Address(0, ");
            EList _threads_1 = cc.getThreads();
            int _indexOf = _threads_1.indexOf((Object)thread);
            int _plus = _indexOf + 1;
            _builder.append((Object)_plus, "\t\t");
            _builder.append((Object)", 0),\"MessageService_");
            String _name_4 = thread.getName();
            _builder.append((Object)_name_4, "\t\t");
            _builder.append((Object)"\", /* threadprio */ 0));");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"for (std::vector<MessageService*>::iterator it=m_msgServices.begin(); it != m_msgServices.end(); ++it) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"RTServices::getInstance().getMsgSvcCtrl().addMsgSvc( *(*it));");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"void ");
        String _name_5 = cc.getName();
        _builder.append((Object)_name_5, "\t");
        _builder.append((Object)"::instantiateActors(){");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"// all addresses");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// Addresses for the Subsystem Systemport");
        _builder.newLine();
        EList _allContainedInstances_1 = comp.getAllContainedInstances();
        int _maxObjId = comp.getMaxObjId();
        Iterable _indexed = Indexed.indexed((Iterable)_allContainedInstances_1, (int)_maxObjId);
        Iterator _plus = _indexed.iterator();
        while (_plus.hasNext()) {
            Indexed ai_1 = (Indexed)_plus.next();
            _builder.append((Object)"\t");
            _builder.append((Object)"Address addr_item_SystemPort_");
            EList _allContainedInstances_2 = comp.getAllContainedInstances();
            ActorInstance _value = (ActorInstance)ai_1.getValue();
            int _indexOf_1 = _allContainedInstances_2.indexOf((Object)_value);
            _builder.append((Object)_indexOf_1, "\t");
            _builder.append((Object)"(0,0,");
            int _index1 = ai_1.getIndex1();
            _builder.append((Object)_index1, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        EList _allContainedInstances_3 = comp.getAllContainedInstances();
        for (ActorInstance ai_2 : _allContainedInstances_3) {
            _builder.append((Object)"\t");
            _builder.append((Object)"// actor instance ");
            String _path_1 = ai_2.getPath();
            _builder.append((Object)_path_1, "\t");
            _builder.append((Object)" itself => Systemport Address");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"// TODOTJ: For each Actor, multiple addresses should be generated (actor?, systemport, debugport)");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"Address addr_item_");
            String _path_2 = ai_2.getPath();
            String _pathName = this._roomExtensions.getPathName(_path_2);
            _builder.append((Object)_pathName, "\t");
            _builder.append((Object)"(0,");
            int _threadId = ai_2.getThreadId();
            _builder.append((Object)_threadId, "\t");
            _builder.append((Object)",");
            int _objId = ai_2.getObjId();
            _builder.append((Object)_objId, "\t");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"// interface items of ");
            String _path_3 = ai_2.getPath();
            _builder.append((Object)_path_3, "\t");
            _builder.newLineIfNotEmpty();
            EList _orderedIfItemInstances = ai_2.getOrderedIfItemInstances();
            for (InterfaceItemInstance pi : _orderedIfItemInstances) {
                boolean _isReplicated = pi.isReplicated();
                if (_isReplicated) {
                    EList _peers = pi.getPeers();
                    for (InterfaceItemInstance peer : _peers) {
                        _builder.append((Object)"\t");
                        EList _peers_1 = pi.getPeers();
                        int i = _peers_1.indexOf((Object)peer);
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)"Address addr_item_");
                        String _path_4 = pi.getPath();
                        String _pathName_1 = this._roomExtensions.getPathName(_path_4);
                        _builder.append((Object)_pathName_1, "\t");
                        _builder.append((Object)"_");
                        _builder.append((Object)i, "\t");
                        _builder.append((Object)"(0,");
                        int _threadId_1 = pi.getThreadId();
                        _builder.append((Object)_threadId_1, "\t");
                        _builder.append((Object)",");
                        int _objId_1 = pi.getObjId();
                        int _plus_1 = _objId_1 + i;
                        _builder.append((Object)_plus_1, "\t");
                        _builder.append((Object)");");
                        _builder.newLineIfNotEmpty();
                    }
                    continue;
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"Address addr_item_");
                String _path_5 = pi.getPath();
                String _pathName_2 = this._roomExtensions.getPathName(_path_5);
                _builder.append((Object)_pathName_2, "\t");
                _builder.append((Object)"(0,");
                int _threadId_2 = ai_2.getThreadId();
                _builder.append((Object)_threadId_2, "\t");
                _builder.append((Object)",");
                int _objId_2 = pi.getObjId();
                _builder.append((Object)_objId_2, "\t");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// instantiate all actor instances");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"m_instances.reserve(");
        EList _allContainedInstances_4 = comp.getAllContainedInstances();
        int _size = _allContainedInstances_4.size();
        _builder.append((Object)_size, "\t");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        EList _allContainedInstances_5 = comp.getAllContainedInstances();
        for (ActorInstance ai_3 : _allContainedInstances_5) {
            _builder.append((Object)"\t");
            _builder.append((Object)"//----------------------------------------------------------------------------------------------");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"// addresses for actor instance: ");
            String _name_6 = ai_3.getName();
            _builder.append((Object)_name_6, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"//----------------------------------------------------------------------------------------------");
            _builder.newLine();
            _builder.append((Object)"\t");
            CharSequence _generateOwnInterfaceItemAddresses = this.generateOwnInterfaceItemAddresses(ai_3);
            _builder.append((Object)_generateOwnInterfaceItemAddresses, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            CharSequence _generatePeerInterfaceItemAddresses = this.generatePeerInterfaceItemAddresses(ai_3, comp);
            _builder.append((Object)_generatePeerInterfaceItemAddresses, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"m_instances[");
            EList _allContainedInstances_6 = comp.getAllContainedInstances();
            int _indexOf_2 = _allContainedInstances_6.indexOf((Object)ai_3);
            _builder.append((Object)_indexOf_2, "\t");
            _builder.append((Object)"] = new ");
            ActorClass _actorClass_2 = ai_3.getActorClass();
            String _name_7 = _actorClass_2.getName();
            _builder.append((Object)_name_7, "\t");
            _builder.append((Object)"(");
            _builder.newLineIfNotEmpty();
            EObject _eContainer = ai_3.eContainer();
            if (_eContainer instanceof SubSystemInstance) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"this,");
                _builder.newLine();
            } else {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"m_instances[");
                EList _allContainedInstances_7 = comp.getAllContainedInstances();
                EObject _eContainer_1 = ai_3.eContainer();
                int _indexOf_3 = _allContainedInstances_7.indexOf((Object)_eContainer_1);
                _builder.append((Object)_indexOf_3, "\t\t");
                _builder.append((Object)"],");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"\"");
            String _name_8 = ai_3.getName();
            _builder.append((Object)_name_8, "\t\t");
            _builder.append((Object)"\",");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            String _name_9 = ai_3.getName();
            _builder.append((Object)_name_9, "\t\t");
            _builder.append((Object)"_ownInterfaceItemAddresses,");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            String _name_10 = ai_3.getName();
            _builder.append((Object)_name_10, "\t\t");
            _builder.append((Object)"_peerInterfaceItemAddresses");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"); ");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"// apply instance attribute configurations");
        _builder.newLine();
        EList _allContainedInstances_8 = comp.getAllContainedInstances();
        for (ActorInstance ai_4 : _allContainedInstances_8) {
            boolean _greaterThan;
            CharSequence cfg = this.configGenAddon.genActorInstanceConfig(ai_4, "inst");
            _builder.newLineIfNotEmpty();
            int _length = cfg.length();
            boolean bl = _greaterThan = _length > 0;
            if (!_greaterThan) continue;
            _builder.append((Object)"{");
            _builder.newLine();
            _builder.append((Object)"\t");
            ActorClass _actorClass_3 = ai_4.getActorClass();
            String _name_11 = _actorClass_3.getName();
            _builder.append((Object)_name_11, "\t");
            _builder.append((Object)" inst = (");
            ActorClass _actorClass_4 = ai_4.getActorClass();
            String _name_12 = _actorClass_4.getName();
            _builder.append((Object)_name_12, "\t");
            _builder.append((Object)") instances[");
            EList _allContainedInstances_9 = comp.getAllContainedInstances();
            int _indexOf_4 = _allContainedInstances_9.indexOf((Object)ai_4);
            _builder.append((Object)_indexOf_4, "\t");
            _builder.append((Object)"];");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)cfg, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"//----------------------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// addresses for the subsystem system port");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"//----------------------------------------------------------------------------------------------");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"std::vector<Address> ownAddresses(");
        EList _allContainedInstances_10 = comp.getAllContainedInstances();
        int _size_1 = _allContainedInstances_10.size();
        _builder.append((Object)_size_1, "\t");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        EList _allContainedInstances_11 = comp.getAllContainedInstances();
        for (ActorInstance ai_5 : _allContainedInstances_11) {
            _builder.append((Object)"\t");
            _builder.append((Object)"ownAddresses[");
            EList _allContainedInstances_12 = comp.getAllContainedInstances();
            int _indexOf_5 = _allContainedInstances_12.indexOf((Object)ai_5);
            _builder.append((Object)_indexOf_5, "\t");
            _builder.append((Object)"] = addr_item_SystemPort_");
            EList _allContainedInstances_13 = comp.getAllContainedInstances();
            int _indexOf_6 = _allContainedInstances_13.indexOf((Object)ai_5);
            _builder.append((Object)_indexOf_6, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"std::vector<Address> peerAddresses(");
        EList _allContainedInstances_14 = comp.getAllContainedInstances();
        int _size_2 = _allContainedInstances_14.size();
        _builder.append((Object)_size_2, "\t");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        EList _allContainedInstances_15 = comp.getAllContainedInstances();
        for (ActorInstance ai_6 : _allContainedInstances_15) {
            _builder.append((Object)"\t");
            _builder.append((Object)"peerAddresses[");
            EList _allContainedInstances_16 = comp.getAllContainedInstances();
            int _indexOf_7 = _allContainedInstances_16.indexOf((Object)ai_6);
            _builder.append((Object)_indexOf_7, "\t");
            _builder.append((Object)"] = addr_item_");
            String _path_6 = ai_6.getPath();
            String _pathName_3 = this._roomExtensions.getPathName(_path_6);
            _builder.append((Object)_pathName_3, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"// create the subsystem system port\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"m_RTSystemPort = new RTSystemServicesProtocolConjPortRepl(*this, this, \"RTSystemPort\",");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"0, //local ID");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"ownAddresses,");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"peerAddresses);");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateOwnInterfaceItemAddresses(ActorInstance ai) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"std::vector<std::vector<Address> > ");
        String _name = ai.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"_ownInterfaceItemAddresses;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"std::vector<Address> ");
        String _name_1 = ai.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"_actorInstanceAddresses(1);");
        _builder.newLineIfNotEmpty();
        String _name_2 = ai.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)"_actorInstanceAddresses[0] = addr_item_");
        String _path = ai.getPath();
        String _pathName = this._roomExtensions.getPathName(_path);
        _builder.append((Object)_pathName, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _name_3 = ai.getName();
        _builder.append((Object)_name_3, "");
        _builder.append((Object)"_ownInterfaceItemAddresses.push_back(");
        String _name_4 = ai.getName();
        _builder.append((Object)_name_4, "");
        _builder.append((Object)"_actorInstanceAddresses);");
        _builder.newLineIfNotEmpty();
        EList _orderedIfItemInstances = ai.getOrderedIfItemInstances();
        for (InterfaceItemInstance pi : _orderedIfItemInstances) {
            boolean _isReplicated = pi.isReplicated();
            if (_isReplicated) {
                EList _peers = pi.getPeers();
                boolean _isEmpty = _peers.isEmpty();
                if (_isEmpty) {
                    _builder.append((Object)"std::vector<Address>  ");
                    String _name_5 = ai.getName();
                    _builder.append((Object)_name_5, "");
                    _builder.append((Object)"_");
                    String _name_6 = pi.getName();
                    _builder.append((Object)_name_6, "");
                    _builder.append((Object)"Addresses;");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append((Object)"std::vector<Address>  ");
                    String _name_7 = ai.getName();
                    _builder.append((Object)_name_7, "");
                    _builder.append((Object)"_");
                    String _name_8 = pi.getName();
                    _builder.append((Object)_name_8, "");
                    _builder.append((Object)"Addresses(");
                    EList _peers_1 = pi.getPeers();
                    int _size = _peers_1.size();
                    _builder.append((Object)_size, "");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    EList _peers_2 = pi.getPeers();
                    for (InterfaceItemInstance peer : _peers_2) {
                        String _name_9 = ai.getName();
                        _builder.append((Object)_name_9, "");
                        _builder.append((Object)"_");
                        String _name_10 = pi.getName();
                        _builder.append((Object)_name_10, "");
                        _builder.append((Object)"Addresses[");
                        EList _peers_3 = pi.getPeers();
                        int _indexOf = _peers_3.indexOf((Object)peer);
                        _builder.append((Object)_indexOf, "");
                        _builder.append((Object)"] = addr_item_");
                        String _path_1 = pi.getPath();
                        String _pathName_1 = this._roomExtensions.getPathName(_path_1);
                        _builder.append((Object)_pathName_1, "");
                        _builder.append((Object)"_");
                        EList _peers_4 = pi.getPeers();
                        int _indexOf_1 = _peers_4.indexOf((Object)peer);
                        _builder.append((Object)_indexOf_1, "");
                        _builder.append((Object)";");
                        _builder.newLineIfNotEmpty();
                    }
                }
            } else {
                _builder.append((Object)"std::vector<Address>  ");
                String _name_11 = ai.getName();
                _builder.append((Object)_name_11, "");
                _builder.append((Object)"_");
                String _name_12 = pi.getName();
                _builder.append((Object)_name_12, "");
                _builder.append((Object)"Addresses(1);");
                _builder.newLineIfNotEmpty();
                String _name_13 = ai.getName();
                _builder.append((Object)_name_13, "");
                _builder.append((Object)"_");
                String _name_14 = pi.getName();
                _builder.append((Object)_name_14, "");
                _builder.append((Object)"Addresses[0] = addr_item_");
                String _path_2 = pi.getPath();
                String _pathName_2 = this._roomExtensions.getPathName(_path_2);
                _builder.append((Object)_pathName_2, "");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
            String _name_15 = ai.getName();
            _builder.append((Object)_name_15, "");
            _builder.append((Object)"_ownInterfaceItemAddresses.push_back(");
            String _name_16 = ai.getName();
            _builder.append((Object)_name_16, "");
            _builder.append((Object)"_");
            String _name_17 = pi.getName();
            _builder.append((Object)_name_17, "");
            _builder.append((Object)"Addresses);");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence generatePeerInterfaceItemAddresses(ActorInstance ai, SubSystemInstance comp) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"std::vector<std::vector<Address> > ");
        String _name = ai.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)"_peerInterfaceItemAddresses;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"std::vector<Address> ");
        String _name_1 = ai.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)"_systemPortAddresses(1);");
        _builder.newLineIfNotEmpty();
        String _name_2 = ai.getName();
        _builder.append((Object)_name_2, "");
        _builder.append((Object)"_systemPortAddresses[0] = addr_item_SystemPort_");
        EList _allContainedInstances = comp.getAllContainedInstances();
        int _indexOf = _allContainedInstances.indexOf((Object)ai);
        _builder.append((Object)_indexOf, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        String _name_3 = ai.getName();
        _builder.append((Object)_name_3, "");
        _builder.append((Object)"_peerInterfaceItemAddresses.push_back(");
        String _name_4 = ai.getName();
        _builder.append((Object)_name_4, "");
        _builder.append((Object)"_systemPortAddresses);");
        _builder.newLineIfNotEmpty();
        EList _orderedIfItemInstances = ai.getOrderedIfItemInstances();
        for (InterfaceItemInstance pi : _orderedIfItemInstances) {
            boolean _and = false;
            boolean _isReplicated = pi.isReplicated();
            if (!_isReplicated) {
                _and = false;
            } else {
                EList _peers = pi.getPeers();
                boolean _isEmpty = _peers.isEmpty();
                boolean bl = _and = _isReplicated && _isEmpty;
            }
            if (_and) continue;
            EList _peers_1 = pi.getPeers();
            boolean _isEmpty_1 = _peers_1.isEmpty();
            if (_isEmpty_1) {
                _builder.append((Object)"std::vector<Address>  ");
                String _name_5 = ai.getName();
                _builder.append((Object)_name_5, "");
                _builder.append((Object)"_");
                String _name_6 = pi.getName();
                _builder.append((Object)_name_6, "");
                _builder.append((Object)"PeerAddresses;");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"std::vector<Address>  ");
                String _name_7 = ai.getName();
                _builder.append((Object)_name_7, "");
                _builder.append((Object)"_");
                String _name_8 = pi.getName();
                _builder.append((Object)_name_8, "");
                _builder.append((Object)"PeerAddresses(");
                EList _peers_2 = pi.getPeers();
                int _size = _peers_2.size();
                _builder.append((Object)_size, "");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                EList _peers_3 = pi.getPeers();
                for (InterfaceItemInstance pp : _peers_3) {
                    boolean _isReplicated_1 = pp.isReplicated();
                    if (_isReplicated_1) {
                        String _name_9 = ai.getName();
                        _builder.append((Object)_name_9, "");
                        _builder.append((Object)"_");
                        String _name_10 = pi.getName();
                        _builder.append((Object)_name_10, "");
                        _builder.append((Object)"PeerAddresses[");
                        EList _peers_4 = pi.getPeers();
                        int _indexOf_1 = _peers_4.indexOf((Object)pp);
                        _builder.append((Object)_indexOf_1, "");
                        _builder.append((Object)"] = addr_item_");
                        String _path = pp.getPath();
                        String _pathName = this._roomExtensions.getPathName(_path);
                        _builder.append((Object)_pathName, "");
                        _builder.append((Object)"_");
                        EList _peers_5 = pp.getPeers();
                        int _indexOf_2 = _peers_5.indexOf((Object)pi);
                        _builder.append((Object)_indexOf_2, "");
                        _builder.append((Object)";");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    String _name_11 = ai.getName();
                    _builder.append((Object)_name_11, "");
                    _builder.append((Object)"_");
                    String _name_12 = pi.getName();
                    _builder.append((Object)_name_12, "");
                    _builder.append((Object)"PeerAddresses[");
                    EList _peers_6 = pi.getPeers();
                    int _indexOf_3 = _peers_6.indexOf((Object)pp);
                    _builder.append((Object)_indexOf_3, "");
                    _builder.append((Object)"] = addr_item_");
                    String _path_1 = pp.getPath();
                    String _pathName_1 = this._roomExtensions.getPathName(_path_1);
                    _builder.append((Object)_pathName_1, "");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                }
            }
            String _name_13 = ai.getName();
            _builder.append((Object)_name_13, "");
            _builder.append((Object)"_peerInterfaceItemAddresses.push_back(");
            String _name_14 = ai.getName();
            _builder.append((Object)_name_14, "");
            _builder.append((Object)"_");
            String _name_15 = pi.getName();
            _builder.append((Object)_name_15, "");
            _builder.append((Object)"PeerAddresses);");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }
}

