/*******************************************************************************
 * Copyright (c) 2011 Draeger Medical GmbH (http://www.draeger.com).
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * CONTRIBUTORS:
 * 		Peter Karlitschek (initial contribution)
 * 
 *******************************************************************************/
package org.eclipse.etrice.generator.cpp.gen

import com.google.inject.Inject
import com.google.inject.Singleton
import org.eclipse.etrice.core.room.SubSystemClass
import org.eclipse.etrice.core.genmodel.etricegen.Root
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance
import org.eclipse.xtext.generator.JavaIoFileSystemAccess
import org.eclipse.etrice.generator.generic.RoomExtensions

/**
 * @author Peter Karlitschek
 *
 */
@Singleton
class SubSystemRunnerGen {

	@Inject extension JavaIoFileSystemAccess fileAccess
	@Inject extension CppExtensions
	@Inject extension RoomExtensions roomExt
	
	def doGenerate(Root root) {
		for (sc: root.subSystemInstances) {
			fileAccess.setOutputPath(sc.subSystemClass.generationTargetPath+sc.subSystemClass.getPath)
			fileAccess.generateFile( sc.subSystemClass.name+"_Runner.h", root.generateHeaderFile(sc, sc.subSystemClass))

			fileAccess.setOutputPath(sc.subSystemClass.generationTargetPath+sc.subSystemClass.getPath)
			fileAccess.generateFile( sc.subSystemClass.name+"_Runner.cpp", root.generateSourceFile(sc, sc.subSystemClass))
		}
	}
	
	def generateHeaderFile(Root root, SubSystemInstance ssc, SubSystemClass cc) {'''
		/**
		 * @author generated by eTrice
		 *
		 * this class contains the main function running component cc.name
		 * it instantiates cc.name and starts and ends the lifecycle
		 */
		
		generateIncludeGuardBegin(cc.name+"_Runner")
		
		#include "common/modelbase/SubSystemRunnerBase.h"
		
		class cc.name+"Runner" :public etRuntime::SubSystemRunnerBase {
		
		};
		
		generateIncludeGuardEnd(cc.name+"_Runner")
	'''
	}
	
	def generateSourceFile(Root root, SubSystemInstance ssi, SubSystemClass ssc) {'''
		/**
		 * @author generated by eTrice
		 *
		 * this class contains the main function running component ssc.name
		 * it instantiates ssc.name and starts and ends the lifecycle
		 */
		
		
		#include "ssc.name.h"
		#include "ssc.name_Runner.h"

		#include <iostream>
		
		
		/**
		 * main function
		 * creates component and starts and stops the lifecycle
		 */
		
			
		int main(int argc, char* argv[]) {
			ssc.name mainComponent(0, "ssc.name");
			ssc.name+"Runner"::run(mainComponent, argc, argv);
			return 0;
		}
			
			
	'''
	}	
}