/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.ui.cdt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.CIncludePathEntry;
import org.eclipse.cdt.core.settings.model.CLibraryFileEntry;
import org.eclipse.cdt.core.settings.model.CLibraryPathEntry;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICFolderDescription;
import org.eclipse.cdt.core.settings.model.ICLanguageSetting;
import org.eclipse.cdt.core.settings.model.ICLanguageSettingEntry;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICTargetPlatformSetting;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.etrice.generator.ui.configurator.IProjectConfigurator;

public class ProjectConfigurator
implements IProjectConfigurator {
    public void configure(IProject project) {
        try {
            ProjectConfigurator.addIncludePathsAndLibraries(project);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void addIncludePathsAndLibraries(IProject project) throws CoreException {
        ICConfigurationDescription[] configDecriptions;
        if (!project.hasNature("org.eclipse.cdt.core.cnature")) {
            return;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject runtime = workspace.getRoot().getProject("org.eclipse.etrice.runtime.c");
        IFolder common = runtime.getFolder("src/common");
        IFolder config = runtime.getFolder("src/config");
        IFolder posix = runtime.getFolder("src/platforms/MT_POSIX_GENERIC_GCC");
        IFolder mingw = runtime.getFolder("src/platforms/MT_WIN_MinGW");
        IFolder src_gen = project.getFolder("src-gen");
        IFolder mingw_debug = project.getFolder("MinGWDebug");
        IFolder mingw_release = project.getFolder("MinGWRelease");
        IFolder posix_debug = project.getFolder("PosixDebug");
        IFolder posix_release = project.getFolder("PosixRelease");
        ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescription(project, true);
        ICConfigurationDescription[] iCConfigurationDescriptionArray = configDecriptions = projectDescription.getConfigurations();
        int n = configDecriptions.length;
        int n2 = 0;
        while (n2 < n) {
            ICLanguageSetting[] settings;
            ICConfigurationDescription configDescription = iCConfigurationDescriptionArray[n2];
            ICFolderDescription projectRoot = configDescription.getRootFolderDescription();
            ICLanguageSetting[] iCLanguageSettingArray = settings = projectRoot.getLanguageSettings();
            int n3 = settings.length;
            int n4 = 0;
            while (n4 < n3) {
                ICLanguageSetting setting = iCLanguageSettingArray[n4];
                if ("org.eclipse.cdt.core.gcc".equals(setting.getLanguageId())) {
                    ICTargetPlatformSetting tgt = configDescription.getTargetPlatformSetting();
                    String id = tgt.getId();
                    ArrayList<CIncludePathEntry> includes = new ArrayList<CIncludePathEntry>();
                    includes.add(new CIncludePathEntry(src_gen, 4));
                    includes.add(new CIncludePathEntry(common, 4));
                    includes.add(new CIncludePathEntry(config, 4));
                    if (id.startsWith("cdt.managedbuild.target.gnu.platform.mingw.exe")) {
                        includes.add(new CIncludePathEntry(mingw, 4));
                    } else if (id.startsWith("cdt.managedbuild.target.gnu.platform.posix.exe")) {
                        includes.add(new CIncludePathEntry(posix, 4));
                    }
                    ProjectConfigurator.addSettings(setting, 1, includes);
                    List<CLibraryPathEntry> libPaths = null;
                    if (id.startsWith("cdt.managedbuild.target.gnu.platform.mingw.exe.debug")) {
                        libPaths = Collections.singletonList(new CLibraryPathEntry(mingw_debug, 4));
                    } else if (id.startsWith("cdt.managedbuild.target.gnu.platform.mingw.exe.release")) {
                        libPaths = Collections.singletonList(new CLibraryPathEntry(mingw_release, 4));
                    } else if (id.startsWith("cdt.managedbuild.target.gnu.platform.posix.exe.debug")) {
                        libPaths = Collections.singletonList(new CLibraryPathEntry(posix_debug, 4));
                    } else if (id.startsWith("cdt.managedbuild.target.gnu.platform.posix.exe.release")) {
                        libPaths = Collections.singletonList(new CLibraryPathEntry(posix_release, 4));
                    }
                    if (libPaths != null) {
                        ProjectConfigurator.addSettings(setting, 16, libPaths);
                    }
                    List<CLibraryFileEntry> libs = Collections.singletonList(new CLibraryFileEntry("org.eclipse.etrice.runtime.c", 0));
                    ProjectConfigurator.addSettings(setting, 32, libs);
                }
                ++n4;
            }
            ++n2;
        }
        try {
            CoreModel.getDefault().setProjectDescription(project, projectDescription);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private static void addSettings(ICLanguageSetting setting, int kind, List<? extends ICLanguageSettingEntry> entries) {
        HashMap<String, ICLanguageSettingEntry> newEntries = new HashMap<String, ICLanguageSettingEntry>();
        for (ICLanguageSettingEntry iCLanguageSettingEntry : setting.getSettingEntriesList(kind)) {
            newEntries.put(iCLanguageSettingEntry.getName(), iCLanguageSettingEntry);
        }
        for (ICLanguageSettingEntry iCLanguageSettingEntry : entries) {
            newEntries.put(iCLanguageSettingEntry.getName(), iCLanguageSettingEntry);
        }
        setting.setSettingEntries(kind, new ArrayList(newEntries.values()));
    }
}

