/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.ui.wizard;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

class EmptyProjectConfigPage
extends WizardPage {
    private IProject runtimeProject;
    private Button jdtBuild;
    private Button mvnBuild;
    private boolean useJDTBuild;

    EmptyProjectConfigPage(String pageName, IProject runtimeProject) {
        super(pageName);
        this.runtimeProject = runtimeProject;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.jdtBuild = new Button(composite, 16);
        this.jdtBuild.setText("use &Eclipse JDT build");
        this.jdtBuild.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EmptyProjectConfigPage.this.setPageComplete(EmptyProjectConfigPage.this.validatePage());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.mvnBuild = new Button(composite, 16);
        this.mvnBuild.setText("use &Maven build");
        ScopedPreferenceStore prefStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.etrice.generator.ui");
        if (prefStore.getString("BuildKind").equals("Maven")) {
            this.mvnBuild.setSelection(true);
        } else {
            this.jdtBuild.setSelection(true);
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        this.setPageComplete(this.validatePage());
    }

    protected boolean validatePage() {
        if (!(!this.jdtBuild.getSelection() || this.runtimeProject != null && this.runtimeProject.exists() && this.runtimeProject.isAccessible())) {
            this.setErrorMessage("for JDT build the project 'org.eclipse.etrice.runtime.java' must be in the workspace");
            return false;
        }
        this.useJDTBuild = this.jdtBuild == null || this.jdtBuild.getSelection();
        this.setErrorMessage(null);
        return true;
    }

    public boolean useJDTBuild() {
        return this.useJDTBuild;
    }

    public boolean useMVNBuild() {
        return !this.useJDTBuild;
    }
}

