/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base;

import java.io.File;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.util.RelativePathHelpers;

public class FileSystemHelpers
extends RelativePathHelpers {
    public static URI getProjectURI(EObject obj) {
        return FileSystemHelpers.getMarkerFileURI(obj, ".project");
    }

    public boolean isValidGenerationLocation(EObject obj) {
        return FileSystemHelpers.getProjectURI(obj) != null;
    }

    public static URI getMarkerFileURI(EObject obj, String markerFileName) {
        URI mainPath = null;
        if (obj != null && obj.eResource() != null) {
            mainPath = obj.eResource().getURI().trimSegments(1);
            File parent = null;
            if (mainPath.isPlatform()) {
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                IFolder file = workspaceRoot.getFolder((IPath)new Path(mainPath.toPlatformString(true)));
                String osString = file.getLocation().toOSString();
                parent = new File(osString);
            } else {
                try {
                    parent = new File(mainPath.toFileString()).getAbsoluteFile();
                    mainPath = URI.createFileURI((String)parent.getAbsolutePath());
                }
                catch (Throwable e) {
                    return null;
                }
            }
            boolean isProject = false;
            int nUp = 0;
            while (!isProject && parent != null) {
                String[] contents = parent.list();
                int i = 0;
                while (i < contents.length) {
                    if (contents[i].equals(markerFileName)) {
                        isProject = true;
                        break;
                    }
                    ++i;
                }
                if (isProject) break;
                parent = parent.getParentFile();
                ++nUp;
            }
            if (isProject && nUp > 0) {
                mainPath = mainPath.trimSegments(nUp);
            }
        }
        return mainPath;
    }
}

