/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.generic;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.etricegen.ActiveTrigger;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedRefinedState;
import org.eclipse.etrice.core.genmodel.etricegen.TransitionChain;
import org.eclipse.etrice.core.genmodel.etricegen.util.ETriceGenUtil;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorCommunicationType;
import org.eclipse.etrice.core.room.DetailCode;
import org.eclipse.etrice.core.room.Guard;
import org.eclipse.etrice.core.room.GuardedTransition;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageFromIf;
import org.eclipse.etrice.core.room.NonInitialTransition;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.core.room.TrPoint;
import org.eclipse.etrice.core.room.Transition;
import org.eclipse.etrice.core.room.TransitionPoint;
import org.eclipse.etrice.core.room.Trigger;
import org.eclipse.etrice.core.room.TriggeredTransition;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.etrice.generator.base.AbstractGenerator;
import org.eclipse.etrice.generator.base.CodegenHelpers;
import org.eclipse.etrice.generator.generic.GenericProtocolClassGenerator;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TransitionChainGenerator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class GenericStateMachineGenerator {
    @Inject
    @Extension
    protected RoomExtensions _roomExtensions;
    @Inject
    protected ILanguageExtension langExt;
    @Inject
    protected GenericProtocolClassGenerator pcGen;
    @Inject
    protected TransitionChainGenerator transitionChainGenerator;

    protected String genStateIdConstants(ExpandedActorClass xpac) {
        boolean _not;
        ArrayList<Pair<String, String>> _arrayList;
        List<State> _leafStatesLast;
        int _numberOfInheritedBaseStates;
        ActorClass ac = xpac.getActorClass();
        int _xifexpression = 0;
        boolean _usesInheritance = this.langExt.usesInheritance();
        _xifexpression = _usesInheritance ? (_numberOfInheritedBaseStates = this._roomExtensions.getNumberOfInheritedBaseStates(ac)) : 0;
        int offset = 2 + _xifexpression;
        List<State> _xifexpression_1 = null;
        boolean _usesInheritance_1 = this.langExt.usesInheritance();
        if (_usesInheritance_1) {
            List<State> _baseStateList;
            StateGraph _stateMachine = ac.getStateMachine();
            _xifexpression_1 = _baseStateList = RoomHelpers.getBaseStateList((StateGraph)_stateMachine);
        } else {
            StateGraph _stateMachine_1 = xpac.getStateMachine();
            List _baseStateList_1 = RoomHelpers.getBaseStateList((StateGraph)_stateMachine_1);
            _xifexpression_1 = _baseStateList_1;
        }
        List<State> baseStates = _xifexpression_1;
        baseStates = _leafStatesLast = this._roomExtensions.getLeafStatesLast(baseStates);
        ArrayList<Pair<String, String>> list = _arrayList = new ArrayList<Pair<String, String>>();
        boolean _usesInheritance_2 = this.langExt.usesInheritance();
        boolean bl = _not = !_usesInheritance_2;
        if (_not) {
            Pair _pair = Tuples.pair((Object)"NO_STATE", (Object)"0");
            list.add(_pair);
            Pair _pair_1 = Tuples.pair((Object)"STATE_TOP", (Object)"1");
            list.add(_pair_1);
        }
        for (State state : baseStates) {
            int _plus;
            String _genStateId = CodegenHelpers.getGenStateId(state);
            String _string = Integer.valueOf(offset).toString();
            Pair _pair_2 = Tuples.pair((Object)_genStateId, (Object)_string);
            list.add((Pair<String, String>)_pair_2);
            offset = _plus = offset + 1;
        }
        String _string = Integer.valueOf(offset).toString();
        Pair _pair_2 = Tuples.pair((Object)"STATE_MAX", (Object)_string);
        list.add(_pair_2);
        return this.langExt.genEnumeration("state_ids", list);
    }

    protected String genTransitionChainConstants(ExpandedActorClass xpac) {
        ArrayList<Pair<String, String>> _arrayList;
        EList _transitionChains;
        EList _ownTransitionChains;
        EList _xifexpression = null;
        boolean _usesInheritance = this.langExt.usesInheritance();
        _xifexpression = _usesInheritance ? (_ownTransitionChains = xpac.getOwnTransitionChains()) : (_transitionChains = xpac.getTransitionChains());
        EList chains = _xifexpression;
        int _xifexpression_1 = 0;
        boolean _usesInheritance_1 = this.langExt.usesInheritance();
        if (_usesInheritance_1) {
            int _minus;
            EList _transitionChains_1 = xpac.getTransitionChains();
            int _size = _transitionChains_1.size();
            int _size_1 = chains.size();
            _xifexpression_1 = _minus = _size - _size_1;
        } else {
            _xifexpression_1 = 0;
        }
        int offset = _xifexpression_1;
        ArrayList<Pair<String, String>> list = _arrayList = new ArrayList<Pair<String, String>>();
        for (TransitionChain chain : chains) {
            int _plus;
            offset = _plus = offset + 1;
            String _genChainId = CodegenHelpers.getGenChainId(chain);
            String _string = Integer.valueOf(offset).toString();
            Pair _pair = Tuples.pair((Object)_genChainId, (Object)_string);
            list.add((Pair<String, String>)_pair);
        }
        return this.langExt.genEnumeration("chain_ids", list);
    }

    protected String genTriggerConstants(ExpandedActorClass xpac) {
        ArrayList<Pair<String, String>> _arrayList;
        List _xifexpression = null;
        boolean _usesInheritance = this.langExt.usesInheritance();
        if (_usesInheritance) {
            List _ownMessagesFromInterfaces;
            ActorClass _actorClass = xpac.getActorClass();
            _xifexpression = _ownMessagesFromInterfaces = RoomHelpers.getOwnMessagesFromInterfaces((ActorClass)_actorClass);
        } else {
            List _allMessagesFromInterfaces;
            ActorClass _actorClass_1 = xpac.getActorClass();
            _xifexpression = _allMessagesFromInterfaces = RoomHelpers.getAllMessagesFromInterfaces((ActorClass)_actorClass_1);
        }
        List triggers = _xifexpression;
        ArrayList<Pair<String, String>> list = _arrayList = new ArrayList<Pair<String, String>>();
        Pair _pair = Tuples.pair((Object)"POLLING", (Object)"0");
        list.add(_pair);
        for (MessageFromIf mif : triggers) {
            String _triggerCodeName = xpac.getTriggerCodeName(mif);
            InterfaceItem _from = mif.getFrom();
            String _name = _from.getName();
            String _plus = "IFITEM_" + _name;
            String _plus_1 = String.valueOf(_plus) + " + EVT_SHIFT*";
            String _messageID = this.pcGen.getMessageID(mif);
            String _plus_2 = String.valueOf(_plus_1) + _messageID;
            Pair _pair_1 = Tuples.pair((Object)_triggerCodeName, (Object)_plus_2);
            list.add((Pair<String, String>)_pair_1);
        }
        return this.langExt.genEnumeration("triggers", list);
    }

    public CharSequence genStateMachine(ExpandedActorClass xpac) {
        CharSequence _genStateMachine = this.genStateMachine(xpac, true);
        return _genStateMachine;
    }

    public CharSequence genStateMachine(ExpandedActorClass xpac, boolean shallGenerateOneFile) {
        boolean _not_3;
        String _plus;
        String _accessLevelPrivate;
        String _accessLevelPublic;
        StringConcatenation _xblockexpression = null;
        ActorClass ac = xpac.getActorClass();
        ActorCommunicationType _commType = ac.getCommType();
        boolean async = Objects.equal((Object)_commType, (Object)ActorCommunicationType.ASYNCHRONOUS);
        ActorCommunicationType _commType_1 = ac.getCommType();
        boolean eventDriven = Objects.equal((Object)_commType_1, (Object)ActorCommunicationType.EVENT_DRIVEN);
        boolean _or = false;
        _or = async ? true : async || eventDriven;
        boolean handleEvents = _or;
        String _name = ac.getName();
        String opScope = this.langExt.operationScope(_name, false);
        String _xifexpression = null;
        boolean _usesInheritance = this.langExt.usesInheritance();
        _xifexpression = _usesInheritance ? opScope : "";
        String opScopePriv = _xifexpression;
        String _xifexpression_1 = null;
        boolean _usesInheritance_1 = this.langExt.usesInheritance();
        _xifexpression_1 = _usesInheritance_1 ? (_accessLevelPublic = this.langExt.accessLevelPublic()) : (_accessLevelPrivate = this.langExt.accessLevelPrivate());
        String publicIf = _xifexpression_1;
        String privAccess = this.langExt.accessLevelPrivate();
        String _name_1 = ac.getName();
        String self = this.langExt.selfPointer(_name_1, true);
        String _name_2 = ac.getName();
        String selfOnly = this.langExt.selfPointer(_name_2, false);
        String _xifexpression_2 = null;
        boolean _usesInheritance_2 = this.langExt.usesInheritance();
        if (_usesInheritance_2) {
            String _xifexpression_3 = null;
            boolean _usesPointers = this.langExt.usesPointers();
            _xifexpression_3 = _usesPointers ? "->getLocalId()" : ".getLocalId()";
            _xifexpression_2 = _xifexpression_3;
        } else {
            _xifexpression_2 = "->localId";
        }
        String getLocalId = _xifexpression_2;
        String _pointerLiteral = this.langExt.pointerLiteral();
        String ifItemPtr = "InterfaceItemBase" + _pointerLiteral;
        String _xifexpression_4 = null;
        boolean _usesPointers_1 = this.langExt.usesPointers();
        _xifexpression_4 = _usesPointers_1 ? (_plus = "const " + ifItemPtr) : ifItemPtr;
        String constIfItemPtr = _xifexpression_4;
        boolean usesHdlr = this.usesHandlerTrPoints(xpac);
        StringConcatenation _builder = new StringConcatenation();
        if (shallGenerateOneFile) {
            _builder.append((Object)"/* state IDs */");
            _builder.newLine();
            String _genStateIdConstants = this.genStateIdConstants(xpac);
            _builder.append((Object)_genStateIdConstants, "");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append((Object)"/* transition chains */");
            _builder.newLine();
            String _genTransitionChainConstants = this.genTransitionChainConstants(xpac);
            _builder.append((Object)_genTransitionChainConstants, "");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append((Object)"/* triggers */");
            _builder.newLine();
            String _genTriggerConstants = this.genTriggerConstants(xpac);
            _builder.append((Object)_genTriggerConstants, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        CharSequence _genExtra = this.genExtra(xpac);
        _builder.append((Object)_genExtra, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/* Entry and Exit Codes */");
        _builder.newLine();
        StateGraph _stateMachine = xpac.getStateMachine();
        List _stateList = RoomHelpers.getStateList((StateGraph)_stateMachine);
        for (State state : _stateList) {
            boolean _not;
            boolean _or_1 = false;
            boolean _usesInheritance_3 = this.langExt.usesInheritance();
            boolean bl = _not = !_usesInheritance_3;
            if (_not) {
                _or_1 = true;
            } else {
                boolean _isOwnObject = xpac.isOwnObject((StateGraphItem)state);
                boolean bl2 = _or_1 = _not || _isOwnObject;
            }
            if (!_or_1) continue;
            CharSequence _genActionCodeMethods = this.genActionCodeMethods(xpac, state);
            _builder.append((Object)_genActionCodeMethods, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"/* Action Codes */");
        _builder.newLine();
        StateGraph _stateMachine_1 = xpac.getStateMachine();
        List _allTransitionsRecursive = RoomHelpers.getAllTransitionsRecursive((StateGraph)_stateMachine_1);
        for (Transition tr : _allTransitionsRecursive) {
            boolean _not_1;
            boolean _and = false;
            boolean _or_2 = false;
            boolean _usesInheritance_4 = this.langExt.usesInheritance();
            boolean bl = _not_1 = !_usesInheritance_4;
            if (_not_1) {
                _or_2 = true;
            } else {
                boolean _isOwnObject_1 = xpac.isOwnObject((StateGraphItem)tr);
                boolean bl3 = _or_2 = _not_1 || _isOwnObject_1;
            }
            if (!_or_2) {
                _and = false;
            } else {
                DetailCode _action = tr.getAction();
                boolean _hasDetailCode = RoomHelpers.hasDetailCode((DetailCode)_action);
                boolean bl4 = _and = _or_2 && _hasDetailCode;
            }
            if (!_and) continue;
            TransitionChain _chain = xpac.getChain(tr);
            Transition _transition = null;
            if (_chain != null) {
                _transition = _chain.getTransition();
            }
            Transition start = _transition;
            _builder.newLineIfNotEmpty();
            boolean _and_1 = false;
            if (!(start instanceof NonInitialTransition)) {
                _and_1 = false;
            } else {
                boolean _not_2 = !(start instanceof GuardedTransition);
                _and_1 = start instanceof NonInitialTransition && _not_2;
            }
            boolean hasArgs = _and_1;
            _builder.newLineIfNotEmpty();
            String _accessLevelProtected = this.langExt.accessLevelProtected();
            _builder.append((Object)_accessLevelProtected, "");
            _builder.append((Object)"void ");
            _builder.append((Object)opScopePriv, "");
            String _actionCodeOperationName = CodegenHelpers.getActionCodeOperationName(tr);
            _builder.append((Object)_actionCodeOperationName, "");
            _builder.append((Object)"(");
            String _name_3 = ac.getName();
            String _selfPointer = this.langExt.selfPointer(_name_3, hasArgs);
            _builder.append((Object)_selfPointer, "");
            if (hasArgs) {
                _builder.append((Object)constIfItemPtr, "");
                _builder.append((Object)" ifitem");
                String _generateArgumentList = this.transitionChainGenerator.generateArgumentList(xpac, tr);
                _builder.append((Object)_generateArgumentList, "");
            }
            _builder.append((Object)") {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            AbstractGenerator _instance = AbstractGenerator.getInstance();
            DetailCode _action_1 = tr.getAction();
            String _translatedCode = _instance.getTranslatedCode(_action_1);
            _builder.append((Object)_translatedCode, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* calls exit codes while exiting from the current state to one of its");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* parent states while remembering the history");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param current - the current state");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param to - the final parent state");
        _builder.newLine();
        if (usesHdlr) {
            _builder.append((Object)" ");
            _builder.append((Object)"* @param handler - entry and exit codes are called only if not handler (for handler TransitionPoints)");
            _builder.newLine();
        }
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)privAccess, "");
        _builder.append((Object)"void ");
        _builder.append((Object)opScopePriv, "");
        _builder.append((Object)"exitTo(");
        _builder.append((Object)self, "");
        String _stateType = this.stateType();
        _builder.append((Object)_stateType, "");
        _builder.append((Object)" current, ");
        String _stateType_1 = this.stateType();
        _builder.append((Object)_stateType_1, "");
        _builder.append((Object)" to");
        if (usesHdlr) {
            _builder.append((Object)", ");
            String _boolType = this.boolType();
            _builder.append((Object)_boolType, "");
            _builder.append((Object)" handler");
        }
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"while (current!=to) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"switch (current) {");
        _builder.newLine();
        StateGraph _stateMachine_2 = xpac.getStateMachine();
        List _baseStateList = RoomHelpers.getBaseStateList((StateGraph)_stateMachine_2);
        for (State state_1 : _baseStateList) {
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"case ");
            String _genStateId = CodegenHelpers.getGenStateId(state_1);
            _builder.append((Object)_genStateId, "\t\t\t");
            _builder.append((Object)":");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t");
            boolean _hasExitCode = RoomHelpers.hasExitCode((State)state_1, (boolean)true);
            if (_hasExitCode) {
                if (usesHdlr) {
                    _builder.append((Object)"if (!handler) ");
                }
                String _exitCodeOperationName = CodegenHelpers.getExitCodeOperationName(state_1);
                _builder.append((Object)_exitCodeOperationName, "\t\t\t\t");
                _builder.append((Object)"(");
                String _selfPointer_1 = this.langExt.selfPointer(false);
                _builder.append((Object)_selfPointer_1, "\t\t\t\t");
                _builder.append((Object)");");
            }
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t");
            String _parentStateId = CodegenHelpers.getParentStateId(state_1);
            String _genStateId_1 = CodegenHelpers.getGenStateId(state_1);
            String _setHistory = this.setHistory(_parentStateId, _genStateId_1);
            _builder.append((Object)_setHistory, "\t\t\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"current = ");
            String _parentStateId_1 = CodegenHelpers.getParentStateId(state_1);
            _builder.append((Object)_parentStateId_1, "\t\t\t\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"break;");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"default:");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"/* should not occur */");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"break;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* calls action, entry and exit codes along a transition chain. The generic data are cast to typed data");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* matching the trigger of this chain. The ID of the final state is returned");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param chain - the chain ID");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param generic_data - the generic data pointer");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @return the +/- ID of the final state either with a positive sign, that indicates to execute the state's entry code, or a negative sign vice versa");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)privAccess, "");
        String _stateType_2 = this.stateType();
        _builder.append((Object)_stateType_2, "");
        _builder.append((Object)" ");
        _builder.append((Object)opScopePriv, "");
        _builder.append((Object)"executeTransitionChain(");
        _builder.append((Object)self, "");
        _builder.append((Object)"int chain");
        if (handleEvents) {
            _builder.append((Object)", ");
            _builder.append((Object)constIfItemPtr, "");
            _builder.append((Object)" ifitem, ");
            String _voidPointer = this.langExt.voidPointer();
            _builder.append((Object)_voidPointer, "");
            _builder.append((Object)" generic_data");
        }
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"switch (chain) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        EList allchains = xpac.getTransitionChains();
        _builder.newLineIfNotEmpty();
        for (TransitionChain tc : allchains) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"case ");
            String _genChainId = CodegenHelpers.getGenChainId(tc);
            _builder.append((Object)_genChainId, "\t\t");
            _builder.append((Object)":");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"{");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            String _generateExecuteChain = this.transitionChainGenerator.generateExecuteChain(xpac, tc);
            _builder.append((Object)_generateExecuteChain, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"default:");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"/* should not occur */");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"break;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"return NO_STATE;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* calls entry codes while entering a state's history. The ID of the final leaf state is returned");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"* @param state - the state which is entered");
        _builder.newLine();
        if (usesHdlr) {
            _builder.append((Object)" ");
            _builder.append((Object)"* @param handler - entry code is executed if not handler");
            _builder.newLine();
        }
        _builder.append((Object)" ");
        _builder.append((Object)"* @return - the ID of the final leaf state");
        _builder.newLine();
        _builder.append((Object)" ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)privAccess, "");
        String _stateType_3 = this.stateType();
        _builder.append((Object)_stateType_3, "");
        _builder.append((Object)" ");
        _builder.append((Object)opScopePriv, "");
        _builder.append((Object)"enterHistory(");
        _builder.append((Object)self, "");
        String _stateType_4 = this.stateType();
        _builder.append((Object)_stateType_4, "");
        _builder.append((Object)" state");
        if (usesHdlr) {
            _builder.append((Object)", ");
            String _boolType_1 = this.boolType();
            _builder.append((Object)_boolType_1, "");
            _builder.append((Object)" handler");
        }
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _boolType_2 = this.boolType();
        _builder.append((Object)_boolType_2, "\t");
        _builder.append((Object)" skip_entry = ");
        String _booleanConstant = this.langExt.booleanConstant(false);
        _builder.append((Object)_booleanConstant, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"if (state >= STATE_MAX) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"state = ");
        boolean _usesInheritance_5 = this.langExt.usesInheritance();
        boolean bl = _not_3 = !_usesInheritance_5;
        if (_not_3) {
            _builder.append((Object)"(");
            String _stateType_5 = this.stateType();
            _builder.append((Object)_stateType_5, "\t\t");
            _builder.append((Object)")");
        }
        _builder.append((Object)" (state - STATE_MAX);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"skip_entry = ");
        String _booleanConstant_1 = this.langExt.booleanConstant(true);
        _builder.append((Object)_booleanConstant_1, "\t\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"while (");
        String _booleanConstant_2 = this.langExt.booleanConstant(true);
        _builder.append((Object)_booleanConstant_2, "\t");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"switch (state) {");
        _builder.newLine();
        StateGraph _stateMachine_3 = xpac.getStateMachine();
        List _baseStateList_1 = RoomHelpers.getBaseStateList((StateGraph)_stateMachine_3);
        for (State state_2 : _baseStateList_1) {
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"case ");
            String _genStateId_2 = CodegenHelpers.getGenStateId(state_2);
            _builder.append((Object)_genStateId_2, "\t\t\t");
            _builder.append((Object)":");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t");
            boolean _hasEntryCode = RoomHelpers.hasEntryCode((State)state_2, (boolean)true);
            if (_hasEntryCode) {
                _builder.append((Object)"if (!(skip_entry");
                if (usesHdlr) {
                    _builder.append((Object)" || handler");
                }
                _builder.append((Object)")) ");
                String _entryCodeOperationName = CodegenHelpers.getEntryCodeOperationName(state_2);
                _builder.append((Object)_entryCodeOperationName, "\t\t\t\t");
                _builder.append((Object)"(");
                String _selfPointer_2 = this.langExt.selfPointer(false);
                _builder.append((Object)_selfPointer_2, "\t\t\t\t");
                _builder.append((Object)");");
            }
            _builder.newLineIfNotEmpty();
            boolean _isLeaf = RoomHelpers.isLeaf((State)state_2);
            if (_isLeaf) {
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"/* in leaf state: return state id */");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"return ");
                String _genStateId_3 = CodegenHelpers.getGenStateId(state_2);
                _builder.append((Object)_genStateId_3, "\t\t\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                continue;
            }
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"/* state has a sub graph */");
            _builder.newLine();
            StateGraph _subgraph = state_2.getSubgraph();
            boolean _hasInitTransition = RoomHelpers.hasInitTransition((StateGraph)_subgraph);
            if (_hasInitTransition) {
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"/* with init transition */");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"if (");
                String _genStateId_4 = CodegenHelpers.getGenStateId(state_2);
                String _history = this.getHistory(_genStateId_4);
                _builder.append((Object)_history, "\t\t\t\t");
                _builder.append((Object)"==NO_STATE) {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                StateGraph _subgraph_1 = state_2.getSubgraph();
                Transition sub_initt = RoomHelpers.getInitTransition((StateGraph)_subgraph_1);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"state = executeTransitionChain(");
                String _selfPointer_3 = this.langExt.selfPointer(true);
                _builder.append((Object)_selfPointer_3, "\t\t\t\t\t");
                TransitionChain _chain_1 = xpac.getChain(sub_initt);
                String _genChainId_1 = CodegenHelpers.getGenChainId(_chain_1);
                _builder.append((Object)_genChainId_1, "\t\t\t\t\t");
                if (handleEvents) {
                    _builder.append((Object)", ");
                    String _nullPointer = this.langExt.nullPointer();
                    _builder.append((Object)_nullPointer, "\t\t\t\t\t");
                    _builder.append((Object)", ");
                    String _nullPointer_1 = this.langExt.nullPointer();
                    _builder.append((Object)_nullPointer_1, "\t\t\t\t\t");
                }
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"else {");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"state = ");
                String _genStateId_5 = CodegenHelpers.getGenStateId(state_2);
                String _history_1 = this.getHistory(_genStateId_5);
                _builder.append((Object)_history_1, "\t\t\t\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
            } else {
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"/* without init transition */");
                _builder.newLine();
                _builder.append((Object)"\t\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"state = ");
                String _genStateId_6 = CodegenHelpers.getGenStateId(state_2);
                String _history_2 = this.getHistory(_genStateId_6);
                _builder.append((Object)_history_2, "\t\t\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"break;");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"case STATE_TOP:");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"state = ");
        String _history_3 = this.getHistory("STATE_TOP");
        _builder.append((Object)_history_3, "\t\t\t\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"break;");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"default:");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"/* should not occur */");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)"break;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"skip_entry = ");
        String _booleanConstant_3 = this.langExt.booleanConstant(false);
        _builder.append((Object)_booleanConstant_3, "\t\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _unreachableReturn = this.unreachableReturn();
        _builder.append((Object)_unreachableReturn, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)publicIf, "");
        _builder.append((Object)"void ");
        _builder.append((Object)opScope, "");
        _builder.append((Object)"executeInitTransition(");
        _builder.append((Object)selfOnly, "");
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        StateGraph _stateMachine_4 = xpac.getStateMachine();
        Transition initt = RoomHelpers.getInitTransition((StateGraph)_stateMachine_4);
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"int chain = ");
        TransitionChain _chain_2 = xpac.getChain(initt);
        String _genChainId_2 = CodegenHelpers.getGenChainId(_chain_2);
        _builder.append((Object)_genChainId_2, "\t");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _stateType_6 = this.stateType();
        _builder.append((Object)_stateType_6, "\t");
        _builder.append((Object)" next = ");
        _builder.append((Object)opScopePriv, "\t");
        _builder.append((Object)"executeTransitionChain(");
        String _selfPointer_4 = this.langExt.selfPointer(true);
        _builder.append((Object)_selfPointer_4, "\t");
        _builder.append((Object)"chain");
        if (handleEvents) {
            _builder.append((Object)", ");
            String _nullPointer_2 = this.langExt.nullPointer();
            _builder.append((Object)_nullPointer_2, "\t");
            _builder.append((Object)", ");
            String _nullPointer_3 = this.langExt.nullPointer();
            _builder.append((Object)_nullPointer_3, "\t");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"next = ");
        _builder.append((Object)opScopePriv, "\t");
        _builder.append((Object)"enterHistory(");
        String _selfPointer_5 = this.langExt.selfPointer(true);
        _builder.append((Object)_selfPointer_5, "\t");
        _builder.append((Object)"next");
        if (usesHdlr) {
            _builder.append((Object)", ");
            String _booleanConstant_4 = this.langExt.booleanConstant(false);
            _builder.append((Object)_booleanConstant_4, "\t");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"setState(");
        String _selfPointer_6 = this.langExt.selfPointer(true);
        _builder.append((Object)_selfPointer_6, "\t");
        _builder.append((Object)"next);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"/* receiveEvent contains the main implementation of the FSM */");
        _builder.newLine();
        _builder.append((Object)publicIf, "");
        _builder.append((Object)"void ");
        _builder.append((Object)opScope, "");
        _builder.append((Object)"receiveEvent(");
        String _name_4 = ac.getName();
        String _selfPointer_7 = this.langExt.selfPointer(_name_4, handleEvents);
        _builder.append((Object)_selfPointer_7, "");
        if (handleEvents) {
            _builder.append((Object)ifItemPtr, "");
            _builder.append((Object)" ifitem, int evt, ");
            String _voidPointer_1 = this.langExt.voidPointer();
            _builder.append((Object)_voidPointer_1, "");
            _builder.append((Object)" generic_data");
        }
        _builder.append((Object)") {");
        _builder.newLineIfNotEmpty();
        if (async) {
            _builder.append((Object)"\t");
            _builder.append((Object)"int trigger = (ifitem==");
            String _nullPointer_4 = this.langExt.nullPointer();
            _builder.append((Object)_nullPointer_4, "\t");
            _builder.append((Object)")? POLLING : ifitem");
            _builder.append((Object)getLocalId, "\t");
            _builder.append((Object)" + EVT_SHIFT*evt;");
            _builder.newLineIfNotEmpty();
        } else if (eventDriven) {
            _builder.append((Object)"\t");
            _builder.append((Object)"int trigger = ifitem");
            _builder.append((Object)getLocalId, "\t");
            _builder.append((Object)" + EVT_SHIFT*evt;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"int chain = NOT_CAUGHT;");
        _builder.newLine();
        _builder.append((Object)"\t");
        String _stateType_7 = this.stateType();
        _builder.append((Object)_stateType_7, "\t");
        _builder.append((Object)" catching_state = NO_STATE;");
        _builder.newLineIfNotEmpty();
        if (usesHdlr) {
            _builder.append((Object)"\t");
            String _boolType_3 = this.boolType();
            _builder.append((Object)_boolType_3, "\t");
            _builder.append((Object)" is_handler = ");
            String _booleanConstant_5 = this.langExt.booleanConstant(false);
            _builder.append((Object)_booleanConstant_5, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.newLine();
        if (handleEvents) {
            _builder.append((Object)"\t");
            _builder.append((Object)"if (!handleSystemEvent(ifitem, evt, generic_data)) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            CharSequence _genStateSwitch = this.genStateSwitch(xpac, usesHdlr);
            _builder.append((Object)_genStateSwitch, "\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        } else {
            _builder.append((Object)"\t");
            CharSequence _genStateSwitch_1 = this.genStateSwitch(xpac, usesHdlr);
            _builder.append((Object)_genStateSwitch_1, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"if (chain != NOT_CAUGHT) {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)opScopePriv, "\t\t");
        _builder.append((Object)"exitTo(");
        String _selfPointer_8 = this.langExt.selfPointer(true);
        _builder.append((Object)_selfPointer_8, "\t\t");
        _builder.append((Object)"getState(");
        String _selfPointer_9 = this.langExt.selfPointer(false);
        _builder.append((Object)_selfPointer_9, "\t\t");
        _builder.append((Object)"), catching_state");
        if (usesHdlr) {
            _builder.append((Object)", is_handler");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"{");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        String _stateType_8 = this.stateType();
        _builder.append((Object)_stateType_8, "\t\t\t");
        _builder.append((Object)" next = ");
        _builder.append((Object)opScopePriv, "\t\t\t");
        _builder.append((Object)"executeTransitionChain(");
        String _selfPointer_10 = this.langExt.selfPointer(true);
        _builder.append((Object)_selfPointer_10, "\t\t\t");
        _builder.append((Object)"chain");
        if (handleEvents) {
            _builder.append((Object)", ifitem, generic_data");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"next = ");
        _builder.append((Object)opScopePriv, "\t\t\t");
        _builder.append((Object)"enterHistory(");
        String _selfPointer_11 = this.langExt.selfPointer(true);
        _builder.append((Object)_selfPointer_11, "\t\t\t");
        _builder.append((Object)"next");
        if (usesHdlr) {
            _builder.append((Object)", is_handler");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"setState(");
        String _selfPointer_12 = this.langExt.selfPointer(true);
        _builder.append((Object)_selfPointer_12, "\t\t\t");
        _builder.append((Object)"next);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t\t");
        CharSequence _finalAction = this.finalAction();
        _builder.append((Object)_finalAction, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence finalAction() {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    protected CharSequence genStateSwitch(ExpandedActorClass xpac, boolean usesHdlr) {
        StringConcatenation _xblockexpression = null;
        ActorClass _actorClass = xpac.getActorClass();
        ActorCommunicationType _commType = _actorClass.getCommType();
        boolean async = Objects.equal((Object)_commType, (Object)ActorCommunicationType.ASYNCHRONOUS);
        ActorClass _actorClass_1 = xpac.getActorClass();
        ActorCommunicationType _commType_1 = _actorClass_1.getCommType();
        boolean eventDriven = Objects.equal((Object)_commType_1, (Object)ActorCommunicationType.EVENT_DRIVEN);
        ActorClass _actorClass_2 = xpac.getActorClass();
        ActorCommunicationType _commType_2 = _actorClass_2.getCommType();
        boolean dataDriven = Objects.equal((Object)_commType_2, (Object)ActorCommunicationType.DATA_DRIVEN);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"switch (getState(");
        String _selfPointer = this.langExt.selfPointer(false);
        _builder.append((Object)_selfPointer, "");
        _builder.append((Object)")) {");
        _builder.newLineIfNotEmpty();
        StateGraph _stateMachine = xpac.getStateMachine();
        List _leafStateList = RoomHelpers.getLeafStateList((StateGraph)_stateMachine);
        for (State state : _leafStateList) {
            _builder.append((Object)"\t");
            _builder.append((Object)"case ");
            String _genStateId = CodegenHelpers.getGenStateId(state);
            _builder.append((Object)_genStateId, "\t");
            _builder.append((Object)":");
            _builder.newLineIfNotEmpty();
            if (async) {
                boolean _not;
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                EList atlist = xpac.getActiveTriggers(state);
                _builder.newLineIfNotEmpty();
                boolean _isEmpty = atlist.isEmpty();
                boolean bl = _not = !_isEmpty;
                if (_not) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"switch(trigger) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"case POLLING:");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t\t");
                    CharSequence _genDataDrivenTriggers = this.genDataDrivenTriggers(xpac, state, usesHdlr);
                    _builder.append((Object)_genDataDrivenTriggers, "\t\t\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t\t");
                    _builder.append((Object)"break;");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    CharSequence _genEventDrivenTriggers = this.genEventDrivenTriggers(xpac, state, (List<ActiveTrigger>)atlist, usesHdlr);
                    _builder.append((Object)_genEventDrivenTriggers, "\t\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                } else {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    CharSequence _genDataDrivenTriggers_1 = this.genDataDrivenTriggers(xpac, state, usesHdlr);
                    _builder.append((Object)_genDataDrivenTriggers_1, "\t\t");
                    _builder.newLineIfNotEmpty();
                }
            } else if (dataDriven) {
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                CharSequence _genDataDrivenTriggers_2 = this.genDataDrivenTriggers(xpac, state, usesHdlr);
                _builder.append((Object)_genDataDrivenTriggers_2, "\t\t");
                _builder.newLineIfNotEmpty();
            } else if (eventDriven) {
                boolean _not_1;
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                EList atlist_1 = xpac.getActiveTriggers(state);
                _builder.newLineIfNotEmpty();
                boolean _isEmpty_1 = atlist_1.isEmpty();
                boolean bl = _not_1 = !_isEmpty_1;
                if (_not_1) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"switch(trigger) {");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t\t");
                    CharSequence _genEventDrivenTriggers_1 = this.genEventDrivenTriggers(xpac, state, (List<ActiveTrigger>)atlist_1, usesHdlr);
                    _builder.append((Object)_genEventDrivenTriggers_1, "\t\t\t\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
            }
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"break;");
            _builder.newLine();
        }
        _builder.append((Object)"\t");
        _builder.append((Object)"default:");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"/* should not occur */");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"break;");
        _builder.newLine();
        _builder.append((Object)"}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence genDataDrivenTriggers(ExpandedActorClass xpac, State state, boolean usesHdlr) {
        StringConcatenation _builder = new StringConcatenation();
        String _genDoCodes = this.genDoCodes(state);
        _builder.append((Object)_genDoCodes, "");
        _builder.newLineIfNotEmpty();
        List<Transition> _outgoingTransitionsHierarchical = this._roomExtensions.getOutgoingTransitionsHierarchical(xpac, state);
        Functions.Function1<Transition, Boolean> _function = new Functions.Function1<Transition, Boolean>(){

            public Boolean apply(Transition t) {
                return t instanceof GuardedTransition;
            }
        };
        Iterable transitions = IterableExtensions.filter(_outgoingTransitionsHierarchical, (Functions.Function1)_function);
        _builder.newLineIfNotEmpty();
        for (Transition tr : transitions) {
            boolean _notEquals;
            _builder.append((Object)"if (");
            AbstractGenerator _instance = AbstractGenerator.getInstance();
            DetailCode _guard = ((GuardedTransition)tr).getGuard();
            String _translatedCode = _instance.getTranslatedCode(_guard);
            _builder.append((Object)_translatedCode, "");
            _builder.append((Object)")");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"{");
            _builder.newLine();
            _builder.append((Object)"\t");
            TransitionChain chain = xpac.getChain(tr);
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"chain = ");
            String _genChainId = CodegenHelpers.getGenChainId(chain);
            _builder.append((Object)_genChainId, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"catching_state = ");
            State _stateContext = chain.getStateContext();
            String _genStateId = CodegenHelpers.getGenStateId(_stateContext);
            _builder.append((Object)_genStateId, "\t");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
            boolean _and = false;
            boolean _isHandler = chain.isHandler();
            if (!_isHandler) {
                _and = false;
            } else {
                boolean bl = _and = _isHandler && usesHdlr;
            }
            if (_and) {
                _builder.append((Object)"\t");
                _builder.append((Object)"is_handler = TRUE;");
                _builder.newLine();
            }
            _builder.append((Object)"}");
            _builder.newLine();
            Transition _last = (Transition)IterableExtensions.last((Iterable)transitions);
            boolean bl = _notEquals = !Objects.equal((Object)tr, (Object)_last);
            if (!_notEquals) continue;
            _builder.append((Object)"else ");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence genEventDrivenTriggers(ExpandedActorClass xpac, State state, List<ActiveTrigger> atlist, boolean usesHdlr) {
        StringConcatenation _builder = new StringConcatenation();
        for (ActiveTrigger at : atlist) {
            _builder.append((Object)"case ");
            String _triggerCodeName = xpac.getTriggerCodeName(at);
            _builder.append((Object)_triggerCodeName, "");
            _builder.append((Object)":");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            boolean needData = ETriceGenUtil.hasGuard((ActiveTrigger)at);
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            if (needData) {
                _builder.append((Object)"{ ");
                Message _msg = at.getMsg();
                String _typedDataDefinition = this.langExt.getTypedDataDefinition(_msg);
                _builder.append((Object)_typedDataDefinition, "\t");
            }
            _builder.newLineIfNotEmpty();
            EList _transitions = at.getTransitions();
            boolean _hasElements = false;
            for (TriggeredTransition tt : _transitions) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)" else ", "\t");
                }
                _builder.append((Object)"\t");
                TransitionChain chain = xpac.getChain((Transition)tt);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                Transition _transition = chain.getTransition();
                String _trigger = at.getTrigger();
                CharSequence _guard = this.guard(_transition, _trigger, xpac);
                _builder.append((Object)_guard, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"chain = ");
                String _genChainId = CodegenHelpers.getGenChainId(chain);
                _builder.append((Object)_genChainId, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"catching_state = ");
                State _stateContext = chain.getStateContext();
                String _genStateId = CodegenHelpers.getGenStateId(_stateContext);
                _builder.append((Object)_genStateId, "\t\t");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                boolean _and = false;
                boolean _isHandler = chain.isHandler();
                if (!_isHandler) {
                    _and = false;
                } else {
                    boolean bl = _and = _isHandler && usesHdlr;
                }
                if (_and) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)"\t");
                    _builder.append((Object)"is_handler = ");
                    String _booleanConstant = this.langExt.booleanConstant(true);
                    _builder.append((Object)_booleanConstant, "\t\t");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
            }
            _builder.append((Object)"\t");
            if (needData) {
                _builder.append((Object)"}");
            }
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"break;");
            _builder.newLine();
        }
        _builder.append((Object)"default:");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/* should not occur */");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"break;");
        _builder.newLine();
        return _builder;
    }

    protected String getHistory(String state) {
        String _memberAccess = this.langExt.memberAccess();
        String _plus = String.valueOf(_memberAccess) + "history[";
        String _plus_1 = String.valueOf(_plus) + state;
        String _plus_2 = String.valueOf(_plus_1) + "]";
        return _plus_2;
    }

    protected String setHistory(String state, String historyState) {
        String _memberAccess = this.langExt.memberAccess();
        String _plus = String.valueOf(_memberAccess) + "history[";
        String _plus_1 = String.valueOf(_plus) + state;
        String _plus_2 = String.valueOf(_plus_1) + "] = ";
        String _plus_3 = String.valueOf(_plus_2) + historyState;
        return _plus_3;
    }

    protected String stateType() {
        return "int";
    }

    protected String unreachableReturn() {
        return "/* return NO_STATE; // required by CDT but detected as unreachable by JDT because of while (true) */";
    }

    protected String boolType() {
        return "boolean";
    }

    protected CharSequence genExtra(ExpandedActorClass xpac) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    protected CharSequence genExtraDecl(ExpandedActorClass xpac) {
        StringConcatenation _builder = new StringConcatenation();
        return _builder;
    }

    protected CharSequence _guard(TriggeredTransition tt, final String trigger, final ExpandedActorClass ac) {
        StringConcatenation _xblockexpression = null;
        EList _triggers = tt.getTriggers();
        Functions.Function1<Trigger, Boolean> _function = new Functions.Function1<Trigger, Boolean>(){

            public Boolean apply(Trigger e) {
                boolean _isMatching = ac.isMatching(e, trigger);
                return _isMatching;
            }
        };
        Trigger tr = (Trigger)IterableExtensions.findFirst((Iterable)_triggers, (Functions.Function1)_function);
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasGuard = RoomHelpers.hasGuard((Trigger)tr);
        if (_hasGuard) {
            _builder.append((Object)"if (");
            AbstractGenerator _instance = AbstractGenerator.getInstance();
            Guard _guard = tr.getGuard();
            DetailCode _guard_1 = _guard.getGuard();
            String _translatedCode = _instance.getTranslatedCode(_guard_1);
            _builder.append((Object)_translatedCode, "");
            _builder.append((Object)")");
            _builder.newLineIfNotEmpty();
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence _guard(Transition t, String trigger, ExpandedActorClass ac) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"/* error */");
        _builder.newLine();
        return _builder;
    }

    protected String genDoCodes(State state) {
        EObject _eContainer;
        EObject _eContainer_1;
        StringConcatenation _builder = new StringConcatenation();
        boolean _hasDoCode = RoomHelpers.hasDoCode((State)state, (boolean)true);
        if (_hasDoCode) {
            String _doCodeOperationName = CodegenHelpers.getDoCodeOperationName(state);
            _builder.append((Object)_doCodeOperationName, "");
            _builder.append((Object)"(");
            String _selfPointer = this.langExt.selfPointer(false);
            _builder.append((Object)_selfPointer, "");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        if ((_eContainer_1 = (_eContainer = state.eContainer()).eContainer()) instanceof State) {
            EObject _eContainer_2 = state.eContainer();
            EObject _eContainer_3 = _eContainer_2.eContainer();
            String _genDoCodes = this.genDoCodes((State)_eContainer_3);
            _builder.append((Object)_genDoCodes, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }

    protected CharSequence genActionCodeMethods(ExpandedActorClass xpac, State state) {
        CharSequence _genActionCodeMethods = this.genActionCodeMethods(xpac, state, true);
        return _genActionCodeMethods;
    }

    protected CharSequence genActionCodeMethods(ExpandedActorClass xpac, State state, boolean generateImplementation) {
        boolean _isEmpty_2;
        boolean _not_2;
        boolean _isEmpty_1;
        boolean _not_1;
        boolean _not;
        StringConcatenation _xblockexpression = null;
        ActorClass ac = xpac.getActorClass();
        ActorClass _actorClass = xpac.getActorClass();
        String _name = _actorClass.getName();
        String selfPtr = this.langExt.selfPointer(_name, false);
        String _name_1 = ac.getName();
        String opScope = this.langExt.operationScope(_name_1, false);
        String _xifexpression = null;
        boolean _usesInheritance = this.langExt.usesInheritance();
        _xifexpression = _usesInheritance ? opScope : "";
        String opScopePriv = _xifexpression;
        String entryOp = CodegenHelpers.getEntryCodeOperationName(state);
        String exitOp = CodegenHelpers.getExitCodeOperationName(state);
        String doOp = CodegenHelpers.getDoCodeOperationName(state);
        AbstractGenerator _instance = AbstractGenerator.getInstance();
        DetailCode _entryCode = state.getEntryCode();
        String entry = _instance.getTranslatedCode(_entryCode);
        AbstractGenerator _instance_1 = AbstractGenerator.getInstance();
        DetailCode _exitCode = state.getExitCode();
        String exit = _instance_1.getTranslatedCode(_exitCode);
        AbstractGenerator _instance_2 = AbstractGenerator.getInstance();
        DetailCode _doCode = state.getDoCode();
        String docode = _instance_2.getTranslatedCode(_doCode);
        if (state instanceof ExpandedRefinedState) {
            ExpandedRefinedState rs = (ExpandedRefinedState)state;
            AbstractGenerator _instance_3 = AbstractGenerator.getInstance();
            DetailCode _inheritedEntry = rs.getInheritedEntry();
            String inhEntry = _instance_3.getTranslatedCode(_inheritedEntry);
            AbstractGenerator _instance_4 = AbstractGenerator.getInstance();
            DetailCode _inheritedExit = rs.getInheritedExit();
            String inhExit = _instance_4.getTranslatedCode(_inheritedExit);
            AbstractGenerator _instance_5 = AbstractGenerator.getInstance();
            DetailCode _inheritedDo = rs.getInheritedDo();
            String inhDo = _instance_5.getTranslatedCode(_inheritedDo);
            boolean _usesInheritance_1 = this.langExt.usesInheritance();
            if (_usesInheritance_1) {
                DetailCode _inheritedDo_1;
                boolean _hasDetailCode_2;
                DetailCode _inheritedExit_1;
                boolean _hasDetailCode_1;
                ActorClass _actorClass_1 = xpac.getActorClass();
                ActorClass _base = _actorClass_1.getBase();
                String baseName = _base.getName();
                DetailCode _inheritedEntry_1 = rs.getInheritedEntry();
                boolean _hasDetailCode = RoomHelpers.hasDetailCode((DetailCode)_inheritedEntry_1);
                if (_hasDetailCode) {
                    String _plus;
                    String _superCall = this.langExt.superCall(baseName, entryOp, "");
                    entry = _plus = String.valueOf(_superCall) + entry;
                }
                if (_hasDetailCode_1 = RoomHelpers.hasDetailCode((DetailCode)(_inheritedExit_1 = rs.getInheritedExit()))) {
                    String _plus_1;
                    String _superCall_1 = this.langExt.superCall(baseName, exitOp, "");
                    exit = _plus_1 = String.valueOf(exit) + _superCall_1;
                }
                if (_hasDetailCode_2 = RoomHelpers.hasDetailCode((DetailCode)(_inheritedDo_1 = rs.getInheritedDo()))) {
                    String _plus_2;
                    String _superCall_2 = this.langExt.superCall(baseName, doOp, "");
                    docode = _plus_2 = String.valueOf(_superCall_2) + docode;
                }
            } else {
                String _plus_5;
                String _plus_4;
                String _plus_3;
                entry = _plus_3 = String.valueOf(inhEntry) + entry;
                exit = _plus_4 = String.valueOf(exit) + inhExit;
                docode = _plus_5 = String.valueOf(inhDo) + docode;
            }
        }
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = entry.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            if (generateImplementation) {
                String _accessLevelProtected = this.langExt.accessLevelProtected();
                _builder.append((Object)_accessLevelProtected, "");
                _builder.append((Object)"void ");
                _builder.append((Object)opScopePriv, "");
                _builder.append((Object)entryOp, "");
                _builder.append((Object)"(");
                _builder.append((Object)selfPtr, "");
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)entry, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
            } else {
                String _accessLevelProtected_1 = this.langExt.accessLevelProtected();
                _builder.append((Object)_accessLevelProtected_1, "");
                _builder.append((Object)"void ");
                _builder.append((Object)entryOp, "");
                _builder.append((Object)"(");
                _builder.append((Object)selfPtr, "");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
        }
        boolean bl2 = _not_1 = !(_isEmpty_1 = exit.isEmpty());
        if (_not_1) {
            if (generateImplementation) {
                String _accessLevelProtected_2 = this.langExt.accessLevelProtected();
                _builder.append((Object)_accessLevelProtected_2, "");
                _builder.append((Object)"void ");
                _builder.append((Object)opScopePriv, "");
                _builder.append((Object)exitOp, "");
                _builder.append((Object)"(");
                _builder.append((Object)selfPtr, "");
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)exit, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
            } else {
                String _accessLevelProtected_3 = this.langExt.accessLevelProtected();
                _builder.append((Object)_accessLevelProtected_3, "");
                _builder.append((Object)"void ");
                _builder.append((Object)exitOp, "");
                _builder.append((Object)"(");
                _builder.append((Object)selfPtr, "");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
        }
        boolean bl3 = _not_2 = !(_isEmpty_2 = docode.isEmpty());
        if (_not_2) {
            if (generateImplementation) {
                String _accessLevelProtected_4 = this.langExt.accessLevelProtected();
                _builder.append((Object)_accessLevelProtected_4, "");
                _builder.append((Object)" void ");
                _builder.append((Object)opScopePriv, "");
                _builder.append((Object)doOp, "");
                _builder.append((Object)"(");
                _builder.append((Object)selfPtr, "");
                _builder.append((Object)") {");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)docode, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
            } else {
                String _accessLevelProtected_5 = this.langExt.accessLevelProtected();
                _builder.append((Object)_accessLevelProtected_5, "");
                _builder.append((Object)"void ");
                _builder.append((Object)doOp, "");
                _builder.append((Object)"(");
                _builder.append((Object)selfPtr, "");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected String constPointer(String classname) {
        return classname;
    }

    public CharSequence genStateMachineMethodDeclarations(ExpandedActorClass xpac) {
        StringConcatenation _xblockexpression = null;
        ActorClass ac = xpac.getActorClass();
        ActorCommunicationType _commType = ac.getCommType();
        boolean async = Objects.equal((Object)_commType, (Object)ActorCommunicationType.ASYNCHRONOUS);
        ActorCommunicationType _commType_1 = ac.getCommType();
        boolean eventDriven = Objects.equal((Object)_commType_1, (Object)ActorCommunicationType.EVENT_DRIVEN);
        boolean _or = false;
        _or = async ? true : async || eventDriven;
        boolean handleEvents = _or;
        String _name = ac.getName();
        String self = this.langExt.selfPointer(_name, true);
        boolean usesHdlr = this.usesHandlerTrPoints(xpac);
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append((Object)"/* state IDs */");
        _builder.newLine();
        String _genStateIdConstants = this.genStateIdConstants(xpac);
        _builder.append((Object)_genStateIdConstants, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/* transition chains */");
        _builder.newLine();
        String _genTransitionChainConstants = this.genTransitionChainConstants(xpac);
        _builder.append((Object)_genTransitionChainConstants, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/* triggers */");
        _builder.newLine();
        String _genTriggerConstants = this.genTriggerConstants(xpac);
        _builder.append((Object)_genTriggerConstants, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _genExtraDecl = this.genExtraDecl(xpac);
        _builder.append((Object)_genExtraDecl, "");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"/* Entry and Exit Codes */");
        _builder.newLine();
        StateGraph _stateMachine = xpac.getStateMachine();
        List _stateList = RoomHelpers.getStateList((StateGraph)_stateMachine);
        for (State state : _stateList) {
            boolean _not;
            boolean _or_1 = false;
            boolean _usesInheritance = this.langExt.usesInheritance();
            boolean bl = _not = !_usesInheritance;
            if (_not) {
                _or_1 = true;
            } else {
                boolean _isOwnObject = xpac.isOwnObject((StateGraphItem)state);
                boolean bl2 = _or_1 = _not || _isOwnObject;
            }
            if (!_or_1) continue;
            CharSequence _genActionCodeMethods = this.genActionCodeMethods(xpac, state, false);
            _builder.append((Object)_genActionCodeMethods, "");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"/* Action Codes */");
        _builder.newLine();
        StateGraph _stateMachine_1 = xpac.getStateMachine();
        List _allTransitionsRecursive = RoomHelpers.getAllTransitionsRecursive((StateGraph)_stateMachine_1);
        for (Transition tr : _allTransitionsRecursive) {
            boolean _not_1;
            boolean _and = false;
            boolean _or_2 = false;
            boolean _usesInheritance_1 = this.langExt.usesInheritance();
            boolean bl = _not_1 = !_usesInheritance_1;
            if (_not_1) {
                _or_2 = true;
            } else {
                boolean _isOwnObject_1 = xpac.isOwnObject((StateGraphItem)tr);
                boolean bl3 = _or_2 = _not_1 || _isOwnObject_1;
            }
            if (!_or_2) {
                _and = false;
            } else {
                DetailCode _action = tr.getAction();
                boolean _hasDetailCode = RoomHelpers.hasDetailCode((DetailCode)_action);
                boolean bl4 = _and = _or_2 && _hasDetailCode;
            }
            if (!_and) continue;
            TransitionChain _chain = xpac.getChain(tr);
            Transition start = _chain.getTransition();
            _builder.newLineIfNotEmpty();
            boolean _and_1 = false;
            if (!(start instanceof NonInitialTransition)) {
                _and_1 = false;
            } else {
                boolean _not_2 = !(start instanceof GuardedTransition);
                _and_1 = start instanceof NonInitialTransition && _not_2;
            }
            boolean hasArgs = _and_1;
            _builder.newLineIfNotEmpty();
            String _accessLevelProtected = this.langExt.accessLevelProtected();
            _builder.append((Object)_accessLevelProtected, "");
            _builder.append((Object)"void ");
            String _actionCodeOperationName = CodegenHelpers.getActionCodeOperationName(tr);
            _builder.append((Object)_actionCodeOperationName, "");
            _builder.append((Object)"(");
            String _name_1 = ac.getName();
            String _selfPointer = this.langExt.selfPointer(_name_1, hasArgs);
            _builder.append((Object)_selfPointer, "");
            if (hasArgs) {
                String _constPointer = this.constPointer("etRuntime::InterfaceItemBase");
                _builder.append((Object)_constPointer, "");
                _builder.append((Object)" ifitem");
                String _generateArgumentList = this.transitionChainGenerator.generateArgumentList(xpac, tr);
                _builder.append((Object)_generateArgumentList, "");
            }
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"private:");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* calls exit codes while exiting from the current state to one of its");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* parent states while remembering the history");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @param current - the current state");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @param to - the final parent state");
        _builder.newLine();
        if (usesHdlr) {
            _builder.append((Object)"\t ");
            _builder.append((Object)"* @param handler - entry and exit codes are called only if not handler (for handler TransitionPoints)");
            _builder.newLine();
        }
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"void exitTo(");
        _builder.append((Object)self, "\t");
        _builder.append((Object)"int current, int to");
        if (usesHdlr) {
            _builder.append((Object)", ");
            String _boolType = this.boolType();
            _builder.append((Object)_boolType, "\t");
            _builder.append((Object)" handler");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* calls action, entry and exit codes along a transition chain. The generic data are cast to typed data");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* matching the trigger of this chain. The ID of the final state is returned");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @param chain - the chain ID");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @param generic_data - the generic data pointer");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @return the ID of the final state");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"int executeTransitionChain(");
        _builder.append((Object)self, "\t");
        _builder.append((Object)"int chain");
        if (handleEvents) {
            _builder.append((Object)", ");
            String _constPointer_1 = this.constPointer("etRuntime::InterfaceItemBase");
            _builder.append((Object)_constPointer_1, "\t");
            _builder.append((Object)" ifitem, ");
            String _voidPointer = this.langExt.voidPointer();
            _builder.append((Object)_voidPointer, "\t");
            _builder.append((Object)" generic_data");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/**");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* calls entry codes while entering a state's history. The ID of the final leaf state is returned");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @param state - the state which is entered");
        _builder.newLine();
        if (usesHdlr) {
            _builder.append((Object)"\t ");
            _builder.append((Object)"* @param handler - entry code is executed if not handler");
            _builder.newLine();
        }
        _builder.append((Object)"\t ");
        _builder.append((Object)"* @return - the ID of the final leaf state");
        _builder.newLine();
        _builder.append((Object)"\t ");
        _builder.append((Object)"*/");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"int enterHistory(");
        _builder.append((Object)self, "\t");
        _builder.append((Object)"int state");
        if (usesHdlr) {
            _builder.append((Object)", ");
            String _boolType_1 = this.boolType();
            _builder.append((Object)_boolType_1, "\t");
            _builder.append((Object)" handler");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"public:");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"void executeInitTransition(");
        String _name_2 = ac.getName();
        String _selfPointer_1 = this.langExt.selfPointer(_name_2, false);
        _builder.append((Object)_selfPointer_1, "\t");
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"/* receiveEvent contains the main implementation of the FSM */");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"void receiveEvent(");
        String _name_3 = ac.getName();
        String _selfPointer_2 = this.langExt.selfPointer(_name_3, handleEvents);
        _builder.append((Object)_selfPointer_2, "\t");
        if (handleEvents) {
            _builder.append((Object)"etRuntime::InterfaceItemBase* ifitem, int evt, ");
            String _voidPointer_1 = this.langExt.voidPointer();
            _builder.append((Object)_voidPointer_1, "\t");
            _builder.append((Object)" generic_data");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    private boolean usesHandlerTrPoints(ExpandedActorClass xpac) {
        boolean _not;
        Functions.Function1<TrPoint, Boolean> _function;
        boolean _xblockexpression = false;
        StateGraph _stateMachine = xpac.getStateMachine();
        boolean _isEmpty = RoomHelpers.isEmpty((StateGraph)_stateMachine);
        if (_isEmpty) {
            return false;
        }
        StateGraph _stateMachine_1 = xpac.getStateMachine();
        List _allTrPointsRecursive = RoomHelpers.getAllTrPointsRecursive((StateGraph)_stateMachine_1);
        Iterable _filter = IterableExtensions.filter((Iterable)_allTrPointsRecursive, (Functions.Function1)(_function = new Functions.Function1<TrPoint, Boolean>(){

            public Boolean apply(TrPoint t) {
                boolean _and = false;
                if (!(t instanceof TransitionPoint)) {
                    _and = false;
                } else {
                    boolean _isHandler = ((TransitionPoint)t).isHandler();
                    _and = t instanceof TransitionPoint && _isHandler;
                }
                return _and;
            }
        }));
        boolean _isEmpty_1 = IterableExtensions.isEmpty((Iterable)_filter);
        _xblockexpression = _not = !_isEmpty_1;
        return _xblockexpression;
    }

    protected CharSequence guard(Transition tt, String trigger, ExpandedActorClass ac) {
        if (tt instanceof TriggeredTransition) {
            return this._guard((TriggeredTransition)tt, trigger, ac);
        }
        if (tt != null) {
            return this._guard(tt, trigger, ac);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(tt, trigger, ac).toString());
    }
}

