/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.markers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.graphiti.tb.IDecorator;
import org.eclipse.graphiti.tb.ImageDecorator;

public class DecoratorUtil {
    private DecoratorUtil() {
    }

    public static ArrayList<IDecorator> getMarkersFromDiagnostics(ArrayList<Diagnostic> diagnostics) {
        ImageDecorator decorator;
        if (diagnostics == null) {
            return new ArrayList<IDecorator>();
        }
        HashMap<Integer, Set<String>> severityMessageMap = new HashMap<Integer, Set<String>>();
        for (Diagnostic diagnostic : diagnostics) {
            switch (diagnostic.getSeverity()) {
                case 4: {
                    DecoratorUtil.addMessage(severityMessageMap, 4, diagnostic.getMessage());
                    break;
                }
                case 2: {
                    DecoratorUtil.addMessage(severityMessageMap, 2, diagnostic.getMessage());
                    break;
                }
                case 1: {
                    DecoratorUtil.addMessage(severityMessageMap, 1, diagnostic.getMessage());
                }
            }
        }
        ArrayList<IDecorator> decorators = new ArrayList<IDecorator>();
        if (severityMessageMap.containsKey(4)) {
            decorator = new ImageDecorator("org.eclipse.graphiti.eclipse.error.tsk");
            decorator.setMessage(DecoratorUtil.convertSetToString(severityMessageMap.get(4)));
            decorators.add((IDecorator)decorator);
        }
        if (severityMessageMap.containsKey(2)) {
            decorator = new ImageDecorator("org.eclipse.graphiti.eclipse.warning.tsk");
            decorator.setMessage(DecoratorUtil.convertSetToString(severityMessageMap.get(2)));
            decorators.add((IDecorator)decorator);
        }
        if (severityMessageMap.containsKey(1)) {
            decorator = new ImageDecorator("org.eclipse.graphiti.eclipse.information.tsk");
            decorator.setMessage(DecoratorUtil.convertSetToString(severityMessageMap.get(1)));
            decorators.add((IDecorator)decorator);
        }
        return decorators;
    }

    private static void addMessage(HashMap<Integer, Set<String>> map, int key, String message) {
        if (!map.containsKey(key)) {
            map.put(key, new HashSet());
        }
        map.get(key).add(message);
    }

    private static String convertSetToString(Set<String> stringSet) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringSet) {
            stringBuilder.append("- ").append(string).append("\n");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        if (stringSet.size() == 1) {
            return stringBuilder.substring(2);
        }
        return stringBuilder.toString();
    }
}

