/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.support;

import java.util.ArrayList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.naming.RoomNameProvider;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ChoicePoint;
import org.eclipse.etrice.core.room.RoomFactory;
import org.eclipse.etrice.core.room.StateGraph;
import org.eclipse.etrice.core.room.StateGraphItem;
import org.eclipse.etrice.ui.behavior.dialogs.ChoicePointPropertyDialog;
import org.eclipse.etrice.ui.behavior.editor.BehaviorEditor;
import org.eclipse.etrice.ui.behavior.markers.DecoratorUtil;
import org.eclipse.etrice.ui.behavior.support.SupportUtil;
import org.eclipse.etrice.ui.common.support.ChangeAwareCreateFeature;
import org.eclipse.etrice.ui.common.support.ChangeAwareCustomFeature;
import org.eclipse.etrice.ui.common.support.CommonSupportUtil;
import org.eclipse.etrice.ui.common.support.DeleteWithoutConfirmFeature;
import org.eclipse.etrice.ui.common.support.NoResizeFeature;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.ICreateFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IAreaContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.IDeleteContext;
import org.eclipse.graphiti.features.context.IDoubleClickContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IRemoveContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.CreateConnectionContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.features.impl.AbstractUpdateFeature;
import org.eclipse.graphiti.features.impl.DefaultMoveShapeFeature;
import org.eclipse.graphiti.features.impl.DefaultRemoveFeature;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Ellipse;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ChopboxAnchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeCreateService;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.tb.DefaultToolBehaviorProvider;
import org.eclipse.graphiti.tb.IContextButtonPadData;
import org.eclipse.graphiti.tb.IDecorator;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.tb.ImageDecorator;
import org.eclipse.graphiti.ui.features.DefaultFeatureProvider;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ChoicePointSupport {
    public static final int ITEM_SIZE = 25;
    protected static final int LINE_WIDTH = 2;
    protected static final IColorConstant DARK_COLOR = new ColorConstant(0, 0, 0);
    protected static final IColorConstant INHERITED_COLOR = new ColorConstant(100, 100, 100);
    protected static final IColorConstant BRIGHT_COLOR = new ColorConstant(255, 255, 255);
    protected static final String PROP_KIND = "item-kind";
    private FeatureProvider pfp;
    private BehaviorProvider tbp;

    public ChoicePointSupport(IDiagramTypeProvider dtp, IFeatureProvider fp) {
        this.pfp = new FeatureProvider(dtp, fp);
        this.tbp = new BehaviorProvider(dtp);
    }

    public IFeatureProvider getFeatureProvider() {
        return this.pfp;
    }

    public IToolBehaviorProvider getToolBehaviorProvider() {
        return this.tbp;
    }

    private class BehaviorProvider
    extends DefaultToolBehaviorProvider {
        public BehaviorProvider(IDiagramTypeProvider dtp) {
            super(dtp);
        }

        public GraphicsAlgorithm[] getClickArea(PictogramElement pe) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            return new GraphicsAlgorithm[]{rectangle};
        }

        public GraphicsAlgorithm getSelectionBorder(PictogramElement pe) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            return rectangle;
        }

        public ICustomFeature getDoubleClickFeature(IDoubleClickContext context) {
            return new FeatureProvider.PropertyFeature(this.getDiagramTypeProvider().getFeatureProvider());
        }

        public Object getToolTip(GraphicsAlgorithm ga) {
            PictogramElement pe = ga.getPictogramElement();
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
            if (bo instanceof ChoicePoint) {
                return ((ChoicePoint)bo).getName();
            }
            return super.getToolTip(ga);
        }

        public IContextButtonPadData getContextButtonPad(IPictogramElementContext context) {
            ICreateConnectionFeature[] features;
            IContextButtonPadData data = super.getContextButtonPad(context);
            PictogramElement pe = context.getPictogramElement();
            CreateConnectionContext ccc = new CreateConnectionContext();
            ccc.setSourcePictogramElement(pe);
            Anchor anchor = null;
            if (pe instanceof AnchorContainer) {
                anchor = (Anchor)((ContainerShape)pe).getAnchors().get(0);
            }
            ccc.setSourceAnchor(anchor);
            ContextButtonEntry button = new ContextButtonEntry(null, (IContext)context);
            button.setText("Create Transition");
            button.setIconId("org.eclipse.etrice.ui.behavior.transition");
            ICreateConnectionFeature[] iCreateConnectionFeatureArray = features = this.getFeatureProvider().getCreateConnectionFeatures();
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                ICreateConnectionFeature feature = iCreateConnectionFeatureArray[n2];
                if (feature.isAvailable((IContext)ccc) && feature.canStartConnection((ICreateConnectionContext)ccc)) {
                    button.addDragAndDropFeature((IFeature)feature);
                }
                ++n2;
            }
            if (button.getDragAndDropFeatures().size() > 0) {
                data.getDomainSpecificContextButtons().add(button);
            }
            return data;
        }

        public IDecorator[] getDecorators(PictogramElement pe) {
            GraphicsAlgorithm invisible = pe.getGraphicsAlgorithm();
            GraphicsAlgorithm rectangle = (GraphicsAlgorithm)invisible.getGraphicsAlgorithmChildren().get(0);
            int xOrigin = rectangle.getX();
            int yOrigin = rectangle.getY();
            int xGap = 10;
            int yGap = 0;
            EObject bo = Graphiti.getLinkService().getBusinessObjectForLinkedPictogramElement(pe);
            ArrayList<Diagnostic> diagnostics = ((BehaviorEditor)this.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer()).getDiagnosingModelObserver().getElementDiagonsticMap().get(bo);
            ArrayList<IDecorator> decorators = DecoratorUtil.getMarkersFromDiagnostics(diagnostics);
            if (decorators.isEmpty()) {
                return super.getDecorators(pe);
            }
            int i = 0;
            for (IDecorator decorator : decorators) {
                ((ImageDecorator)decorator).setX(xOrigin + xGap * i);
                ((ImageDecorator)decorator).setY(yOrigin + yGap * i);
                ++i;
            }
            return decorators.toArray(new IDecorator[decorators.size()]);
        }
    }

    private static class FeatureProvider
    extends DefaultFeatureProvider {
        protected IFeatureProvider fp;

        protected FeatureProvider(IDiagramTypeProvider dtp, IFeatureProvider fp) {
            super(dtp);
            this.fp = fp;
        }

        public ICreateFeature[] getCreateFeatures() {
            return new ICreateFeature[]{new CreateFeature(this.fp, "Choice Point", "Create Choice Point")};
        }

        public IAddFeature getAddFeature(IAddContext context) {
            return new AddFeature(this.fp);
        }

        public IMoveShapeFeature getMoveShapeFeature(IMoveShapeContext context) {
            return new MoveShapeFeature(this.fp);
        }

        public IResizeShapeFeature getResizeShapeFeature(IResizeShapeContext context) {
            return new NoResizeFeature(this.fp);
        }

        public ICustomFeature[] getCustomFeatures(ICustomContext context) {
            return new ICustomFeature[]{new PropertyFeature(this.fp)};
        }

        public IUpdateFeature getUpdateFeature(IUpdateContext context) {
            return new UpdateFeature(this.fp);
        }

        public IRemoveFeature getRemoveFeature(IRemoveContext context) {
            return new RemoveFeature(this.fp);
        }

        public IDeleteFeature getDeleteFeature(IDeleteContext context) {
            return new DeleteFeature(this.fp);
        }

        protected static void createFigure(ChoicePoint cp, ContainerShape containerShape, GraphicsAlgorithm invisibleRectangle, Color darkColor, Color brightColor) {
            IGaService gaService = Graphiti.getGaService();
            Ellipse circle = gaService.createEllipse((GraphicsAlgorithmContainer)invisibleRectangle);
            circle.setForeground(darkColor);
            circle.setBackground(brightColor);
            circle.setLineWidth(Integer.valueOf(2));
            int s2 = 12;
            gaService.setLocationAndSize((GraphicsAlgorithm)circle, s2, s2, 25, 25);
            if (containerShape.getAnchors().isEmpty()) {
                IPeCreateService peCreateService = Graphiti.getPeCreateService();
                ChopboxAnchor anchor = peCreateService.createChopboxAnchor((AnchorContainer)containerShape);
                anchor.setReferencedGraphicsAlgorithm((GraphicsAlgorithm)circle);
            }
        }

        private static void updateFigure(ChoicePoint cp, PictogramElement pe, Color dark, Color bright) {
            ContainerShape container = (ContainerShape)pe;
            GraphicsAlgorithm borderRect = pe.getGraphicsAlgorithm();
            while (!borderRect.getGraphicsAlgorithmChildren().isEmpty()) {
                EcoreUtil.delete((EObject)((EObject)borderRect.getGraphicsAlgorithmChildren().get(0)), (boolean)true);
            }
            FeatureProvider.createFigure(cp, container, borderRect, dark, bright);
        }

        private class AddFeature
        extends AbstractAddFeature {
            public AddFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canAdd(IAddContext context) {
                EObject obj;
                return context.getNewObject() instanceof ChoicePoint && context.getTargetContainer().getLink().getBusinessObjects().size() == 1 && (obj = (EObject)context.getTargetContainer().getLink().getBusinessObjects().get(0)) instanceof StateGraph;
            }

            public PictogramElement add(IAddContext context) {
                ChoicePoint cp = (ChoicePoint)context.getNewObject();
                ContainerShape sgShape = context.getTargetContainer();
                boolean inherited = SupportUtil.isInherited((StateGraphItem)cp, sgShape);
                IPeCreateService peCreateService = Graphiti.getPeCreateService();
                ContainerShape containerShape = peCreateService.createContainerShape(sgShape, true);
                Graphiti.getPeService().setPropertyValue((PropertyContainer)containerShape, "obj-type", "trp");
                int x = context.getX() - 25;
                int y = context.getY() - 25;
                if (context.getWidth() > 0) {
                    x += context.getWidth() / 2;
                }
                if (context.getHeight() > 0) {
                    y += context.getHeight() / 2;
                }
                Color dark = this.manageColor(inherited ? INHERITED_COLOR : DARK_COLOR);
                IGaService gaService = Graphiti.getGaService();
                Rectangle invisibleRectangle = gaService.createInvisibleRectangle((PictogramElement)containerShape);
                gaService.setLocationAndSize((GraphicsAlgorithm)invisibleRectangle, x, y, 50, 50);
                FeatureProvider.createFigure(cp, containerShape, (GraphicsAlgorithm)invisibleRectangle, dark, this.manageColor(BRIGHT_COLOR));
                this.link((PictogramElement)containerShape, cp);
                Shape labelShape = peCreateService.createShape(containerShape, false);
                Text label = gaService.createDefaultText(this.getDiagram(), (GraphicsAlgorithmContainer)labelShape, "C");
                label.setForeground(dark);
                label.setBackground(dark);
                label.setHorizontalAlignment(Orientation.ALIGNMENT_CENTER);
                label.setVerticalAlignment(Orientation.ALIGNMENT_CENTER);
                gaService.setLocationAndSize((GraphicsAlgorithm)label, 0, 12, 50, 25);
                this.layoutPictogramElement((PictogramElement)containerShape);
                return containerShape;
            }
        }

        private static class CreateFeature
        extends ChangeAwareCreateFeature {
            public CreateFeature(IFeatureProvider fp, String name, String description) {
                super(fp, name, description);
            }

            public String getCreateImageId() {
                return "org.eclipse.etrice.ui.behavior.cp";
            }

            public Object[] doCreate(ICreateContext context) {
                ContainerShape targetContainer = context.getTargetContainer();
                StateGraph sg = (StateGraph)targetContainer.getLink().getBusinessObjects().get(0);
                ActorClass ac = SupportUtil.getActorClass(this.getDiagram());
                boolean inherited = SupportUtil.isInherited(this.getDiagram(), (EObject)sg);
                if (inherited) {
                    sg = SupportUtil.insertRefinedState(sg, ac, targetContainer, this.getFeatureProvider());
                }
                ChoicePoint cp = RoomFactory.eINSTANCE.createChoicePoint();
                cp.setName(RoomNameProvider.getUniqueChoicePointName((StateGraph)sg));
                sg.getChPoints().add((Object)cp);
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ChoicePointPropertyDialog dlg = new ChoicePointPropertyDialog(shell, cp);
                if (dlg.open() == 0) {
                    this.addGraphicalRepresentation((IAreaContext)context, cp);
                    return new Object[]{cp};
                }
                return null;
            }

            public boolean canCreate(ICreateContext context) {
                EObject obj;
                return context.getTargetContainer().getLink() != null && context.getTargetContainer().getLink().getBusinessObjects().size() == 1 && (obj = (EObject)context.getTargetContainer().getLink().getBusinessObjects().get(0)) instanceof StateGraph;
            }
        }

        protected static class DeleteFeature
        extends DeleteWithoutConfirmFeature {
            public DeleteFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canDelete(IDeleteContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof ChoicePoint) {
                    ChoicePoint cp = (ChoicePoint)bo;
                    return !SupportUtil.isInherited(this.getDiagram(), (EObject)cp);
                }
                return false;
            }

            public void preDelete(IDeleteContext context) {
                super.preDelete(context);
                ContainerShape container = (ContainerShape)context.getPictogramElement();
                CommonSupportUtil.deleteConnectionsRecursive((ContainerShape)container, (IFeatureProvider)this.getFeatureProvider());
            }
        }

        protected class MoveShapeFeature
        extends DefaultMoveShapeFeature {
            public MoveShapeFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canMoveShape(IMoveShapeContext context) {
                boolean canMove = super.canMoveShape(context);
                if (canMove) {
                    Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                    if (bo instanceof ChoicePoint) {
                        ChoicePoint cp = (ChoicePoint)bo;
                        ContainerShape acShape = context.getTargetContainer();
                        return !SupportUtil.isInherited((StateGraphItem)cp, acShape);
                    }
                    return false;
                }
                return canMove;
            }
        }

        private static class PropertyFeature
        extends ChangeAwareCustomFeature {
            private String name = "Edit Choice Point";
            private String description = "Edit Choice Point";

            public PropertyFeature(IFeatureProvider fp) {
                super(fp);
            }

            public String getName() {
                return this.name;
            }

            public String getDescription() {
                return this.description;
            }

            public boolean canExecute(ICustomContext context) {
                Object bo;
                PictogramElement[] pes = context.getPictogramElements();
                if (pes != null && pes.length == 1 && pes[0] instanceof ContainerShape && (bo = this.getBusinessObjectForPictogramElement(pes[0])) instanceof ChoicePoint) {
                    return !SupportUtil.isInherited(this.getDiagram(), (EObject)((ChoicePoint)bo));
                }
                return false;
            }

            public boolean doExecute(ICustomContext context) {
                PictogramElement pe = context.getPictogramElements()[0];
                ChoicePoint cp = (ChoicePoint)this.getBusinessObjectForPictogramElement(pe);
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ChoicePointPropertyDialog dlg = new ChoicePointPropertyDialog(shell, cp);
                if (dlg.open() == 0) {
                    FeatureProvider.updateFigure(cp, pe, this.manageColor(DARK_COLOR), this.manageColor(BRIGHT_COLOR));
                    return true;
                }
                return false;
            }
        }

        protected static class RemoveFeature
        extends DefaultRemoveFeature {
            public RemoveFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canRemove(IRemoveContext context) {
                return false;
            }
        }

        private class UpdateFeature
        extends AbstractUpdateFeature {
            public UpdateFeature(IFeatureProvider fp) {
                super(fp);
            }

            public boolean canUpdate(IUpdateContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    return true;
                }
                return bo instanceof ChoicePoint;
            }

            public IReason updateNeeded(IUpdateContext context) {
                Object bo = this.getBusinessObjectForPictogramElement(context.getPictogramElement());
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    return Reason.createTrueReason((String)"ChoicePoint deleted from model");
                }
                return Reason.createFalseReason();
            }

            public boolean update(IUpdateContext context) {
                ContainerShape containerShape = (ContainerShape)context.getPictogramElement();
                Object bo = this.getBusinessObjectForPictogramElement((PictogramElement)containerShape);
                if (bo instanceof EObject && ((EObject)bo).eIsProxy()) {
                    RemoveContext rc = new RemoveContext((PictogramElement)containerShape);
                    IFeatureProvider featureProvider = this.getFeatureProvider();
                    IRemoveFeature removeFeature = featureProvider.getRemoveFeature((IRemoveContext)rc);
                    if (removeFeature != null) {
                        removeFeature.remove((IRemoveContext)rc);
                    }
                    EcoreUtil.delete((EObject)((EObject)bo));
                    return true;
                }
                ChoicePoint cp = (ChoicePoint)bo;
                boolean inherited = SupportUtil.isInherited((StateGraphItem)cp, (ContainerShape)containerShape.eContainer());
                Color dark = this.manageColor(inherited ? INHERITED_COLOR : DARK_COLOR);
                FeatureProvider.updateFigure(cp, (PictogramElement)containerShape, dark, this.manageColor(BRIGHT_COLOR));
                return true;
            }
        }
    }
}

