/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.common.editor;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.ui.RoomUiModule;
import org.eclipse.etrice.core.ui.editor.RoomEditor;
import org.eclipse.etrice.ui.common.Activator;
import org.eclipse.etrice.ui.common.commands.ChangeDiagramInputJob;
import org.eclipse.etrice.ui.common.editor.CustomDiagramBehavior;
import org.eclipse.etrice.ui.common.editor.IInputUriHolder;
import org.eclipse.etrice.ui.common.editor.ModificationTrackingEnabler;
import org.eclipse.etrice.ui.common.editor.SaveOnFocusLostListener;
import org.eclipse.etrice.ui.common.editor.SuperClassListener;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.graphiti.ui.editor.EditorInputAdapter;
import org.eclipse.graphiti.ui.editor.IDiagramContainerUI;
import org.eclipse.graphiti.ui.editor.IDiagramEditorInput;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public abstract class RoomDiagramEditor
extends DiagramEditor
implements IInputUriHolder {
    @Inject
    protected IResourceValidator resourceValidator;
    private SaveOnFocusLostListener partListener;
    private SuperClassListener superClassListener;
    private ModificationTrackingEnabler mte = new ModificationTrackingEnabler();
    private boolean showLostDiagramInputDialog = true;
    private URI inputUri;

    public RoomDiagramEditor() {
        Injector injector = RoomUiModule.getInjector();
        injector.injectMembers((Object)this);
        TrayDialog.setDialogHelpAvailable((boolean)false);
    }

    protected DiagramBehavior createDiagramBehavior() {
        return new CustomDiagramBehavior((IDiagramContainerUI)this);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        DiagramEditorInput newInput = EditorInputAdapter.adaptToDiagramEditorInput((IEditorInput)input);
        if (newInput instanceof IDiagramEditorInput) {
            this.inputUri = ((IDiagramEditorInput)newInput).getUri();
        }
        super.init(site, input);
    }

    public void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        ResourceSet resourceSet = this.getEditingDomain().getResourceSet();
        Map result = EcoreUtil.UnresolvedProxyCrossReferencer.find((ResourceSet)resourceSet);
        if (!result.isEmpty()) {
            System.err.println("ERROR in diagram viewer: could not resolve all proxies!");
        }
        this.mte.setTarget(this.getEditingDomain());
    }

    public void dispose() {
        this.mte.unsetTarget(this.getEditingDomain());
        this.getSite().getPage().removePartListener((IPartListener)this.partListener);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().removePartListener((IPartListener)this.superClassListener);
        this.superClassListener.dispose();
        super.dispose();
    }

    public void doSave(final IProgressMonitor monitor) {
        ResourceSet rs = this.getEditingDomain().getResourceSet();
        for (Resource res : rs.getResources()) {
            if (!(res instanceof XtextResource)) continue;
            if (!res.isLoaded()) {
                try {
                    res.load(Collections.EMPTY_MAP);
                }
                catch (IOException e) {
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"ERROR", (String)("Internal error: couldn't load referenced resource " + res.getURI()));
                    return;
                }
            }
            if (!res.isModified()) continue;
            XtextResource xres = (XtextResource)res;
            ISerializer serializer = xres.getSerializer();
            if (xres.getContents().isEmpty()) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"ERROR", (String)"Internal error: part of textual model is empty, can't save");
                return;
            }
            serializer.serialize((EObject)xres.getContents().get(0));
            List result = this.resourceValidator.validate(res, CheckMode.NORMAL_AND_FAST, new CancelIndicator(){

                public boolean isCanceled() {
                    return monitor.isCanceled();
                }
            });
            if (result.isEmpty()) continue;
            boolean error = false;
            MultiStatus ms = new MultiStatus("org.eclipse.etrice.ui.common", 4, "validation errors during diagram save", null);
            for (Issue issue : result) {
                if (!issue.isSyntaxError() && issue.getSeverity() != Severity.ERROR) continue;
                ms.add((IStatus)new Status(4, "org.eclipse.etrice.ui.common", issue.getMessage()));
                error = true;
            }
            if (!error) continue;
            MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"ERROR", (String)"Internal error: model is invalid, can't save");
            Activator.getDefault().getLog().log((IStatus)ms);
            return;
        }
        super.doSave(monitor);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.partListener = new SaveOnFocusLostListener(this);
        this.getSite().getPage().addPartListener((IPartListener)this.partListener);
        this.superClassListener = new SuperClassListener(this);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().addPartListener((IPartListener)this.superClassListener);
        this.doSave((IProgressMonitor)new NullProgressMonitor());
    }

    public void setFocus() {
        Diagram diagram;
        EObject diagramBo;
        boolean dirtyAlready = this.isDirty();
        super.setFocus();
        if (this.superClassListener.isChangeInSuperClass()) {
            this.superClassChanged();
        }
        if (!dirtyAlready && this.isDirty()) {
            this.doSave(null);
        }
        if ((diagramBo = (EObject)(diagram = this.getDiagramTypeProvider().getDiagram()).getLink().getBusinessObjects().iterator().next()) == null || diagramBo.eIsProxy()) {
            this.handleMissingDiagramBo(diagram);
        }
    }

    protected void handleMissingDiagramBo(Diagram diagram) {
        if (!this.showLostDiagramInputDialog) {
            return;
        }
        this.showLostDiagramInputDialog = false;
        MessageDialog dialog = new MessageDialog(this.getGraphicalControl().getShell(), "Diagram out-dated", null, "Diagram input lost. Cannot find ROOM file or class for " + diagram.getName() + "\n\n" + "Please ensure that no whitespace or special characters are contained in any related path, file or project", 1, new String[]{"OK", "Reconnect Diagram"}, 0);
        int result = dialog.open();
        if (result == 1) {
            new ChangeDiagramInputJob("Change input for " + diagram.getName(), this).schedule();
        }
    }

    protected boolean registerSuperClassListener(RoomDiagramEditor editor) {
        if (!this.getClass().equals(editor.getClass()) || !(this.getStructureClass() instanceof ActorClass)) {
            return false;
        }
        StructureClass editorSc = editor.getStructureClass();
        if (editorSc instanceof ActorClass) {
            URI editorResURI = this.toCurrentPlatformURI(editorSc.eResource().getURI());
            ActorClass base = (ActorClass)this.getStructureClass();
            while ((base = base.getBase()) != null) {
                URI baseResURI = this.toCurrentPlatformURI(base.eResource().getURI());
                if (!editorResURI.equals(baseResURI) || !editorSc.getName().equals(base.getName())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean registerSuperClassListener(RoomEditor editor) {
        if (!(this.getStructureClass() instanceof ActorClass)) {
            return false;
        }
        return (Boolean)editor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork<Boolean, XtextResource>(){

            public Boolean exec(XtextResource resource) throws Exception {
                URI editorResURI = RoomDiagramEditor.this.toCurrentPlatformURI(resource.getURI());
                URI thisScResURI = RoomDiagramEditor.this.toCurrentPlatformURI(RoomDiagramEditor.this.getStructureClass().eResource().getURI());
                if (thisScResURI.equals(editorResURI)) {
                    return false;
                }
                ActorClass base = (ActorClass)RoomDiagramEditor.this.getStructureClass();
                while ((base = base.getBase()) != null) {
                    URI baseResURI = RoomDiagramEditor.this.toCurrentPlatformURI(base.eResource().getURI());
                    if (!editorResURI.equals(baseResURI)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    private URI toCurrentPlatformURI(URI uri) {
        if (uri.isPlatform()) {
            return uri;
        }
        if (uri.isFile()) {
            IPath rootPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
            String rootString = rootPath.toFile().toString();
            String fileString = uri.toFileString();
            if (fileString.startsWith(rootString)) {
                return URI.createPlatformResourceURI((String)fileString.replace(rootString, ""), (boolean)false);
            }
        }
        return null;
    }

    protected abstract void superClassChanged();

    protected abstract StructureClass getStructureClass();

    @Override
    public URI getInputUri() {
        return this.inputUri;
    }
}

