/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.common.quickfix;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.etrice.ui.common.quickfix.IssueResolution;
import org.eclipse.etrice.ui.common.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.validation.FeatureBasedDiagnostic;

public abstract class AbstractQuickfixProvider {
    protected Predicate<Method> getFixMethodPredicate(final String issueCode) {
        return new Predicate<Method>(){

            public boolean apply(Method input) {
                Fix annotation = input.getAnnotation(Fix.class);
                boolean result = annotation != null && issueCode.equals(annotation.value()) && input.getParameterTypes().length == 2 && Void.TYPE == input.getReturnType() && input.getParameterTypes()[0].isAssignableFrom(FeatureBasedDiagnostic.class) && input.getParameterTypes()[1].isAssignableFrom(IssueResolutionAcceptor.class);
                return result;
            }
        };
    }

    protected List<IssueResolution> getResolutions(FeatureBasedDiagnostic issue, List<Method> fixMethods) {
        IssueResolutionAcceptor issueResolutionAcceptor = new IssueResolutionAcceptor();
        for (Method fixMethod : fixMethods) {
            try {
                fixMethod.setAccessible(true);
                fixMethod.invoke((Object)this, issue, issueResolutionAcceptor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return issueResolutionAcceptor.getIssueResolutions();
    }

    protected Iterable<Method> collectMethods(Class<? extends AbstractQuickfixProvider> clazz, String issueCode) {
        ArrayList methods = Lists.newArrayList((Object[])clazz.getMethods());
        return Iterables.filter((Iterable)methods, this.getFixMethodPredicate(issueCode));
    }

    protected List<Method> getFixMethods(FeatureBasedDiagnostic issue) {
        return Lists.newArrayList(this.collectMethods(this.getClass(), issue.getIssueCode()));
    }

    public boolean hasResolutionFor(String issueCode) {
        if (issueCode == null) {
            return false;
        }
        Iterable<Method> methods = this.collectMethods(this.getClass(), issueCode);
        return methods.iterator().hasNext();
    }

    public List<IssueResolution> getResolutions(FeatureBasedDiagnostic issue) {
        List<Method> fixMethods = this.getFixMethods(issue);
        return this.getResolutions(issue, fixMethods);
    }
}

