/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.layout;

import de.cau.cs.kieler.core.kgraph.KGraphElement;
import de.cau.cs.kieler.core.kgraph.KNode;
import de.cau.cs.kieler.core.kgraph.KPort;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.etrice.core.room.State;
import org.eclipse.etrice.ui.layout.ETriceLayoutCommand;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.algorithms.styles.Orientation;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;

public class BehaviorLayoutCommand
extends ETriceLayoutCommand {
    public BehaviorLayoutCommand(TransactionalEditingDomain domain, IFeatureProvider thefeatureProvider) {
        super(domain, thefeatureProvider);
    }

    @Override
    protected void applyNodeLayout(KNode knode, PictogramElement pelem) {
        this.setCalculatedPositionAndSize((KGraphElement)knode, knode.getParent(), (ContainerShape)pelem);
        this.getFeatureProvider().layoutIfPossible((ILayoutContext)new LayoutContext(pelem));
    }

    @Override
    protected void applyPortLayout(KPort kport, PictogramElement pelem) {
        ContainerShape shape = (ContainerShape)((Anchor)pelem).getParent();
        this.setCalculatedPositionAndSize((KGraphElement)kport, kport.getNode(), shape);
        GraphicsAlgorithm ga = shape.getGraphicsAlgorithm();
        EObject bo = (EObject)shape.getContainer().getLink().getBusinessObjects().get(0);
        int margin = 40;
        int size = 20;
        if (bo instanceof State) {
            margin = 30;
            size = 11;
        }
        Text label = (Text)((Shape)shape.getChildren().get(0)).getGraphicsAlgorithm();
        BehaviorLayoutCommand.adjustLabel(label, ga.getX(), ga.getY(), ga.getWidth(), margin, size);
        this.getFeatureProvider().layoutIfPossible((ILayoutContext)new LayoutContext((PictogramElement)shape));
    }

    private static void adjustLabel(Text label, int x, int y, int width, int margin, int size) {
        Orientation halign = Orientation.ALIGNMENT_CENTER;
        Orientation valign = Orientation.ALIGNMENT_CENTER;
        int pos = 0;
        if (x <= margin) {
            halign = Orientation.ALIGNMENT_LEFT;
        } else if (width - margin <= x) {
            halign = Orientation.ALIGNMENT_RIGHT;
        }
        if (y <= margin) {
            pos = 0;
            valign = Orientation.ALIGNMENT_BOTTOM;
        } else {
            pos = 5 * margin / 4;
            valign = Orientation.ALIGNMENT_TOP;
        }
        label.setHorizontalAlignment(halign);
        label.setVerticalAlignment(valign);
        if (pos != label.getY()) {
            IGaService gaService = Graphiti.getGaService();
            gaService.setLocationAndSize((GraphicsAlgorithm)label, 0, pos, 2 * margin, 3 * margin / 4);
        }
    }
}

