/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.layout.preferences;

import de.cau.cs.kieler.core.util.Pair;
import de.cau.cs.kieler.kiml.LayoutDataService;
import de.cau.cs.kieler.kiml.LayoutOptionData;
import de.cau.cs.kieler.kiml.ui.Messages;
import de.cau.cs.kieler.kiml.ui.service.EclipseLayoutInfoService;
import de.cau.cs.kieler.kiml.ui.views.LayoutViewPart;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.etrice.ui.layout.Activator;
import org.eclipse.etrice.ui.layout.preferences.ETriceDomainModelElement;
import org.eclipse.etrice.ui.layout.preferences.ETricePreferenceUtil;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ListDialog;

public class ETriceBehaviorPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer optionTableViewer;
    private List<ETricePreferenceUtil.OptionsTableProvider.DataEntry> optionEntries;

    public ETriceBehaviorPreferencePage() {
        this.setDescription("Preference Page for configuring layout options specific to eTrice Behavior diagrams");
    }

    protected Control createContents(Composite parent) {
        Group optionsGroup = this.createOptionsGroup(parent);
        optionsGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        return optionsGroup;
    }

    protected Group createOptionsGroup(Composite parent) {
        Group elementGroup = new Group(parent, 0);
        elementGroup.setText(Messages.getString((String)"kiml.ui.28"));
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        LayoutDataService dataService = LayoutDataService.getInstance();
        Collection layoutOptionData = dataService.getOptionData();
        this.optionEntries = new LinkedList<ETricePreferenceUtil.OptionsTableProvider.DataEntry>();
        Set elements = EclipseLayoutInfoService.getInstance().getRegisteredElements();
        for (String string : elements) {
            ETricePreferenceUtil.ElementType type;
            Class<?> elementClass = null;
            try {
                elementClass = Class.forName(string);
                try {
                    type = PictogramElement.class.isAssignableFrom(elementClass) ? ETricePreferenceUtil.ElementType.EDIT_PART : ETricePreferenceUtil.ElementType.MODEL_ELEM;
                }
                catch (NullPointerException e) {
                    type = ETricePreferenceUtil.ElementType.MODEL_ELEM;
                }
            }
            catch (ClassNotFoundException e) {
                type = ETricePreferenceUtil.ElementType.MODEL_ELEM;
            }
            int dotIndex = string.lastIndexOf(46);
            String partName = string.substring(dotIndex + 1);
            if (partName.endsWith("Impl")) {
                partName = partName.substring(0, partName.length() - "Impl".length());
            }
            for (LayoutOptionData data : layoutOptionData) {
                Object value;
                String preference = EclipseLayoutInfoService.getPreferenceName((String)string, (String)data.getId());
                if (!preferenceStore.contains(preference) || (value = data.parseValue(preferenceStore.getString(preference))) == null || type != ETricePreferenceUtil.ElementType.EDIT_PART && !ETriceDomainModelElement.isBehaviorModelElement(string)) continue;
                this.optionEntries.add(new ETricePreferenceUtil.OptionsTableProvider.DataEntry(partName, string, type, data, value));
            }
        }
        for (Pair pair : ETriceDomainModelElement.BEHAVIOR_DIAGRAM_TYPES) {
            for (LayoutOptionData data : layoutOptionData) {
                Object value;
                String preference = EclipseLayoutInfoService.getPreferenceName((String)((String)pair.getFirst()), (String)data.getId());
                if (!preferenceStore.contains(preference) || (value = data.parseValue(preferenceStore.getString(preference))) == null) continue;
                this.optionEntries.add(new ETricePreferenceUtil.OptionsTableProvider.DataEntry((String)pair.getSecond(), (String)pair.getFirst(), ETricePreferenceUtil.ElementType.DIAG_TYPE, data, value));
            }
        }
        this.addOptionTable((Composite)elementGroup, this.optionEntries);
        elementGroup.setLayout((Layout)new GridLayout(2, false));
        return elementGroup;
    }

    private void addOptionTable(final Composite parent, final List<ETricePreferenceUtil.OptionsTableProvider.DataEntry> entries) {
        final Table table = new Table(parent, 2048);
        final TableColumn column1 = new TableColumn(table, 0);
        column1.setText(Messages.getString((String)"kiml.ui.29"));
        final TableColumn column2 = new TableColumn(table, 0);
        column2.setText(Messages.getString((String)"kiml.ui.9"));
        final TableColumn column3 = new TableColumn(table, 0);
        column3.setText(Messages.getString((String)"kiml.ui.19"));
        final TableColumn column4 = new TableColumn(table, 0);
        column4.setText(Messages.getString((String)"kiml.ui.20"));
        table.setHeaderVisible(true);
        final TableViewer tableViewer = new TableViewer(table);
        ETricePreferenceUtil.OptionsTableProvider optionsTableProvider = new ETricePreferenceUtil.OptionsTableProvider();
        tableViewer.setContentProvider((IContentProvider)optionsTableProvider);
        tableViewer.setLabelProvider((IBaseLabelProvider)optionsTableProvider);
        tableViewer.setInput(entries);
        this.optionTableViewer = tableViewer;
        column1.pack();
        column2.pack();
        column3.pack();
        column4.pack();
        GridData tableLayoutData = new GridData(4, 4, true, true, 1, 1);
        table.setLayoutData((Object)tableLayoutData);
        table.pack();
        tableLayoutData.heightHint = 300;
        Composite composite = new Composite(parent, 0);
        Button newButton = new Button(composite, 0x1000008);
        newButton.setText(Messages.getString((String)"kiml.ui.41"));
        final Button editButton = new Button(composite, 0x1000008);
        editButton.setText(Messages.getString((String)"kiml.ui.21"));
        editButton.setEnabled(false);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ETricePreferenceUtil.OptionsTableProvider.DataEntry entry = ETricePreferenceUtil.getEntry(entries, table.getSelectionIndex());
                if (entry != null) {
                    ETricePreferenceUtil.showEditDialog(parent.getShell(), entry);
                    tableViewer.refresh();
                }
            }
        });
        final Button removeButton = new Button(composite, 0x1000008);
        removeButton.setText(Messages.getString((String)"kiml.ui.22"));
        removeButton.setEnabled(false);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ETricePreferenceUtil.OptionsTableProvider.DataEntry entry = ETricePreferenceUtil.getEntry(entries, table.getSelectionIndex());
                if (entry != null) {
                    entry.setValue(null);
                    tableViewer.refresh();
                    int count = 0;
                    for (ETricePreferenceUtil.OptionsTableProvider.DataEntry e : entries) {
                        if (e.getValue() == null) continue;
                        ++count;
                    }
                    if (count == 0) {
                        editButton.setEnabled(false);
                        removeButton.setEnabled(false);
                    }
                }
            }
        });
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!entries.isEmpty() && event.item != null) {
                    editButton.setEnabled(true);
                    removeButton.setEnabled(true);
                } else {
                    editButton.setEnabled(false);
                    removeButton.setEnabled(false);
                }
            }
        });
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int newIndex = ETriceBehaviorPreferencePage.this.showNewDialog(parent.getShell(), entries);
                if (newIndex >= 0) {
                    tableViewer.refresh();
                    tableViewer.setSelection((ISelection)new StructuredSelection(entries.get(newIndex)));
                    editButton.setEnabled(true);
                    removeButton.setEnabled(true);
                    column1.pack();
                    column2.pack();
                    column3.pack();
                    column4.pack();
                }
            }
        });
        composite.setLayout((Layout)new FillLayout(512));
        GridData compositeLayoutData = new GridData(16384, 128, false, false, 1, 1);
        composite.setLayoutData((Object)compositeLayoutData);
    }

    private int showNewDialog(Shell shell, List<ETricePreferenceUtil.OptionsTableProvider.DataEntry> entries) {
        ETricePreferenceUtil.NewOptionDialog dialog = new ETricePreferenceUtil.NewOptionDialog(shell){

            @Override
            protected String showBrowseModelElementDialog() {
                Object[] result;
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new LabelProvider(), (ITreeContentProvider)new TreeNodeContentProvider());
                dialog.setTitle("Select Behavior Model Element");
                TreeNode[] input = ETriceDomainModelElement.BEHAVIOR_MODEL.getChildren();
                dialog.setInput((Object)input);
                if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length > 0) {
                    return ((ETriceDomainModelElement)((Object)result[0])).getId();
                }
                return null;
            }

            @Override
            protected String showBrowseDiagtDialog() {
                Object[] result;
                ListDialog dialog = new ListDialog(this.getShell());
                dialog.setTitle(Messages.getString((String)"kiml.ui.57"));
                dialog.setContentProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                dialog.setLabelProvider((ILabelProvider)new LabelProvider());
                Object[] input = new ETricePreferenceUtil.NewOptionDialog.SelectionData[ETriceDomainModelElement.BEHAVIOR_DIAGRAM_TYPES.size()];
                int i = 0;
                for (Pair<String, String> type : ETriceDomainModelElement.BEHAVIOR_DIAGRAM_TYPES) {
                    ETricePreferenceUtil.NewOptionDialog.SelectionData seld = new ETricePreferenceUtil.NewOptionDialog.SelectionData(type);
                    input[i++] = seld;
                }
                Arrays.sort(input);
                dialog.setInput((Object)input);
                if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length > 0) {
                    return ((ETricePreferenceUtil.NewOptionDialog.SelectionData)result[0]).getId();
                }
                return null;
            }
        };
        if (dialog.open() == 0) {
            ETricePreferenceUtil.OptionsTableProvider.DataEntry newEntry = dialog.createDataEntry();
            if (newEntry == null) {
                MessageDialog.openError((Shell)shell, (String)Messages.getString((String)"kiml.ui.51"), (String)Messages.getString((String)"kiml.ui.52"));
            } else {
                int oldIndex = 0;
                ETricePreferenceUtil.OptionsTableProvider.DataEntry oldEntry = null;
                for (ETricePreferenceUtil.OptionsTableProvider.DataEntry e : entries) {
                    if (e.getValue() == null) continue;
                    if (e.equals(newEntry)) {
                        oldEntry = e;
                        break;
                    }
                    ++oldIndex;
                }
                if (oldEntry != null) {
                    return oldIndex;
                }
                entries.add(newEntry);
                return entries.size() - 1;
            }
        }
        return -1;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getSharedPreferenceStore());
    }

    protected void performDefaults() {
        super.performDefaults();
        for (ETricePreferenceUtil.OptionsTableProvider.DataEntry entry : this.optionEntries) {
            entry.setValue(null);
        }
        this.optionTableViewer.refresh();
    }

    public boolean performOk() {
        EclipseLayoutInfoService infoService = EclipseLayoutInfoService.getInstance();
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        for (ETricePreferenceUtil.OptionsTableProvider.DataEntry entry : this.optionEntries) {
            Object oldValue = infoService.getOptionValue(entry.getElementId(), entry.getOptionData().getId());
            Object newValue = entry.getValue();
            if ((oldValue != null || newValue == null) && oldValue.equals(newValue)) continue;
            String preference = EclipseLayoutInfoService.getPreferenceName((String)entry.getElementId(), (String)entry.getOptionData().getId());
            if (newValue == null) {
                infoService.removeOptionValue(entry.getElementId(), entry.getOptionData().getId());
                preferenceStore.setToDefault(preference);
                infoService.getRegisteredElements().remove(entry.getElementId());
                continue;
            }
            infoService.addOptionValue(entry.getElementId(), entry.getOptionData().getId(), newValue);
            preferenceStore.setValue(preference, newValue.toString());
            if (entry.getType() == ETricePreferenceUtil.ElementType.DIAG_TYPE) continue;
            infoService.getRegisteredElements().add(entry.getElementId());
        }
        LayoutViewPart layoutView = LayoutViewPart.findView();
        if (layoutView != null) {
            layoutView.refresh();
        }
        return true;
    }
}

