/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.structure.dialogs;

import java.util.List;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubProtocol;
import org.eclipse.etrice.core.room.util.CompoundProtocolHelpers;
import org.eclipse.etrice.ui.structure.Activator;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.FormDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.Form;

public class SubProtocolSelectionDialog
extends FormDialog {
    private Port src;
    private Port dst;
    private TableViewer viewer;
    private List<CompoundProtocolHelpers.Match> matches;
    private CompoundProtocolHelpers.Match selected;

    public SubProtocolSelectionDialog(Shell shell, Port src, ActorContainerRef srcRef, Port dst, ActorContainerRef dstRef, Binding bind, StructureClass sc) {
        super(shell);
        this.src = src;
        this.dst = dst;
        this.matches = CompoundProtocolHelpers.getMatches((Port)src, (ActorContainerRef)srcRef, (Port)dst, (ActorContainerRef)dstRef, (StructureClass)sc, (Binding)bind);
        if (bind != null) {
            for (CompoundProtocolHelpers.Match match : this.matches) {
                if (match.getLeft() != bind.getEndpoint1().getSub() || match.getRight() != bind.getEndpoint2().getSub()) continue;
                this.selected = match;
            }
        } else {
            this.selected = this.matches.get(0);
        }
    }

    protected void createFormContent(IManagedForm mform) {
        super.createFormContent(mform);
        Form form = mform.getForm().getForm();
        form.setText("Connect SubProtocol(s)");
        mform.getToolkit().decorateFormHeading(form);
        form.setImage(Activator.getImage("icons/Structure.gif"));
        Composite body = form.getBody();
        Table matchTable = mform.getToolkit().createTable(body, 65540);
        this.viewer = new TableViewer(matchTable);
        TableColumn col0 = new TableColumn(this.viewer.getTable(), 0);
        col0.setText("Port " + this.src.getName());
        TableColumn col1 = new TableColumn(this.viewer.getTable(), 0);
        col1.setText("Port " + this.dst.getName());
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)new MatchContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MatchLabelProvider());
        this.viewer.setInput(this.matches);
        TableColumnLayout layout = new TableColumnLayout();
        body.setLayout((Layout)layout);
        layout.setColumnData((Widget)col0, (ColumnLayoutData)new ColumnWeightData(50));
        layout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(50));
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.selected));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Button ok = SubProtocolSelectionDialog.this.getButton(0);
                if (ok != null) {
                    if (event.getSelection() instanceof IStructuredSelection) {
                        Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                        ok.setEnabled(element instanceof CompoundProtocolHelpers.Match);
                    } else {
                        ok.setEnabled(false);
                    }
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SubProtocolSelectionDialog.this.okPressed();
            }
        });
    }

    protected void okPressed() {
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.selected = (CompoundProtocolHelpers.Match)((IStructuredSelection)selection).getFirstElement();
        }
        super.okPressed();
    }

    public CompoundProtocolHelpers.Match getSelected() {
        return this.selected;
    }

    private class MatchContentProvider
    implements IStructuredContentProvider {
        private MatchContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return SubProtocolSelectionDialog.this.matches.toArray();
        }
    }

    private class MatchLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private MatchLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof CompoundProtocolHelpers.Match) {
                SubProtocol sub;
                SubProtocol subProtocol = sub = columnIndex == 0 ? ((CompoundProtocolHelpers.Match)element).getLeft() : ((CompoundProtocolHelpers.Match)element).getRight();
                if (sub == null) {
                    return "-/" + (columnIndex == 0 ? SubProtocolSelectionDialog.this.src.getProtocol().getName() : SubProtocolSelectionDialog.this.dst.getProtocol().getName());
                }
                return String.valueOf(sub.getName()) + "/" + sub.getProtocol().getName();
            }
            return null;
        }
    }
}

