/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.contentassist;

import com.google.common.base.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.ui.contentassist.AbstractRoomProposalProvider;
import org.eclipse.etrice.core.ui.contentassist.IProposalFilter;
import org.eclipse.etrice.core.validation.ValidationUtil;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;

public class RoomProposalProvider
extends AbstractRoomProposalProvider {
    protected Function<IEObjectDescription, ICompletionProposal> getProposalFactory(String ruleName, ContentAssistContext contentAssistContext) {
        if (contentAssistContext != null && contentAssistContext.getCurrentModel().eClass() == RoomPackage.eINSTANCE.getActorRef()) {
            return new FilteredProposalCreator(new ActorRefFilter(), contentAssistContext, ruleName);
        }
        return super.getProposalFactory(ruleName, contentAssistContext);
    }

    protected class ActorRefFilter
    implements IProposalFilter {
        protected ActorRefFilter() {
        }

        @Override
        public boolean accept(ContentAssistContext context, IEObjectDescription candidate) {
            if (!(context.getCurrentModel() instanceof ActorRef)) {
                return false;
            }
            ActorRef ar = (ActorRef)context.getCurrentModel();
            if (!(ar.eContainer() instanceof ActorClass)) {
                return true;
            }
            ActorClass ac = (ActorClass)ar.eContainer();
            EObject objectOrProxy = candidate.getEObjectOrProxy();
            if (objectOrProxy instanceof ActorClass) {
                ActorClass referenced = (ActorClass)objectOrProxy;
                return !ValidationUtil.isReferencing((ActorClass)referenced, (ActorClass)ac);
            }
            return false;
        }
    }

    protected class FilteredProposalCreator
    implements Function<IEObjectDescription, ICompletionProposal> {
        private IProposalFilter filter;
        private final ContentAssistContext contentAssistContext;
        private final String ruleName;

        protected FilteredProposalCreator(IProposalFilter filter, ContentAssistContext contentAssistContext, String ruleName) {
            this.filter = filter;
            this.contentAssistContext = contentAssistContext;
            this.ruleName = ruleName;
        }

        public ICompletionProposal apply(IEObjectDescription candidate) {
            EObject objectOrProxy;
            if (candidate == null) {
                return null;
            }
            ICompletionProposal result = null;
            String proposal = candidate.getName().toString();
            if (this.ruleName != null) {
                proposal = RoomProposalProvider.this.getValueConverter().toString((Object)proposal, this.ruleName);
            }
            if (!(objectOrProxy = candidate.getEObjectOrProxy()).eIsProxy() && this.filter != null && !this.filter.accept(this.contentAssistContext, candidate)) {
                return null;
            }
            StyledString displayString = RoomProposalProvider.this.getStyledDisplayString(objectOrProxy, candidate.getQualifiedName().toString(), candidate.getName().toString());
            Image image = RoomProposalProvider.this.getImage(objectOrProxy);
            result = RoomProposalProvider.this.createCompletionProposal(proposal, displayString, image, this.contentAssistContext);
            RoomProposalProvider.this.getPriorityHelper().adjustCrossReferencePriority(result, this.contentAssistContext.getPrefix());
            return result;
        }
    }
}

