/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.BaseState;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.FreeType;
import org.eclipse.etrice.core.room.Import;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RefinedState;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SAPRef;
import org.eclipse.etrice.core.room.SPPRef;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.SubSystemRef;
import org.eclipse.etrice.core.room.Type;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.xtext.ui.label.DefaultEObjectLabelProvider;
import org.eclipse.xtext.ui.label.StylerFactory;

public class RoomLabelProvider
extends DefaultEObjectLabelProvider {
    private static final String KEYWORD_COLOR = "KEYWORD_COLOR";
    @Inject
    private StylerFactory stylerFactory;
    private StyledString.Styler keywordStyler = null;
    private StyledString.Styler typeStyler = null;

    @Inject
    public RoomLabelProvider(AdapterFactoryLabelProvider delegate) {
        super(delegate);
        JFaceResources.getColorRegistry().put(KEYWORD_COLOR, new RGB(50, 50, 50));
    }

    String image(RoomModel rm) {
        return "RoomModel.gif";
    }

    String image(Import im) {
        return "RoomModelImport.gif";
    }

    String image(DataClass dc) {
        return "DataClass.gif";
    }

    String image(ProtocolClass pc) {
        return "ProtocolClass.gif";
    }

    String image(ActorClass ac) {
        return "ActorClass.gif";
    }

    String image(SubSystemClass cc) {
        return "SubSystemClass.gif";
    }

    String image(LogicalSystem sys) {
        return "LogicalSystem.gif";
    }

    String image(SAPRef sap) {
        return "SAP.gif";
    }

    String image(SPPRef spp) {
        return "SPP.gif";
    }

    String image(ActorRef ar) {
        return "ActorRef.gif";
    }

    String image(SubSystemRef ar) {
        return "SubSystemRef.gif";
    }

    String image(BaseState state) {
        return "State.gif";
    }

    String image(RefinedState state) {
        return "RefinedState.gif";
    }

    String image(ServiceImplementation svc) {
        return "ServiceImpl.gif";
    }

    String image(Message state) {
        return "Message.gif";
    }

    String image(Operation op) {
        return "Operation.gif";
    }

    String image(Port p) {
        ActorClass ac = (ActorClass)p.eContainer();
        boolean relay = true;
        if (ac.getIntPorts().contains((Object)p)) {
            relay = false;
        } else {
            for (ExternalPort ep : ac.getExtPorts()) {
                if (ep.getIfport() != p) continue;
                relay = false;
                break;
            }
        }
        if (relay) {
            if (p.isConjugated()) {
                if (p.isReplicated()) {
                    return "ConjReplRelayPort.gif";
                }
                return "ConjRelayPort.gif";
            }
            if (p.isReplicated()) {
                return "ReplRelayPort.gif";
            }
            return "RelayPort.gif";
        }
        if (p.isConjugated()) {
            if (p.isReplicated()) {
                return "ConjReplPort.gif";
            }
            return "ConjPort.gif";
        }
        if (p.isReplicated()) {
            return "ReplPort.gif";
        }
        return "Port.gif";
    }

    StyledString text(Import im) {
        if (im.getImportedNamespace() == null) {
            StyledString txt = new StyledString("import model " + im.getImportURI());
            txt.setStyle(0, 12, this.getKeywordStyler());
            return txt;
        }
        StyledString txt = new StyledString("import ns " + im.getImportedNamespace());
        txt.setStyle(0, 9, this.getKeywordStyler());
        return txt;
    }

    String text(DataClass dc) {
        String base = dc.getBase() != null ? " extends " + dc.getBase().getName() : "";
        return String.valueOf(dc.getName()) + base;
    }

    String text(ProtocolClass pc) {
        String base = pc.getBase() != null ? " extends " + pc.getBase().getName() : "";
        return String.valueOf(pc.getName()) + base;
    }

    String text(ActorClass ac) {
        String base = ac.getBase() != null ? " extends " + ac.getBase().getName() : "";
        return String.valueOf(ac.getName()) + base;
    }

    String text(Port p) {
        String conjugated;
        String location = null;
        ActorClass ac = (ActorClass)p.eContainer();
        if (ac.getIntPorts().contains((Object)p)) {
            location = "internal";
        } else {
            for (ExternalPort ep : ac.getExtPorts()) {
                if (ep.getIfport() != p) continue;
                location = "external";
                break;
            }
        }
        if (location == null) {
            location = "relay";
        }
        String string = conjugated = p.isConjugated() ? "conjugated " : "";
        String multiplicity = p.getMultiplicity() > 1 ? "[" + p.getMultiplicity() + "]" : (p.getMultiplicity() == -1 ? "[*]" : "");
        String protocol = p.getProtocol() != null ? " : " + p.getProtocol().getName() : "";
        return String.valueOf(conjugated) + " " + location + " Port " + p.getName() + multiplicity + protocol;
    }

    String text(ExternalPort ep) {
        return this.text(ep.getIfport());
    }

    String text(SAPRef sap) {
        String protocol = sap.getProtocol() != null ? " : " + sap.getProtocol().getName() : "";
        return "SAP " + sap.getName() + protocol;
    }

    String text(SPPRef spp) {
        String protocol = spp.getProtocol() != null ? " : " + spp.getProtocol().getName() : "";
        return "SPP " + spp.getName() + protocol;
    }

    String text(ServiceImplementation svc) {
        if (svc.getSpp() == null) {
            return "Implementation";
        }
        String protocol = svc.getSpp().getProtocol() != null ? " : " + svc.getSpp().getProtocol().getName() : "";
        return "Implementation of " + svc.getSpp().getName() + protocol;
    }

    StyledString text(ActorRef ref) {
        String cls = ref.getType() != null ? " : " + ref.getType().getName() : "";
        StyledString txt = new StyledString("ref " + ref.getName() + cls);
        if (!cls.isEmpty()) {
            txt.setStyle(txt.length() - cls.length() + 2, cls.length() - 2, this.getTypeStyler());
        }
        return txt;
    }

    String text(SubSystemRef ref) {
        String cls = ref.getType() != null ? " : " + ref.getType().getName() : "";
        return "ref " + ref.getName() + cls;
    }

    String text(Attribute attr) {
        String type = attr.getType() != null ? " : " + RoomHelpers.getName((Type)attr.getType()) : "";
        String value = attr.getDefaultValueLiteral() != null && !attr.getDefaultValueLiteral().isEmpty() ? " = " + attr.getDefaultValueLiteral() : "";
        return "Attr " + attr.getName() + type + value;
    }

    String text(Operation op) {
        String rt = op.getReturntype() != null ? ": " + RoomHelpers.getName((FreeType)op.getReturntype()) : "";
        String signature = RoomHelpers.getSignature((Operation)op);
        return String.valueOf(op.getName()) + signature + rt;
    }

    String text(Message m) {
        String signature = "";
        if (m.getData() != null) {
            signature = String.valueOf(m.getData().getName()) + ":" + RoomHelpers.getName((Type)m.getData().getType());
        }
        signature = "(" + signature + ")";
        return String.valueOf(m.getName()) + signature;
    }

    String text(BaseState s) {
        return s.getName();
    }

    String text(RefinedState rs) {
        if (rs.getBase() != null) {
            return this.text(rs.getBase());
        }
        return "";
    }

    private StyledString.Styler getKeywordStyler() {
        if (this.keywordStyler == null) {
            FontDescriptor font = JFaceResources.getFontDescriptor((String)"org.eclipse.jface.textfont");
            FontDescriptor boldFont = font.setStyle(1);
            this.keywordStyler = this.stylerFactory.createStyler(boldFont, KEYWORD_COLOR, null);
        }
        return this.keywordStyler;
    }

    private StyledString.Styler getTypeStyler() {
        if (this.typeStyler == null) {
            FontDescriptor font = JFaceResources.getFontDescriptor((String)"org.eclipse.jface.textfont");
            FontDescriptor italicFont = font.setStyle(2);
            this.typeStyler = this.stylerFactory.createStyler(italicFont, null, null);
        }
        return this.typeStyler;
    }
}

