/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.ui.newwizard;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.etrice.core.ui.internal.RoomActivator;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.resource.ImageDescriptor;

public class ProjectCreator {
    private static final String[] commonNatureIDs = new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.xtext.ui.shared.xtextNature"};
    private static final String[] commonBuilderIDs = new String[]{"org.eclipse.xtext.ui.shared.xtextBuilder"};

    public static List<String> getCommonNatureIDs() {
        return Arrays.asList(commonNatureIDs);
    }

    public static List<String> getCommonBuilderIDs() {
        return Arrays.asList(commonBuilderIDs);
    }

    public static IProject createETriceProject(IPath javaSource, IPath javaSourceGen, URI projectLocationURI, IProject runtimeProject, List<String> naturesToAdd, List<String> buildersToAdd, Monitor monitor) {
        IProgressMonitor progressMonitor = BasicMonitor.toIProgressMonitor((Monitor)monitor);
        String projectName = javaSource.segment(0);
        IProject project = null;
        try {
            try {
                String[] natureIds;
                UniqueEList classpathEntries = new UniqueEList();
                progressMonitor.beginTask("", 10);
                progressMonitor.subTask("Creating eTrice project " + projectName + " (" + (projectLocationURI != null ? projectLocationURI.toString() : projectName) + ")");
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                project = workspace.getRoot().getProject(projectName);
                if (!project.exists()) {
                    File projectFile;
                    URI location = projectLocationURI;
                    if (location == null) {
                        location = URI.createFileURI((String)workspace.getRoot().getLocation().append(projectName).toOSString());
                    }
                    if ((projectFile = new File((location = location.appendSegment(".project")).toString())).exists()) {
                        projectFile.renameTo(new File(String.valueOf(location.toString()) + ".old"));
                    }
                }
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IProjectDescription projectDescription = null;
                if (!project.exists()) {
                    projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
                    if (projectLocationURI != null) {
                        projectDescription.setLocationURI(new java.net.URI(projectLocationURI.toString()));
                    }
                    project.create(projectDescription, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                } else {
                    projectDescription = project.getDescription();
                    project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                        classpathEntries.addAll(Arrays.asList(javaProject.getRawClasspath()));
                    }
                }
                boolean isInitiallyEmpty = classpathEntries.isEmpty();
                ArrayList<IProject> referencedProjects = new ArrayList<IProject>();
                if (runtimeProject != null) {
                    referencedProjects.add(runtimeProject);
                }
                if (!referencedProjects.isEmpty()) {
                    projectDescription.setReferencedProjects(referencedProjects.toArray(new IProject[referencedProjects.size()]));
                    for (IProject referencedProject : referencedProjects) {
                        IClasspathEntry referencedProjectClasspathEntry = JavaCore.newProjectEntry((IPath)referencedProject.getFullPath());
                        classpathEntries.add(referencedProjectClasspathEntry);
                    }
                }
                if ((natureIds = projectDescription.getNatureIds()) == null) {
                    natureIds = new String[]{};
                }
                for (String nature : naturesToAdd) {
                    natureIds = ProjectCreator.addNature(nature, natureIds, project);
                }
                projectDescription.setNatureIds(natureIds);
                ICommand[] builders = projectDescription.getBuildSpec();
                if (builders == null) {
                    builders = new ICommand[]{};
                }
                for (String builder : buildersToAdd) {
                    builders = ProjectCreator.addBuilder(builder, builders, projectDescription);
                }
                projectDescription.setBuildSpec(builders);
                project.setDescription(projectDescription, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                ProjectCreator.createSrcFolder(progressMonitor, project, (List<IClasspathEntry>)classpathEntries, javaSource);
                ProjectCreator.createSrcFolder(progressMonitor, project, (List<IClasspathEntry>)classpathEntries, javaSourceGen);
                if (isInitiallyEmpty) {
                    IClasspathEntry jreClasspathEntry = JavaCore.newVariableEntry((IPath)new Path("JRE_LIB"), (IPath)new Path("JRE_SRC"), (IPath)new Path("JRE_SRCROOT"));
                    Iterator i = classpathEntries.iterator();
                    while (i.hasNext()) {
                        IClasspathEntry classpathEntry = (IClasspathEntry)i.next();
                        if (!classpathEntry.getPath().isPrefixOf(jreClasspathEntry.getPath())) continue;
                        i.remove();
                    }
                    String jreContainer = JavaRuntime.JRE_CONTAINER;
                    jreContainer = String.valueOf(jreContainer) + "/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-1.6";
                    classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path(jreContainer)));
                }
                javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                if (isInitiallyEmpty) {
                    javaProject.setOutputLocation((IPath)new Path("/" + javaSource.segment(0) + "/bin"), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                }
                javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                if (isInitiallyEmpty) {
                    javaProject.setOutputLocation((IPath)new Path("/" + javaSource.segment(0) + "/bin"), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                }
            }
            catch (Exception e) {
                Logger.getLogger(ProjectCreator.class).error((Object)e.getMessage(), (Throwable)e);
                progressMonitor.done();
            }
        }
        finally {
            progressMonitor.done();
        }
        return project;
    }

    private static ICommand[] addBuilder(String manifestBuilder, ICommand[] builders, IProjectDescription projectDescription) {
        boolean hasBuilder = false;
        int i = 0;
        while (i < builders.length) {
            if (manifestBuilder.equals(builders[i].getBuilderName())) {
                hasBuilder = true;
            }
            ++i;
        }
        if (!hasBuilder) {
            ICommand[] oldBuilders = builders;
            builders = new ICommand[oldBuilders.length + 1];
            System.arraycopy(oldBuilders, 0, builders, 0, oldBuilders.length);
            builders[oldBuilders.length] = projectDescription.newCommand();
            builders[oldBuilders.length].setBuilderName(manifestBuilder);
        }
        return builders;
    }

    private static String[] addNature(String natureId, String[] natureIds, IProject project) throws CoreException {
        if (!project.hasNature(natureId)) {
            String[] oldNatureIds = natureIds;
            natureIds = new String[oldNatureIds.length + 1];
            System.arraycopy(oldNatureIds, 0, natureIds, 0, oldNatureIds.length);
            natureIds[oldNatureIds.length] = natureId;
        }
        return natureIds;
    }

    private static void createSrcFolder(IProgressMonitor progressMonitor, IProject project, List<IClasspathEntry> classpathEntries, IPath src) throws CoreException {
        if (src.segmentCount() > 1) {
            IPath sourceContainerPath = src.removeFirstSegments(1).makeAbsolute();
            IFolder sourceContainer = project.getFolder(sourceContainerPath);
            if (!sourceContainer.exists()) {
                int i = sourceContainerPath.segmentCount() - 1;
                while (i >= 0) {
                    sourceContainer = project.getFolder(sourceContainerPath.removeLastSegments(i));
                    if (!sourceContainer.exists()) {
                        sourceContainer.create(false, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    }
                    --i;
                }
            }
            IClasspathEntry sourceClasspathEntry = JavaCore.newSourceEntry((IPath)src);
            Iterator<IClasspathEntry> i = classpathEntries.iterator();
            while (i.hasNext()) {
                IClasspathEntry classpathEntry = i.next();
                if (!classpathEntry.getPath().isPrefixOf(src)) continue;
                i.remove();
            }
            classpathEntries.add(0, sourceClasspathEntry);
        }
    }

    public static IContainer findOrCreateContainer(IPath path, boolean forceRefresh, IPath localLocation, IProgressMonitor progressMonitor) throws CoreException {
        String projectName = path.segment(0);
        IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
        projectDescription.setLocation(localLocation);
        return ProjectCreator.findOrCreateContainer(path, forceRefresh, projectDescription, progressMonitor);
    }

    public static IContainer findOrCreateContainer(IPath path, boolean forceRefresh, IProjectDescription projectDescription, IProgressMonitor progressMonitor) throws CoreException {
        try {
            String projectName = path.segment(0);
            progressMonitor.beginTask("", path.segmentCount() + 3);
            progressMonitor.subTask("examine new project " + projectName);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject project = workspace.getRoot().getProject(path.segment(0));
            if (forceRefresh) {
                project.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            } else {
                progressMonitor.worked(1);
            }
            if (!project.exists()) {
                project.create(projectDescription, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            } else {
                project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 2));
            }
            IProject container = project;
            int i = 1;
            int length = path.segmentCount();
            while (i < length) {
                IFolder folder = container.getFolder((IPath)new Path(path.segment(i)));
                if (!folder.exists()) {
                    folder.create(false, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                } else {
                    progressMonitor.worked(1);
                }
                container = folder;
                ++i;
            }
            IProject iProject = container;
            return iProject;
        }
        finally {
            progressMonitor.done();
        }
    }

    public static void createModel(URI uri, String baseName) {
        try {
            PrintStream model = new PrintStream(URIConverter.INSTANCE.createOutputStream(uri, null), false, "UTF-8");
            model.println("RoomModel " + baseName + " {");
            model.println("\t// TODO: add ROOM classes here...");
            model.println("}");
            model.close();
        }
        catch (UnsupportedEncodingException e) {
            Logger.getLogger(ProjectCreator.class).error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            Logger.getLogger(ProjectCreator.class).error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void createBuildProperties(URI uri, String baseName) {
        try {
            PrintStream prop = new PrintStream(URIConverter.INSTANCE.createOutputStream(uri, null), false, "UTF-8");
            prop.println("source.. = src/,\\");
            prop.println("src-gen/");
            prop.close();
        }
        catch (UnsupportedEncodingException e) {
            Logger.getLogger(ProjectCreator.class).error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            Logger.getLogger(ProjectCreator.class).error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static void createLaunchConfig(URI uri, String baseName, String[] addLines) {
        try {
            PrintStream launch = new PrintStream(URIConverter.INSTANCE.createOutputStream(uri, null), false, "UTF-8");
            launch.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
            launch.println("<launchConfiguration type=\"org.eclipse.etrice.generator.launch.java.launchConfigurationType\">");
            launch.println("<listAttribute key=\"ModelFiles\">");
            launch.println("<listEntry value=\"${workspace_loc:/" + baseName + "/model/" + baseName + ".room}\"/>");
            launch.println("</listAttribute>");
            launch.println("<listAttribute key=\"org.eclipse.debug.ui.favoriteGroups\">");
            launch.println("<listEntry value=\"org.eclipse.debug.ui.launchGroup.run\"/>");
            launch.println("</listAttribute>");
            String[] stringArray = addLines;
            int n = addLines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                launch.println(line);
                ++n2;
            }
            launch.println("</launchConfiguration>");
            launch.close();
        }
        catch (UnsupportedEncodingException e) {
            Logger.getLogger(ProjectCreator.class).error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            Logger.getLogger(ProjectCreator.class).error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        ImageDescriptor desc = RoomActivator.getInstance().getImageRegistry().getDescriptor(path);
        if (desc == null) {
            desc = RoomActivator.imageDescriptorFromPlugin((String)"org.eclipse.etrice.core.room.ui", (String)path);
            if (desc == null) {
                System.err.println("image not found: " + path);
            } else {
                RoomActivator.getInstance().getImageRegistry().put(path, desc);
                RoomActivator.getInstance().getImageRegistry().get(path);
            }
        }
        return desc;
    }
}

